# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ncbi.datasets.configuration import Configuration


class V1alpha1GeneDatasetRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'accessions': 'list[str]',
        'gene_ids': 'list[int]',
        'include_sequence_type': 'list[GeneDatasetRequestSeqType]',
        'symbol': 'list[str]',
        'tax_token': 'str'
    }

    attribute_map = {
        'accessions': 'accessions',
        'gene_ids': 'gene_ids',
        'include_sequence_type': 'include_sequence_type',
        'symbol': 'symbol',
        'tax_token': 'tax_token'
    }

    def __init__(self, accessions=None, gene_ids=None, include_sequence_type=None, symbol=None, tax_token=None, local_vars_configuration=None):  # noqa: E501
        """V1alpha1GeneDatasetRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._accessions = None
        self._gene_ids = None
        self._include_sequence_type = None
        self._symbol = None
        self._tax_token = None
        self.discriminator = None

        if accessions is not None:
            self.accessions = accessions
        if gene_ids is not None:
            self.gene_ids = gene_ids
        if include_sequence_type is not None:
            self.include_sequence_type = include_sequence_type
        if symbol is not None:
            self.symbol = symbol
        if tax_token is not None:
            self.tax_token = tax_token

    @property
    def accessions(self):
        """Gets the accessions of this V1alpha1GeneDatasetRequest.  # noqa: E501

        RNA or Protein accessions.  # noqa: E501

        :return: The accessions of this V1alpha1GeneDatasetRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._accessions

    @accessions.setter
    def accessions(self, accessions):
        """Sets the accessions of this V1alpha1GeneDatasetRequest.

        RNA or Protein accessions.  # noqa: E501

        :param accessions: The accessions of this V1alpha1GeneDatasetRequest.  # noqa: E501
        :type: list[str]
        """

        self._accessions = accessions

    @property
    def gene_ids(self):
        """Gets the gene_ids of this V1alpha1GeneDatasetRequest.  # noqa: E501


        :return: The gene_ids of this V1alpha1GeneDatasetRequest.  # noqa: E501
        :rtype: list[int]
        """
        return self._gene_ids

    @gene_ids.setter
    def gene_ids(self, gene_ids):
        """Sets the gene_ids of this V1alpha1GeneDatasetRequest.


        :param gene_ids: The gene_ids of this V1alpha1GeneDatasetRequest.  # noqa: E501
        :type: list[int]
        """

        self._gene_ids = gene_ids

    @property
    def include_sequence_type(self):
        """Gets the include_sequence_type of this V1alpha1GeneDatasetRequest.  # noqa: E501


        :return: The include_sequence_type of this V1alpha1GeneDatasetRequest.  # noqa: E501
        :rtype: list[GeneDatasetRequestSeqType]
        """
        return self._include_sequence_type

    @include_sequence_type.setter
    def include_sequence_type(self, include_sequence_type):
        """Sets the include_sequence_type of this V1alpha1GeneDatasetRequest.


        :param include_sequence_type: The include_sequence_type of this V1alpha1GeneDatasetRequest.  # noqa: E501
        :type: list[GeneDatasetRequestSeqType]
        """

        self._include_sequence_type = include_sequence_type

    @property
    def symbol(self):
        """Gets the symbol of this V1alpha1GeneDatasetRequest.  # noqa: E501


        :return: The symbol of this V1alpha1GeneDatasetRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._symbol

    @symbol.setter
    def symbol(self, symbol):
        """Sets the symbol of this V1alpha1GeneDatasetRequest.


        :param symbol: The symbol of this V1alpha1GeneDatasetRequest.  # noqa: E501
        :type: list[str]
        """

        self._symbol = symbol

    @property
    def tax_token(self):
        """Gets the tax_token of this V1alpha1GeneDatasetRequest.  # noqa: E501


        :return: The tax_token of this V1alpha1GeneDatasetRequest.  # noqa: E501
        :rtype: str
        """
        return self._tax_token

    @tax_token.setter
    def tax_token(self, tax_token):
        """Sets the tax_token of this V1alpha1GeneDatasetRequest.


        :param tax_token: The tax_token of this V1alpha1GeneDatasetRequest.  # noqa: E501
        :type: str
        """

        self._tax_token = tax_token

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha1GeneDatasetRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha1GeneDatasetRequest):
            return True

        return self.to_dict() != other.to_dict()
