(self["webpackChunkjupyterlab_optumi"] = self["webpackChunkjupyterlab_optumi"] || []).push([["lib_index_js"],{

/***/ "./lib/Global.js":
/*!***********************!*\
  !*** ./lib/Global.js ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Global": () => (/* binding */ Global)
/* harmony export */ });
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ "webpack/sharing/consume/default/@lumino/signaling");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _models_machine_Machine__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./models/machine/Machine */ "./lib/models/machine/Machine.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_LogScaleUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils/LogScaleUtils */ "./lib/utils/LogScaleUtils.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class Global {
    static get version() { return Global._version; }
    static set version(version) {
        Global._version = version;
        if (Global.shouldLogOnEmit)
            console.log('SignalEmit (' + new Date().getSeconds() + ')');
        Global._onVersionSet.emit(void 0);
    }
    static get onVersionSet() { return Global._onVersionSet; }
    static getStringWidth(text, font) {
        // re-use canvas object for better performance
        var context = this.canvas.getContext("2d");
        context.font = font;
        var metrics = context.measureText(text + ' ');
        return metrics.width + 1;
    }
    static get domain() { return Global._domain; }
    static set domain(domain) {
        Global._domain = domain;
        if (Global.shouldLogOnEmit)
            console.log('SignalEmit (' + new Date().getSeconds() + ')');
        Global._onDomainChange.emit(domain);
    }
    static get onDomainChange() { return Global._onDomainChange; }
    static get shouldLogOnRender() { return Global._shouldLogOnRender; }
    static __setShouldLogOnRender(shouldLogOnRender) {
        Global._shouldLogOnRender = shouldLogOnRender;
        return 'shouldLogOnRender is now set to ' + Global._shouldLogOnRender;
    }
    static get shouldLogOnEmit() { return Global._shouldLogOnEmit; }
    static __setShouldLogOnEmit(shouldLogOnEmit) {
        Global._shouldLogOnEmit = shouldLogOnEmit;
        return 'shouldLogOnEmit is now set to ' + Global._shouldLogOnEmit;
    }
    static get shouldLogOnPoll() { return Global._shouldLogOnPoll; }
    static __setShouldLogOnPoll(shouldLogOnPoll) {
        Global._shouldLogOnPoll = shouldLogOnPoll;
        return 'shouldLogOnPoll is now set to ' + Global._shouldLogOnPoll;
    }
    static get shouldLogOnSafeSetState() { return Global._shouldLogOnSafeSetState; }
    static __setShouldLogOnSafeSetState(shouldLogOnSafeSetState) {
        Global._shouldLogOnSafeSetState = shouldLogOnSafeSetState;
        return 'shouldLogOnSafeSetState is now set to ' + Global._shouldLogOnSafeSetState;
    }
    static get inQuestionMode() { return Global._inQuestionMode; }
    static set inQuestionMode(inQuestionMode) {
        Global._inQuestionMode = inQuestionMode;
        if (Global.shouldLogOnEmit)
            console.log('SignalEmit (' + new Date().getSeconds() + ')');
        Global._onInQuestionModeChange.emit(inQuestionMode);
    }
    static get jobLaunched() { return Global._jobLaunched; }
    static get onInQuestionModeChange() { return Global._onInQuestionModeChange; }
    static get lab() { return Global._lab; }
    static set lab(lab) { Global._lab = lab; }
    static get labShell() { return Global._labShell; }
    static set labShell(labShell) { Global._labShell = labShell; }
    static get themeManager() { return Global._themeManager; }
    static set themeManager(themeManager) { Global._themeManager = themeManager; }
    static get tracker() { return Global._tracker; }
    static set tracker(tracker) { Global._tracker = tracker; }
    static get metadata() { return Global._metadata; }
    static set metadata(metadata) {
        Global._metadata = metadata;
        // if (Global._metadata.getMetadata().metadata.version === 'DEV') {
        //     (window as any).setShouldLogOnRender = Global.__setShouldLogOnRender;
        //     (window as any).setShouldLogOnEmit = Global.__setShouldLogOnEmit;
        //     (window as any).setShouldLogOnPoll = Global.__setShouldLogOnPoll;
        //     (window as any).setShouldLogOnSafeSetState = Global.__setShouldLogOnSafeSetState;
        // } else {
        //     (window as any).setShouldLogOnRender = undefined;
        //     (window as any).setShouldLogOnEmit = undefined;
        //     (window as any).setShouldLogOnPoll = undefined;
        //     (window as any).setShouldLogOnSafeSetState = undefined;
        // }
    }
    static get docManager() { return Global._docManager; }
    static set docManager(docManager) { Global._docManager = docManager; }
    static get user() { return Global._user; }
    static set user(user) {
        if (user == null) {
            this._user.appTracker.stopPolling();
            if (Global.shouldLogOnEmit)
                console.log('SignalEmit (' + new Date().getSeconds() + ')');
            Global._onNullUser.emit(null);
        }
        Global._user = user;
        // Reset 401 counter
        Global.consecutive401s = 0;
        // Reset cached info
        Global.lastMachines = [];
        Global.lastMachineRate = 0;
        Global.lastCreditsCost = 0;
        Global.lastCreditsBalance = 0;
        Global.lastBudgetCost = 0;
        Global.lastDataConnectors = [];
        // Refresh the metadata before continuing with the login
        this._metadata.refreshMetadata().then(() => {
            // Wait to signal the change until the metadata has been set properly
            if (Global.shouldLogOnEmit)
                console.log('SignalEmit (' + new Date().getSeconds() + ')');
            Global._onUserChange.emit(user);
        });
    }
    static get onUserChange() { return Global._onUserChange; }
    static get onNullUser() { return Global._onNullUser; }
}
Global.emitter = new Global();
Global._version = undefined;
Global._onVersionSet = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(Global.emitter);
Global.canvas = document.createElement("canvas");
Global._domain = "";
Global._onDomainChange = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(Global.emitter);
Global._shouldLogOnRender = false;
Global._shouldLogOnEmit = false;
Global._shouldLogOnPoll = false;
Global._shouldLogOnSafeSetState = false;
Global._inQuestionMode = false;
Global._jobLaunched = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(Global.emitter);
Global._onInQuestionModeChange = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(Global.emitter);
Global._lab = undefined;
Global._labShell = undefined;
Global._themeManager = undefined;
Global._tracker = undefined;
Global._metadata = undefined;
Global._docManager = undefined;
Global._user = null; // If we are logged in we will have a user, otherwise it will be null
Global._onUserChange = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(Global.emitter);
Global._onNullUser = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(Global.emitter);
Global.snackbarChange = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(Global.emitter);
// We will keep some state here to avoid having no information to show before a request returns
Global.lastMachines = [];
Global.lastMachineRate = 0;
Global.lastCreditsCost = 0;
Global.lastCreditsBalance = 0;
Global.lastBudgetCost = 0;
Global.lastDataConnectors = [];
// We will use these for the steps for fractions
Global.generateFractionSteps = () => {
    const steps = new _utils_LogScaleUtils__WEBPACK_IMPORTED_MODULE_2__.default(0, 1, 0.01, 1, true).getMarks();
    steps.unshift({
        value: -1,
    });
    return steps;
};
Global.fractionMarks = Global.generateFractionSteps();
Global.consecutive401s = 0;
// This function will update the consecutive 401s properly and throw exceptions if the request failed
Global.handleResponse = (response) => {
    if (response.status == 401) {
        Global.consecutive401s++;
        if (Global.consecutive401s > 5) {
            Global.user = null;
        }
        throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.ResponseError(response);
    }
    else {
        Global.consecutive401s = 0;
        if (response.status >= 300) {
            throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.ResponseError(response);
        }
    }
};
// Poll for machines in the background
Global.updateMachines = () => {
    if (Global.shouldLogOnPoll)
        console.log('FunctionPoll (' + new Date().getSeconds() + ')');
    setTimeout(Global.updateMachines, 30000);
    if (Global.user != null) {
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/get-machines";
        const init = {
            method: 'GET',
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            Global.handleResponse(response);
            return response.json();
        }).then((body) => {
            var machines = [];
            for (var i = 0; i < body.machines.length; i++) {
                machines.push(Object.setPrototypeOf(body.machines[i], _models_machine_Machine__WEBPACK_IMPORTED_MODULE_3__.Machine.prototype));
            }
            Global.lastMachines = machines;
        });
    }
};


/***/ }),

/***/ "./lib/components/Agreement.js":
/*!*************************************!*\
  !*** ./lib/components/Agreement.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Agreement": () => (/* binding */ Agreement)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class Agreement extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        // Log out of the REST interface (Copied from SettingsPage aside from setState call)
        this.logout = () => {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/logout";
            const init = {
                method: 'GET',
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user = null;
                this.safeSetState({ open: false });
            });
        };
        this.acceptAgreement = () => {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/sign-agreement";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    timeOfSigning: new Date().toISOString(),
                }),
            };
            return _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
                return response.text();
            }).then((body) => {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.unsignedAgreement = false;
                this.props.callback();
            });
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { className: 'jp-optumi-logo' }),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: {
                        display: 'flex',
                        flexFlow: 'column',
                        overflow: 'hidden',
                        height: '100%',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: {
                            padding: '0px',
                            flexGrow: 1,
                            // overflowY: 'auto',
                            overflowY: 'hidden',
                            whiteSpace: 'pre-wrap',
                            backgroundColor: 'white'
                        } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("embed", { src: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.agreementURL, height: '100%', width: '100%' })),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Divider, { variant: 'middle' }),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { padding: '6px', display: 'flex', justifyContent: 'center' } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Checkbox, { checked: this.state.agreed, color: 'primary', onClick: () => this.safeSetState({ agreed: !this.state.agreed }), style: {
                                padding: '6px',
                                margin: '0px',
                                flexGrow: 1,
                            } }),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: {
                                padding: '6px',
                                margin: '0px',
                                flexGrow: 1,
                                fontWeight: 'bold'
                            } }, "I have read and I agree to the Optumi Terms and Conditions of Service")),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { padding: '6px', display: 'flex', justifyContent: 'center' } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Button, { onClick: this.logout, style: {
                                padding: '9px',
                                fontWeight: 'bold',
                                fontSize: '14px',
                                lineHeight: '14px',
                                margin: '0px',
                                flexGrow: 1,
                            } }, "Logout"),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Button, { onClick: this.acceptAgreement, color: 'primary', variant: 'contained', disabled: !this.state.agreed, style: {
                                padding: '9px',
                                fontWeight: 'bold',
                                fontSize: '14px',
                                lineHeight: '14px',
                                margin: '0px',
                                flexGrow: 1,
                            } }, "I accept")))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            agreed: false,
        };
    }
}


/***/ }),

/***/ "./lib/components/DeployPage.js":
/*!**************************************!*\
  !*** ./lib/components/DeployPage.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DeployPage": () => (/* binding */ DeployPage)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _deploy_PreviewLaunchButton__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./deploy/PreviewLaunchButton */ "./lib/components/deploy/PreviewLaunchButton.js");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../core */ "./lib/core/IntentSlider.js");
/* harmony import */ var _deploy_FilesPanel__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./deploy/FilesPanel */ "./lib/components/deploy/FilesPanel.js");
/* harmony import */ var _deploy_resources_ResourcesPanel__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./deploy/resources/ResourcesPanel */ "./lib/components/deploy/resources/ResourcesPanel.js");
/* harmony import */ var _deploy_resources_LaunchMode__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./deploy/resources/LaunchMode */ "./lib/components/deploy/resources/LaunchMode.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/








// Defaults for this component
const DefaultState = {};
class DeployPage extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.state = DefaultState;
        // We need to know if the component is mounted to change state
        this._isMounted = false;
        // The contents of the component
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({ overflow: 'auto' }, this.props.style) }, ((_Global__WEBPACK_IMPORTED_MODULE_2__.Global.labShell.currentWidget instanceof _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__.NotebookPanel) && (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.tracker.currentWidget != null) && (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.tracker.currentWidget.context.isReady)) ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata.getMetadata() == undefined ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({ display: 'flex', flexFlow: 'column', overflow: 'hidden' }, this.props.style) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { flexGrow: 1, overflowY: 'auto', padding: '6px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { textAlign: 'center', margin: '12px' } }, "Fetching configuration...")))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { padding: '6px 20px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_FilesPanel__WEBPACK_IMPORTED_MODULE_3__.FilesPanel, { openUserDialogTo: this.props.openUserDialogTo }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_resources_LaunchMode__WEBPACK_IMPORTED_MODULE_4__.LaunchMode, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_resources_ResourcesPanel__WEBPACK_IMPORTED_MODULE_5__.ResourcesPanel, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.IntentSlider, { color: '#10A0F9', getValue: this.getValue, saveValue: this.saveValue })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_PreviewLaunchButton__WEBPACK_IMPORTED_MODULE_7__.PreviewLaunchButton, { style: { padding: '6px' } }))))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { textAlign: 'center', padding: "16px" } }, "Open a notebook to get started..."))));
        };
        this.handleLabShellChange = () => this.forceUpdate();
        this.handleTrackerChange = () => this.forceUpdate();
        this.handleMetadataChange = () => this.forceUpdate();
        this.handleUserChange = () => {
            this.forceUpdate();
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.labShell.currentChanged.connect(this.handleLabShellChange);
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.tracker.currentChanged.connect(this.handleTrackerChange);
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.tracker.selectionChanged.connect(this.handleTrackerChange);
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.onUserChange.connect(this.handleUserChange);
            this.handleUserChange();
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.labShell.currentChanged.disconnect(this.handleLabShellChange);
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.tracker.currentChanged.disconnect(this.handleTrackerChange);
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.tracker.selectionChanged.disconnect(this.handleTrackerChange);
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.onUserChange.disconnect(this.handleUserChange);
            this._isMounted = false;
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.tracker.currentWidget != null) {
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.tracker.currentWidget.context.ready.then(() => { if (this._isMounted)
                this.forceUpdate(); });
        }
    }
    getValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata;
        const optumi = tracker.getMetadata();
        return optumi.config.intent;
    }
    async saveValue(intent) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata;
        const optumi = tracker.getMetadata();
        optumi.config.intent = intent;
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/InfoSkirt.js":
/*!*************************************!*\
  !*** ./lib/components/InfoSkirt.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "InfoSkirt": () => (/* binding */ InfoSkirt)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class InfoSkirt extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.handleMouseOver = (event) => {
            if (this.props.onMouseOver)
                this.props.onMouseOver(event);
        };
        this.handleMouseOut = (event) => {
            if (this.props.onMouseOut)
                this.props.onMouseOut(event);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Paper, { elevation: 1, style: Object.assign({
                    width: '100%',
                    padding: '3px',
                    backgroundColor: 'var(--jp-layout-color2)',
                    borderRadius: '3px',
                }, this.props.style), onMouseOver: this.handleMouseOver, onMouseOut: this.handleMouseOut },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                        display: 'inline-flex',
                        width: '100%',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                            width: '100%',
                            margin: '3px 0px 3px 3px',
                            overflow: 'hidden',
                        } }, this.props.children),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                            display: 'inline-flex',
                            minWidth: this.props.leftButton && this.props.rightButton ? '82px' : '50px',
                            margin: '10px 3px 0px 0px',
                        } },
                        this.props.leftButton && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { margin: this.props.rightButton ? 'auto 0 auto auto' : '0px 10px 0px 4px' } }, this.props.leftButton)),
                        this.props.rightButton && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { margin: this.props.leftButton ? 'auto auto auto 0' : '0px 4px 0px 10px' } }, this.props.rightButton)))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                        display: 'inline-flex',
                        flexWrap: 'wrap',
                        width: '100%',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                            display: 'inline-flex',
                            flexGrow: 1,
                        } }, this.props.tags.length == 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                            minWidth: '74px',
                            height: '20px',
                        } })) : (this.props.tags)))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}


/***/ }),

/***/ "./lib/components/LaunchSkirt.js":
/*!***************************************!*\
  !*** ./lib/components/LaunchSkirt.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LaunchSkirt": () => (/* binding */ LaunchSkirt)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class LaunchSkirt extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.handleMouseOver = (event) => {
            if (this.props.onMouseOver)
                this.props.onMouseOver(event);
        };
        this.handleMouseOut = (event) => {
            if (this.props.onMouseOut)
                this.props.onMouseOut(event);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Paper, { elevation: 1, style: Object.assign({
                    width: '100%',
                    padding: '3px',
                    backgroundColor: 'var(--jp-layout-color2)',
                    borderRadius: '3px',
                }, this.props.style), onMouseOver: this.handleMouseOver, onMouseOut: this.handleMouseOut },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                        display: 'inline-flex',
                        width: '100%',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                            width: '100%',
                            margin: '3px 0px 0px 3px',
                            overflow: 'hidden',
                        } },
                        this.props.children,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                                display: 'inline-flex',
                                flexWrap: 'wrap',
                                width: '100%',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                                    display: 'inline-flex',
                                    flexGrow: 1,
                                    marginTop: '3px',
                                    marginLeft: '-3px',
                                } }, this.props.tags.length == 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                                    minWidth: '74px',
                                    height: '20px',
                                } })) : (this.props.tags)))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                            display: 'inline-flex',
                            margin: '6px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { margin: '1px 3px' } }, this.props.launchButton)))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}


/***/ }),

/***/ "./lib/components/LeftPanel.js":
/*!*************************************!*\
  !*** ./lib/components/LeftPanel.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OptumiLeftPanel": () => (/* binding */ StyledOptumiLeftPanel)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _models_User__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../models/User */ "./lib/models/User.js");
/* harmony import */ var _Login__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Login */ "./lib/components/Login.js");
/* harmony import */ var _Pilot__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Pilot */ "./lib/components/Pilot.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _material_ui_core_CssBaseline__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @material-ui/core/CssBaseline */ "./node_modules/@material-ui/core/esm/CssBaseline/CssBaseline.js");
/* harmony import */ var _material_ui_core_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/withStyles.js");
/* harmony import */ var _material_ui_core_styles__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/styles/esm/ThemeProvider/ThemeProvider.js");
/* harmony import */ var _material_ui_core_styles__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/createMuiTheme.js");
/* harmony import */ var _Agreement__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Agreement */ "./lib/components/Agreement.js");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! notistack */ "webpack/sharing/consume/default/notistack/notistack");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(notistack__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _models_Snackbar__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../models/Snackbar */ "./lib/models/Snackbar.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_3__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/












const GlobalThemeDiv = (0,_material_ui_core_styles__WEBPACK_IMPORTED_MODULE_4__.default)({
    '@global': {
        ':root': {
            '--ot-font-family': 'var(--jp-ui-font-family)',
            '--ot-padding': '12px',
            '--ot-padding-half': '6px',
            '--ot-margin': '12px',
            '--ot-margin-half': '6px',
            '--ot-backgroundColor': 'var(--jp-layout-color1)',
            '--ot-backgroundColor-emphasized': 'var(--jp-layout-color2)',
        },
        'button:focus': {
            outline: 'none !important',
        },
        'code': {
            color: 'var(--jp-ui-font-color0) !important',
        },
    }
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_3__.Box);
class OptumiLeftPanel extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        // We need to know if the component is mounted to change state
        this._isMounted = false;
        // The contents of the component
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(GlobalThemeDiv, { component: 'div', style: {
                    height: '100%',
                    display: 'flex',
                    flexFlow: 'column',
                    overflow: 'hidden',
                    color: 'var(--jp-ui-font-color1)',
                    backgroundColor: 'var(--jp-layout-color1)',
                    fontSize: 'var(--jp-ui-font-size1)',
                    fontFamily: 'var(--jp-ui-font-family)'
                } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core_CssBaseline__WEBPACK_IMPORTED_MODULE_6__.default, null),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core_styles__WEBPACK_IMPORTED_MODULE_7__.default, { theme: this.theme },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(notistack__WEBPACK_IMPORTED_MODULE_2__.SnackbarProvider, { maxSnack: 3, domRoot: this.domRoot, classes: {
                            variantSuccess: this.props.classes.success,
                            variantError: this.props.classes.error,
                            variantWarning: this.props.classes.warning,
                            variantInfo: this.props.classes.info,
                        } }, this.state.loggedIn && _Global__WEBPACK_IMPORTED_MODULE_5__.Global.version ?
                        (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.user.unsignedAgreement ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Agreement__WEBPACK_IMPORTED_MODULE_8__.Agreement, { callback: () => this.forceUpdate() })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Pilot__WEBPACK_IMPORTED_MODULE_9__.Pilot, null))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Login__WEBPACK_IMPORTED_MODULE_10__.Login, null))))));
        };
        this.getTheme = () => {
            var themeManager = _Global__WEBPACK_IMPORTED_MODULE_5__.Global.themeManager;
            return (0,_material_ui_core_styles__WEBPACK_IMPORTED_MODULE_11__.default)({
                props: {
                    MuiOutlinedInput: { inputProps: { spellCheck: 'false' } }
                },
                overrides: {
                    MuiButton: { root: { textTransform: 'none', fontWeight: 'bold' } },
                    MuiDialog: { paperWidthSm: { maxWidth: '650px' } }
                },
                palette: {
                    type: themeManager.theme == null || themeManager.isLight(themeManager.theme) ? 'light' : 'dark',
                    primary: {
                        // light: will be calculated from palette.primary.main,
                        main: '#10A0F9',
                    },
                    secondary: {
                        // light: will be calculated from palette.secondary.main,
                        main: '#afaab0',
                    },
                    error: {
                        // light: will be calculated from palette.error.main,
                        main: '#f48f8d',
                    },
                    // warning: {
                    // },
                    // info: {
                    // },
                    success: {
                        // light: will be calculated from palette.error.main,
                        main: '#68da7c',
                    },
                    // Used by `getContrastText()` to maximize the contrast between
                    // the background and the text.
                    contrastThreshold: 2.2,
                    // Used by the functions below to shift a color's luminance by approximately
                    // two indexes within its tonal palette.
                    // E.g., shift from Red 500 to Red 300 or Red 700.
                    tonalOffset: 0.2,
                },
            });
        };
        this.theme = this.getTheme();
        this.handleVersionSet = () => this.forceUpdate();
        this.handleUserChange = () => this.safeSetState({ loggedIn: _Global__WEBPACK_IMPORTED_MODULE_5__.Global.user != null });
        this.handleNullUserChange = () => this.safeSetState({ loggedIn: false });
        //TODO:JJ should this be async?
        this.handleThemeChange = async () => {
            this.theme = this.getTheme();
            this.forceUpdate();
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.onVersionSet.connect(this.handleVersionSet);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.onNullUser.connect(this.handleNullUserChange);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.onUserChange.connect(this.handleUserChange);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.themeManager.themeChanged.connect(this.handleThemeChange);
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/login";
            const init = {
                method: 'GET',
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                if (response.status !== 200 && response.status !== 201) {
                    // We still want to get the domain
                    response.json().then((body) => { _Global__WEBPACK_IMPORTED_MODULE_5__.Global.domain = body.domain; });
                    throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.ResponseError(response);
                }
                return response.json();
            }).then((body) => {
                _Global__WEBPACK_IMPORTED_MODULE_5__.Global.domain = body.domain;
                if (body.loginFailed || body.domainFailed) {
                    // No login
                }
                else {
                    var user = _models_User__WEBPACK_IMPORTED_MODULE_12__.User.handleLogin(body);
                    _Global__WEBPACK_IMPORTED_MODULE_5__.Global.user = user;
                }
            });
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.onVersionSet.disconnect(this.handleVersionSet);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.onNullUser.disconnect(this.handleNullUserChange);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.onUserChange.disconnect(this.handleUserChange);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.themeManager.themeChanged.disconnect(this.handleThemeChange);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            loggedIn: false
        };
        this.domRoot = document.getElementById("main");
    }
}
const StyledOptumiLeftPanel = (0,_material_ui_core_styles__WEBPACK_IMPORTED_MODULE_4__.default)(_models_Snackbar__WEBPACK_IMPORTED_MODULE_13__.providerOptions)(OptumiLeftPanel);



/***/ }),

/***/ "./lib/components/Login.js":
/*!*********************************!*\
  !*** ./lib/components/Login.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Login": () => (/* binding */ Login)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _models_User__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../models/User */ "./lib/models/User.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../core */ "./lib/core/Header.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../core */ "./lib/core/ShadowedDivider.js");
///<reference path="../../node_modules/@types/node/index.d.ts"/>
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






// Element to display the Copyright with optumi.com link
function Copyright() {
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Typography, { style: { marginBottom: '10px' }, variant: "body2", color: "textSecondary", align: "center" },
        'Copyright © ',
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Link, { color: "inherit", href: "https://optumi.com/" }, "Optumi Inc")));
}
const StyledDialog = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.withStyles)({
    root: {
        margin: '12px',
        padding: '0px',
    },
    paper: {
        backgroundColor: 'var(--jp-layout-color1)',
    },
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Dialog);
// The login screen
class Login extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleDomainChange = (e) => {
            const value = e.target.value;
            if (new RegExp('^[A-Za-z0-9.:]*$').test(value)) {
                this.safeSetState({ domain: value, loginFailed: false, domainFailed: false });
            }
        };
        this.handleLoginNameChange = (e) => {
            this.safeSetState({ loginName: e.target.value, loginFailed: false, domainFailed: false });
        };
        this.handlePasswordChange = (e) => {
            this.safeSetState({ password: e.target.value, loginFailed: false, domainFailed: false });
        };
        this.handleKeyDown = (e) => {
            if (e.key === 'Enter') {
                this.login();
            }
        };
        // The contents of the component
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'jp-optumi-logo' }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Container, { style: { textAlign: 'center' }, maxWidth: "xs" },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Typography, { component: "h1", variant: "h5" }, "Sign in"),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("form", null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TextField, { fullWidth: true, required: true, style: { marginTop: "16px", marginBottom: "8px" }, label: "Domain", variant: "outlined", value: this.state.domain, onChange: this.handleDomainChange, onKeyDown: this.handleKeyDown, error: this.state.domainFailed, helperText: this.state.domainFailed ? "Unable to contact " + this.state.domain : "" }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TextField, { id: 'username', name: 'username', fullWidth: true, required: true, style: { marginTop: "16px", marginBottom: "8px" }, label: "Username", variant: "outlined", value: this.state.loginName, onChange: this.handleLoginNameChange, onKeyDown: this.handleKeyDown, error: this.state.loginFailed, autoComplete: 'username' }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.TextField, { id: 'password', name: 'password', fullWidth: true, required: true, style: { marginTop: "16px", marginBottom: "8px" }, type: "password", label: "Password", variant: "outlined", value: this.state.password, onChange: this.handlePasswordChange, onKeyDown: this.handleKeyDown, error: this.state.loginFailed, helperText: this.state.loginFailed ? this.state.loginFailedMessage : "", autoComplete: 'current-password' }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Button, { fullWidth: true, style: { marginTop: "16px", marginBottom: "8px" }, variant: "contained", color: "primary", disabled: this.state.waiting, onClick: () => this.login() }, this.state.waiting && this.state.spinning ? react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.CircularProgress, { size: '1.75em' }) : 'Sign in')),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { marginTop: "30px" } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(Copyright, null)),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledDialog, { disableBackdropClick: true, disableEscapeKeyDown: true, open: this.state.packageString != "" },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.DialogTitle, { disableTypography: true, style: {
                            backgroundColor: 'var(--jp-layout-color2)',
                            height: '48px',
                            padding: '6px 30px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.Header, { title: this.state.downgrade ? "Switch to compatible JupyterLab extension" : "Upgrade JupyterLab extension", style: { lineHeight: '24px' } })),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.ShadowedDivider, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { padding: '18px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.DialogContent, { style: { padding: '6px 18px', lineHeight: '24px' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, this.state.downgrade ?
                                "Sorry, we've noticed an incompatibility between this JupyterLab extension version and our backend. To switch to a compatible JupyterLab extension run the command"
                                :
                                    "We've made enhancements on the backend that require a new JupyterLab extension version. To upgrade your JupyterLab extension run the command"),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement("textarea", { id: "optumi-upgrade-string", style: {
                                    fontFamily: 'var(--jp-code-font-family)',
                                    width: '100%',
                                    lineHeight: '18px',
                                    marginTop: '6px',
                                }, rows: 1, readOnly: true }, 'pip install ' + this.state.packageString),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, 'and restart JupyterLab.')),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.DialogActions, { style: { padding: '12px 6px 6px 6px' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Button, { variant: 'contained', onClick: () => {
                                    var copyTextarea = document.getElementById('optumi-upgrade-string');
                                    copyTextarea.focus();
                                    copyTextarea.select();
                                    try {
                                        document.execCommand('copy');
                                    }
                                    catch (err) {
                                        console.log(err);
                                    }
                                }, color: 'primary' }, "Copy command"),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Button, { variant: 'contained', onClick: () => {
                                    this.safeSetState({ loginFailed: false, domainFailed: false, packageString: "", downgrade: false, loginFailedMessage: "" });
                                }, color: 'secondary' }, "Close"))))));
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.handleGlobalDomainChange = () => this.safeSetState({ domain: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.domain });
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.onDomainChange.connect(this.handleGlobalDomainChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.onDomainChange.disconnect(this.handleGlobalDomainChange);
            this._isMounted = false;
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            domain: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.domain,
            loginName: "",
            password: "",
            loginFailed: false,
            domainFailed: false,
            loginFailedMessage: "",
            waiting: false,
            spinning: false,
            packageString: "",
            downgrade: false,
        };
    }
    // Try to log into the REST interface and update state according to response
    async login() {
        this.safeSetState({ waiting: true, spinning: false });
        setTimeout(() => this.safeSetState({ spinning: true }), 1000);
        _Global__WEBPACK_IMPORTED_MODULE_3__.Global.domain = this.state.domain;
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/login";
        const init = {
            method: 'POST',
            body: JSON.stringify({
                'domain': this.state.domain,
                'loginName': this.state.loginName,
                'password': this.state.password,
            })
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            this.safeSetState({ waiting: false });
            if (response.status !== 200 && response.status !== 201) {
                this.safeSetState({ loginFailed: false, domainFailed: true });
                throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.ResponseError(response);
            }
            return response.json();
        }, () => this.safeSetState({ waiting: false })).then((body) => {
            if (body.loginFailed || body.domainFailed) {
                if (body.message == 'Version exchange failed') {
                    var rawVersion = body.loginFailedMessage;
                    var split = rawVersion.split('-')[0].split('.');
                    const downgrade = _Global__WEBPACK_IMPORTED_MODULE_3__.Global.version.split('.')[1] > split[1];
                    var packageString = '"jupyterlab-optumi>=' + split[0] + '.' + split[1] + '.0,' + '<' + split[0] + '.' + (+split[1] + 1) + '.0"';
                    this.safeSetState({ loginFailed: body.loginFailed || false, domainFailed: body.domainFailed || false, packageString: packageString, downgrade: downgrade });
                }
                else {
                    this.safeSetState({ loginFailed: body.loginFailed || false, domainFailed: body.domainFailed || false, loginFailedMessage: body.loginFailedMessage || "" });
                }
            }
            else {
                var user = _models_User__WEBPACK_IMPORTED_MODULE_6__.User.handleLogin(body);
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user = user;
                this.safeSetState({ loginFailed: false, domainFailed: false });
            }
        });
    }
}


/***/ }),

/***/ "./lib/components/MachinesPage.js":
/*!****************************************!*\
  !*** ./lib/components/MachinesPage.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MachinesPage": () => (/* binding */ MachinesPage)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _models_machine_Machine__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../models/machine/Machine */ "./lib/models/machine/Machine.js");
/* harmony import */ var _machines_Credits__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./machines/Credits */ "./lib/components/machines/Credits.js");
/* harmony import */ var _machines_Rate__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./machines/Rate */ "./lib/components/machines/Rate.js");
/* harmony import */ var _machines_Budget__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./machines/Budget */ "./lib/components/machines/Budget.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/








class MachinesPage extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        // We need to know if the component is mounted to change state
        this._isMounted = false;
        this.polling = false;
        this.updateMachines = () => {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/get-machines";
            const init = {
                method: 'GET',
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                if (this.polling) {
                    // If we are polling, send a new request in 2 seconds
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnPoll)
                        console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                    setTimeout(() => this.updateMachines(), 2000);
                }
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
                return response.json();
            }).then((body) => {
                var machines = [];
                for (var i = 0; i < body.machines.length; i++) {
                    machines.push(Object.setPrototypeOf(body.machines[i], _models_machine_Machine__WEBPACK_IMPORTED_MODULE_4__.Machine.prototype));
                }
                if (JSON.stringify(body) !== JSON.stringify(this.previousMachines)) {
                    this.safeSetState({ machines: machines });
                    this.previousMachines = body;
                }
            });
        };
        // The contents of the component
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            var machines = new Array();
            for (var i = 0; i < this.state.machines.length; i++) {
                var machine = this.state.machines[i];
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.userExpertise >= 2 || _models_machine_Machine__WEBPACK_IMPORTED_MODULE_4__.Machine.getStateMessage(machine.state) != 'Releasing') {
                    machines.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { key: machine.uuid, style: { display: 'inline-flex', width: '100%', padding: '6px 0px' } }, machine.getComponent()));
                }
            }
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({ display: 'flex', flexFlow: 'column', overflow: 'hidden' }, this.props.style) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { margin: '0px 20px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_machines_Rate__WEBPACK_IMPORTED_MODULE_5__.Rate, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.Divider, { variant: 'middle' }),
                    _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.userExpertise > 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_machines_Budget__WEBPACK_IMPORTED_MODULE_6__.Budget, null)) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_machines_Credits__WEBPACK_IMPORTED_MODULE_7__.Credits, null)),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.Divider, { variant: 'middle' })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { flexGrow: 1, overflowY: 'auto', padding: '6px' } }, machines.length == 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { textAlign: 'center', margin: '12px' } }, "Running machines will appear here.")) : (machines))));
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            this.startPolling();
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            this.stopPolling();
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.lastMachines = this.state.machines;
            this._isMounted = false;
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            machines: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.lastMachines,
        };
    }
    startPolling() {
        this.polling = true;
        this.updateMachines();
    }
    stopPolling() {
        this.polling = false;
    }
}


/***/ }),

/***/ "./lib/components/MonitorPage.js":
/*!***************************************!*\
  !*** ./lib/components/MonitorPage.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MonitorPage": () => (/* binding */ MonitorPage)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../core */ "./lib/core/Header.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




// Defaults for this component
const DefaultState = {};
class MonitorPage extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.state = DefaultState;
        this.generateActive = (apps) => {
            var sorted = apps.sort((n1, n2) => {
                if (n1.timestamp > n2.timestamp) {
                    return -1;
                }
                if (n1.timestamp < n2.timestamp) {
                    return 1;
                }
                return 0;
            });
            return sorted.map(value => (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { key: value.uuid, style: { padding: '6px 0px 6px 6px' } }, value.getComponent(this.props.openUserDialogTo))));
        };
        this.generateFinished = (apps) => {
            var sorted = apps.sort((n1, n2) => {
                if (n1.getEndTime() > n2.getEndTime()) {
                    return -1;
                }
                if (n1.getEndTime() < n2.getEndTime()) {
                    return 1;
                }
                return 0;
            });
            return sorted.map(value => (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { key: value.uuid, style: { padding: '6px 0px 6px 6px' } }, value.getComponent(this.props.openUserDialogTo))));
        };
        // The contents of the component
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const appTracker = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.appTracker;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({ overflowY: 'auto' }, this.props.style) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { padding: '6px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_3__.Header, { title: "Active" }),
                    appTracker.activeSessions.length != 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_3__.SubHeader, { title: "Sessions" }),
                        this.generateActive(appTracker.activeSessions))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'inline-flex', width: '100%' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_3__.SubHeader, { title: "Sessions", grey: true }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                                margin: '6px 0px',
                                fontSize: '14px',
                                lineHeight: '18px',
                                opacity: 0.5
                            } }, "(none)"))),
                    appTracker.activeJobs.length != 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_3__.SubHeader, { title: "Jobs", grey: true }),
                        this.generateActive(appTracker.activeJobs))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'inline-flex', width: '100%' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_3__.SubHeader, { title: "Jobs", grey: true }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                                margin: '6px 0px',
                                fontSize: '14px',
                                lineHeight: '18px',
                                opacity: 0.5
                            } }, "(none)")))),
                (appTracker.finishedSessions.length != 0 || appTracker.finishedJobs.length == 0) && react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Divider, { variant: 'middle' }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { padding: '6px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_3__.Header, { title: "Finished" }),
                    appTracker.finishedSessions.length != 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_3__.SubHeader, { title: "Sessions", grey: true }),
                        this.generateFinished(appTracker.finishedSessions))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'inline-flex', width: '100%' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_3__.SubHeader, { title: "Sessions", grey: true }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                                margin: '6px 0px',
                                fontSize: '14px',
                                lineHeight: '18px',
                                opacity: 0.5
                            } }, "(none)"))),
                    appTracker.finishedJobs.length != 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_3__.SubHeader, { title: "Jobs", grey: true }),
                        this.generateFinished(appTracker.finishedJobs))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'inline-flex', width: '100%' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_3__.SubHeader, { title: "Jobs", grey: true }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                                margin: '6px 0px',
                                fontSize: '14px',
                                lineHeight: '18px',
                                opacity: 0.5
                            } }, "(none)"))))));
        };
        this.handleAppChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.appTracker.appsChanged.connect(this.handleAppChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.appTracker.appsChanged.disconnect(this.handleAppChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}


/***/ }),

/***/ "./lib/components/Pilot.js":
/*!*********************************!*\
  !*** ./lib/components/Pilot.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Pilot": () => (/* binding */ SnackbarPilot)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _DeployPage__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./DeployPage */ "./lib/components/DeployPage.js");
/* harmony import */ var _MonitorPage__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./MonitorPage */ "./lib/components/MonitorPage.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _MachinesPage__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./MachinesPage */ "./lib/components/MachinesPage.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../core */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! notistack */ "webpack/sharing/consume/default/notistack/notistack");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(notistack__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _UserDialog__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./UserDialog */ "./lib/components/UserDialog.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/









var Page;
(function (Page) {
    Page[Page["Deploy"] = 0] = "Deploy";
    Page[Page["Monitor"] = 1] = "Monitor";
    Page[Page["Machines"] = 2] = "Machines";
})(Page || (Page = {}));
class Pilot extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.openUserDialogTo = () => new Promise(resolve => resolve()); // This is somewhat spaghetti code-y, maybe think about revising
        this.handleTabChange = (event, newValue) => {
            this.safeSetState({ page: newValue });
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.lastPage = newValue;
        };
        // The contents of the component
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { paddingBottom: "5px", textAlign: 'center', verticalAlign: 'middle' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'inline-flex', width: '100%' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("a", { href: 'https://www.optumi.com', target: '_blank' },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'jp-optumi-logo' })),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_UserDialog__WEBPACK_IMPORTED_MODULE_4__.UserDialog, { style: { margin: 'auto 6px auto auto' }, getOpenTo: (openTo) => {
                                this.openUserDialogTo = openTo;
                                this.forceUpdate();
                            } })),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Tabs, { value: this.state.page, onChange: this.handleTabChange, variant: "fullWidth", indicatorColor: "primary", textColor: "primary", style: { margin: '0px 6px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Tab, { icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.SvgIcon, { viewBox: "0, 0, 400,446", style: { width: '28px', height: '28px' } },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M348.000 58.232 C 324.618 61.984,306.000 66.674,306.000 68.813 C 306.000 71.851,369.545 135.122,371.067 133.599 C 372.905 131.761,382.000 74.336,382.000 64.567 L 382.000 56.000 370.500 56.234 C 364.175 56.362,354.050 57.262,348.000 58.232 M261.029 86.235 C 214.374 111.539,184.827 137.455,151.438 182.354 C 131.859 208.683,134.247 207.280,105.973 209.077 C 77.646 210.877,78.107 210.586,46.111 246.944 C 14.709 282.628,13.657 285.006,24.595 295.608 C 33.914 304.640,38.535 303.841,62.774 289.000 C 74.453 281.850,85.356 276.000,87.004 276.000 C 90.397 276.000,91.021 279.133,88.000 281.000 C 80.966 285.347,86.211 293.260,115.524 322.525 C 145.290 352.241,154.153 357.842,159.000 350.000 C 161.093 346.613,163.948 347.791,162.638 351.500 C 161.957 353.425,155.685 364.580,148.700 376.288 C 133.629 401.551,133.207 405.011,144.006 414.767 C 155.049 424.744,153.659 425.401,190.701 392.696 C 227.821 359.922,227.156 360.976,229.004 332.000 C 230.748 304.673,229.916 306.203,252.454 288.864 C 308.578 245.687,341.585 206.858,361.005 161.165 C 368.325 143.941,367.373 141.488,347.134 125.396 C 330.680 112.314,319.724 100.874,305.577 82.000 C 295.803 68.959,292.260 69.296,261.029 86.235 M281.518 145.989 C 295.397 154.451,299.651 169.944,291.460 182.204 C 279.075 200.744,254.612 198.973,245.060 178.845 C 234.650 156.906,260.788 133.350,281.518 145.989 M65.116 318.984 C 41.834 327.278,33.655 343.820,22.828 404.507 C 19.046 425.702,19.740 429.180,26.337 422.099 C 32.573 415.406,48.022 408.969,72.496 402.867 C 109.336 393.683,120.097 382.787,119.904 354.869 L 119.808 341.000 116.404 347.823 C 111.679 357.294,105.398 361.342,88.000 366.125 C 79.750 368.394,70.975 371.564,68.500 373.171 C 63.012 376.734,63.005 376.424,68.070 354.701 C 73.737 330.396,81.234 320.000,93.094 320.000 C 94.692 320.000,96.000 319.100,96.000 318.000 C 96.000 315.041,74.239 315.734,65.116 318.984 " })), style: { minWidth: "72px" } }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Tab, { icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Badge, { badgeContent: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.appTracker.getDisplayNum(), color: "primary" },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.SvgIcon, { viewBox: "0, 0, 400,400", style: { width: '28px', height: '28px' } },
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M184.000 75.671 C 157.886 84.352,136.646 102.091,124.338 125.500 L 117.765 138.000 105.383 138.035 C 90.924 138.075,71.538 141.909,56.000 147.801 C -14.626 174.580,-18.484 281.128,49.988 313.831 L 65.000 321.000 203.705 321.553 L 342.409 322.106 353.376 317.085 C 385.732 302.272,399.199 277.664,397.610 236.256 C 396.006 194.437,366.443 166.000,324.574 166.000 C 319.271 166.000,315.638 165.024,315.269 163.500 C 304.910 120.762,285.610 93.164,256.447 79.388 C 239.169 71.226,202.961 69.368,184.000 75.671 M244.970 147.777 C 301.927 179.760,259.786 271.237,199.913 245.586 L 192.826 242.549 169.913 267.273 C 142.622 296.721,133.842 300.366,127.894 284.720 C 125.394 278.145,125.295 278.289,151.476 250.369 L 173.952 226.400 169.629 216.700 C 148.789 169.946,200.388 122.743,244.970 147.777 M206.094 158.498 C 190.267 163.800,177.795 184.895,181.098 200.776 C 190.562 246.287,256.850 241.187,256.856 194.948 C 256.859 168.669,231.052 150.138,206.094 158.498 " }))), style: { minWidth: "72px" } }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Tab, { icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.SvgIcon, { viewBox: "0, 0, 400,200", style: { width: '28px', height: '28px' } },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M0.000 40.000 L 0.000 80.000 200.000 80.000 L 400.000 80.000 400.000 40.000 L 400.000 0.000 200.000 0.000 L 0.000 0.000 0.000 40.000 M80.000 40.000 L 80.000 60.000 60.000 60.000 L 40.000 60.000 40.000 40.000 L 40.000 20.000 60.000 20.000 L 80.000 20.000 80.000 40.000 M0.000 160.000 L 0.000 200.000 200.000 200.000 L 400.000 200.000 400.000 160.000 L 400.000 120.000 200.000 120.000 L 0.000 120.000 0.000 160.000 M80.000 160.000 L 80.000 180.000 60.000 180.000 L 40.000 180.000 40.000 160.000 L 40.000 140.000 60.000 140.000 L 80.000 140.000 80.000 160.000 " })), style: { minWidth: "72px" } }))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.ShadowedDivider, null),
                this.state.page == Page.Deploy ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DeployPage__WEBPACK_IMPORTED_MODULE_6__.DeployPage, { style: { flexGrow: 1 }, openUserDialogTo: this.openUserDialogTo })) : this.state.page == Page.Monitor ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_MonitorPage__WEBPACK_IMPORTED_MODULE_7__.MonitorPage, { style: { flexGrow: 1 }, openUserDialogTo: this.openUserDialogTo })) : this.state.page == Page.Machines ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_MachinesPage__WEBPACK_IMPORTED_MODULE_8__.MachinesPage, { style: { flexGrow: 1 } })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null))));
        };
        this.handleSnackbarChange = (sender, snackbar) => this.props.enqueueSnackbar(snackbar.message, snackbar.options);
        this.handleAppsChange = () => this.forceUpdate();
        this.handleJobLaunched = () => this.safeSetState({ page: Page.Monitor });
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.appTracker.appsChanged.connect(this.handleAppsChange);
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.snackbarChange.connect(this.handleSnackbarChange);
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.jobLaunched.connect(this.handleJobLaunched);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.appTracker.appsChanged.disconnect(this.handleAppsChange);
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.snackbarChange.disconnect(this.handleSnackbarChange);
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.jobLaunched.disconnect(this.handleJobLaunched);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            page: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.lastPage,
            deployDisabled: false,
        };
    }
}
const SnackbarPilot = (0,notistack__WEBPACK_IMPORTED_MODULE_2__.withSnackbar)(Pilot);



/***/ }),

/***/ "./lib/components/StatusWrapper.js":
/*!*****************************************!*\
  !*** ./lib/components/StatusWrapper.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StatusColor": () => (/* binding */ StatusColor),
/* harmony export */   "StatusWrapper": () => (/* binding */ StatusWrapper)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



var StatusColor;
(function (StatusColor) {
    StatusColor["RED"] = "#f48f8d";
    StatusColor["ORANGE"] = "#ffab61";
    StatusColor["YELLOW"] = "#fff21c";
    StatusColor["GREEN"] = "#68da7c";
    StatusColor["BLUE"] = "#10A0F9";
    StatusColor["LIGHT_BLUE"] = "#c3d7ff";
    StatusColor["PURPLE"] = "#934692";
    StatusColor["DARK_GRAY"] = "#89858b";
    StatusColor["LIGHT_GRAY"] = "#e7e5e7";
})(StatusColor || (StatusColor = {}));
class StatusWrapper extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.isLightMode = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            var color;
            if (this.props.statusColor.startsWith('var')) {
                color = getComputedStyle(document.documentElement).getPropertyValue(this.props.statusColor.replace('var(', '').replace(')', '')).trim();
            }
            else {
                color = this.props.statusColor;
            }
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: this.props.style },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Paper, { elevation: 0, style: {
                        marginLeft: '-6px',
                        background: this.props.opened ? (this.isLightMode ? (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.darken)(color, 0.5) : (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.lighten)(color, 0.5)) : color,
                        transition: 'background 750ms cubic-bezier(0.4, 0, 0.2, 1) 0ms',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { marginLeft: '6px', padding: '2px' } }, this.props.children))));
        };
        this.handleThemeChange = () => {
            this.isLightMode = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager == undefined || _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.isLight(_Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.theme);
            this.forceUpdate();
        };
        this.componentDidMount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.themeChanged.connect(this.handleThemeChange);
        };
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.themeChanged.disconnect(this.handleThemeChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.isLightMode = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager == undefined || _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.isLight(_Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.theme);
    }
}


/***/ }),

/***/ "./lib/components/Tag.js":
/*!*******************************!*\
  !*** ./lib/components/Tag.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Tag": () => (/* binding */ Tag)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _StatusWrapper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./StatusWrapper */ "./lib/components/StatusWrapper.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




const progressBorderSize = 1;
class Tag extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        // Do some extra work to avoid creating new styles every time this component renders
        this.PreviousStyledChip = null;
        this.PreviousStyledLinearProgress = null;
        this.getStyledChip = () => {
            return (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.withStyles)({
                root: {
                    position: 'relative',
                    bottom: '0px',
                    margin: `${progressBorderSize}px`,
                    height: '18px',
                    backgroundColor: this.props.solid ? (this.props.color || _StatusWrapper__WEBPACK_IMPORTED_MODULE_2__.StatusColor.DARK_GRAY) : 'var(--jp-layout-color2)',
                    fontSize: 'var(--jp-ui-font-size1)',
                    color: this.props.solid ? '#ffffff' : '',
                },
                label: {
                    overflow: 'visible',
                }
            })(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Chip);
        };
        this.getStyledLinearProgress = () => {
            return (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.withStyles)({
                root: {
                    position: 'absolute',
                    bottom: '0px',
                    height: `${18 + (2 * progressBorderSize)}px`,
                    borderRadius: `${(18 + (2 * progressBorderSize)) / 2}px`,
                },
                barColorPrimary: {
                    backgroundColor: this.props.color || '#10A0F9',
                },
                colorPrimary: {
                    backgroundColor: _StatusWrapper__WEBPACK_IMPORTED_MODULE_2__.StatusColor.DARK_GRAY,
                },
            })(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.LinearProgress);
        };
        this.handleMouseOver = (event) => {
            if (this.props.onMouseOver)
                this.props.onMouseOver(event);
        };
        this.handleMouseOut = (event) => {
            if (this.props.onMouseOut)
                this.props.onMouseOut(event);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, this.props.label != "" && this.props.label != undefined &&
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({
                        position: 'relative',
                        margin: '3px',
                    }, this.props.style), onMouseOver: this.handleMouseOver, onMouseOut: this.handleMouseOut },
                    this.props.showLoading && (this.props.percentLoaded === undefined ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledLinearProgress, { style: { width: (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.getStringWidth(this.props.label, '13px Roboto, Helvetica, Arial, sans-serif') + 14 + (2 * progressBorderSize)) + 'px' } })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledLinearProgress, { style: { width: (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.getStringWidth(this.props.label, '13px Roboto, Helvetica, Arial, sans-serif') + 14 + (2 * progressBorderSize)) + 'px' }, variant: 'determinate', value: this.props.percentLoaded * 100 }))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledChip, { key: this.props.label + this.props.color + this.props.icon, id: this.props.id, size: 'small', label: this.props.label, icon: this.props.icon, style: {
                            border: !this.props.showLoading ? '1px solid ' + (this.props.color || _StatusWrapper__WEBPACK_IMPORTED_MODULE_2__.StatusColor.DARK_GRAY) : '',
                            width: ((_Global__WEBPACK_IMPORTED_MODULE_3__.Global.getStringWidth(this.props.label, '13px Roboto, Helvetica, Arial, sans-serif') + 14) + (this.props.icon ? 14 : 0)) + 'px',
                        } }))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.StyledChip = this.getStyledChip();
        this.StyledLinearProgress = this.getStyledLinearProgress();
    }
}


/***/ }),

/***/ "./lib/components/UserDialog.js":
/*!**************************************!*\
  !*** ./lib/components/UserDialog.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "UserDialog": () => (/* binding */ UserDialog)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _material_ui_core_DialogTitle__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material-ui/core/DialogTitle */ "./node_modules/@material-ui/core/esm/DialogTitle/DialogTitle.js");
/* harmony import */ var _material_ui_icons_Close__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @material-ui/icons/Close */ "./node_modules/@material-ui/icons/Close.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _settings_SettingsMenu__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./settings/SettingsMenu */ "./lib/components/settings/SettingsMenu.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../core */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _core_WarningPopup__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../core/WarningPopup */ "./lib/core/WarningPopup.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/









const StyledDialog = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.withStyles)({
    paper: {
        width: 'calc(min(80%, 600px + 150px + 2px))',
        // width: '100%',
        height: '80%',
        overflowY: 'visible',
        backgroundColor: 'var(--jp-layout-color1)',
        maxWidth: 'inherit',
    },
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Dialog);
// TODO:Beck The popup needs to be abstracted out, there is too much going on to reproduce it in more than one file
class UserDialog extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.resolveOpenToPromise = undefined;
        this.openTo = (page) => {
            this.safeSetState({ open: true, selectedPanel: page });
            return new Promise(resolve => {
                this.resolveOpenToPromise = resolve;
            });
        };
        this.handleClickOpen = () => {
            if (this.props.onOpen)
                this.props.onOpen();
            this.safeSetState({ open: true, selectedPanel: 0 /* GENERAL */ });
        };
        this.handleClose = () => {
            this.safeSetState({ open: false, validPhoneNumber: true });
            if (this.props.onClose)
                this.props.onClose();
            if (this.resolveOpenToPromise) {
                this.resolveOpenToPromise();
                this.resolveOpenToPromise = undefined;
            }
        };
        this.handleStopClicked = (app) => {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/stop-notebook";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    uuid: app.uuid,
                }),
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
            });
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            var defaultProfilePicture = _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.name.replace(/(?<=\B)\w+/g, '').replace(/[ ]/g, '').toUpperCase();
            return (react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: Object.assign({}, this.props.style) },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.IconButton, { onClick: this.handleClickOpen, style: {
                        display: 'inline-block',
                        width: '36px',
                        height: '36px',
                        padding: '3px',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: {
                            width: '24px',
                            height: '24px',
                            // margin: '6px auto',
                            borderRadius: '12px',
                            backgroundColor: '#10A0F9',
                            color: 'white',
                            fontSize: '14px',
                            fontWeight: 'bold',
                            lineHeight: '24px',
                            textAlign: 'center'
                        } }, defaultProfilePicture[defaultProfilePicture.length - 1])),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(StyledDialog, { open: this.state.open, onClose: () => {
                        if (!this.state.validPhoneNumber) {
                            this.safeSetState({ showCloseWithInvalidNumberPopup: true });
                        }
                        else {
                            this.handleClose();
                        }
                    }, scroll: 'paper' },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core_DialogTitle__WEBPACK_IMPORTED_MODULE_4__.default, { disableTypography: true, style: {
                            display: 'inline-flex',
                            backgroundColor: 'var(--jp-layout-color2)',
                            height: '60px',
                            padding: '6px',
                            borderRadius: '4px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: {
                                display: 'inline-flex',
                                minWidth: '150px',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                paddingRight: '12px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { margin: 'auto', paddingLeft: '12px' } }, "Settings")),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { flexGrow: 1 } }),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", null,
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core_WarningPopup__WEBPACK_IMPORTED_MODULE_5__.default, { open: this.state.showLogoutWithSessionPopup, headerText: "Are you sure?", bodyText: `You have a session that is currently active. If you log out, your session will be closed.`, cancel: {
                                    text: `Cancel`,
                                    onCancel: (prevent) => {
                                        this.safeSetState({ showLogoutWithSessionPopup: false });
                                    },
                                }, continue: {
                                    text: `Close it`,
                                    onContinue: (prevent) => {
                                        this.safeSetState({ showLogoutWithSessionPopup: false });
                                        for (let app of _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.appTracker.activeSessions) {
                                            this.handleStopClicked(app);
                                        }
                                        this.logout();
                                    },
                                    color: `error`,
                                } }),
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Button, { disableElevation: true, style: { height: '36px', margin: '6px' }, variant: "contained", color: "secondary", onClick: () => {
                                    const user = _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user;
                                    if (user.appTracker.activeSessions.length != 0) {
                                        this.safeSetState({ showLogoutWithSessionPopup: true });
                                    }
                                    else {
                                        this.logout();
                                    }
                                } }, "Logout")),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", null,
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core_WarningPopup__WEBPACK_IMPORTED_MODULE_5__.default, { open: this.state.showCloseWithInvalidNumberPopup, headerText: "Heads Up!", bodyText: `The phone number you entered is invalid. If you continue we'll revert back to your previous number.`, cancel: {
                                    text: `Edit number`,
                                    onCancel: (prevent) => {
                                        this.safeSetState({ showCloseWithInvalidNumberPopup: false });
                                    },
                                }, continue: {
                                    text: `Continue`,
                                    onContinue: (prevent) => {
                                        this.safeSetState({ showCloseWithInvalidNumberPopup: false });
                                        this.handleClose();
                                    },
                                    color: `primary`,
                                } }),
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.IconButton, { onClick: () => {
                                    if (!this.state.validPhoneNumber) {
                                        this.safeSetState({ showCloseWithInvalidNumberPopup: true });
                                    }
                                    else {
                                        this.handleClose();
                                    }
                                }, style: {
                                    margin: '6px',
                                    display: 'inline-block',
                                    width: '36px',
                                    height: '36px',
                                    padding: '3px',
                                } },
                                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_icons_Close__WEBPACK_IMPORTED_MODULE_6__.default, { style: {
                                        width: '30px',
                                        height: '30px',
                                        padding: '3px',
                                    } })))),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_7__.ShadowedDivider, null),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { display: 'flex', height: 'calc(100% - 60px - 2px' } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { width: '150px' } },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.DialogContent, { style: { padding: '0px' } },
                                react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { padding: '6px' } },
                                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Tabs, { value: this.state.selectedPanel, onChange: (event, newValue) => this.safeSetState({ selectedPanel: newValue }), orientation: 'vertical', variant: 'fullWidth', indicatorColor: 'primary', textColor: 'primary', style: { minHeight: '24px' } },
                                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Tab, { label: 'GENERAL', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            }, value: 0 /* GENERAL */ }),
                                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Tab, { label: 'LIMITS', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            }, value: 1 /* LIMITS */ }),
                                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Tab, { label: 'CONNECTORS', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            }, value: 3 /* CONNECTORS */ }),
                                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Tab, { label: 'PAYMENTS', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            }, value: 2 /* PAYMENT */ }))))),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_7__.ShadowedDivider, { orientation: 'vertical' }),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { display: 'flex', flexFlow: 'column', overflow: 'hidden', width: 'calc(100% - 150px)', height: '100%' } },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.DialogContent, { style: {
                                    flexGrow: 1,
                                    overflowY: 'auto',
                                    width: '100%',
                                    height: '100%',
                                    padding: '0px',
                                    marginBottom: '0px',
                                    // lineHeight: 'var(--jp-code-line-height)',
                                    fontSize: 'var(--jp-ui-font-size1)',
                                    fontFamily: 'var(--jp-ui-font-family)',
                                } },
                                react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: {
                                        // Height needs to be 100% otherwise it will cause problems with the phone number country selection
                                        display: 'flex', flexFlow: 'column', overflow: 'hidden', height: '100%'
                                    } }, this.state.selectedPanel == 0 /* GENERAL */ ? (react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null,
                                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { display: 'flex', padding: '6px 6px 0px 6px', maxWidth: '450px' } },
                                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { width: '68px', margin: '0px 6px' } },
                                            react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: {
                                                    width: '48px',
                                                    height: '48px',
                                                    margin: '6px auto',
                                                    borderRadius: '24px',
                                                    backgroundColor: '#10A0F9',
                                                    color: 'white',
                                                    fontSize: (28 - defaultProfilePicture.length * 4) + 'px',
                                                    fontWeight: 'bold',
                                                    lineHeight: '48px',
                                                    textAlign: 'center'
                                                } }, defaultProfilePicture)),
                                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { display: 'table', height: '48px', margin: '6px' } },
                                            react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { display: 'table-cell', verticalAlign: 'middle' } },
                                                react__WEBPACK_IMPORTED_MODULE_1__.createElement("span", { style: { fontSize: '16px', lineHeight: '1', fontWeight: 'normal' } }, _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.name),
                                                react__WEBPACK_IMPORTED_MODULE_1__.createElement("br", null)))),
                                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_settings_SettingsMenu__WEBPACK_IMPORTED_MODULE_8__.AccountGeneralSubMenu, { style: { flexGrow: 1, overflowY: 'auto', maxWidth: '450px' }, phoneValidOnBlur: (valid) => {
                                            this.setState({ validPhoneNumber: valid });
                                        } }))) : this.state.selectedPanel == 1 /* LIMITS */ ? (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_settings_SettingsMenu__WEBPACK_IMPORTED_MODULE_8__.AccountLimitsSubMenu, { style: { flexGrow: 1, overflowY: 'auto', maxWidth: '450px' } })) : this.state.selectedPanel == 2 /* PAYMENT */ ? (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_settings_SettingsMenu__WEBPACK_IMPORTED_MODULE_8__.AccountPaymentSubMenu, { style: { flexGrow: 1, overflowY: 'auto', maxWidth: '450px' } })) : this.state.selectedPanel == 3 /* CONNECTORS */ && (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_settings_SettingsMenu__WEBPACK_IMPORTED_MODULE_8__.AccountConnectorsSubMenu, { style: { flexGrow: 1, overflowY: 'auto' } })))))),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { display: 'inline-flex' } }))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            if (this.props.getOpenTo)
                this.props.getOpenTo(this.openTo);
        };
        this.componentWillUnmount = () => {
            if (this.props.getOpenTo)
                this.props.getOpenTo(() => new Promise(() => { }));
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            open: false,
            selectedPanel: 0 /* GENERAL */,
            showLogoutWithSessionPopup: false,
            validPhoneNumber: true,
            showCloseWithInvalidNumberPopup: false,
        };
    }
    // Log out of the REST interface
    logout() {
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/logout";
        const init = {
            method: 'GET',
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user = null;
        });
    }
}


/***/ }),

/***/ "./lib/components/deploy/AddDataConnectorsPopup.js":
/*!*********************************************************!*\
  !*** ./lib/components/deploy/AddDataConnectorsPopup.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddDataConnectorsPopup": () => (/* binding */ AddDataConnectorsPopup)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/icons */ "webpack/sharing/consume/default/@material-ui/icons/@material-ui/icons");
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_icons__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core_DialogTitle__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material-ui/core/DialogTitle */ "./node_modules/@material-ui/core/esm/DialogTitle/DialogTitle.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _dataConnectorBrowser_DataConnectorBrowser__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./dataConnectorBrowser/DataConnectorBrowser */ "./lib/components/deploy/dataConnectorBrowser/DataConnectorBrowser.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/







const StyledDialog = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.withStyles)({
    paper: {
        width: 'calc(min(80%, 600px + 150px + 2px))',
        // width: '100%',
        height: '80%',
        overflowY: 'visible',
        backgroundColor: 'var(--jp-layout-color1)',
        maxWidth: 'inherit',
    },
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Dialog);
const StyledButton = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.withStyles)({
    root: {
        height: '20px',
        padding: '0px',
        fontSize: '12px',
        lineHeight: '12px',
        minWidth: '0px',
        margin: '0px 6px 6px 6px',
        width: '100%',
    },
    label: {
        height: '20px',
    },
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Button);
class AddDataConnectorsPopup extends react__WEBPACK_IMPORTED_MODULE_2__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.getSelectedDataConnectors = () => [];
        this.handleClickOpen = () => {
            if (this.props.onOpen)
                this.props.onOpen();
            this.safeSetState({ open: true });
        };
        this.handleClose = () => {
            this.safeSetState({ open: false });
            if (this.props.onClose)
                this.props.onClose();
        };
        this.handleAdd = () => {
            this.props.onDataConnectorsAdded(this.getSelectedDataConnectors());
            // console.log(this.getSelectedFiles())
            this.handleClose();
        };
        this.handleKeyDown = (event) => {
            if (!this.state.open || document.getElementsByClassName('MuiDialog-root').length > 1)
                return; // This means theres another popup open, so it expects the key input
            // The enter has to be a timeout because without it the file gets added but the popup doesn't close
            if (event.key === 'Enter')
                setTimeout(() => this.handleAdd(), 0);
            if (event.key === 'Escape')
                this.handleClose();
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: Object.assign({ display: 'inline-flex', width: '50%' }, this.props.style) },
                react__WEBPACK_IMPORTED_MODULE_2__.createElement(StyledButton, { onClick: this.handleClickOpen, variant: 'contained', disableElevation: true, color: 'primary' }, "+ Connector"),
                react__WEBPACK_IMPORTED_MODULE_2__.createElement(StyledDialog, { open: this.state.open, onClose: this.handleClose, scroll: 'paper' },
                    react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_core_DialogTitle__WEBPACK_IMPORTED_MODULE_4__.default, { disableTypography: true, style: {
                            display: 'inline-flex',
                            backgroundColor: 'var(--jp-layout-color2)',
                            height: '60px',
                            padding: '6px',
                            borderRadius: '4px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: {
                                display: 'inline-flex',
                                width: '100%',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                paddingRight: '12px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: { margin: 'auto 12px' } }, "Select Data Connectors")),
                        react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: { flexGrow: 1 } }),
                        react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", null,
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Button, { disableElevation: true, style: { height: '36px', margin: '6px' }, variant: 'contained', color: 'primary', onClick: this.handleAdd }, "Add")),
                        react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.IconButton, { onClick: this.handleClose, style: {
                                display: 'inline-block',
                                width: '36px',
                                height: '36px',
                                padding: '3px',
                                margin: '6px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_icons__WEBPACK_IMPORTED_MODULE_1__.Close, { style: {
                                    width: '30px',
                                    height: '30px',
                                    padding: '3px',
                                } }))),
                    react__WEBPACK_IMPORTED_MODULE_2__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.ShadowedDivider, null),
                    react__WEBPACK_IMPORTED_MODULE_2__.createElement(_dataConnectorBrowser_DataConnectorBrowser__WEBPACK_IMPORTED_MODULE_6__.default, { style: { flexGrow: 1, height: '100%', maxHeight: 'calc(100% - 60px - 60px - 2px)' }, onAdd: this.handleAdd, getSelected: (getSelectedDataConnectors) => this.getSelectedDataConnectors = getSelectedDataConnectors }),
                    react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Divider, null),
                    react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: { display: 'inline-flex', margin: '6px 100px', height: '60px' } },
                        react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: { display: 'inline-flex', flexGrow: 1, margin: 'auto' } },
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { className: 'jp-s3-logo', style: { width: '30px', height: '30px', backgroundSize: 'contain', margin: '0px 12px' } }),
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { className: 'jp-drive-logo', style: { width: '30px', height: '30px', backgroundSize: 'contain', margin: '0px 12px' } }),
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { className: 'jp-cloud-logo', style: { width: '30px', height: '30px', backgroundSize: 'contain', margin: '0px 12px' } }),
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { className: 'jp-kaggle-logo', style: { width: '30px', height: '30px', backgroundSize: 'contain', margin: '0px 12px' } }),
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { className: 'jp-wasabi-logo', style: { width: '30px', height: '30px', backgroundSize: 'contain', margin: '0px 12px' } })),
                        react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Button, { disableElevation: true, style: { height: '36px', margin: 'auto 12px' }, variant: 'contained', color: 'primary', onClick: () => {
                                this.props.openUserDialogTo(3 /* CONNECTORS */);
                                this.safeSetState({ open: false });
                            }, endIcon: react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_icons__WEBPACK_IMPORTED_MODULE_1__.OpenInNew, null) }, "Create connectors")))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            document.addEventListener('keydown', this.handleKeyDown, false);
        };
        this.componentWillUnmount = () => {
            document.removeEventListener('keydown', this.handleKeyDown, false);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            open: false,
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/AddFilesPopup.js":
/*!************************************************!*\
  !*** ./lib/components/deploy/AddFilesPopup.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddFilesPopup": () => (/* binding */ AddFilesPopup)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/icons */ "webpack/sharing/consume/default/@material-ui/icons/@material-ui/icons");
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_icons__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core_DialogTitle__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material-ui/core/DialogTitle */ "./node_modules/@material-ui/core/esm/DialogTitle/DialogTitle.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _fileBrowser_FileBrowser__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./fileBrowser/FileBrowser */ "./lib/components/deploy/fileBrowser/FileBrowser.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/







const StyledDialog = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.withStyles)({
    paper: {
        width: 'calc(min(80%, 600px + 150px + 2px))',
        // width: '100%',
        height: '80%',
        overflowY: 'visible',
        backgroundColor: 'var(--jp-layout-color1)',
        maxWidth: 'inherit',
    },
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Dialog);
const StyledButton = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.withStyles)({
    root: {
        height: '20px',
        padding: '0px',
        fontSize: '12px',
        lineHeight: '12px',
        minWidth: '0px',
        margin: '0px 6px 6px 6px',
        width: '100%',
    },
    label: {
        height: '20px',
    },
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Button);
// TODO:Beck The popup needs to be abstracted out, there is too much going on to reproduce it in more than one file
class AddFilesPopup extends react__WEBPACK_IMPORTED_MODULE_2__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.getSelectedFiles = () => [];
        this.handleClickOpen = () => {
            if (this.props.onOpen)
                this.props.onOpen();
            this.safeSetState({ open: true });
        };
        this.handleClose = () => {
            this.safeSetState({ open: false });
            if (this.props.onClose)
                this.props.onClose();
        };
        this.handleAdd = () => {
            this.props.onFilesAdded(this.getSelectedFiles());
            // console.log(this.getSelectedFiles())
            this.handleClose();
        };
        this.handleKeyDown = (event) => {
            // The enter has to be a timeout because without it the file gets added but the popup doesn't close
            if (event.key === 'Enter')
                setTimeout(() => this.handleAdd(), 0);
            if (event.key === 'Escape')
                this.handleClose();
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: Object.assign({ display: 'inline-flex', width: '50%' }, this.props.style) },
                react__WEBPACK_IMPORTED_MODULE_2__.createElement(StyledButton, { onClick: this.handleClickOpen, variant: 'contained', disableElevation: true, color: 'primary' }, "+ Upload"),
                react__WEBPACK_IMPORTED_MODULE_2__.createElement(StyledDialog, { open: this.state.open, onClose: this.handleClose, scroll: 'paper' },
                    react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_core_DialogTitle__WEBPACK_IMPORTED_MODULE_4__.default, { disableTypography: true, style: {
                            display: 'inline-flex',
                            backgroundColor: 'var(--jp-layout-color2)',
                            height: '60px',
                            padding: '6px',
                            borderRadius: '4px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: {
                                display: 'inline-flex',
                                minWidth: '225px',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                paddingRight: '12px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: { margin: 'auto', paddingLeft: '12px' } }, "Select Files or Directories")),
                        react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: { flexGrow: 1 } }),
                        react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", null,
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Button, { disableElevation: true, style: { height: '36px', margin: '6px' }, variant: 'contained', color: 'primary', onClick: this.handleAdd }, "Add")),
                        react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.IconButton, { onClick: this.handleClose, style: {
                                display: 'inline-block',
                                width: '36px',
                                height: '36px',
                                padding: '3px',
                                margin: '6px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_icons__WEBPACK_IMPORTED_MODULE_1__.Close, { style: {
                                    width: '30px',
                                    height: '30px',
                                    padding: '3px',
                                } }))),
                    react__WEBPACK_IMPORTED_MODULE_2__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.ShadowedDivider, null),
                    react__WEBPACK_IMPORTED_MODULE_2__.createElement(_fileBrowser_FileBrowser__WEBPACK_IMPORTED_MODULE_6__.default, { style: { maxHeight: 'calc(100% - 60px - 2px)' }, onAdd: this.handleAdd, getSelectedFiles: (getSelectedFiles) => this.getSelectedFiles = getSelectedFiles }))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            document.addEventListener('keydown', this.handleKeyDown, false);
        };
        this.componentWillUnmount = () => {
            document.removeEventListener('keydown', this.handleKeyDown, false);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            open: false,
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/AmazonS3ConnectorPopup.js":
/*!*********************************************************!*\
  !*** ./lib/components/deploy/AmazonS3ConnectorPopup.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AmazonS3ConnectorPopup": () => (/* binding */ AmazonS3ConnectorPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core */ "./lib/core/Dropdown.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core */ "./lib/core/TextBox.js");
/* harmony import */ var _dataConnectorBrowser_DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./dataConnectorBrowser/DataConnectorDirListingItemIcon */ "./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListingItemIcon.js");
/* harmony import */ var _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/BaseConnectorPopup */ "./lib/core/BaseConnectorPopup.js");
/* harmony import */ var _models_AWSRegions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../models/AWSRegions */ "./lib/models/AWSRegions.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






const defaultState = {
    region: _models_AWSRegions__WEBPACK_IMPORTED_MODULE_1__.AWSRegions.US_EAST_1.region,
    bucketName: '',
    objectKey: '',
    accessKeyID: '',
    secretAccessKey: '',
};
class AmazonS3ConnectorPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClose = () => {
            if (this.props.onClose)
                this.props.onClose();
            this.safeSetState(defaultState);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup, { dataService: _dataConnectorBrowser_DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_4__.DataService.AMAZON_S3, iconClass: 'jp-s3-logo', description: 'Access an S3 bucket', header: 'Connect to an Amazon S3 bucket or object.', downloadPath: '', onClose: this.handleClose, getInfo: () => this.state, getContents: (waiting) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.Dropdown, { getValue: () => this.state.region, saveValue: (value) => this.safeSetState({ region: value }), label: 'Region', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup.LABEL_WIDTH, values: _models_AWSRegions__WEBPACK_IMPORTED_MODULE_1__.AWSRegions.values.map(x => { return { value: x.region, description: x.description }; }), helperText: 'The service region as specified in S3 documentation.' }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.TextBox, { getValue: () => this.state.bucketName, saveValue: (value) => this.safeSetState({ bucketName: value }), label: 'Bucket Name', helperText: 'The Bucket Name as specified in S3 documentation.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.TextBox, { getValue: () => this.state.objectKey, saveValue: (value) => this.safeSetState({ objectKey: value }), label: 'Object Key', helperText: 'If you leave this blank, we will transfer the entire bucket.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.TextBox, { getValue: () => this.state.accessKeyID, saveValue: (value) => this.safeSetState({ accessKeyID: value }), label: 'Access Key ID', helperText: 'The Access Key ID as specified in S3 documentation.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.TextBox, { getValue: () => this.state.secretAccessKey, saveValue: (value) => this.safeSetState({ secretAccessKey: value }), label: 'Secret Access Key', helperText: 'The Secret Access Key as specified in S3 documentation.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }))) }));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = defaultState;
    }
}


/***/ }),

/***/ "./lib/components/deploy/AnnotationInput.js":
/*!**************************************************!*\
  !*** ./lib/components/deploy/AnnotationInput.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AnnotationInput": () => (/* binding */ AnnotationInput)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



const StyledInput = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.withStyles)({
    root: {
        fontSize: 'var(--jp-ui-font-size1)',
        lineHeight: '1',
        fontWeight: 'normal',
        width: '200px',
    },
    input: {
        padding: '2px 0px',
    },
    underline: {
        '&:hover:before': {
            borderBottom: '1px solid rgba(0, 0, 0, 0.87) !important',
        },
        '&::before': {
            borderBottom: 'none',
        },
    },
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Input);
class AnnotationInput extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(StyledInput, { inputRef: this.textField, value: this.state.value, onChange: (event) => {
                        const value = event.target.value;
                        this.safeSetState({ value: value });
                    }, onKeyDown: (e) => {
                        if (e.key === 'Enter') {
                            this.textField.current.blur();
                        }
                    }, onBlur: () => this.props.saveValue(this.state.value), placeholder: this.props.placeholder })));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.textField = react__WEBPACK_IMPORTED_MODULE_1__.createRef();
        this.state = {
            value: this.props.getValue(),
            editing: false,
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/DataConnectorIdentity.js":
/*!********************************************************!*\
  !*** ./lib/components/deploy/DataConnectorIdentity.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DataConnectorIdentity": () => (/* binding */ DataConnectorIdentity)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _dataConnectorBrowser_DataConnectorDirListingItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./dataConnectorBrowser/DataConnectorDirListingItem */ "./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListingItem.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class DataConnectorIdentity extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({}, this.props.style) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_dataConnectorBrowser_DataConnectorDirListingItem__WEBPACK_IMPORTED_MODULE_2__.default, { key: this.props.dataService, dataConnectorMetadata: {
                        name: this.props.description,
                        dataService: this.props.dataService,
                    }, selected: false, handleButtonClick: this.props.handleClick, buttonText: 'Create', buttonColor: '#10A0F9', onClick: () => false, onDoubleClick: () => false }))
            // <div style={{margin: '6px'}}>
            //     <div style={{display: 'inline-flex', width: '100%', height: '40px'}}>
            //         <div className={this.props.iconClass} style={{width: '30px', margin: '6px 6px 6px 12px'}}/>
            //         <div style={{margin: 'auto 6px', lineHeight: '14px', width: this.props.description && '92px'}}>
            //             <div style={{fontWeight: 'bold'}}>
            //                 {this.props.provider}
            //             </div>
            //             {this.props.service != '' && (
            //                 <div>
            //                     {this.props.service}
            //                 </div>
            //             )}
            //         </div>
            //         {this.props.description && <div style={{flexGrow: 1, margin: 'auto 12px', maxWidth: '160px'}}>
            //             {this.props.description}
            //         </div>}
            //         {this.props.handleClick && <Button
            //             onClick={this.props.handleClick}
            //             style={{
            //             //     padding: '6px',
            //             //     fontWeight: 'bold',
            //             //     height: '24px',
            //                 margin: 'auto 12px',
            //             }}
            //             variant='outlined'
            //             color='primary'
            //             disableElevation
            //         >
            //             Create   
            //         </Button>}
            //     </div>
            // </div>
            );
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/FilesPanel.js":
/*!*********************************************!*\
  !*** ./lib/components/deploy/FilesPanel.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FilesPanel": () => (/* binding */ ThemedFilesPanel)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_core_styles_withStyles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material-ui/core/styles/withStyles */ "./node_modules/@material-ui/core/styles/withStyles.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core */ "./lib/core/Header.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core */ "./lib/core/TextBox.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _models_FileUploadConfig__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../models/FileUploadConfig */ "./lib/models/FileUploadConfig.js");
/* harmony import */ var _material_ui_icons_Close__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @material-ui/icons/Close */ "./node_modules/@material-ui/icons/Close.js");
/* harmony import */ var _utils_FileServerUtils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../utils/FileServerUtils */ "./lib/utils/FileServerUtils.js");
/* harmony import */ var _AddFilesPopup__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./AddFilesPopup */ "./lib/components/deploy/AddFilesPopup.js");
/* harmony import */ var _fileBrowser_DirListingItemIcon__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./fileBrowser/DirListingItemIcon */ "./lib/components/deploy/fileBrowser/DirListingItemIcon.js");
/* harmony import */ var _AddDataConnectorsPopup__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./AddDataConnectorsPopup */ "./lib/components/deploy/AddDataConnectorsPopup.js");
/* harmony import */ var _models_DataConnectorUploadConfig__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../models/DataConnectorUploadConfig */ "./lib/models/DataConnectorUploadConfig.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _dataConnectorBrowser_DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./dataConnectorBrowser/DataConnectorDirListingItemIcon */ "./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListingItemIcon.js");
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material-ui/icons */ "webpack/sharing/consume/default/@material-ui/icons/@material-ui/icons");
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_material_ui_icons__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _NotificationsPopup__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./NotificationsPopup */ "./lib/components/deploy/NotificationsPopup.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
















// const emDirNotFile = 'Path is a directory, not a file'
// const emDupPath = 'Duplicate file or directory'
// const emNoPath = 'Unable to find file or directory'
// const bounceAnimation = 'all 333ms cubic-bezier(0.33, 1.33, 0.66, 1) 0s'
const easeAnimation = 'all 150ms ease 0s';
const StyledAccordion = (0,_material_ui_core_styles_withStyles__WEBPACK_IMPORTED_MODULE_4__.default)({
    root: {
        borderWidth: '0px',
        '&.Mui-expanded': {
            margin: '0px',
        },
        '&:before': {
            backgroundColor: 'unset',
        },
    },
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Accordion);
const StyledAccordionSummary = (0,_material_ui_core_styles_withStyles__WEBPACK_IMPORTED_MODULE_4__.default)({
    root: {
        padding: '0px',
        minHeight: '0px',
        '&.Mui-expanded': {
            minHeight: '0px',
        },
    },
    content: {
        margin: '0px',
        '&.Mui-expanded': {
            margin: '0px',
        },
    },
    expandIcon: {
        padding: '0px',
        marginRight: '0px',
    },
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.AccordionSummary);
const StyledAccordionDetails = (0,_material_ui_core_styles_withStyles__WEBPACK_IMPORTED_MODULE_4__.default)({
    root: {
        display: 'flex',
        flexDirection: 'column',
        padding: '0px',
    },
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.AccordionDetails);
class FilesPanel extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.getStyledOutlinedInput = () => {
            return (0,_material_ui_core_styles_withStyles__WEBPACK_IMPORTED_MODULE_4__.default)({
                root: {
                    backgroundColor: 'var(--jp-layout-color1)'
                },
                input: {
                    fontSize: '12px',
                    padding: '3px 6px 3px 6px',
                },
            })(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.OutlinedInput);
        };
        this.getRequirementsValue = () => {
            const tracker = _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata;
            const optumi = tracker.getMetadata();
            const uploads = optumi.config.upload;
            return uploads.requirements;
        };
        this.saveRequirements = (value) => {
            const tracker = _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata;
            const optumi = tracker.getMetadata();
            const uploads = optumi.config.upload;
            uploads.requirements = value;
            tracker.setMetadata(optumi);
            return '';
        };
        this.pathHasError = (path) => {
            const tracker = _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata;
            const optumi = tracker.getMetadata();
            const upload = optumi.config.upload;
            const files = upload.files;
            for (var i = 0; i < files.length; i++) {
                if (files[i].path === path)
                    return true;
            }
            return false;
        };
        this.nameHasError = (name) => {
            const tracker = _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata;
            const optumi = tracker.getMetadata();
            const upload = optumi.config.upload;
            const dataConnectors = upload.dataConnectors;
            for (var i = 0; i < dataConnectors.length; i++) {
                if (dataConnectors[i].name === name)
                    return true;
            }
            return false;
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const optumi = _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata.getMetadata().config;
            const files = optumi.upload.files;
            const dataConnectors = optumi.upload.dataConnectors;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: this.props.style },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledAccordion, { variant: 'outlined', expanded: this.state.packagesExpanded, style: { background: 'var(--jp-layout-color1)' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledAccordionSummary, { style: { cursor: 'default' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.SubHeader, { title: 'Packages' }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { style: {
                                margin: 'auto 15px',
                                flexGrow: 1,
                                textAlign: 'end',
                                opacity: this.state.packagesExpanded ? 0 : 0.5,
                                transitionDuration: '217ms',
                                whiteSpace: 'nowrap',
                                fontSize: '12px',
                                fontStyle: 'italic',
                            } }, (() => {
                            const requirements = optumi.upload.requirements;
                            const numRequirements = requirements === '' ? 0 : requirements.split('\n').filter(line => line !== '').length;
                            if (numRequirements > 0) {
                                return numRequirements + ' requirement' + (numRequirements > 1 ? 's' : '');
                            }
                        })()),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.IconButton, { onClick: () => this.safeSetState({ packagesExpanded: !this.state.packagesExpanded }), style: { padding: '0px', marginRight: '-3px', width: '30px' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons__WEBPACK_IMPORTED_MODULE_3__.ExpandMore, null))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledAccordionDetails, null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'flex', width: '100%' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_7__.TextBox, { key: optumi.upload.requirements, multiline: true, getValue: this.getRequirementsValue, saveValue: this.saveRequirements, placeholder: 'package==version', style: { padding: '0px 0px 6px 0px' } })))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledAccordion, { variant: 'outlined', expanded: this.state.filesExpanded, style: { background: 'var(--jp-layout-color1)' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledAccordionSummary, { style: { cursor: 'default' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.SubHeader, { title: 'Files' }),
                        (this.state.problemFiles.length > 0 || this.state.problemDataConnectors.length > 0) && react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons__WEBPACK_IMPORTED_MODULE_3__.WarningRounded, { fontSize: 'small', style: { color: this.props.theme.palette.error.main, marginTop: '4px' } }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { style: {
                                margin: 'auto 15px',
                                flexGrow: 1,
                                textAlign: 'end',
                                opacity: this.state.filesExpanded ? 0 : 0.5,
                                transitionDuration: '217ms',
                                whiteSpace: 'nowrap',
                                fontSize: '12px',
                                fontStyle: 'italic',
                            } },
                            files.length > 0 && (files.length + ' upload' + (files.length > 1 ? 's' : '')),
                            files.length > 0 && dataConnectors.length > 0 ? ', ' : '',
                            dataConnectors.length > 0 && (dataConnectors.length + ' connector' + (dataConnectors.length > 1 ? 's' : ''))),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.IconButton, { onClick: () => this.safeSetState({ filesExpanded: !this.state.filesExpanded }), style: { padding: '0px', marginRight: '-3px', width: '30px' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons__WEBPACK_IMPORTED_MODULE_3__.ExpandMore, null))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledAccordionDetails, null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'inline-flex', width: '100%' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AddFilesPopup__WEBPACK_IMPORTED_MODULE_8__.AddFilesPopup, { onFilesAdded: async (metadatas) => {
                                    for (let fileModel of metadatas) {
                                        // Don't try to add the same file/directory more than once
                                        if (this.pathHasError(fileModel.path))
                                            continue;
                                        const tracker = _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata;
                                        const optumi = tracker.getMetadata();
                                        var files = optumi.config.upload.files;
                                        if (fileModel.type != 'directory') {
                                            files.push(new _models_FileUploadConfig__WEBPACK_IMPORTED_MODULE_9__.FileUploadConfig({
                                                path: fileModel.path,
                                                type: fileModel.type,
                                                mimetype: fileModel.mimetype,
                                                files: [fileModel.path]
                                            }));
                                        }
                                        else {
                                            files.push(new _models_FileUploadConfig__WEBPACK_IMPORTED_MODULE_9__.FileUploadConfig({
                                                path: fileModel.path,
                                                type: fileModel.type,
                                                mimetype: fileModel.mimetype,
                                                files: (await _utils_FileServerUtils__WEBPACK_IMPORTED_MODULE_10__.default.getRecursiveTree(fileModel.path))
                                            }));
                                        }
                                        tracker.setMetadata(optumi);
                                    }
                                } }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AddDataConnectorsPopup__WEBPACK_IMPORTED_MODULE_11__.AddDataConnectorsPopup, { openUserDialogTo: this.props.openUserDialogTo, onDataConnectorsAdded: async (metadatas) => {
                                    for (let dataConnectorModel of metadatas) {
                                        // Don't try to add the same file/directory more than once
                                        if (this.nameHasError(dataConnectorModel.name))
                                            continue;
                                        const tracker = _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata;
                                        const optumi = tracker.getMetadata();
                                        var dataConnectors = optumi.config.upload.dataConnectors;
                                        dataConnectors.push(new _models_DataConnectorUploadConfig__WEBPACK_IMPORTED_MODULE_12__.DataConnectorUploadConfig({
                                            name: dataConnectorModel.name,
                                            dataService: dataConnectorModel.dataService,
                                        }));
                                        tracker.setMetadata(optumi);
                                    }
                                } })),
                        files.length == 0 && dataConnectors.length == 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                                fontSize: '12px',
                                lineHeight: '14px',
                                padding: '3px 6px 3px 6px',
                            } }, "None")) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                            files.map((value) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(ResourceFile, { key: value.path, file: value, handleFileDelete: () => {
                                    const tracker = _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata;
                                    const optumi = tracker.getMetadata();
                                    const files = optumi.config.upload.files;
                                    for (var i = 0; i < files.length; i++) {
                                        if (files[i].path === value.path) {
                                            files.splice(i, 1);
                                            break;
                                        }
                                    }
                                    // optumi.upload.files = (optumi.upload.files as UploadVarMetadata[]).filter(x => x.path !== (event.currentTarget as HTMLButtonElement).id.replace('-delete', ''));
                                    tracker.setMetadata(optumi);
                                    if (this.state.problemFiles.includes(value.path))
                                        this.safeSetState({ problemFiles: this.state.problemFiles.filter(x => x != value.path) });
                                }, noLongerExists: this.state.problemFiles.includes(value.path) }))),
                            dataConnectors.map((value) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(ResourceDataConnector, { key: value.name, dataConnector: value, handleFileDelete: () => {
                                    const tracker = _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata;
                                    const optumi = tracker.getMetadata();
                                    const dataConnectors = optumi.config.upload.dataConnectors;
                                    for (var i = 0; i < dataConnectors.length; i++) {
                                        if (dataConnectors[i].name === value.name) {
                                            dataConnectors.splice(i, 1);
                                            break;
                                        }
                                    }
                                    // optumi.upload.files = (optumi.upload.files as UploadVarMetadata[]).filter(x => x.path !== (event.currentTarget as HTMLButtonElement).id.replace('-delete', ''));
                                    tracker.setMetadata(optumi);
                                    if (this.state.problemDataConnectors.includes(value.name))
                                        this.safeSetState({ problemDataConnectors: this.state.problemDataConnectors.filter(x => x != value.name) });
                                }, noLongerExists: this.state.problemDataConnectors.includes(value.name) }))))))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledAccordionSummary, { style: { cursor: 'default' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.SubHeader, { title: 'Notifications' }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { style: {
                            margin: 'auto 15px',
                            flexGrow: 1,
                            textAlign: 'end',
                            opacity: 0.5,
                            transitionDuration: '217ms',
                            whiteSpace: 'nowrap',
                            fontSize: '12px',
                            fontStyle: 'italic',
                        } }, (() => {
                        let numEnabled = 0;
                        const config = _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata.getMetadata().config;
                        if (!config.interactive) {
                            const notifications = config.notifications;
                            if (notifications.jobStartedSMSEnabled)
                                numEnabled++;
                            if (notifications.jobFailedSMSEnabled || notifications.jobCompletedSMSEnabled)
                                numEnabled++;
                            // TODO:JJ This currently does not refresh automatically when Global.user.notificationsEnabled changes, and I wasn't sure how to quickly do this.
                            if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.user.notificationsEnabled && numEnabled > 0) {
                                return numEnabled + ' enabled';
                            }
                        }
                    })()),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_NotificationsPopup__WEBPACK_IMPORTED_MODULE_13__.NotificationsPopup, { disabled: _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata.getMetadata().config.interactive, openUserDialogTo: this.props.openUserDialogTo }))));
        };
        this.refreshFiles = async () => {
            if (this.refreshingFiles) {
                if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnPoll)
                    console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                setTimeout(this.refreshFiles, 60000);
                const optumi = _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata.getMetadata().config;
                const files = optumi.upload.files;
                for (var file of files) {
                    if (!this.refreshingFiles)
                        break;
                    if (!this.state.problemFiles.includes(file.path)) {
                        const barr = await _utils_FileServerUtils__WEBPACK_IMPORTED_MODULE_10__.default.checkIfPathExists(file.path);
                        if (!barr[0]) {
                            this.safeSetState({ problemFiles: this.state.problemFiles.concat([file.path]) });
                        }
                    }
                }
            }
        };
        this.refreshDataConnectors = async () => {
            if (this.refreshingDataConnectors) {
                if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnPoll)
                    console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                setTimeout(this.refreshDataConnectors, 60000);
                const optumi = _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata.getMetadata().config;
                const dataConnectors = optumi.upload.dataConnectors;
                const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
                const url = settings.baseUrl + "optumi/get-data-connectors";
                const dataConnectorsFromController = await (_jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, {}, settings).then(response => {
                    if (response.status !== 200)
                        throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.ResponseError(response);
                    return response.json();
                }).then((json) => json.connectors));
                for (var dataConnector of dataConnectors) {
                    if (!this.refreshingDataConnectors)
                        break;
                    if (!this.state.problemDataConnectors.includes(dataConnector.name)) {
                        const exists = dataConnectorsFromController.map(x => x.name).includes(dataConnector.name);
                        if (!exists) {
                            this.safeSetState({ problemDataConnectors: this.state.problemDataConnectors.concat([dataConnector.name]) });
                        }
                    }
                }
            }
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        this.handleLabShellChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            this.refreshingFiles = true;
            this.refreshingDataConnectors = true;
            this.refreshFiles();
            this.refreshDataConnectors();
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.labShell.currentChanged.connect(this.handleLabShellChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.labShell.currentChanged.disconnect(this.handleLabShellChange);
            this.refreshingFiles = false;
            this.refreshingDataConnectors = false;
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.StyledOutlinedInput = this.getStyledOutlinedInput();
        this.textField = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
        this.state = {
            filePath: '',
            problemFiles: [],
            problemDataConnectors: [],
            packagesExpanded: false,
            filesExpanded: false,
        };
    }
}
const ThemedFilesPanel = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.withTheme)(FilesPanel);

class ResourceFile extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'flex', width: '100%', position: 'relative' }, onMouseOver: () => {
                    this.safeSetState({ hovering: true });
                }, onMouseOut: () => {
                    this.safeSetState({ hovering: false });
                } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                        position: 'absolute',
                        right: '-16px',
                        display: 'inline-flex',
                        background: 'var(--jp-layout-color1)',
                        opacity: this.state.hovering ? '1' : '0',
                        transition: easeAnimation,
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.IconButton, { onClick: this.props.handleFileDelete, style: {
                            width: '22px',
                            height: '22px',
                            padding: '0px',
                            position: 'relative',
                            display: 'inline-block',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_Close__WEBPACK_IMPORTED_MODULE_14__.default, { style: { position: 'relative', width: '16px', height: '16px' } }))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                        width: '100%',
                        fontSize: '12px',
                        lineHeight: '14px',
                        padding: '3px 6px 3px 6px',
                        display: 'inline-flex'
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_fileBrowser_DirListingItemIcon__WEBPACK_IMPORTED_MODULE_15__.default, { fileType: this.props.file.type, mimetype: this.props.file.mimetype }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                            margin: 'auto 0px',
                            overflow: 'hidden',
                            color: this.props.noLongerExists ? '#f48f8d' : ''
                        }, title: (this.props.file.path.includes('/') ? (`Name: ${this.props.file.path.split('/').pop()}
Path: ${this.props.file.path.replace(/\/[^\/]*$/, '')}`) : (`Name: ${this.props.file.path.split('/').pop()}`)) },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                                direction: 'rtl',
                                overflow: 'hidden',
                                textOverflow: 'ellipsis',
                                whiteSpace: 'nowrap',
                            } }, this.props.file.path + (this.props.noLongerExists ? ' (no longer exists)' : ''))))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            hovering: false,
        };
    }
}
class ResourceDataConnector extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'flex', width: '100%', position: 'relative' }, onMouseOver: () => {
                    this.safeSetState({ hovering: true });
                }, onMouseOut: () => {
                    this.safeSetState({ hovering: false });
                } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                        position: 'absolute',
                        right: '-16px',
                        display: 'inline-flex',
                        background: 'var(--jp-layout-color1)',
                        opacity: this.state.hovering ? '1' : '0',
                        transition: easeAnimation,
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.IconButton, { onClick: this.props.handleFileDelete, style: {
                            width: '22px',
                            height: '22px',
                            padding: '0px',
                            position: 'relative',
                            display: 'inline-block',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_Close__WEBPACK_IMPORTED_MODULE_14__.default, { style: { position: 'relative', width: '16px', height: '16px' } }))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                        width: '100%',
                        fontSize: '12px',
                        lineHeight: '14px',
                        padding: '3px 6px 3px 6px',
                        display: 'inline-flex'
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_dataConnectorBrowser_DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_16__.default, { dataService: this.props.dataConnector.dataService }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                            margin: 'auto 0px',
                            overflow: 'hidden',
                            textOverflow: 'ellipsis',
                            whiteSpace: 'nowrap',
                            direction: 'rtl',
                            color: this.props.noLongerExists ? '#f48f8d' : ''
                        } }, this.props.dataConnector.name + (this.props.noLongerExists ? ' (no longer exists)' : '')))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            hovering: false,
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/GoogleCloudStorageConnectorPopup.js":
/*!*******************************************************************!*\
  !*** ./lib/components/deploy/GoogleCloudStorageConnectorPopup.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GoogleCloudStorageConnectorPopup": () => (/* binding */ GoogleCloudStorageConnectorPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core */ "./lib/core/TextBox.js");
/* harmony import */ var _dataConnectorBrowser_DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./dataConnectorBrowser/DataConnectorDirListingItemIcon */ "./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListingItemIcon.js");
/* harmony import */ var _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/BaseConnectorPopup */ "./lib/core/BaseConnectorPopup.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





const defaultState = {
    bucketName: '',
    serviceAccountKey: '',
};
class GoogleCloudStorageConnectorPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClose = () => {
            if (this.props.onClose)
                this.props.onClose();
            this.safeSetState(defaultState);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup, { dataService: _dataConnectorBrowser_DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__.DataService.GOOGLE_CLOUD_STORAGE, iconClass: 'jp-cloud-logo', description: 'Access a Cloud Storage bucket', header: 'Connect to a Google Cloud Storage bucket using a Service Account.', downloadPath: '', onClose: this.handleClose, getInfo: () => this.state, getContents: (waiting) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { getValue: () => this.state.bucketName, saveValue: (value) => this.safeSetState({ bucketName: value }), label: 'Bucket Name', helperText: 'The Bucket Name as specified in Google Cloud Storage documentation.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { getValue: () => this.state.serviceAccountKey, saveValue: (value) => this.safeSetState({ serviceAccountKey: value }), label: 'Service Account Key', helperText: 'The contents of the credentials file generated for your Google Service Account.', helperLink: { link: 'https://cloud.google.com/iam/docs/service-accounts', text: 'learn more' }, labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, multiline: true, minLines: 5 }))) }));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = defaultState;
    }
}


/***/ }),

/***/ "./lib/components/deploy/GoogleDriveConnectorPopup.js":
/*!************************************************************!*\
  !*** ./lib/components/deploy/GoogleDriveConnectorPopup.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GoogleDriveConnectorPopup": () => (/* binding */ GoogleDriveConnectorPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core */ "./lib/core/TextBox.js");
/* harmony import */ var _dataConnectorBrowser_DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./dataConnectorBrowser/DataConnectorDirListingItemIcon */ "./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListingItemIcon.js");
/* harmony import */ var _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/BaseConnectorPopup */ "./lib/core/BaseConnectorPopup.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





const defaultState = {
    fileID: '',
    serviceAccountKey: '',
};
class GoogleDriveConnectorPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClose = () => {
            if (this.props.onClose)
                this.props.onClose();
            this.safeSetState(defaultState);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup, { dataService: _dataConnectorBrowser_DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__.DataService.GOOGLE_DRIVE, iconClass: 'jp-drive-logo', description: 'Access a Drive file', header: 'Connect to a Google Drive file using a Service Account.', downloadPath: '', onClose: this.handleClose, getInfo: () => this.state, getContents: (waiting) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { getValue: () => this.state.fileID, saveValue: (value) => this.safeSetState({ fileID: value }), label: 'File ID', helperText: 'The unique ID found in the sharable link.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { getValue: () => this.state.serviceAccountKey, saveValue: (value) => this.safeSetState({ serviceAccountKey: value }), label: 'Service Account Key', helperText: 'The contents of the credentials file generated for your Google Service Account.', helperLink: { link: 'https://cloud.google.com/iam/docs/service-accounts', text: 'learn more' }, labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, multiline: true, minLines: 5 }))) }));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = defaultState;
    }
}


/***/ }),

/***/ "./lib/components/deploy/KaggleConnectorPopup.js":
/*!*******************************************************!*\
  !*** ./lib/components/deploy/KaggleConnectorPopup.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "KaggleConnectorPopup": () => (/* binding */ KaggleConnectorPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core */ "./lib/core/TextBox.js");
/* harmony import */ var _dataConnectorBrowser_DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./dataConnectorBrowser/DataConnectorDirListingItemIcon */ "./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListingItemIcon.js");
/* harmony import */ var _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/BaseConnectorPopup */ "./lib/core/BaseConnectorPopup.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





const defaultState = {
    datasetName: '',
    username: '',
    key: '',
};
class KaggleConnectorPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClose = () => {
            if (this.props.onClose)
                this.props.onClose();
            this.safeSetState(defaultState);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup, { dataService: _dataConnectorBrowser_DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__.DataService.KAGGLE, iconClass: 'jp-kaggle-logo', description: 'Access a Kaggle dataset', header: 'Connect to a Kaggle dataset using an API Token.', downloadPath: '', onClose: this.handleClose, getInfo: () => this.state, getContents: (waiting) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { getValue: () => this.state.datasetName, saveValue: (value) => this.safeSetState({ datasetName: value }), label: 'Dataset Name', helperText: 'The unique data set name as specified in Kaggle documentation.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { getValue: () => this.state.username, saveValue: (value) => this.safeSetState({ username: value }), label: 'Username', helperText: 'Your kaggle username.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { getValue: () => this.state.key, saveValue: (value) => this.safeSetState({ key: value }), label: 'Key', helperText: 'The key generated with an API token.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }))) }));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = defaultState;
    }
}


/***/ }),

/***/ "./lib/components/deploy/NotificationsPopup.js":
/*!*****************************************************!*\
  !*** ./lib/components/deploy/NotificationsPopup.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "NotificationsPopup": () => (/* binding */ NotificationsPopup)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/icons */ "webpack/sharing/consume/default/@material-ui/icons/@material-ui/icons");
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_icons__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core_DialogTitle__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material-ui/core/DialogTitle */ "./node_modules/@material-ui/core/esm/DialogTitle/DialogTitle.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _core_NotificationContent__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/NotificationContent */ "./lib/core/NotificationContent.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/







const StyledDialog = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.withStyles)({
    paper: {
        width: 'calc(min(80%, 600px + 150px + 2px))',
        // width: '100%',
        height: '80%',
        overflowY: 'visible',
        backgroundColor: 'var(--jp-layout-color1)',
        maxWidth: 'inherit',
    },
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Dialog);
// TODO:Beck The popup needs to be abstracted out, there is too much going on to reproduce it in more than one file
class NotificationsPopup extends react__WEBPACK_IMPORTED_MODULE_2__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClickOpen = () => {
            if (this.props.onOpen)
                this.props.onOpen();
            this.safeSetState({ open: true });
        };
        this.handleClose = () => {
            this.safeSetState({ open: false });
            if (this.props.onClose)
                this.props.onClose();
        };
        this.handleKeyDown = (event) => {
            if (event.key === 'Escape')
                this.handleClose();
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: Object.assign({ margin: 'auto' }, this.props.style) },
                react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.IconButton, { onClick: this.handleClickOpen, style: { padding: '0px', marginRight: '-3px', width: '30px', height: '30px' }, disabled: this.props.disabled },
                    react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_icons__WEBPACK_IMPORTED_MODULE_1__.AddAlert, { style: { height: '21px' } })),
                react__WEBPACK_IMPORTED_MODULE_2__.createElement(StyledDialog, { open: this.state.open, onClose: this.handleClose, scroll: 'paper' },
                    react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_core_DialogTitle__WEBPACK_IMPORTED_MODULE_4__.default, { disableTypography: true, style: {
                            display: 'inline-flex',
                            backgroundColor: 'var(--jp-layout-color2)',
                            height: '60px',
                            padding: '6px',
                            borderRadius: '4px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: {
                                display: 'inline-flex',
                                minWidth: '225px',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                paddingRight: '12px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: { margin: 'auto', paddingLeft: '12px' } }, "Configure Notifications")),
                        react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: { flexGrow: 1 } }),
                        react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.IconButton, { onClick: this.handleClose, style: {
                                display: 'inline-block',
                                width: '36px',
                                height: '36px',
                                padding: '3px',
                                margin: '6px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_icons__WEBPACK_IMPORTED_MODULE_1__.Close, { style: {
                                    width: '30px',
                                    height: '30px',
                                    padding: '3px',
                                } }))),
                    react__WEBPACK_IMPORTED_MODULE_2__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.ShadowedDivider, null),
                    react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: {
                            padding: '12px',
                            fontSize: 'var(--jp-ui-font-size1)',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_2__.createElement(_core_NotificationContent__WEBPACK_IMPORTED_MODULE_6__.NotificationContent, { getValue: () => _Global__WEBPACK_IMPORTED_MODULE_3__.Global.metadata.getMetadata().config, saveValue: (config) => {
                                const metadata = _Global__WEBPACK_IMPORTED_MODULE_3__.Global.metadata.getMetadata();
                                metadata.config = config;
                                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.metadata.setMetadata(metadata);
                            }, openUserDialogTo: this.props.openUserDialogTo, handleClose: this.handleClose })))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            document.addEventListener('keydown', this.handleKeyDown, false);
        };
        this.componentWillUnmount = () => {
            document.removeEventListener('keydown', this.handleKeyDown, false);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            open: false,
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/OutlinedResourceRadio.js":
/*!********************************************************!*\
  !*** ./lib/components/deploy/OutlinedResourceRadio.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OutlinedResourceRadio": () => (/* binding */ OutlinedResourceRadio)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core_styles_withStyles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/core/styles/withStyles */ "./node_modules/@material-ui/core/styles/withStyles.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _material_ui_icons_RadioButtonUnchecked__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material-ui/icons/RadioButtonUnchecked */ "./node_modules/@material-ui/icons/RadioButtonUnchecked.js");
/* harmony import */ var _material_ui_icons_CheckCircle__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material-ui/icons/CheckCircle */ "./node_modules/@material-ui/icons/CheckCircle.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






class OutlinedResourceRadio extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.handleMouseOver = (event) => {
            if (this.props.onMouseOver)
                this.props.onMouseOver(event);
        };
        this.handleMouseOut = (event) => {
            if (this.props.onMouseOut)
                this.props.onMouseOut(event);
        };
        this.getStyledButton = (color) => {
            return (0,_material_ui_core_styles_withStyles__WEBPACK_IMPORTED_MODULE_2__.default)({
                root: {
                    textAlign: 'center',
                    fontWeight: 'normal',
                    display: 'inline-flex',
                    padding: '6px',
                    height: '34px',
                    border: '2px solid ' + color + '80',
                    borderRadius: '6px',
                    margin: '0px 6px 6px 6px',
                    width: 'calc(100% - 12px)',
                    transition: 'background-color 250ms cubic-bezier(0.4, 0, 0.2, 1) 0ms',
                    overflow: 'hidden',
                    position: 'relative',
                    '&:hover': {
                        border: '2px solid ' + color + '80',
                        backgroundColor: color + '40'
                    },
                },
            })(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Button);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledButton, { style: Object.assign({
                    border: this.props.selected ? '2px solid ' + this.props.hexColor : '',
                    backgroundColor: this.props.selected ? this.props.hexColor + '40' : '',
                }, this.props.style), onClick: () => this.props.handleClick(), onMouseOver: this.handleMouseOver, onMouseOut: this.handleMouseOut },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { style: {
                        flexGrow: 1,
                        lineHeight: '14px',
                        margin: 'auto auto auto 6px',
                        textAlign: 'center',
                        whiteSpace: 'pre-wrap',
                    } }, (this.props.beta ? ' ' : '' /* This extra space is explicitly for 'Session' launch mode so we dont forget to remove the space when we remove the beta label */) + this.props.label),
                this.props.selected ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_CheckCircle__WEBPACK_IMPORTED_MODULE_4__.default, { fontSize: 'small', style: {
                        fill: this.props.hexColor,
                        margin: 'auto',
                    } })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_RadioButtonUnchecked__WEBPACK_IMPORTED_MODULE_5__.default, { fontSize: 'small', style: {
                        fill: this.props.hexColor + '80',
                        margin: 'auto',
                    } })),
                this.props.beta && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                        position: 'absolute',
                        left: '-22px',
                        top: '3px',
                        transform: 'rotate(-45deg)',
                        background: this.props.selected ? this.props.hexColor : this.props.hexColor + '80',
                        color: '#ffffff',
                        fontSize: '9px',
                        lineHeight: '14px',
                        fontWeight: 'bold',
                        padding: '0px 20px',
                    } }, "BETA"))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.StyledButton = this.getStyledButton(this.props.hexColor);
    }
}


/***/ }),

/***/ "./lib/components/deploy/OutputFileEntry.js":
/*!**************************************************!*\
  !*** ./lib/components/deploy/OutputFileEntry.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OutputFileEntry": () => (/* binding */ OutputFileEntry)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _material_ui_icons_GetApp__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material-ui/icons/GetApp */ "./node_modules/@material-ui/icons/GetApp.js");
/* harmony import */ var _material_ui_icons_Done__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material-ui/icons/Done */ "./node_modules/@material-ui/icons/Done.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






class OutputFileEntry extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        // We need to know if the component is mounted to change state
        this._isMounted = false;
        this.formatSize = (value) => {
            if (value < Math.pow(1024, 1)) {
                return value.toFixed() + ' B';
            }
            else if (value < Math.pow(1024, 2)) {
                return (value / Math.pow(1024, 1)).toFixed(1) + ' KiB';
            }
            else if (value < Math.pow(1024, 3)) {
                return (value / Math.pow(1024, 2)).toFixed(1) + ' MiB';
            }
            else if (value < Math.pow(1024, 4)) {
                return (value / Math.pow(1024, 3)).toFixed(1) + ' GiB';
            }
            else if (value < Math.pow(1024, 5)) {
                return (value / Math.pow(1024, 4)).toFixed(1) + ' TiB';
            }
            else {
                return (value / Math.pow(1024, 5)).toFixed(1) + ' PiB';
            }
        };
        this.formatExtraInfo = () => {
            var lastModified = this.props.lastModified == "" ? "" : new Date(this.props.lastModified).toLocaleTimeString();
            var size = this.props.size == 0 ? "" : this.formatSize(this.props.size);
            if (lastModified == "" && size == "")
                return "";
            if (lastModified == "")
                return " (" + size + ")";
            if (size == "")
                return " (" + lastModified + ")";
            return " (" + size + ", " + lastModified + ")";
        };
        // The contents of the component
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.ListItem, { style: { paddingTop: "2px", paddingBottom: "2px" } },
                this.state.downloaded ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.IconButton, { edge: "end", disabled: true },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_Done__WEBPACK_IMPORTED_MODULE_4__.default, null))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, !this.state.downloading ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.IconButton, { edge: "end", disabled: this.props.disabled, onClick: () => {
                        this.saveOutputFile(this.props.name, this.props.files);
                        this.safeSetState({ downloading: true });
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_GetApp__WEBPACK_IMPORTED_MODULE_5__.default, null))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { position: 'relative', height: '48px', width: '48px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.CircularProgress, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { style: { position: 'absolute', top: '12.5px', left: '9px', fontSize: '0.75rem' } }, this.state.loaded != this.state.total ? ((this.state.loaded / this.state.total) * 100).toFixed(0) + "%" : ''))))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                        overflow: 'auto',
                        marginLeft: !this.state.downloading ? '24px' : '12px',
                        marginTop: '4px',
                        marginBottom: '4px',
                        opacity: this.props.disabled ? '0.5' : '1',
                    } }, this.props.name + this.formatExtraInfo())));
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            this.update();
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            loaded: 0,
            total: 0,
            downloading: false,
            downloaded: false,
        };
    }
    getDownloadProgress(name) {
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/get-file-download-progress";
        const init = {
            method: 'POST',
            body: JSON.stringify({
                // The key we use to watch download progress
                name: name,
            }),
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
            if (response.status == 204) {
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnPoll)
                    console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                setTimeout(() => this.getDownloadProgress(name), 500);
                return;
            }
            return response.json();
        }).then((body) => {
            if (body) {
                this.safeSetState({ loaded: body.read, total: body.total });
                if (!(body.read != 0 && body.read == body.total)) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnPoll)
                        console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                    setTimeout(() => this.getDownloadProgress(name), 500);
                }
            }
        }, (error) => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnPoll)
                console.log('FunctionPoll (' + new Date().getSeconds() + ')');
            setTimeout(() => this.getDownloadProgress(name), 500);
        });
    }
    async saveOutputFile(name, files) {
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/save-notebook-output-file";
        const init = {
            method: 'POST',
            body: JSON.stringify({
                workloadUUID: this.props.workloadUUID,
                moduleUUID: this.props.moduleUUID,
                name: name,
                files: files,
                overwrite: this.props.overwrite,
            }),
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
            return response.text();
        }).then((body) => {
            this.safeSetState({ downloaded: true, downloading: false });
            setTimeout(() => this.safeSetState({ downloaded: false }), 5000);
        });
        this.getDownloadProgress(name);
    }
    update() {
        if (this._isMounted) {
            this.forceUpdate();
        }
    }
}


/***/ }),

/***/ "./lib/components/deploy/OutputFileList.js":
/*!*************************************************!*\
  !*** ./lib/components/deploy/OutputFileList.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OutputFileList": () => (/* binding */ OutputFileList)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _OutputFileEntry__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./OutputFileEntry */ "./lib/components/deploy/OutputFileEntry.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _core_Switch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Switch */ "./lib/core/Switch.js");
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






const StyledSwitch = (0,_core_Switch__WEBPACK_IMPORTED_MODULE_2__.getStyledSwitch)();
class OutputFileList extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { padding: '12px', width: "100%" } }, this.getFiles()));
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            overwrite: false
        };
    }
    getFiles() {
        var files = [];
        for (let module of this.props.app.modules) {
            if (module.files) {
                for (let file of module.files) {
                    files.push({
                        "file": file.path,
                        "lastModified": file.lastModified,
                        "size": file.size,
                        "moduleUUID": module.uuid,
                    });
                }
            }
        }
        if (!this.props.app.running.started) {
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, "Files will appear here when the job starts."));
        }
        else {
            var sorted = files.sort((n1, n2) => {
                if (n1.file > n2.file) {
                    return 1;
                }
                if (n1.file < n2.file) {
                    return -1;
                }
                return 0;
            });
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'inline-flex', alignItems: 'center' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { paddingLeft: '16px', paddingRight: '16px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_4__.default, { reminder: 'Overwrite existing files with downloaded files, or rename the downloaded files' },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledSwitch, { color: 'primary', inputProps: { style: { height: '24px' } }, checked: this.state.overwrite, onChange: (event) => {
                                    this.safeSetState({ overwrite: event.currentTarget.checked });
                                } }))),
                    "Overwrite existing files"),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.List, null,
                    sorted.map((value) => react__WEBPACK_IMPORTED_MODULE_0__.cloneElement((react__WEBPACK_IMPORTED_MODULE_0__.createElement(_OutputFileEntry__WEBPACK_IMPORTED_MODULE_5__.OutputFileEntry, { name: value.file, lastModified: value.lastModified, size: value.size, files: [value.file], workloadUUID: this.props.app.uuid, moduleUUID: value.moduleUUID, disabled: false, overwrite: this.state.overwrite })), { key: value.file })),
                    this.props.app.interactive && react__WEBPACK_IMPORTED_MODULE_0__.createElement(_OutputFileEntry__WEBPACK_IMPORTED_MODULE_5__.OutputFileEntry, { name: 'Download stdout as file', lastModified: "", size: 0, files: [this.props.app.path.replace('.ipynb', '.stdout')], workloadUUID: this.props.app.uuid, moduleUUID: this.props.app.modules[0].uuid, disabled: false, overwrite: this.state.overwrite }),
                    this.props.app.interactive && react__WEBPACK_IMPORTED_MODULE_0__.createElement(_OutputFileEntry__WEBPACK_IMPORTED_MODULE_5__.OutputFileEntry, { name: 'Download stderr as file', lastModified: "", size: 0, files: [this.props.app.path.replace('.ipynb', '.stderr')], workloadUUID: this.props.app.uuid, moduleUUID: this.props.app.modules[0].uuid, disabled: false, overwrite: this.state.overwrite }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_OutputFileEntry__WEBPACK_IMPORTED_MODULE_5__.OutputFileEntry, { name: 'Download all files', size: sorted.length == 0 ? 0 : sorted.reduce((a, b) => { return { size: a.size + b.size }; }, { size: 0 }).size, lastModified: "", files: sorted.map((value) => value.file).concat(this.props.app.interactive ? [this.props.app.path.replace('.ipynb', '.stderr'), this.props.app.path.replace('.ipynb', '.stdout')] : []), workloadUUID: this.props.app.uuid, moduleUUID: this.props.app.modules[0].uuid, disabled: !this.props.app.interactive && sorted.length == 0, overwrite: this.state.overwrite }))));
        }
    }
}


/***/ }),

/***/ "./lib/components/deploy/PreviewLaunchButton.js":
/*!******************************************************!*\
  !*** ./lib/components/deploy/PreviewLaunchButton.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PreviewLaunchButton": () => (/* binding */ PreviewLaunchButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _models_machine_Machine__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../models/machine/Machine */ "./lib/models/machine/Machine.js");
/* harmony import */ var _models_application_App__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../models/application/App */ "./lib/models/application/App.js");
/* harmony import */ var _models_application_LightweightApp__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../models/application/LightweightApp */ "./lib/models/application/LightweightApp.js");
/* harmony import */ var _StatusWrapper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../StatusWrapper */ "./lib/components/StatusWrapper.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






// Defaults for this component
const DefaultState = {
    machine: [new _models_machine_Machine__WEBPACK_IMPORTED_MODULE_1__.NoMachine()]
};
var retrievingPreview = false;
var updatePreviewAgain = false;
class PreviewLaunchButton extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.state = DefaultState;
        // We need to know if the component is mounted to change state
        this._isMounted = false;
        this.polling = false;
        this.poll = () => {
            // We will poll for a new preview every 10 seconds
            if (this.polling) {
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnPoll)
                    console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                setTimeout(() => this.poll(), 10000);
            }
            this.handlePreviewClick(false);
        };
        // To understand whats going on, look at the commented out functions below
        this.handlePreviewClick = (printRecommendations, bypassLimiter) => {
            const current = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.tracker.currentWidget;
            if (current != null) {
                const config = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata.getMetadata().config;
                // await current.context.ready;
                // current.context.save();
                // Make sure the notebook has the correct metadata.
                if (bypassLimiter || !retrievingPreview) {
                    retrievingPreview = true;
                    const app = new _models_application_App__WEBPACK_IMPORTED_MODULE_3__.App(current.context.path, current.model.toJSON(), config);
                    app.previewNotebook(printRecommendations).then((machines) => {
                        this.safeSetState({
                            machine: machines,
                        });
                        if (updatePreviewAgain) {
                            updatePreviewAgain = false;
                            this.handlePreviewClick(false, true);
                        }
                        else {
                            retrievingPreview = false;
                        }
                    }, () => {
                        retrievingPreview = false;
                    });
                }
                else {
                    updatePreviewAgain = true;
                }
            }
        };
        // This is the logic of the function above incase we want to understand what it is doing easier
        // This function uses two flags, one flag keeps track of when we are actively getting an update, and one keeps track if we need to get another at the end.
        // We do this to not lose any requests that would be dropped between when we last started an update and the last request to update
        // private newHandlePreviewClick = (printRecommendations: boolean, bypassLimiter?: boolean) => {
        // 	if (bypassLimiter || !retrievingPreview) {
        // 		retrievingPreview = true;
        //		try {
        // 			// do the update
        //			...
        //			// after the update completed
        // 			if (updatePreviewAgain) {
        // 				updatePreviewAgain = false;
        // 				this.newHandlePreviewClick(false, true);
        // 			} else {
        // 				retrievingPreview = false;
        // 			}
        //		} catch (exception) {
        //			retrievingPreview = false;
        //		}
        // 	} else {
        // 		updatePreviewAgain = true;
        // 	}
        // }
        // This is the old handle code that was combined with the function above for the current handlePreviewClick
        // private oldHandlePreviewClick = (printRecommendations: boolean) => {
        // 	const current = Global.tracker.currentWidget;
        // 	if (current != null) {
        // 		const app = new App(current.context.path, current.model.toJSON(), "");
        // 		app.previewNotebook(printRecommendations).then((machine: Machine) => {
        // 			this.safeSetState({
        // 				machine: machine,
        // 			});
        // 		});
        // 	}
        // }
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            // var order = 1;
            const metadata = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata.getMetadata();
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({ width: '100%' }, this.props.style) },
                react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(this.state.machine[0].getPreviewComponent(), { style: { marginTop: '-12px' } }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { marginLeft: '6px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_StatusWrapper__WEBPACK_IMPORTED_MODULE_4__.StatusWrapper, { statusColor: 'var(--jp-layout-color2)' }, new _models_application_LightweightApp__WEBPACK_IMPORTED_MODULE_5__.LightweightApp(metadata.metadata.nbKey, _Global__WEBPACK_IMPORTED_MODULE_2__.Global.tracker.currentWidget.context.path, metadata.config).getLaunchComponent(this.state.machine[0] instanceof _models_machine_Machine__WEBPACK_IMPORTED_MODULE_1__.NoMachine))),
                " "));
        };
        // We need to force update in case the preview doesn't change but the metadata does
        this.handleMetadataChange = () => { this.forceUpdate(), this.handlePreviewClick(false); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            this.polling = true;
            this.poll();
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
            this.handlePreviewClick(false);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            this._isMounted = false;
            this.polling = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/RequirementsBar.js":
/*!**************************************************!*\
  !*** ./lib/components/deploy/RequirementsBar.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Page": () => (/* binding */ Page),
/* harmony export */   "RequirementsBar": () => (/* binding */ RequirementsBar)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _material_ui_core_styles_withStyles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/core/styles/withStyles */ "./node_modules/@material-ui/core/styles/withStyles.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




const StyledTab = (0,_material_ui_core_styles_withStyles__WEBPACK_IMPORTED_MODULE_2__.default)({
    root: {
        minHeight: "24px",
        padding: "6px"
    }
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Tab);
var Page;
(function (Page) {
    Page[Page["RESOURCES"] = 0] = "RESOURCES";
    Page[Page["FILES"] = 1] = "FILES";
})(Page || (Page = {}));
class RequirementsBar extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleTabChange = (event, newValue) => {
            this.safeSetState({ page: newValue });
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.deploySubMenu = newValue;
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { width: '100%', textAlign: 'center' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Tabs, { value: this.state.page, onChange: this.handleTabChange, variant: "fullWidth", indicatorColor: "primary", textColor: "primary", style: { padding: "0px 6px 0px 6px", minHeight: "24px" } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledTab, { label: "RESOURCES", style: { minWidth: "100px" } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledTab, { label: "FILES", style: { minWidth: "100px" } }))));
        };
        this.handleCardChange = () => this.forceUpdate();
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.deploySubMenuChanged.connect(this.handleCardChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.deploySubMenuChanged.disconnect(this.handleCardChange);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            page: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.deploySubMenu || Page.RESOURCES,
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/WasabiConnectorPopup.js":
/*!*******************************************************!*\
  !*** ./lib/components/deploy/WasabiConnectorPopup.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WasabiConnectorPopup": () => (/* binding */ WasabiConnectorPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core */ "./lib/core/Dropdown.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core */ "./lib/core/TextBox.js");
/* harmony import */ var _dataConnectorBrowser_DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./dataConnectorBrowser/DataConnectorDirListingItemIcon */ "./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListingItemIcon.js");
/* harmony import */ var _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/BaseConnectorPopup */ "./lib/core/BaseConnectorPopup.js");
/* harmony import */ var _models_WasabiRegions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../models/WasabiRegions */ "./lib/models/WasabiRegions.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






const defaultState = {
    region: _models_WasabiRegions__WEBPACK_IMPORTED_MODULE_1__.WasabiRegions.US_EAST_1.region,
    bucketName: '',
    objectKey: '',
    accessKeyID: '',
    secretAccessKey: '',
};
class WasabiConnectorPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClose = () => {
            if (this.props.onClose)
                this.props.onClose();
            this.safeSetState(defaultState);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup, { dataService: _dataConnectorBrowser_DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_4__.DataService.WASABI, iconClass: 'jp-wasabi-logo', description: 'Access a Wasabi bucket', header: 'Connect to a Wasabi bucket or object.', downloadPath: '', onClose: this.handleClose, getInfo: () => this.state, getContents: (waiting) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.Dropdown, { getValue: () => this.state.region, saveValue: (value) => this.safeSetState({ region: value }), label: 'Region', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup.LABEL_WIDTH, values: _models_WasabiRegions__WEBPACK_IMPORTED_MODULE_1__.WasabiRegions.values.map(x => { return { value: x.region, description: x.description }; }), helperText: 'The service region as specified in Wasabi (or S3) documentation.' }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.TextBox, { getValue: () => this.state.bucketName, saveValue: (value) => this.safeSetState({ bucketName: value }), label: 'Bucket Name', helperText: 'The Bucket Name as specified in Wasabi (or S3) documentation.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.TextBox, { getValue: () => this.state.objectKey, saveValue: (value) => this.safeSetState({ objectKey: value }), label: 'Object Key', helperText: 'If you leave this blank, we will transfer the entire bucket.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.TextBox, { getValue: () => this.state.accessKeyID, saveValue: (value) => this.safeSetState({ accessKeyID: value }), label: 'Access Key ID', helperText: 'The Access Key ID as specified in Wasabi (or S3) documentation.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.TextBox, { getValue: () => this.state.secretAccessKey, saveValue: (value) => this.safeSetState({ secretAccessKey: value }), label: 'Secret Access Key', helperText: 'The Secret Access Key as specified in Wasabi (or S3) documentation.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }))) }));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = defaultState;
    }
}


/***/ }),

/***/ "./lib/components/deploy/dataConnectorBrowser/DataConnectorBrowser.js":
/*!****************************************************************************!*\
  !*** ./lib/components/deploy/dataConnectorBrowser/DataConnectorBrowser.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DataConnectorBrowser)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _DataConnectorDirListing__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DataConnectorDirListing */ "./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListing.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class DataConnectorBrowser extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.getSelected = () => {
            return this.getSelected();
        };
        this.request = async () => {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
            const url = settings.baseUrl + 'optumi/get-data-connectors';
            return _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, {}, settings).then(response => {
                if (response.status !== 200)
                    throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.ResponseError(response);
                return response.json();
            });
        };
        this.handleOpen = (file) => {
            if (this.props.onAdd)
                this.props.onAdd();
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'jp-FileBrowser', style: this.props.style },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DataConnectorDirListing__WEBPACK_IMPORTED_MODULE_3__.default, { dataConnectors: this.state.dataConnectors, onOpen: this.handleOpen, getSelected: this.props.getSelected && (getSelected => this.getSelected = getSelected), handleDelete: this.props.handleDelete })));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            this.request().then(json => {
                this.safeSetState({ dataConnectors: json.connectors });
                _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lastDataConnectors = json.connectors;
            });
            // Override the JupyterLab context menu open (disable it)
            this.oldOpen = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lab.contextMenu.open;
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lab.contextMenu.open = () => false;
        };
        // Add context menu items back
        this.componentWillUnmount = () => {
            // Restore the old JupyterLab context menu open
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lab.contextMenu.open = this.oldOpen;
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        if (this.props.getSelected) {
            this.props.getSelected(this.getSelected);
        }
        this.state = {
            dataConnectors: _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lastDataConnectors,
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListing.js":
/*!*******************************************************************************!*\
  !*** ./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListing.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DataConnectorDirListing)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _DataConnectorDirListingContent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DataConnectorDirListingContent */ "./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListingContent.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class DataConnectorDirListing extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const sort = (a, b) => {
                const sortDirection = (a, b) => a.localeCompare(b) * (this.state.sorted === 'forward' ? 1 : -1);
                if (this.state.selected === 'name') {
                    if (a.name === b.name)
                        return a.dataService.localeCompare(b.dataService);
                    return sortDirection(a.name, b.name);
                }
                else if (this.state.selected === 'dataService') {
                    if (a.dataService === b.dataService)
                        return a.name.localeCompare(b.name);
                    return sortDirection(a.dataService, b.dataService);
                }
            };
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'jp-DirListing jp-FileBrowser-listing', style: { overflow: 'hidden' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'jp-DirListing-header' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'jp-DirListing-headerItem jp-id-data-service' + (this.state.selected === 'dataService' ? ' jp-mod-selected' : ''), onClick: () => {
                            if (this.state.selected === 'dataService') {
                                this.safeSetState({ sorted: this.state.sorted === 'forward' ? 'backward' : 'forward' });
                            }
                            else {
                                this.safeSetState({ selected: 'dataService', sorted: 'forward' });
                            }
                        }, style: { flex: '0 0 210px', textAlign: 'left', padding: '4px 12px 2px 17px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: 'jp-DirListing-headerItemText' }, "Data Service"),
                        this.state.selected === 'dataService' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: 'jp-DirListing-headerItemIcon', style: { float: 'right' } }, this.state.sorted === 'forward' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.caretUpIcon.react, { container: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null) })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.caretDownIcon.react, { container: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null) }))))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'jp-DirListing-headerItem jp-id-name' + (this.state.selected === 'name' ? ' jp-mod-selected' : ''), onClick: () => {
                            if (this.state.selected === 'name') {
                                this.safeSetState({ sorted: this.state.sorted === 'forward' ? 'backward' : 'forward' });
                            }
                            else {
                                this.safeSetState({ selected: 'name', sorted: 'forward' });
                            }
                        }, style: { padding: '4px 12px 2px 17px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: 'jp-DirListing-headerItemText' }, "Name"),
                        this.state.selected === 'name' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: 'jp-DirListing-headerItemIcon', style: { float: 'right' } }, this.state.sorted === 'forward' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.caretUpIcon.react, { container: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null) })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.caretDownIcon.react, { container: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null) })))))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { marginBottom: '6px' } }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DataConnectorDirListingContent__WEBPACK_IMPORTED_MODULE_3__.default, { dataConnectors: this.props.dataConnectors, handleDelete: this.props.handleDelete, onOpen: this.props.onOpen, sort: sort, getSelected: this.props.getSelected }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { marginBottom: '6px' } })));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            selected: 'name',
            sorted: 'forward',
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListingContent.js":
/*!**************************************************************************************!*\
  !*** ./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListingContent.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DataConnectorDirListingContent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _DataConnectorDirListingItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./DataConnectorDirListingItem */ "./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListingItem.js");
/* harmony import */ var _DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DataConnectorDirListingItemIcon */ "./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListingItemIcon.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class DataConnectorDirListingContent extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const sortedDataConnectors = this.props.dataConnectors.sort(this.props.sort);
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("ul", { className: 'jp-DirListing-content', style: { overflowY: 'auto' } }, sortedDataConnectors.length == 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DataConnectorDirListingItem__WEBPACK_IMPORTED_MODULE_2__.default, { key: 'empty', dataConnectorMetadata: {
                        name: '--',
                        dataService: _DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__.DataService.EMPTY,
                    }, selected: false, onClick: () => false, onDoubleClick: () => false }))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, sortedDataConnectors.map(dataConnector => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DataConnectorDirListingItem__WEBPACK_IMPORTED_MODULE_2__.default, { key: dataConnector.path + dataConnector.name, dataConnectorMetadata: dataConnector, selected: this.state.selected.includes(dataConnector), handleButtonClick: this.props.handleDelete, buttonText: 'Delete', buttonColor: '#f48f8d', onClick: (event) => {
                    if (this.props.getSelected === undefined)
                        return; // If someone doesn't want what is selected, don't select.
                    if (this.firstClicked === undefined) {
                        if (event.shiftKey) {
                            this.firstClicked = sortedDataConnectors[0];
                            this.lastClicked = sortedDataConnectors[0];
                        }
                        else {
                            this.firstClicked = dataConnector;
                        }
                    }
                    if (event.ctrlKey) {
                        const newSelected = [...this.state.selected];
                        if (newSelected.includes(dataConnector)) {
                            newSelected.splice(newSelected.indexOf(dataConnector), 1);
                        }
                        else {
                            newSelected.push(dataConnector);
                        }
                        this.safeSetState({ selected: newSelected });
                        this.lastClicked = dataConnector;
                    }
                    else if (event.shiftKey) {
                        const newSelected = [...this.state.selected];
                        let index = sortedDataConnectors.indexOf(dataConnector);
                        const lastClickedIndex = sortedDataConnectors.indexOf(this.lastClicked);
                        const direction = index < lastClickedIndex ? 1 : -1;
                        while (!newSelected.includes(sortedDataConnectors[index]) && index !== lastClickedIndex) {
                            newSelected.push(sortedDataConnectors[index]);
                            index += direction;
                        }
                        if (index === lastClickedIndex && !newSelected.includes(this.lastClicked))
                            newSelected.push(this.lastClicked);
                        this.safeSetState({ selected: newSelected });
                    }
                    else {
                        this.safeSetState({ selected: [dataConnector] });
                        this.firstClicked = dataConnector;
                        this.lastClicked = dataConnector;
                    }
                }, onDoubleClick: (event) => {
                    if (!event.ctrlKey && !event.shiftKey)
                        this.props.onOpen(dataConnector);
                } })))))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        if (this.props.getSelected)
            this.props.getSelected(() => this.state.selected);
        this.state = {
            selected: []
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListingItem.js":
/*!***********************************************************************************!*\
  !*** ./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListingItem.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DataConnectorDirListingItem)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./DataConnectorDirListingItemIcon */ "./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListingItemIcon.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




const StyledButton = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.withStyles)({
    root: {
        display: 'inline-block',
        height: '20px',
        padding: '3px 6px',
        lineHeight: '12px',
        fontSize: '12px',
        minWidth: '0px',
        margin: 'auto',
    },
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Button);
const dataConnectorTypes = [
    { dataService: _DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_2__.DataService.AMAZON_S3, provider: 'Amazon', service: 'S3' },
    { dataService: _DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_2__.DataService.WASABI, provider: 'Wasabi', service: '' },
    { dataService: _DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_2__.DataService.GOOGLE_DRIVE, provider: 'Google', service: 'Drive' },
    { dataService: _DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_2__.DataService.GOOGLE_CLOUD_STORAGE, provider: 'Google', service: 'Cloud Storage' },
    { dataService: _DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_2__.DataService.KAGGLE, provider: 'Kaggle', service: '' },
    { dataService: _DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_2__.DataService.EMPTY, provider: '', service: '--' },
];
class DataConnectorDirListingItem extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const dataConnectorMetadata = this.props.dataConnectorMetadata;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", { className: 'jp-DirListing-item' + (this.props.selected ? ' jp-mod-selected' : ''), style: { lineHeight: '25px', padding: '4px 17px' }, onClick: (event) => this.props.onClick(event), onDoubleClick: (event) => this.props.onDoubleClick(event) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_2__.default, { style: {
                        margin: '2.5px auto',
                        width: '20px',
                        height: '20px',
                    }, dataService: dataConnectorMetadata.dataService }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: 'jp-DirListing-itemModified', style: dataConnectorMetadata.dataService == _DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_2__.DataService.EMPTY ? {
                        textAlign: 'left',
                        flex: '0 0 185px',
                        marginLeft: '-24px',
                        marginRight: '24px',
                    } : {
                        textAlign: 'left',
                        flex: '0 0 185px',
                        marginLeft: '8px'
                    } }, (() => {
                    for (const dataConnectorType of dataConnectorTypes) {
                        if (dataConnectorType.dataService === dataConnectorMetadata.dataService) {
                            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { style: { fontWeight: 'bold', marginRight: '0.25em' } }, dataConnectorType.provider),
                                dataConnectorType.service));
                        }
                    }
                    return react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", null);
                })()),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: 'jp-DirListing-itemText' }, dataConnectorMetadata.name),
                this.props.handleButtonClick && this.props.buttonColor && this.props.buttonText && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledButton, { onClick: () => this.props.handleButtonClick(this.props.dataConnectorMetadata), variant: 'outlined', color: 'primary', disableElevation: true, style: {
                        color: this.props.buttonColor,
                        border: '1px solid ' + this.props.buttonColor,
                    } }, this.props.buttonText))));
        };
        this.state = {
            focused: false
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListingItemIcon.js":
/*!***************************************************************************************!*\
  !*** ./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListingItemIcon.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DataService": () => (/* binding */ DataService),
/* harmony export */   "default": () => (/* binding */ DataConnectorDirListingItemIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



var DataService;
(function (DataService) {
    DataService["AMAZON_S3"] = "amazon s3";
    DataService["WASABI"] = "wasabi";
    DataService["GOOGLE_CLOUD_STORAGE"] = "google cloud storage";
    DataService["GOOGLE_DRIVE"] = "google drive";
    DataService["KAGGLE"] = "kaggle";
    DataService["EMPTY"] = "--";
})(DataService || (DataService = {}));
const dataConnectorTypes = [
    { dataService: DataService.AMAZON_S3, iconClass: 'jp-s3-logo' },
    { dataService: DataService.WASABI, iconClass: 'jp-wasabi-logo' },
    { dataService: DataService.GOOGLE_DRIVE, iconClass: 'jp-drive-logo' },
    { dataService: DataService.GOOGLE_CLOUD_STORAGE, iconClass: 'jp-cloud-logo' },
    { dataService: DataService.KAGGLE, iconClass: 'jp-kaggle-logo' },
    { dataService: DataService.EMPTY, iconClass: '' },
];
class DataConnectorDirListingItemIcon extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: 'jp-DirListing-itemIcon' }, (() => {
                for (const dataConnectorType of dataConnectorTypes) {
                    if (dataConnectorType.dataService === this.props.dataService) {
                        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { title: dataConnectorType.dataService, className: dataConnectorType.iconClass, style: Object.assign({
                                width: '16px',
                                height: '16px',
                                backgroundSize: 'contain',
                                display: 'block'
                            }, this.props.style) }));
                    }
                }
                return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.fileIcon.react, { display: 'block' });
            })()));
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/fileBrowser/BreadCrumbEllipses.js":
/*!*****************************************************************!*\
  !*** ./lib/components/deploy/fileBrowser/BreadCrumbEllipses.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ BreadCrumbItem)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/


class BreadCrumbItem extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: 'jp-BreadCrumbs-item', title: this.props.file.path, onClick: () => this.props.onOpen(this.props.file) }, "..."),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", null, "/")));
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/fileBrowser/BreadCrumbHome.js":
/*!*************************************************************!*\
  !*** ./lib/components/deploy/fileBrowser/BreadCrumbHome.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ BreadCrumbHome)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/


class BreadCrumbHome extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: 'jp-BreadCrumbs-home jp-BreadCrumbs-item', title: this.props.serverRoot, onClick: () => this.props.onOpen(this.props.file) },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", { width: '16', viewBox: '0 0 24 24', style: {
                            height: '16px',
                            bottom: '1px',
                            position: 'relative',
                            margin: '0px 2px 0px 0px',
                            padding: '0px 2px',
                            verticalAlign: 'middle'
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { className: 'jp-icon3 jp-icon-selectable', fill: '#616161', d: 'M10 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2h-8l-2-2z' }))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", null, "/")));
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/fileBrowser/BreadCrumbItem.js":
/*!*************************************************************!*\
  !*** ./lib/components/deploy/fileBrowser/BreadCrumbItem.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ BreadCrumbItem)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/


class BreadCrumbItem extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: 'jp-BreadCrumbs-item', title: this.props.file.path, onClick: () => this.props.onOpen(this.props.file) }, this.props.file.name),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", null, "/")));
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/fileBrowser/BreadCrumbs.js":
/*!**********************************************************!*\
  !*** ./lib/components/deploy/fileBrowser/BreadCrumbs.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ BreadCrumbs)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _BreadCrumbEllipses__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./BreadCrumbEllipses */ "./lib/components/deploy/fileBrowser/BreadCrumbEllipses.js");
/* harmony import */ var _BreadCrumbHome__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./BreadCrumbHome */ "./lib/components/deploy/fileBrowser/BreadCrumbHome.js");
/* harmony import */ var _BreadCrumbItem__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./BreadCrumbItem */ "./lib/components/deploy/fileBrowser/BreadCrumbItem.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





class BreadCrumbs extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'jp-BreadCrumbs jp-FileBrowser-crumbs' },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_BreadCrumbHome__WEBPACK_IMPORTED_MODULE_2__.default, { serverRoot: this.props.serverRoot, file: this.props.root, onOpen: this.props.onOpen }),
                this.props.path.length > 2 && react__WEBPACK_IMPORTED_MODULE_0__.createElement(_BreadCrumbEllipses__WEBPACK_IMPORTED_MODULE_3__.default, { file: this.props.path[this.props.path.length - 3], onOpen: this.props.onOpen }),
                this.props.path.length > 1 && react__WEBPACK_IMPORTED_MODULE_0__.createElement(_BreadCrumbItem__WEBPACK_IMPORTED_MODULE_4__.default, { file: this.props.path[this.props.path.length - 2], onOpen: this.props.onOpen }),
                this.props.path.length > 0 && react__WEBPACK_IMPORTED_MODULE_0__.createElement(_BreadCrumbItem__WEBPACK_IMPORTED_MODULE_4__.default, { file: this.props.path[this.props.path.length - 1], onOpen: this.props.onOpen })));
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/fileBrowser/DirListing.js":
/*!*********************************************************!*\
  !*** ./lib/components/deploy/fileBrowser/DirListing.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DirListing)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _DirListingContent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DirListingContent */ "./lib/components/deploy/fileBrowser/DirListingContent.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class DirListing extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const sort = (a, b) => {
                if (a.type !== b.type && (a.type === 'directory' || b.type === 'directory'))
                    return a.type.localeCompare(b.type);
                const sortDirection = (a, b) => a.localeCompare(b) * (this.state.sorted === 'forward' ? 1 : -1);
                if (this.state.selected === 'name') {
                    return sortDirection(a.name, b.name);
                }
                else if (this.state.selected === 'modified') {
                    return sortDirection(b.last_modified, a.last_modified);
                }
            };
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'jp-DirListing jp-FileBrowser-listing', style: { overflow: 'hidden' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'jp-DirListing-header' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'jp-DirListing-headerItem jp-id-name' + (this.state.selected === 'name' ? ' jp-mod-selected' : ''), onClick: () => {
                            if (this.state.selected === 'name') {
                                this.safeSetState({ sorted: this.state.sorted === 'forward' ? 'backward' : 'forward' });
                            }
                            else {
                                this.safeSetState({ selected: 'name', sorted: 'forward' });
                            }
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: 'jp-DirListing-headerItemText' }, "Name"),
                        this.state.selected === 'name' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: 'jp-DirListing-headerItemIcon', style: { float: 'right' } }, this.state.sorted === 'forward' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.caretUpIcon.react, { container: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null) })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.caretDownIcon.react, { container: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null) }))))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'jp-DirListing-headerItem jp-id-modified' + (this.state.selected === 'modified' ? ' jp-mod-selected' : ''), onClick: () => {
                            if (this.state.selected === 'modified') {
                                this.safeSetState({ sorted: this.state.sorted === 'forward' ? 'backward' : 'forward' });
                            }
                            else {
                                this.safeSetState({ selected: 'modified', sorted: 'forward' });
                            }
                        }, style: { flex: '0 0 150px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: 'jp-DirListing-headerItemText' }, "Last Modified"),
                        this.state.selected === 'modified' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: 'jp-DirListing-headerItemIcon', style: { float: 'right' } }, this.state.sorted === 'forward' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.caretUpIcon.react, { container: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null) })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.caretDownIcon.react, { container: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null) })))))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DirListingContent__WEBPACK_IMPORTED_MODULE_3__.default, { files: this.props.files, onOpen: this.props.onOpen, sort: sort, getSelected: this.props.getSelected })));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            selected: 'name',
            sorted: 'forward',
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/fileBrowser/DirListingContent.js":
/*!****************************************************************!*\
  !*** ./lib/components/deploy/fileBrowser/DirListingContent.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DirListingContent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _DirListingItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./DirListingItem */ "./lib/components/deploy/fileBrowser/DirListingItem.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class DirListingContent extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const sortedFiles = this.props.files.sort(this.props.sort);
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("ul", { className: 'jp-DirListing-content', style: { overflowY: 'auto' } }, sortedFiles.map(file => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DirListingItem__WEBPACK_IMPORTED_MODULE_2__.default, { key: file.path + file.name, file: file, selected: this.state.selected.includes(file), onClick: (event) => {
                    if (this.firstClicked === undefined) {
                        if (event.shiftKey) {
                            this.firstClicked = sortedFiles[0];
                            this.lastClicked = sortedFiles[0];
                        }
                        else {
                            this.firstClicked = file;
                        }
                    }
                    if (event.ctrlKey) {
                        const newSelected = [...this.state.selected];
                        if (newSelected.includes(file)) {
                            newSelected.splice(newSelected.indexOf(file), 1);
                        }
                        else {
                            newSelected.push(file);
                        }
                        this.safeSetState({ selected: newSelected });
                        this.lastClicked = file;
                    }
                    else if (event.shiftKey) {
                        const newSelected = [...this.state.selected];
                        let index = sortedFiles.indexOf(file);
                        const lastClickedIndex = sortedFiles.indexOf(this.lastClicked);
                        const direction = index < lastClickedIndex ? 1 : -1;
                        while (!newSelected.includes(sortedFiles[index]) && index !== lastClickedIndex) {
                            newSelected.push(sortedFiles[index]);
                            index += direction;
                        }
                        if (index === lastClickedIndex && !newSelected.includes(this.lastClicked))
                            newSelected.push(this.lastClicked);
                        this.safeSetState({ selected: newSelected });
                    }
                    else {
                        this.safeSetState({ selected: [file] });
                        this.firstClicked = file;
                        this.lastClicked = file;
                    }
                }, onDoubleClick: (event) => {
                    if (!event.ctrlKey && !event.shiftKey)
                        this.props.onOpen(file);
                } })))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.props.getSelected(() => this.state.selected);
        this.state = {
            selected: []
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/fileBrowser/DirListingItem.js":
/*!*************************************************************!*\
  !*** ./lib/components/deploy/fileBrowser/DirListingItem.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DirListingItem)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _DirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DirListingItemIcon */ "./lib/components/deploy/fileBrowser/DirListingItemIcon.js");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! moment */ "webpack/sharing/consume/default/moment/moment");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class DirListingItem extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.formatSize = (size) => {
            if (size < Math.pow(1000, 1))
                return (size / Math.pow(1000, 0)).toFixed(1) + ' Bytes';
            if (size < Math.pow(1000, 2))
                return (size / Math.pow(1000, 1)).toFixed(1) + ' KB';
            if (size < Math.pow(1000, 3))
                return (size / Math.pow(1000, 2)).toFixed(1) + ' MB';
            if (size < Math.pow(1000, 4))
                return (size / Math.pow(1000, 3)).toFixed(1) + ' GB';
            return (size / Math.pow(1000, 4)).toFixed(1) + ' TB';
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const file = this.props.file;
            const path = file.path.replace(file.name, '').replace(/\/$/, '');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", { className: 'jp-DirListing-item' + (this.props.selected ? ' jp-mod-selected' : ''), onClick: (event) => this.props.onClick(event), onDoubleClick: (event) => this.props.onDoubleClick(event), title: `Name: ${file.name}
${file.size === null ? '' : `Size: ${this.formatSize(file.size)}
`}${path === '' ? '' : `Path: ${path}
`}Created: ${moment__WEBPACK_IMPORTED_MODULE_1___default()(file.created).format('YYYY-MM-DD hh:mm:ss')}
Modified: ${moment__WEBPACK_IMPORTED_MODULE_1___default()(file.last_modified).format('YYYY-MM-DD hh:mm:ss')}
Writable: ${file.writable}` },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__.default, { fileType: file.type, mimetype: file.mimetype }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: 'jp-DirListing-itemText' }, file.name),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: 'jp-DirListing-itemModified', title: moment__WEBPACK_IMPORTED_MODULE_1___default()(file.last_modified).format('MMM D, YYYY h:mm A') }, moment__WEBPACK_IMPORTED_MODULE_1___default()(file.last_modified).fromNow())));
        };
        this.state = {
            focused: false
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/fileBrowser/DirListingItemIcon.js":
/*!*****************************************************************!*\
  !*** ./lib/components/deploy/fileBrowser/DirListingItemIcon.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DirListingItemIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



const fileTypes = [
    { extension: '.aac', mime: 'audio/aac', icon: undefined },
    { extension: '.abw', mime: 'application/x-abiword', icon: undefined },
    { extension: '.arc', mime: 'application/x-freearc', icon: undefined },
    { extension: '.avi', mime: 'video/x-msvideo', icon: undefined },
    { extension: '.azw', mime: 'application/vnd.amazon.ebook', icon: undefined },
    { extension: '.bin', mime: 'application/octet-stream', icon: undefined },
    { extension: '.bmp', mime: 'image/bmp', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }) },
    { extension: '.bz', mime: 'application/x-bzip', icon: undefined },
    { extension: '.bz2', mime: 'application/x-bzip2', icon: undefined },
    { extension: '.csh', mime: 'application/x-csh', icon: undefined },
    { extension: '.css', mime: 'text/css', icon: undefined },
    { extension: '.csv', mime: 'text/csv', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.spreadsheetIcon.react, { display: 'block' }) },
    { extension: '.doc', mime: 'application/msword', icon: undefined },
    { extension: '.docx', mime: 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', icon: undefined },
    { extension: '.eot', mime: 'application/vnd.ms-fontobject', icon: undefined },
    { extension: '.gz', mime: 'application/gzip', icon: undefined },
    { extension: '.gif', mime: 'image/gif', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }) },
    { extension: '.html', mime: 'text/html', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.html5Icon.react, { display: 'block' }), alternativeExtensions: ['.htm'] },
    { extension: '.ico', mime: 'image/vnd.microsoft.icon', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }) },
    { extension: '.ics', mime: 'text/calendar', icon: undefined },
    { extension: '.jar', mime: 'application/java-archive', icon: undefined },
    { extension: '.jpeg', mime: 'image/jpeg', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }), alternativeExtensions: ['.jpg'] },
    { extension: '.js', mime: 'text/javascript', icon: undefined },
    { extension: '.json', mime: 'application/json', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.jsonIcon.react, { display: 'block' }) },
    { extension: '.md', mime: 'text/markdown', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.markdownIcon.react, { display: 'block' }) },
    { extension: '.midi', mime: 'audio/midi', icon: undefined, alternativeExtensions: ['.mid'], alternativeMimes: ['audio/x-midi'] },
    { extension: '.mjs', mime: 'text/javascript', icon: undefined },
    { extension: '.mp3', mime: 'audio/mpeg', icon: undefined },
    { extension: '.mpeg', mime: 'video/mpeg', icon: undefined },
    { extension: '.odp', mime: 'application/vnd.oasis.opendocument.presentation', icon: undefined },
    { extension: '.ods', mime: 'application/vnd.oasis.opendocument.spreadsheet', icon: undefined },
    { extension: '.odt', mime: 'application/vnd.oasis.opendocument.text', icon: undefined },
    { extension: '.oga', mime: 'audio/ogg', icon: undefined },
    { extension: '.ogv', mime: 'video/ogg', icon: undefined },
    { extension: '.ogx', mime: 'application/ogg', icon: undefined },
    { extension: '.opus', mime: 'audio/opus', icon: undefined },
    { extension: '.otf', mime: 'font/otf', icon: undefined },
    { extension: '.png', mime: 'image/png', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }) },
    { extension: '.pdf', mime: 'application/pdf', icon: undefined },
    { extension: '.php', mime: 'application/x-httpd-php', icon: undefined },
    { extension: '.ppt', mime: 'application/vnd.ms-powerpoint', icon: undefined },
    { extension: '.pptx', mime: 'application/vnd.openxmlformats-officedocument.presentationml.presentation', icon: undefined },
    { extension: '.py', mime: 'text/x-python', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.pythonIcon.react, { display: 'block' }) },
    { extension: '.rar', mime: 'application/vnd.rar', icon: undefined },
    { extension: '.rtf', mime: 'application/rtf', icon: undefined },
    { extension: '.sh', mime: 'application/x-sh', icon: undefined },
    { extension: '.svg', mime: 'image/svg+xml', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }) },
    { extension: '.swf', mime: 'application/x-shockwave-flash', icon: undefined },
    { extension: '.tar', mime: 'application/x-tar', icon: undefined },
    { extension: '.tiff', mime: 'image/tiff', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }), alternativeExtensions: ['.tif'] },
    { extension: '.ts', mime: 'video/mp2t', icon: undefined },
    { extension: '.ttf', mime: 'font/ttf', icon: undefined },
    { extension: '.txt', mime: 'text/plain', icon: undefined },
    { extension: '.vsd', mime: 'application/vnd.visio', icon: undefined },
    { extension: '.wav', mime: 'audio/wav', icon: undefined },
    { extension: '.woff', mime: 'font/woff', icon: undefined },
    { extension: '.woff2', mime: 'font/woff2', icon: undefined },
    { extension: '.xhtml', mime: 'application/xhtml+xml', icon: undefined },
    { extension: '.xls', mime: 'application/vnd.ms-excel', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.spreadsheetIcon.react, { display: 'block' }) },
    { extension: '.xlsx', mime: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.spreadsheetIcon.react, { display: 'block' }) },
    { extension: '.xml', mime: 'application/xml', icon: undefined, alternativeExtensions: undefined, alternativeMimes: ['text/xml'] },
    { extension: '.xul', mime: 'application/vnd.mozilla.xul+xml', icon: undefined },
    { extension: '.yaml', mime: 'application/x-yaml', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.yamlIcon.react, { display: 'block' }), alternativeExtensions: ['.yml'], alternativeMimes: ['text/yaml'] },
    { extension: '.zip', mime: 'application/zip', icon: undefined },
    { extension: '.3gp', mime: 'video/3gpp', icon: undefined, alternativeExtensions: undefined, alternativeMimes: ['audio/3gpp'] },
    { extension: '.3g2', mime: 'video/3gpp2', icon: undefined, alternativeExtensions: undefined, alternativeMimes: ['audio/3gpp2'] },
    { extension: '.7z', mime: 'application/x-7z-compressed', icon: undefined },
];
class DirListingItemIcon extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: 'jp-DirListing-itemIcon' }, this.props.fileType === 'notebook' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.notebookIcon.react, { display: 'block' })) : this.props.fileType === 'directory' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.folderIcon.react, { display: 'block' })) : (() => {
                for (const fileType of fileTypes) {
                    if (fileType.mime === this.props.mimetype)
                        return fileType.icon || react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.fileIcon.react, { display: 'block' });
                    if (fileType.alternativeMimes !== undefined) {
                        for (const alternativeMime of fileType.alternativeMimes) {
                            if (alternativeMime === this.props.mimetype)
                                return fileType.icon || react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.fileIcon.react, { display: 'block' });
                        }
                    }
                }
                return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.fileIcon.react, { display: 'block' });
            })()));
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/fileBrowser/FileBrowser.js":
/*!**********************************************************!*\
  !*** ./lib/components/deploy/fileBrowser/FileBrowser.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FileBrowser)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _BreadCrumbs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./BreadCrumbs */ "./lib/components/deploy/fileBrowser/BreadCrumbs.js");
/* harmony import */ var _DirListing__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./DirListing */ "./lib/components/deploy/fileBrowser/DirListing.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






class FileBrowser extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.getSelectedFiles = () => {
            return this.getSelected();
        };
        this.request = async (path) => {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
            const url = settings.baseUrl + 'api' + path;
            return _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, {}, settings).then(response => {
                if (response.status !== 200)
                    throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.ResponseError(response);
                return response.json();
            });
        };
        this.handleOpen = (file) => {
            if (file.type === 'directory') {
                this.request('/contents/' + file.path).then(json => {
                    const newPath = [...this.state.path];
                    const depth = file.path.replace(/[^/]/g, '').length;
                    while (newPath.length > depth)
                        newPath.pop();
                    if (file !== this.state.root)
                        newPath.push(file);
                    this.safeSetState({
                        path: newPath,
                        files: json.content,
                    });
                });
            }
            else {
                if (this.props.onAdd)
                    this.props.onAdd();
            }
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'jp-FileBrowser', style: this.props.style },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_BreadCrumbs__WEBPACK_IMPORTED_MODULE_4__.default, { serverRoot: this.state.serverRoot, root: this.state.root, path: this.state.path, onOpen: this.handleOpen }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DirListing__WEBPACK_IMPORTED_MODULE_5__.default, { files: this.state.files, onOpen: this.handleOpen, getSelected: getSelected => this.getSelected = getSelected })));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            this.request('/contents').then(json => {
                this.safeSetState({ root: json, files: json.content });
            });
            // Override the JupyterLab context menu open (disable it)
            this.oldOpen = _Global__WEBPACK_IMPORTED_MODULE_3__.Global.lab.contextMenu.open;
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.lab.contextMenu.open = () => false;
        };
        // Add context menu items back
        this.componentWillUnmount = () => {
            // Restore the old JupyterLab context menu open
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.lab.contextMenu.open = this.oldOpen;
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.props.getSelectedFiles(this.getSelectedFiles);
        this.state = {
            serverRoot: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__.PageConfig.getOption('serverRoot'),
            root: undefined,
            path: [],
            files: [],
        };
    }
}
// // Copyright (c) Jupyter Development Team.
// // Distributed under the terms of the Modified BSD License.
// import { PageConfig, URLExt } from '@jupyterlab/coreutils';
// (window as any).__webpack_public_path__ = URLExt.join(
//     PageConfig.getBaseUrl(),
//     'example/'
// );
// import '@jupyterlab/application/style/index.css';
// import '@jupyterlab/codemirror/style/index.css';
// import '@jupyterlab/filebrowser/style/index.css';
// import '@jupyterlab/theme-light-extension/style/index.css';
// import '../index.css';
// import { each } from '@lumino/algorithm';
// import { CommandRegistry } from '@lumino/commands';
// import { DockPanel, Menu, SplitPanel, Widget } from '@lumino/widgets';
// import {  } from '@jupyter-widgets/html-manager';
// import { ServiceManager } from '@jupyterlab/services';
// import { Dialog, ToolbarButton, showDialog } from '@jupyterlab/apputils';
// import {
//     CodeMirrorEditorFactory,
//     CodeMirrorMimeTypeService
// } from '@jupyterlab/codemirror';
// import { DocumentManager } from '@jupyterlab/docmanager';
// import { DocumentRegistry } from '@jupyterlab/docregistry';
// import { FileBrowser, FilterFileBrowserModel } from '@jupyterlab/filebrowser';
// import { FileEditorFactory } from '@jupyterlab/fileeditor';
// import {
//     ITranslator,
//     nullTranslator,
//     TranslationManager
// } from '@jupyterlab/translation';
// import { addIcon } from '@jupyterlab/ui-components';
// const LANG = 'en';
// async function main(): Promise<void> {
//     // init translator
//     const translator = new TranslationManager();
//     await translator.fetch(LANG);
//     const manager = new ServiceManager();
//     void manager.ready.then(() => {
//         createApp(manager, translator);
//     });
// }
// function createApp(
//     manager: ServiceManager.IManager,
//     translator?: ITranslator
// ): void {
//     translator = translator || nullTranslator;
//     const trans = translator.load('jupyterlab');
//     const widgets: Widget[] = [];
//     let activeWidget: Widget;
//     const opener = {
//         open: (widget: Widget) => {
//             if (widgets.indexOf(widget) === -1) {
//                 dock.addWidget(widget, { mode: 'tab-after' });
//                 widgets.push(widget);
//             }
//             dock.activateWidget(widget);
//             activeWidget = widget;
//             widget.disposed.connect((w: Widget) => {
//                 const index = widgets.indexOf(w);
//                 widgets.splice(index, 1);
//             });
//         }
//     };
//     const docRegistry = new DocumentRegistry();
//     const docManager = new DocumentManager({
//         registry: docRegistry,
//         manager,
//         opener
//     });
//     const editorServices = {
//         factoryService: new CodeMirrorEditorFactory(),
//         mimeTypeService: new CodeMirrorMimeTypeService()
//     };
//     const wFactory = new FileEditorFactory({
//         editorServices,
//         factoryOptions: {
//             name: trans.__('Editor'),
//             modelName: 'text',
//             fileTypes: ['*'],
//             defaultFor: ['*'],
//             preferKernel: false,
//             canStartKernel: true
//         }
//     });
//     docRegistry.addWidgetFactory(wFactory);
//     const commands = new CommandRegistry();
//     const fbModel = new FilterFileBrowserModel({
//         manager: docManager
//     });
//     const fbWidget = new FileBrowser({
//         id: 'filebrowser',
//         model: fbModel
//     });
//     // Add a creator toolbar item.
//     const creator = new ToolbarButton({
//         icon: addIcon,
//         onClick: () => {
//             void docManager
//                 .newUntitled({
//                     type: 'file',
//                     path: fbModel.path
//                 })
//                 .then(model => {
//                     docManager.open(model.path);
//                 });
//         }
//     });
//     fbWidget.toolbar.insertItem(0, 'create', creator);
//     const panel = new SplitPanel();
//     panel.id = 'main';
//     panel.addWidget(fbWidget);
//     SplitPanel.setStretch(fbWidget, 0);
//     const dock = new DockPanel();
//     panel.addWidget(dock);
//     SplitPanel.setStretch(dock, 1);
//     dock.spacing = 8;
//     document.addEventListener('focus', event => {
//         for (let i = 0; i < widgets.length; i++) {
//             const widget = widgets[i];
//             if (widget.node.contains(event.target as HTMLElement)) {
//                 activeWidget = widget;
//                 break;
//             }
//         }
//     });
//     // Add commands.
//     commands.addCommand('file-open', {
//         label: trans.__('Open'),
//         icon: 'fa fa-folder-open-o',
//         mnemonic: 0,
//         execute: () => {
//             each(fbWidget.selectedItems(), item => {
//                 docManager.openOrReveal(item.path);
//             });
//         }
//     });
//     commands.addCommand('file-rename', {
//         label: trans.__('Rename'),
//         icon: 'fa fa-edit',
//         mnemonic: 0,
//         execute: () => {
//             return fbWidget.rename();
//         }
//     });
//     commands.addCommand('file-save', {
//         execute: () => {
//             const context = docManager.contextForWidget(activeWidget);
//             return context?.save();
//         }
//     });
//     commands.addCommand('file-cut', {
//         label: trans.__('Cut'),
//         icon: 'fa fa-cut',
//         execute: () => {
//             fbWidget.cut();
//         }
//     });
//     commands.addCommand('file-copy', {
//         label: trans.__('Copy'),
//         icon: 'fa fa-copy',
//         mnemonic: 0,
//         execute: () => {
//             fbWidget.copy();
//         }
//     });
//     commands.addCommand('file-delete', {
//         label: trans.__('Delete'),
//         icon: 'fa fa-remove',
//         mnemonic: 0,
//         execute: () => {
//             return fbWidget.delete();
//         }
//     });
//     commands.addCommand('file-duplicate', {
//         label: trans.__('Duplicate'),
//         icon: 'fa fa-copy',
//         mnemonic: 0,
//         execute: () => {
//             return fbWidget.duplicate();
//         }
//     });
//     commands.addCommand('file-paste', {
//         label: trans.__('Paste'),
//         icon: 'fa fa-paste',
//         mnemonic: 0,
//         execute: () => {
//             return fbWidget.paste();
//         }
//     });
//     commands.addCommand('file-download', {
//         label: trans.__('Download'),
//         icon: 'fa fa-download',
//         execute: () => {
//             return fbWidget.download();
//         }
//     });
//     commands.addCommand('file-shutdown-kernel', {
//         label: trans.__('Shut Down Kernel'),
//         icon: 'fa fa-stop-circle-o',
//         execute: () => {
//             return fbWidget.shutdownKernels();
//         }
//     });
//     commands.addCommand('file-dialog-demo', {
//         label: trans.__('Dialog Demo'),
//         execute: () => {
//             dialogDemo();
//         }
//     });
//     commands.addCommand('file-info-demo', {
//         label: trans.__('Info Demo'),
//         execute: () => {
//             const msg = 'The quick brown fox jumped over the lazy dog';
//             void showDialog({
//                 title: 'Cool Title',
//                 body: msg,
//                 buttons: [Dialog.okButton()]
//             });
//         }
//     });
//     commands.addKeyBinding({
//         keys: ['Enter'],
//         selector: '.jp-DirListing',
//         command: 'file-open'
//     });
//     commands.addKeyBinding({
//         keys: ['Accel S'],
//         selector: '.jp-CodeMirrorEditor',
//         command: 'file-save'
//     });
//     window.addEventListener('keydown', event => {
//         commands.processKeydownEvent(event);
//     });
//     // Create a context menu.
//     const menu = new Menu({ commands });
//     menu.addItem({ command: 'file-open' });
//     menu.addItem({ command: 'file-rename' });
//     menu.addItem({ command: 'file-remove' });
//     menu.addItem({ command: 'file-duplicate' });
//     menu.addItem({ command: 'file-delete' });
//     menu.addItem({ command: 'file-cut' });
//     menu.addItem({ command: 'file-copy' });
//     menu.addItem({ command: 'file-paste' });
//     menu.addItem({ command: 'file-shutdown-kernel' });
//     menu.addItem({ command: 'file-dialog-demo' });
//     menu.addItem({ command: 'file-info-demo' });
//     // Add a context menu to the dir listing.
//     // const node = fbWidget.node.getElementsByClassName('jp-DirListing-content')[0];
//     // node.addEventListener('contextmenu', (event: MouseEvent) => {
//     //     event.preventDefault();
//     //     const x = event.clientX;
//     //     const y = event.clientY;
//     //     menu.open(x, y);
//     // });
//     // Attach the panel to the DOM.
//     Widget.attach(panel, document.body);
//     // Handle resize events.
//     window.addEventListener('resize', () => {
//         panel.update();
//     });
//     console.debug('Example started!');
// }
// /**
//  * Create a non-functional dialog demo.
//  */
// function dialogDemo(): void {
//     const body = document.createElement('div');
//     const input = document.createElement('input');
//     input.value = 'Untitled.ipynb';
//     const selector = document.createElement('select');
//     const option0 = document.createElement('option');
//     option0.value = 'python';
//     option0.text = 'Python 3';
//     selector.appendChild(option0);
//     const option1 = document.createElement('option');
//     option1.value = 'julia';
//     option1.text = 'Julia';
//     selector.appendChild(option1);
//     body.appendChild(input);
//     body.appendChild(selector);
//     void showDialog({
//         title: 'Create new notebook'
//     });
// }
// window.addEventListener('load', main);


/***/ }),

/***/ "./lib/components/deploy/resources/Basic.js":
/*!**************************************************!*\
  !*** ./lib/components/deploy/resources/Basic.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Basic": () => (/* binding */ Basic)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core */ "./lib/core/Header.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../models/OptumiConfig */ "./lib/models/OptumiConfig.js");
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/* harmony import */ var _OutlinedResourceRadio__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../OutlinedResourceRadio */ "./lib/components/deploy/OutlinedResourceRadio.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






class Basic extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const value = this.getValue();
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.SubHeader, { title: 'Resource Selection' }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                        alignItems: 'center',
                        display: 'inline-flex',
                        width: '100%',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_3__.default, { reminder: 'Optimize for GPU' },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_OutlinedResourceRadio__WEBPACK_IMPORTED_MODULE_4__.OutlinedResourceRadio, { label: "GPU", hexColor: '#ffba7d', selected: value == "GPU", handleClick: () => this.saveValue("GPU") })),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_3__.default, { reminder: 'Optimize for CPU' },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_OutlinedResourceRadio__WEBPACK_IMPORTED_MODULE_4__.OutlinedResourceRadio, { label: "CPU", hexColor: '#f48f8d', selected: value == "CPU", handleClick: () => this.saveValue("CPU") })),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_3__.default, { reminder: 'Optimize for RAM' },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_OutlinedResourceRadio__WEBPACK_IMPORTED_MODULE_4__.OutlinedResourceRadio, { label: "RAM", hexColor: '#afaab0', selected: value == "RAM", handleClick: () => this.saveValue("RAM") })))));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
            const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
            const optumi = tracker.getMetadata();
            // Ser all resource levels to basic
            optumi.config.graphics.expertise = _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_5__.Expertise.BASIC;
            optumi.config.compute.expertise = _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_5__.Expertise.BASIC;
            optumi.config.memory.expertise = _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_5__.Expertise.BASIC;
            optumi.config.storage.expertise = _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_5__.Expertise.BASIC;
            // Make sure only one required flag is set to true
            if (optumi.config.graphics.required) {
                optumi.config.compute.required = false;
                optumi.config.memory.required = false;
                optumi.config.storage.required = false;
            }
            else if (optumi.config.compute.required) {
                optumi.config.graphics.required = false;
                optumi.config.memory.required = false;
                optumi.config.storage.required = false;
            }
            else if (optumi.config.memory.required) {
                optumi.config.graphics.required = false;
                optumi.config.compute.required = false;
                optumi.config.storage.required = false;
            }
            else { // By default we will set compute to required
                optumi.config.graphics.required = false;
                optumi.config.compute.required = true;
                optumi.config.memory.required = false;
                optumi.config.storage.required = false;
            }
            tracker.setMetadata(optumi);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        if (optumi.config.graphics.required == true)
            return "GPU";
        if (optumi.config.compute.required == true)
            return "CPU";
        if (optumi.config.memory.required == true)
            return "RAM";
        if (optumi.config.storage.required == true)
            return "DSK";
        return "CPU";
    }
    saveValue(value) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        optumi.config.graphics.required = value == "GPU" ? true : false;
        optumi.config.compute.required = value == "CPU" ? true : false;
        optumi.config.memory.required = value == "RAM" ? true : false;
        optumi.config.storage.required = value == "DSK" ? true : false;
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/deploy/resources/ComputeBasic.js":
/*!*********************************************************!*\
  !*** ./lib/components/deploy/resources/ComputeBasic.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ComputeBasic": () => (/* binding */ ComputeBasic)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core */ "./lib/core/Switch.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class ComputeBasic extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.handleChange = (event) => {
            const checked = event.target.checked;
            this.saveValue(checked);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: this.props.style },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Switch, { label: 'Required', flip: true, getValue: this.getValue, saveValue: this.saveValue })));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const compute = optumi.config.compute;
        return compute.required;
    }
    async saveValue(checked) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const compute = optumi.config.compute;
        compute.required = checked;
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/deploy/resources/ComputeComponent.js":
/*!*************************************************************!*\
  !*** ./lib/components/deploy/resources/ComputeComponent.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ComputeComponent": () => (/* binding */ ComputeComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core */ "./lib/core/Slider.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class ComputeComponent extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            var user = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: this.props.style },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Slider, { getValue: this.getCoresValue, saveValue: this.saveCoresValue, minValue: -1, maxValue: user.machines.absoluteComputeMaxCores, label: 'Cores', color: '#f48f8d', showUnit: true }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Slider, { getValue: this.getScoreValue, saveValue: this.saveScoreValue, minValue: -1, maxValue: user.machines.absoluteComputeMaxScore, label: 'Score', color: '#f48f8d', showUnit: true }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Slider, { getValue: this.getFrequencyValue, saveValue: this.saveFrequencyValue, minValue: -1, step: 1000000, maxValue: user.machines.absoluteComputeMaxFrequency, label: 'Frequency', color: '#f48f8d', showUnit: true, styledUnit: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.styleFrequencyUnit(), styledValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.styleFrequencyValue(), unstyledValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.unstyleFrequencyValue() })));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getCoresValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const compute = optumi.config.compute;
        return compute.cores[1];
    }
    async saveCoresValue(cores) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const compute = optumi.config.compute;
        compute.cores = [-1, cores, -1];
        tracker.setMetadata(optumi);
    }
    getScoreValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const compute = optumi.config.compute;
        return compute.score[1];
    }
    async saveScoreValue(score) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const compute = optumi.config.compute;
        compute.score = [-1, score, -1];
        tracker.setMetadata(optumi);
    }
    getFrequencyValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const compute = optumi.config.compute;
        return compute.frequency[1];
    }
    async saveFrequencyValue(frequency) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const compute = optumi.config.compute;
        compute.frequency = [-1, frequency, -1];
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/deploy/resources/ComputeRating.js":
/*!**********************************************************!*\
  !*** ./lib/components/deploy/resources/ComputeRating.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ComputeRating": () => (/* binding */ ComputeRating)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core */ "./lib/core/Slider.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class ComputeRating extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: this.props.style },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Slider, { getValue: this.getValue, saveValue: this.saveValue, marks: _Global__WEBPACK_IMPORTED_MODULE_1__.Global.fractionMarks, step: null, label: 'CPU', color: '#f48f8d', styledUnit: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.styleRatingUnit(), styledValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.styleRatingValue(), unstyledValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.unstyleRatingValue() })));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const compute = optumi.config.compute;
        return compute.rating[1];
    }
    async saveValue(rating) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const compute = optumi.config.compute;
        compute.rating = [-1, rating, -1];
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/deploy/resources/ComputeSimplified.js":
/*!**************************************************************!*\
  !*** ./lib/components/deploy/resources/ComputeSimplified.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ComputeSimplified": () => (/* binding */ ComputeSimplified)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core */ "./lib/core/Slider.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class ComputeSimplified extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            var user = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: this.props.style },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Slider, { getValue: this.getCoresValue, saveValue: this.saveCoresValue, minValue: -1, maxValue: user.machines.absoluteComputeMaxCores, label: 'Cores', color: '#f48f8d', showUnit: true })));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getCoresValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const compute = optumi.config.compute;
        return compute.cores[0];
    }
    async saveCoresValue(cores) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const compute = optumi.config.compute;
        compute.cores = [cores, -1, -1];
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/deploy/resources/GraphicsBasic.js":
/*!**********************************************************!*\
  !*** ./lib/components/deploy/resources/GraphicsBasic.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GraphicsBasic": () => (/* binding */ GraphicsBasic)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core */ "./lib/core/Switch.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class GraphicsBasic extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.handleChange = (event) => {
            const checked = event.target.checked;
            this.saveValue(checked);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: this.props.style },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Switch, { label: 'Required', flip: true, getValue: this.getValue, saveValue: this.saveValue })));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        return graphics.required;
    }
    async saveValue(checked) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        graphics.required = checked;
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/deploy/resources/GraphicsComponent.js":
/*!**************************************************************!*\
  !*** ./lib/components/deploy/resources/GraphicsComponent.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GraphicsComponent": () => (/* binding */ GraphicsComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core */ "./lib/core/Slider.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class GraphicsComponent extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            var user = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: this.props.style },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Slider, { getValue: this.getCoresValue, saveValue: this.saveCoresValue, minValue: -1, maxValue: user.machines.absoluteGraphicsMaxCores, label: 'Cores', color: '#ffba7d', showUnit: true }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Slider, { getValue: this.getScoreValue, saveValue: this.saveScoreValue, minValue: -1, maxValue: user.machines.absoluteGraphicsMaxScore, label: 'Score', color: '#ffba7d', showUnit: true }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Slider, { getValue: this.getFrequencyValue, saveValue: this.saveFrequencyValue, minValue: -1, step: 1000000, maxValue: user.machines.absoluteGraphicsMaxFrequency, label: 'Frequency', color: '#ffba7d', showUnit: true, styledUnit: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.styleFrequencyUnit(), styledValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.styleFrequencyValue(), unstyledValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.unstyleFrequencyValue() }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Slider, { getValue: this.getMemoryValue, saveValue: this.saveMemoryValue, minValue: -1, step: 1048576, maxValue: user.machines.absoluteGraphicsMaxMemory, label: 'Memory', color: '#ffba7d', showUnit: true, styledUnit: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.styleCapacityUnit(), styledValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.styleCapacityValue(), unstyledValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.unstyleCapacityValue() })));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getCoresValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        return graphics.cores[1];
    }
    async saveCoresValue(cores) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        graphics.cores = [-1, cores, -1];
        tracker.setMetadata(optumi);
    }
    getScoreValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        return graphics.score[1];
    }
    async saveScoreValue(score) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        graphics.score = [-1, score, -1];
        tracker.setMetadata(optumi);
    }
    getFrequencyValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        return graphics.frequency[1];
    }
    async saveFrequencyValue(frequency) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        graphics.frequency = [-1, frequency, -1];
        tracker.setMetadata(optumi);
    }
    getMemoryValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        return graphics.memory[1];
    }
    async saveMemoryValue(memory) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        graphics.memory = [-1, memory, -1];
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/deploy/resources/GraphicsEquipment.js":
/*!**************************************************************!*\
  !*** ./lib/components/deploy/resources/GraphicsEquipment.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GraphicsEquipment": () => (/* binding */ GraphicsEquipment)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



const StyledSelect = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.withStyles)({
    root: {
        fontSize: "var(--jp-ui-font-size1)",
        width: '68px',
    },
    iconOutlined: {
        right: '0px'
    }
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Select);
const StyledMenuItem = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.withStyles)({
    root: {
        fontSize: 'var(--jp-ui-font-size1)',
        padding: '3px 3px 3px 6px',
        justifyContent: 'center',
    }
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.MenuItem);
class GraphicsEquipment extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleCardChange = (event) => {
            const value = event.target.value;
            this.safeSetState({ selectedCard: value });
            this.saveCardValue(value);
            if (value != 'None') {
                const card = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.machines.absoluteGraphicsMaxCards.filter(x => x.name == value).pop();
                for (var i = card.configs.length - 1; i >= 0; i--) {
                    if (this.state.selectedNumCard >= card.configs[i]) {
                        this.safeSetState({ selectedNumCard: card.configs[i] });
                        break;
                    }
                }
            }
        };
        this.handleNumCardChange = (event) => {
            const value = event.target.value;
            if (value == -1) {
                this.safeSetState({ selectedNumCard: value, selectedCard: 'None' });
                this.saveNumCardValue(value);
                this.saveCardValue('None');
            }
            else {
                this.safeSetState({ selectedNumCard: value });
                this.saveNumCardValue(value);
            }
        };
        this.getCardItems = () => {
            var cardItems = new Array();
            cardItems.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledMenuItem, { key: 'None', value: 'None' }, "Any"));
            const availableCards = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.machines.absoluteGraphicsMaxCards;
            for (var i = 0; i < availableCards.length; i++) {
                var value = availableCards[i].name;
                cardItems.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledMenuItem, { key: value, value: value }, value));
            }
            return cardItems;
        };
        this.getNumCardItems = (cardName) => {
            var numCardItems = new Array();
            numCardItems.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledMenuItem, { key: -1, value: -1 }, 'At least 0'));
            if (cardName == 'None') {
                numCardItems.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledMenuItem, { key: 1, value: 1 }, 'At least 1'));
                numCardItems.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledMenuItem, { key: 2, value: 2 }, 'At least 2'));
                numCardItems.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledMenuItem, { key: 4, value: 4 }, 'At least 4'));
            }
            else {
                const card = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.machines.absoluteGraphicsMaxCards.filter(x => x.name == cardName).pop();
                if (card != undefined) {
                    for (var i = 0; i < card.configs.length; i++) {
                        var value = card.configs[i];
                        numCardItems.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledMenuItem, { key: value, value: value }, 'At least ' + value));
                    }
                }
            }
            return numCardItems;
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'inline-flex', width: '100%', padding: '3px 0px' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'inline-flex', width: '100%', justifyContent: 'center' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { padding: '0px 6px 0px 6px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledSelect, { value: this.state.selectedNumCard, variant: 'outlined', onChange: this.handleNumCardChange, SelectDisplayProps: { style: { padding: '3px 20px 3px 6px' } }, MenuProps: { MenuListProps: { style: { paddingTop: '6px', paddingBottom: '6px' } } } }, this.getNumCardItems(this.state.selectedCard))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { padding: '0px 6px 0px 6px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledSelect, { disabled: this.state.selectedNumCard == -1, value: this.state.selectedCard, variant: 'outlined', onChange: this.handleCardChange, SelectDisplayProps: { style: { padding: '3px 20px 3px 6px' } }, MenuProps: { MenuListProps: { style: { paddingTop: '6px', paddingBottom: '6px' } } } }, this.getCardItems()))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { 
                    // title={this.props.tooltip || ''}
                    style: {
                        minWidth: '68px',
                        lineHeight: '24px',
                        textAlign: 'center',
                        margin: '0px 6px',
                    } }, 'Cards')));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        var card = this.getCardValue();
        var numCard = this.getNumCardValue();
        // TODO:JJ Get this list of valid names/numbers from the available graphics cards
        card = ['None', 'K80', 'M60', 'P100', 'V100'].includes(card) ? card : 'None';
        numCard = [-1, 1, 2, 4].includes(numCard) ? numCard : -1;
        this.state = {
            selectedCard: numCard == -1 ? "None" : card,
            selectedNumCard: numCard,
        };
        this.saveCardValue(this.state.selectedCard);
        this.saveNumCardValue(this.state.selectedNumCard);
    }
    getCardValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        return graphics.boardType;
    }
    async saveCardValue(value) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        graphics.boardType = value;
        tracker.setMetadata(optumi);
    }
    getNumCardValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        return graphics.boardCount[0];
    }
    async saveNumCardValue(value) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        graphics.boardCount = [value, -1, -1];
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/deploy/resources/GraphicsRating.js":
/*!***********************************************************!*\
  !*** ./lib/components/deploy/resources/GraphicsRating.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GraphicsRating": () => (/* binding */ GraphicsRating)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core */ "./lib/core/Slider.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class GraphicsRating extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: this.props.style },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Slider, { getValue: this.getValue, saveValue: this.saveValue, marks: _Global__WEBPACK_IMPORTED_MODULE_1__.Global.fractionMarks, step: null, label: 'GPU', color: '#ffba7d', styledUnit: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.styleRatingUnit(), styledValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.styleRatingValue(), unstyledValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.unstyleRatingValue() })));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        return graphics.rating[1];
    }
    async saveValue(rating) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        graphics.rating = [-1, rating, -1];
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/deploy/resources/LaunchMode.js":
/*!*******************************************************!*\
  !*** ./lib/components/deploy/resources/LaunchMode.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LaunchMode": () => (/* binding */ LaunchMode)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core */ "./lib/core/Header.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/* harmony import */ var _OutlinedResourceRadio__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../OutlinedResourceRadio */ "./lib/components/deploy/OutlinedResourceRadio.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





class LaunchMode extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const value = this.getValue();
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.SubHeader, { title: 'Launch Mode' }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                        alignItems: 'center',
                        display: 'inline-flex',
                        width: '100%',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_3__.default, { reminder: 'Run an interactive session' },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_OutlinedResourceRadio__WEBPACK_IMPORTED_MODULE_4__.OutlinedResourceRadio, { beta: true, label: 'Session', hexColor: '#afaab0', selected: value == "Session", handleClick: () => this.saveValue("Session") })),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_3__.default, { reminder: 'Run a batch job' },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_OutlinedResourceRadio__WEBPACK_IMPORTED_MODULE_4__.OutlinedResourceRadio, { label: "Job", hexColor: '#afaab0', selected: value == "Job", handleClick: () => this.saveValue("Job") })))));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        return optumi.config.interactive ? "Session" : "Job";
    }
    saveValue(value) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        optumi.config.interactive = value == "Session" ? true : false;
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/deploy/resources/MemoryBasic.js":
/*!********************************************************!*\
  !*** ./lib/components/deploy/resources/MemoryBasic.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MemoryBasic": () => (/* binding */ MemoryBasic)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core */ "./lib/core/Switch.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class MemoryBasic extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.handleChange = (event) => {
            const checked = event.target.checked;
            this.saveValue(checked);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: this.props.style },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Switch, { label: 'Required', flip: true, getValue: this.getValue, saveValue: this.saveValue })));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const memory = optumi.config.memory;
        return memory.required;
    }
    async saveValue(checked) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const memory = optumi.config.memory;
        memory.required = checked;
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/deploy/resources/MemoryComponent.js":
/*!************************************************************!*\
  !*** ./lib/components/deploy/resources/MemoryComponent.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MemoryComponent": () => (/* binding */ MemoryComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core */ "./lib/core/Slider.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class MemoryComponent extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            var user = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: this.props.style },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Slider, { getValue: this.getSizeValue, saveValue: this.saveSizeValue, minValue: -1, step: 1048576, maxValue: user.machines.absoluteMemoryMaxSize, label: 'Size', color: '#89858b', showUnit: true, styledUnit: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.styleCapacityUnit(), styledValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.styleCapacityValue(), unstyledValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.unstyleCapacityValue() })));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getSizeValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const memory = optumi.config.memory;
        return memory.size[1];
    }
    async saveSizeValue(size) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const memory = optumi.config.memory;
        memory.size = [-1, size, -1];
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/deploy/resources/MemoryRating.js":
/*!*********************************************************!*\
  !*** ./lib/components/deploy/resources/MemoryRating.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MemoryRating": () => (/* binding */ MemoryRating)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core */ "./lib/core/Slider.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class MemoryRating extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: this.props.style },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Slider, { getValue: this.getValue, saveValue: this.saveValue, marks: _Global__WEBPACK_IMPORTED_MODULE_1__.Global.fractionMarks, step: null, label: 'RAM', color: '#89858b', styledUnit: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.styleRatingUnit(), styledValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.styleRatingValue(), unstyledValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.unstyleRatingValue() })));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const memory = optumi.config.memory;
        return memory.rating[1];
    }
    async saveValue(rating) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const memory = optumi.config.memory;
        memory.rating = [-1, rating, -1];
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/deploy/resources/ResourceSelector.js":
/*!*************************************************************!*\
  !*** ./lib/components/deploy/resources/ResourceSelector.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ResourceSelector": () => (/* binding */ ResourceSelector)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _material_ui_icons_ChevronLeft__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material-ui/icons/ChevronLeft */ "./node_modules/@material-ui/icons/ChevronLeft.js");
/* harmony import */ var _material_ui_icons_ChevronRight__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material-ui/icons/ChevronRight */ "./node_modules/@material-ui/icons/ChevronRight.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





class ResourceSelector extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        // This had to be written because ResourcePanel complained that a single element
        // was not an array, so we had to accept both and handle internally
        this.getChildren = () => {
            var children = this.props.children;
            if (children instanceof Array) {
                // The filter below allows us to remove levels conditionally (if they aren't added they evaluate as false)
                return children.filter(child => react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(child));
            }
            else {
                var singleton = [];
                singleton.push(children);
                return singleton;
            }
        };
        this.decreaseExpertise = () => {
            const newLevel = this.state.currentLevel - 1;
            if (this.state.currentLevel > 0) {
                this.safeSetState({ currentLevel: newLevel });
            }
            this.props.saveValue(_Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata, this.props.childrenLabels[newLevel]);
        };
        this.increaseExpertise = () => {
            const newLevel = this.state.currentLevel + 1;
            if (this.state.currentLevel < this.getChildren().length - 1) {
                this.safeSetState({ currentLevel: newLevel });
            }
            this.props.saveValue(_Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata, this.props.childrenLabels[newLevel]);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            this.props.children;
            // The padding is not in the div because the padding affects the ability to click the chevrons
            // The position and left/right on the icons is so all chevrons are aligned vertically no matter the size of the text
            // The title is in an inline-block div because we want the chevrons around the title and they use position: absolute
            // The lineHeight in the title centers the text vertically (24px comes from the chevron height from the inspector)
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: this.props.style },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { textAlign: 'center', margin: '6px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { position: 'relative', textAlign: 'center' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.IconButton, { disabled: this.state.currentLevel <= 0 ? true : false, color: 'primary', onClick: () => this.decreaseExpertise(), style: { position: 'absolute', left: '25%', padding: '3px' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_ChevronLeft__WEBPACK_IMPORTED_MODULE_3__.default, null)),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'inline-block', fontSize: '16px', fontWeight: 'bold', lineHeight: '18px', margin: '6px' } }, this.props.title),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.IconButton, { disabled: this.state.currentLevel >= this.getChildren().length - 1 ? true : false, color: 'primary', onClick: () => this.increaseExpertise(), style: { position: 'absolute', right: '25%', padding: '3px' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_ChevronRight__WEBPACK_IMPORTED_MODULE_4__.default, null))),
                    this.getChildren()[this.state.currentLevel])));
        };
        this.handleMetadataChange = () => {
            this.safeSetState({ currentLevel: this.props.childrenLabels.indexOf(this.props.getValue(_Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata)) });
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            currentLevel: this.props.childrenLabels.indexOf(this.props.getValue(_Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata)),
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/resources/ResourcesPanel.js":
/*!***********************************************************!*\
  !*** ./lib/components/deploy/resources/ResourcesPanel.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ResourcesPanel": () => (/* binding */ ResourcesPanel)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _ResourceSelector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ResourceSelector */ "./lib/components/deploy/resources/ResourceSelector.js");
/* harmony import */ var _GraphicsBasic__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./GraphicsBasic */ "./lib/components/deploy/resources/GraphicsBasic.js");
/* harmony import */ var _GraphicsRating__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./GraphicsRating */ "./lib/components/deploy/resources/GraphicsRating.js");
/* harmony import */ var _GraphicsEquipment__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./GraphicsEquipment */ "./lib/components/deploy/resources/GraphicsEquipment.js");
/* harmony import */ var _GraphicsComponent__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./GraphicsComponent */ "./lib/components/deploy/resources/GraphicsComponent.js");
/* harmony import */ var _ComputeBasic__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ComputeBasic */ "./lib/components/deploy/resources/ComputeBasic.js");
/* harmony import */ var _ComputeRating__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./ComputeRating */ "./lib/components/deploy/resources/ComputeRating.js");
/* harmony import */ var _ComputeComponent__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./ComputeComponent */ "./lib/components/deploy/resources/ComputeComponent.js");
/* harmony import */ var _ComputeSimplified__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./ComputeSimplified */ "./lib/components/deploy/resources/ComputeSimplified.js");
/* harmony import */ var _MemoryBasic__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./MemoryBasic */ "./lib/components/deploy/resources/MemoryBasic.js");
/* harmony import */ var _MemoryRating__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./MemoryRating */ "./lib/components/deploy/resources/MemoryRating.js");
/* harmony import */ var _MemoryComponent__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./MemoryComponent */ "./lib/components/deploy/resources/MemoryComponent.js");
/* harmony import */ var _StorageBasic__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./StorageBasic */ "./lib/components/deploy/resources/StorageBasic.js");
/* harmony import */ var _StorageComponent__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./StorageComponent */ "./lib/components/deploy/resources/StorageComponent.js");
/* harmony import */ var _StorageRating__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./StorageRating */ "./lib/components/deploy/resources/StorageRating.js");
/* harmony import */ var _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../models/OptumiConfig */ "./lib/models/OptumiConfig.js");
/* harmony import */ var _Basic__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./Basic */ "./lib/components/deploy/resources/Basic.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




















class ResourcesPanel extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            // For non-experimental users, we only need to look at one resource to decide what mode they are in
            // const basic: boolean = Global.metadata.getMetadata().metadata.graphics.expertise == Expertise.BASIC;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: this.props.style }, _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.userExpertise >= 2 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ResourceSelector__WEBPACK_IMPORTED_MODULE_3__.ResourceSelector, { title: 'GPU', getValue: this.getGraphicsLevel, saveValue: this.saveGraphicsLevel, childrenLabels: [_models_OptumiConfig__WEBPACK_IMPORTED_MODULE_4__.Expertise.BASIC, _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_4__.Expertise.RATING, _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_4__.Expertise.EQUIPMENT, _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_4__.Expertise.COMPONENT] },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_GraphicsBasic__WEBPACK_IMPORTED_MODULE_5__.GraphicsBasic, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_GraphicsRating__WEBPACK_IMPORTED_MODULE_6__.GraphicsRating, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_GraphicsEquipment__WEBPACK_IMPORTED_MODULE_7__.GraphicsEquipment, null),
                    _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.userExpertise >= 2 && react__WEBPACK_IMPORTED_MODULE_0__.createElement(_GraphicsComponent__WEBPACK_IMPORTED_MODULE_8__.GraphicsComponent, null)),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Divider, { variant: 'middle' }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ResourceSelector__WEBPACK_IMPORTED_MODULE_3__.ResourceSelector, { title: 'CPU', getValue: this.getComputeLevel, saveValue: this.saveComputeLevel, childrenLabels: [_models_OptumiConfig__WEBPACK_IMPORTED_MODULE_4__.Expertise.BASIC, _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_4__.Expertise.RATING, _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_4__.Expertise.SIMPLIFIED, _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_4__.Expertise.COMPONENT] },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ComputeBasic__WEBPACK_IMPORTED_MODULE_9__.ComputeBasic, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ComputeRating__WEBPACK_IMPORTED_MODULE_10__.ComputeRating, null),
                    _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.userExpertise >= 2 && react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ComputeSimplified__WEBPACK_IMPORTED_MODULE_11__.ComputeSimplified, null),
                    _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.userExpertise >= 2 && react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ComputeComponent__WEBPACK_IMPORTED_MODULE_12__.ComputeComponent, null)),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Divider, { variant: 'middle' }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ResourceSelector__WEBPACK_IMPORTED_MODULE_3__.ResourceSelector, { title: 'RAM', getValue: this.getMemoryLevel, saveValue: this.saveMemoryLevel, childrenLabels: [_models_OptumiConfig__WEBPACK_IMPORTED_MODULE_4__.Expertise.BASIC, _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_4__.Expertise.RATING, _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_4__.Expertise.COMPONENT] },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_MemoryBasic__WEBPACK_IMPORTED_MODULE_13__.MemoryBasic, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_MemoryRating__WEBPACK_IMPORTED_MODULE_14__.MemoryRating, null),
                    _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.userExpertise >= 2 && react__WEBPACK_IMPORTED_MODULE_0__.createElement(_MemoryComponent__WEBPACK_IMPORTED_MODULE_15__.MemoryComponent, null)),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Divider, { variant: 'middle' }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ResourceSelector__WEBPACK_IMPORTED_MODULE_3__.ResourceSelector, { title: 'DSK', getValue: this.getStorageLevel, saveValue: this.saveStorageLevel, childrenLabels: [_models_OptumiConfig__WEBPACK_IMPORTED_MODULE_4__.Expertise.BASIC, _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_4__.Expertise.RATING, _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_4__.Expertise.COMPONENT] },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_StorageBasic__WEBPACK_IMPORTED_MODULE_16__.StorageBasic, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_StorageRating__WEBPACK_IMPORTED_MODULE_17__.StorageRating, null),
                    _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.userExpertise >= 2 && react__WEBPACK_IMPORTED_MODULE_0__.createElement(_StorageComponent__WEBPACK_IMPORTED_MODULE_18__.StorageComponent, null)))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Basic__WEBPACK_IMPORTED_MODULE_19__.Basic, null)))));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            // This will cause the display to change when we change to a new notebook with a different level specified
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getGraphicsLevel(tracker) {
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        return graphics.expertise;
    }
    async saveGraphicsLevel(tracker, expertise) {
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        graphics.expertise = expertise;
        tracker.setMetadata(optumi);
    }
    getComputeLevel(tracker) {
        const optumi = tracker.getMetadata();
        const compute = optumi.config.compute;
        return compute.expertise;
    }
    async saveComputeLevel(tracker, expertise) {
        const optumi = tracker.getMetadata();
        const compute = optumi.config.compute;
        compute.expertise = expertise;
        tracker.setMetadata(optumi);
    }
    getMemoryLevel(tracker) {
        const optumi = tracker.getMetadata();
        const memory = optumi.config.memory;
        return memory.expertise;
    }
    async saveMemoryLevel(tracker, expertise) {
        const optumi = tracker.getMetadata();
        const memory = optumi.config.memory;
        memory.expertise = expertise;
        tracker.setMetadata(optumi);
    }
    getStorageLevel(tracker) {
        const optumi = tracker.getMetadata();
        const storage = optumi.config.storage;
        return storage.expertise;
    }
    async saveStorageLevel(tracker, expertise) {
        const optumi = tracker.getMetadata();
        const storage = optumi.config.storage;
        storage.expertise = expertise;
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/deploy/resources/StorageBasic.js":
/*!*********************************************************!*\
  !*** ./lib/components/deploy/resources/StorageBasic.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StorageBasic": () => (/* binding */ StorageBasic)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core */ "./lib/core/Switch.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class StorageBasic extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.handleChange = (event) => {
            const checked = event.target.checked;
            this.saveValue(checked);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: this.props.style },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Switch, { label: 'Required', flip: true, getValue: this.getValue, saveValue: this.saveValue })));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const storage = optumi.config.storage;
        return storage.required;
        return false;
    }
    async saveValue(checked) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const storage = optumi.config.storage;
        storage.required = checked;
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/deploy/resources/StorageComponent.js":
/*!*************************************************************!*\
  !*** ./lib/components/deploy/resources/StorageComponent.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StorageComponent": () => (/* binding */ StorageComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core */ "./lib/core/Slider.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class StorageComponent extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            var user = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: this.props.style },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Slider, { getValue: this.getSizeValue, saveValue: this.saveSizeValue, minValue: -1, step: 1048576, maxValue: user.machines.absoluteStorageMaxSize, label: 'Size', color: '#89858b', showUnit: true, styledUnit: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.styleCapacityUnit(), styledValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.styleCapacityValue(), unstyledValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.unstyleCapacityValue() }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Slider, { getValue: this.getIopsValue, saveValue: this.saveIopsValue, minValue: -1, maxValue: user.machines.absoluteStorageMaxIops, label: 'IOPS', color: '#89858b', showUnit: true }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Slider, { getValue: this.getThroughputValue, saveValue: this.saveThroughputValue, minValue: -1, step: 1000000, maxValue: user.machines.absoluteStorageMaxThroughput, label: 'Throughput', color: '#89858b', showUnit: true, styledUnit: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.styleThroughputUnit(), styledValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.styleThroughputValue(), unstyledValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.unstyleThroughputValue() })));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getSizeValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const storage = optumi.config.storage;
        return storage.size[1];
        return 20;
    }
    async saveSizeValue(size) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const storage = optumi.config.storage;
        storage.size = [-1, size, -1];
        tracker.setMetadata(optumi);
    }
    getIopsValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const storage = optumi.config.storage;
        return storage.iops[1];
        return 20;
    }
    async saveIopsValue(iops) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const storage = optumi.config.storage;
        storage.iops = [-1, iops, -1];
        tracker.setMetadata(optumi);
    }
    getThroughputValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const storage = optumi.config.storage;
        return storage.throughput[1];
        return 20;
    }
    async saveThroughputValue(throughput) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const storage = optumi.config.storage;
        storage.throughput = [-1, throughput, -1];
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/deploy/resources/StorageRating.js":
/*!**********************************************************!*\
  !*** ./lib/components/deploy/resources/StorageRating.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StorageRating": () => (/* binding */ StorageRating)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core */ "./lib/core/Slider.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class StorageRating extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: this.props.style },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Slider, { getValue: this.getValue, saveValue: this.saveValue, marks: _Global__WEBPACK_IMPORTED_MODULE_1__.Global.fractionMarks, step: null, label: 'DSK', color: '#68da7c', styledUnit: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.styleRatingUnit(), styledValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.styleRatingValue(), unstyledValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__.default.unstyleRatingValue() })));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const storage = optumi.config.storage;
        return storage.rating[1];
    }
    async saveValue(rating) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const storage = optumi.config.storage;
        storage.rating = [-1, rating, -1];
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/machines/Budget.js":
/*!*******************************************!*\
  !*** ./lib/components/machines/Budget.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Budget": () => (/* binding */ Budget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class Budget extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.polling = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'flex', margin: '6px' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { flexGrow: 1, justifyContent: 'center', fontSize: '16px', lineHeight: '30px', fontWeight: 'bold' } }, "Monthly Budget"),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { flexGrow: 1, justifyContent: 'center', fontSize: '14px', lineHeight: '30px', textAlign: 'right' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
                        "Left: $",
                        (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.userBudget - this.state.cost).toFixed(2)),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
                        "Used: $",
                        this.state.cost.toFixed(2)))));
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            this.polling = true;
            this.receiveUpdate();
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            this._isMounted = false;
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lastBudgetCost = this.state.cost;
            this.polling = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            cost: _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lastBudgetCost,
        };
    }
    async receiveUpdate() {
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/get-total-billing";
        const now = new Date();
        const thisMonth = new Date(now);
        thisMonth.setDate(1);
        thisMonth.setHours(0);
        thisMonth.setMinutes(0);
        thisMonth.setSeconds(0);
        thisMonth.setMilliseconds(0);
        const init = {
            method: 'POST',
            body: JSON.stringify({
                startTime: thisMonth.toISOString(),
                endTime: now.toISOString(),
            }),
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            if (this.polling) {
                // If we are polling, send a new request in 2 seconds
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnPoll)
                    console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                setTimeout(() => this.receiveUpdate(), 2000);
            }
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.handleResponse(response);
            return response.json();
        }).then((body) => {
            if (body) {
                if (JSON.stringify(body) !== JSON.stringify(this.previousUpdate)) {
                    this.safeSetState({ cost: body.total });
                    this.previousUpdate = body;
                }
            }
        });
    }
}


/***/ }),

/***/ "./lib/components/machines/Credits.js":
/*!********************************************!*\
  !*** ./lib/components/machines/Credits.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Credits": () => (/* binding */ Credits)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class Credits extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.polling = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'flex', margin: '6px' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { flexGrow: 1, justifyContent: 'center', fontSize: '16px', lineHeight: '30px', fontWeight: 'bold' } }, "Credits"),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { flexGrow: 1, justifyContent: 'center', fontSize: '14px', lineHeight: '30px', textAlign: 'right' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
                        "Left: $",
                        (-this.state.balance).toFixed(2)),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
                        "Used: $",
                        this.state.cost.toFixed(2)))));
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            this.polling = true;
            this.receiveUpdate();
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            this._isMounted = false;
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lastCreditsCost = this.state.cost;
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lastCreditsBalance = this.state.balance;
            this.polling = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            cost: _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lastCreditsCost,
            balance: _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lastCreditsBalance,
        };
    }
    async receiveUpdate() {
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/get-total-billing";
        const init = {
            method: 'POST',
            body: JSON.stringify({
                startTime: new Date(0).toISOString(),
                endTime: new Date().toISOString(),
            }),
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            if (this.polling) {
                // If we are polling, send a new request in 2 seconds
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnPoll)
                    console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                setTimeout(() => this.receiveUpdate(), 2000);
            }
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.handleResponse(response);
            return response.json();
        }).then((body) => {
            if (body) {
                if (JSON.stringify(body) !== JSON.stringify(this.previousUpdate)) {
                    this.safeSetState({ balance: body.balance, cost: body.total });
                    this.previousUpdate = body;
                }
            }
        });
    }
}


/***/ }),

/***/ "./lib/components/machines/Rate.js":
/*!*****************************************!*\
  !*** ./lib/components/machines/Rate.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Rate": () => (/* binding */ Rate)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class Rate extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.polling = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'flex', margin: '6px' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { flexGrow: 1, justifyContent: 'center', fontSize: '16px', lineHeight: '30px', fontWeight: 'bold' } }, "Rate"),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { flexGrow: 1, justifyContent: 'center', fontSize: '14px', lineHeight: '30px', textAlign: 'right' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
                        "$",
                        this.state.cost.toFixed(2),
                        "/hr"))));
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            this.polling = true;
            this.receiveUpdate();
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            this._isMounted = false;
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lastMachineRate = this.state.cost;
            this.polling = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            cost: _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lastMachineRate,
        };
    }
    async receiveUpdate() {
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/get-total-billing";
        const now = new Date();
        const init = {
            method: 'POST',
            body: JSON.stringify({
                startTime: now.toISOString(),
                endTime: now.toISOString(),
            }),
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            if (this.polling) {
                // If we are polling, send a new request in 2 seconds
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnPoll)
                    console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                setTimeout(() => this.receiveUpdate(), 2000);
            }
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.handleResponse(response);
            return response.json();
        }).then((body) => {
            if (body) {
                if (JSON.stringify(body) !== JSON.stringify(this.previousUpdate)) {
                    this.safeSetState({ balance: body.balance, cost: body.total });
                    this.previousUpdate = body;
                }
            }
        });
    }
}


/***/ }),

/***/ "./lib/components/monitor/ScrollableDiv.js":
/*!*************************************************!*\
  !*** ./lib/components/monitor/ScrollableDiv.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ScrollableDiv": () => (/* binding */ ScrollableDiv)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var ansi_to_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ansi-to-react */ "webpack/sharing/consume/default/ansi-to-react/ansi-to-react");
/* harmony import */ var ansi_to_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(ansi_to_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_NotebookUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/NotebookUtils */ "./lib/utils/NotebookUtils.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class ScrollableDiv extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.getFormattedContents = () => {
            var source = this.props.source;
            if (source.length == 0) {
                return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", null, "No output to display."));
            }
            else {
                const lines = [];
                for (let outputLine of source) {
                    lines.push(outputLine.line);
                }
                var ansiText = _utils_NotebookUtils__WEBPACK_IMPORTED_MODULE_2__.default.fixOverwrittenChars(lines);
                return (react__WEBPACK_IMPORTED_MODULE_0__.createElement((ansi_to_react__WEBPACK_IMPORTED_MODULE_1___default()), { key: lines[0] }, ansiText));
            }
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null));
            // return content;
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { overflow: 'auto', width: '100%', height: '100%', padding: "20px", whiteSpace: 'pre' }, ref: this.element }, this.getFormattedContents()));
        };
        this.getSnapshotBeforeUpdate = (prevProps, prevState) => {
            if (this.props.autoScroll && this.element.current != null) {
                return {
                    "scrollTop": this.element.current.scrollTop,
                    "scrollHeight": this.element.current.scrollHeight,
                    "clientHeight": this.element.current.clientHeight
                };
            }
            return null;
        };
        this.componentDidUpdate = (prevProps, prevState, snapshot) => {
            if (this.props.autoScroll && snapshot != null) {
                // if (this.element.current != null) {
                var element = this.element.current;
                if (snapshot.scrollTop >= snapshot.scrollHeight - snapshot.clientHeight) {
                    element.scrollTo({
                        top: element.scrollHeight - element.clientHeight,
                        behavior: 'smooth'
                    });
                }
                // }
            }
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            if (this.props.autoScroll) {
                var element = this.element.current;
                element.scrollTo({
                    top: element.scrollHeight - element.clientHeight,
                    behavior: 'auto'
                });
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.element = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
    }
}


/***/ }),

/***/ "./lib/components/settings/ChangePasswordPopup.js":
/*!********************************************************!*\
  !*** ./lib/components/settings/ChangePasswordPopup.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ChangePasswordPopup": () => (/* binding */ ChangePasswordPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _material_ui_icons_Close__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material-ui/icons/Close */ "./node_modules/@material-ui/icons/Close.js");
/* harmony import */ var _material_ui_core_DialogTitle__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material-ui/core/DialogTitle */ "./node_modules/@material-ui/core/esm/DialogTitle/DialogTitle.js");
/* harmony import */ var _material_ui_core_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/core/styles */ "./node_modules/@material-ui/core/esm/styles/withStyles.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core */ "./lib/core/TextBox.js");
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/








const StyledDialog = (0,_material_ui_core_styles__WEBPACK_IMPORTED_MODULE_2__.default)({
    paper: {
        width: '300px',
        backgroundColor: 'var(--jp-layout-color1)',
    },
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Dialog);
class ChangePasswordPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClickOpen = () => {
            if (this.props.onOpen !== undefined)
                this.props.onOpen();
            this.safeSetState({ open: true });
        };
        this.handleClose = () => {
            this.safeSetState({ open: false, loginName: '', oldPassword: '', newPassword: '', errorMessage: '' });
            if (this.props.onClose !== undefined)
                this.props.onClose();
        };
        this.changePassword = () => {
            if (this.state.newPassword.length < 8) {
                this.safeSetState({ errorMessage: 'Password bust be at least 8 characters' });
            }
            else {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.changePassword(this.state.loginName, this.state.oldPassword, this.state.newPassword).then(() => {
                    this.handleClose();
                }, (reason) => {
                    this.safeSetState({ errorMessage: `Failed to change password...
Try checking your username/password` });
                });
            }
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Button, { onClick: this.handleClickOpen, style: Object.assign({
                        minWidth: '0px',
                    }, this.props.style), variant: "contained", color: "secondary", disableElevation: true }, "Edit"),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledDialog, { open: this.state.open, onClose: this.handleClose, scroll: 'paper' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core_DialogTitle__WEBPACK_IMPORTED_MODULE_4__.default, { disableTypography: true, style: {
                            display: 'inline-flex',
                            backgroundColor: 'var(--jp-layout-color2)',
                            height: '60px',
                            padding: '6px'
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                                display: 'inline-flex',
                                width: '100%',
                                padding: '6px',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                lineHeight: '24px',
                                margin: '6px',
                            } }, "Change Password"),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.IconButton, { onClick: this.handleClose, style: {
                                display: 'inline-block',
                                width: '36px',
                                height: '36px',
                                padding: '3px',
                                margin: '6px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_Close__WEBPACK_IMPORTED_MODULE_5__.default, { style: {
                                    width: '30px',
                                    height: '30px',
                                    padding: '3px',
                                } }))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.ShadowedDivider, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.DialogContent, { style: { padding: '0px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { padding: '6px' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_7__.TextBox, { label: 'Username', getValue: () => '', saveValue: (loginName) => {
                                    this.safeSetState({ loginName: loginName, errorMessage: '' });
                                }, placeholder: 'Username' }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_7__.TextBox, { label: 'Old', getValue: () => '', saveValue: (oldPassword) => {
                                    this.safeSetState({ oldPassword: oldPassword, errorMessage: '' });
                                }, placeholder: 'Old Password', password: true }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_7__.TextBox, { label: 'New', getValue: () => '', saveValue: (newPassword) => {
                                    this.safeSetState({ newPassword: newPassword, errorMessage: '' });
                                }, placeholder: 'New Password', password: true }),
                            this.state.errorMessage != '' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                                    color: '#f48f8d',
                                    margin: '0px 12px',
                                } }, this.state.errorMessage)))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Divider, { variant: 'middle' }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.DialogActions, { style: { padding: '6px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_8__.default, { reminder: this.state.errorMessage },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Button, { onClick: this.changePassword, color: 'primary', style: {
                                    padding: '6px',
                                    fontWeight: 'bold',
                                    fontSize: '14px',
                                    lineHeight: '14px',
                                    margin: '0px',
                                    color: this.state.errorMessage ? '#f48f8d' : '',
                                } }, "Confirm"))))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            open: false,
            loginName: '',
            oldPassword: '',
            newPassword: '',
            errorMessage: '',
        };
    }
}


/***/ }),

/***/ "./lib/components/settings/CheckoutForm.js":
/*!*************************************************!*\
  !*** ./lib/components/settings/CheckoutForm.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CheckoutForm": () => (/* binding */ CheckoutForm)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _stripe_stripe_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @stripe/stripe-js */ "webpack/sharing/consume/default/@stripe/stripe-js/@stripe/stripe-js");
/* harmony import */ var _stripe_stripe_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_stripe_stripe_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_3__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





const StyledSelect = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_3__.withStyles)({
    root: {
        fontSize: "var(--jp-ui-font-size1)",
    },
    iconOutlined: {
        right: '0px'
    }
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_3__.Select);
const StyledMenuItem = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_3__.withStyles)({
    root: {
        fontSize: 'var(--jp-ui-font-size1)',
        padding: '3px 3px 3px 6px',
    }
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_3__.MenuItem);
// const stripePromise = loadStripe("pk_test_51HIzv8LdDawhowJuVhTKv6KRnt72In8txUs0Dss0eT4KgFFcRfQlkWEDX9kzhAeiTjiYbxgxRvKbR6TfSJcqiD4o00irQVFdtY");
const stripePromise = (0,_stripe_stripe_js__WEBPACK_IMPORTED_MODULE_2__.loadStripe)("pk_live_51HIzv8LdDawhowJuSfMFb1yBW8F9VfK87tSAfMF2UdwTNVdaixpy7xjYUcP6d5GGWs1bDfLGEexyjbYj0dkKHJac00HMDHWhxU");
class CheckoutForm extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClick = async () => {
            // Get Stripe.js instance    
            // Call your backend to create the Checkout Session
            this.safeSetState({ waiting: true });
            const stripe = await stripePromise;
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/create-checkout";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    items: [Math.round(this.state.amount).toString() + ' credits'],
                    redirect: settings.baseUrl,
                }),
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_4__.Global.handleResponse(response);
                return response.json();
            }).then((body) => {
                // When the customer clicks on the button, redirect them to Checkout.
                return stripe.redirectToCheckout({
                    sessionId: body.id,
                });
            }).then((result) => {
                this.safeSetState({ waiting: false });
                if (result.error) {
                    // If `redirectToCheckout` fails due to a browser or network
                    // error, display the localized error message to your customer
                    // using `result.error.message`.
                }
            });
        };
        this.handleAmountChange = (event) => {
            const value = event.target.value;
            this.safeSetState({ amount: value });
        };
        // The contents of the component
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'inline-flex', width: '100%', padding: '3px 0px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                            lineHeight: '24px',
                            margin: '0px 12px',
                            flexGrow: 1,
                        } }, 'Increase balance by'),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { padding: '0px 6px 0px 6px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledSelect, { value: this.isCustom(this.state.amount) ? -1 : this.state.amount, variant: 'outlined', onChange: this.handleAmountChange, SelectDisplayProps: { style: { padding: '3px 20px 3px 6px' } }, MenuProps: { MenuListProps: { style: { paddingTop: '6px', paddingBottom: '6px' } } } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledMenuItem, { value: 5 }, "$5"),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledMenuItem, { value: 10 }, "$10"),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledMenuItem, { value: 25 }, "$25"),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledMenuItem, { value: 50 }, "$50"),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledMenuItem, { value: 100 }, "$100")))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { padding: '6px', width: '100%' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_3__.Button, { disabled: this.state.waiting, color: "primary", variant: "contained", style: { width: '100%' }, onClick: this.handleClick }, this.state.waiting ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_3__.CircularProgress, { size: '1.75em' })) : 'Checkout'))));
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            amount: 10,
            waiting: false,
        };
    }
    isCustom(amount) {
        return !(this.state.amount == 5 || this.state.amount == 10 || this.state.amount == 25 || this.state.amount == 50 || this.state.amount == 100);
    }
}


/***/ }),

/***/ "./lib/components/settings/SettingsMenu.js":
/*!*************************************************!*\
  !*** ./lib/components/settings/SettingsMenu.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AccountGeneralSubMenu": () => (/* binding */ AccountGeneralSubMenu),
/* harmony export */   "AccountLimitsSubMenu": () => (/* binding */ AccountLimitsSubMenu),
/* harmony export */   "AccountPaymentSubMenu": () => (/* binding */ AccountPaymentSubMenu),
/* harmony export */   "AccountConnectorsSubMenu": () => (/* binding */ AccountConnectorsSubMenu),
/* harmony export */   "TeamSubMenu": () => (/* binding */ TeamSubMenu)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _ChangePasswordPopup__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ChangePasswordPopup */ "./lib/components/settings/ChangePasswordPopup.js");
/* harmony import */ var _CheckoutForm__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./CheckoutForm */ "./lib/components/settings/CheckoutForm.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core */ "./lib/core/TextBox.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core */ "./lib/core/Switch.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core */ "./lib/core/TextBoxDropdown.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../core */ "./lib/core/Header.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _material_ui_icons_GetApp__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @material-ui/icons/GetApp */ "./node_modules/@material-ui/icons/GetApp.js");
/* harmony import */ var _deploy_dataConnectorBrowser_DataConnectorBrowser__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../deploy/dataConnectorBrowser/DataConnectorBrowser */ "./lib/components/deploy/dataConnectorBrowser/DataConnectorBrowser.js");
/* harmony import */ var _deploy_AmazonS3ConnectorPopup__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../deploy/AmazonS3ConnectorPopup */ "./lib/components/deploy/AmazonS3ConnectorPopup.js");
/* harmony import */ var _deploy_GoogleCloudStorageConnectorPopup__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../deploy/GoogleCloudStorageConnectorPopup */ "./lib/components/deploy/GoogleCloudStorageConnectorPopup.js");
/* harmony import */ var _deploy_GoogleDriveConnectorPopup__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../deploy/GoogleDriveConnectorPopup */ "./lib/components/deploy/GoogleDriveConnectorPopup.js");
/* harmony import */ var _deploy_KaggleConnectorPopup__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../deploy/KaggleConnectorPopup */ "./lib/components/deploy/KaggleConnectorPopup.js");
/* harmony import */ var _deploy_WasabiConnectorPopup__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../deploy/WasabiConnectorPopup */ "./lib/components/deploy/WasabiConnectorPopup.js");
/* harmony import */ var _core_PhoneTextBox__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/PhoneTextBox */ "./lib/core/PhoneTextBox.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
















const emUpSub = 'Upgrade subscription to unlock';
const LABEL_WIDTH = '80px';
class AccountGeneralSubMenu extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({ padding: '6px' }, this.props.style) },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'inline-flex', width: '100%' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { style: { flexGrow: 1 }, getValue: this.getPasswordValue, saveValue: this.savePasswordValue, label: 'Password', labelWidth: LABEL_WIDTH }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ChangePasswordPopup__WEBPACK_IMPORTED_MODULE_5__.ChangePasswordPopup, { style: { margin: '8px 0px', height: '20px', fontSize: '12px', lineHeight: '12px' } })),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_PhoneTextBox__WEBPACK_IMPORTED_MODULE_6__.PhoneTextBox, { getValue: () => _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.phoneNumber, saveValue: (phoneNumber) => {
                            if (phoneNumber == '')
                                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.notificationsEnabled = false;
                            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.phoneNumber = phoneNumber;
                            // We need to update so the switch below will be updated properly
                            this.setState({ switchKey: this.state.switchKey + 1 });
                        }, validOnBlur: this.props.phoneValidOnBlur, label: 'Phone', labelWidth: LABEL_WIDTH }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_7__.Switch, { key: this.state.switchKey, getValue: () => _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.notificationsEnabled, saveValue: (notificationsEnabled) => { _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.notificationsEnabled = notificationsEnabled; }, label: 'Enable SMS notifications to the listed phone number', labelWidth: LABEL_WIDTH, disabled: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.phoneNumber == '' }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_7__.Switch, { getValue: () => _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.compressFilesEnabled, saveValue: (compressFilesEnabled) => { _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.compressFilesEnabled = compressFilesEnabled; }, label: 'Compress my files before uploading', labelWidth: LABEL_WIDTH }))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            // We need to increment this when the user changes his number so the switch will be enabled/disabled properly
            switchKey: 0
        };
    }
    getPasswordValue() { return '******'; }
    savePasswordValue(password) {
        _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.changePassword("", "", password);
    }
}
class AccountLimitsSubMenu extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({ padding: '6px' }, this.props.style) },
                    _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.userExpertise > 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { getValue: this.getUserBudgetValue, saveValue: this.saveUserBudgetValue, styledUnitValue: (value) => '$' + value.toFixed(2), unstyleUnitValue: (value) => { return value.replace('$', '').replace('.', '').replace(/\d/g, '').length > 0 ? Number.NaN : Number.parseFloat(value.replace('$', '')); }, label: 'Budget', labelWidth: LABEL_WIDTH, onFocus: () => this.safeSetState({ budgetFocused: true }), onBlur: () => this.safeSetState({ budgetFocused: false }), helperText: this.state.budgetFocused ? `Must be between $1 and $${_Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.maxBudget}` : 'Max monthly spend', minValue: 1, maxValue: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.maxBudget })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null)),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { getValue: this.getMaxJobsValue, saveValue: this.saveMaxJobsValue, unstyleUnitValue: (value) => { return value.replace(/\d/g, '').length > 0 ? Number.NaN : Number.parseFloat(value); }, label: 'Jobs/Sessions', labelWidth: LABEL_WIDTH, helperText: 'Max combined number of concurrent jobs and sessions', disabledMessage: emUpSub }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { getValue: this.getMaxMachinesValue, saveValue: this.saveMaxMachinesValue, unstyleUnitValue: (value) => { return value.replace(/\d/g, '').length > 0 ? Number.NaN : Number.parseFloat(value); }, label: 'Machines', labelWidth: LABEL_WIDTH, helperText: 'Max number of concurrent machines', disabledMessage: emUpSub }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_8__.TextBoxDropdown, { getValue: this.getUserHoldoverTimeValue, saveValue: this.saveUserHoldoverTimeValue, unitValues: [
                            { unit: 'seconds', value: 1 },
                            { unit: 'minutes', value: 60 },
                            { unit: 'hours', value: 3600 },
                        ], label: 'Auto-release', labelWidth: LABEL_WIDTH, onFocus: () => this.safeSetState({ holdoverFocused: true }), onBlur: () => this.safeSetState({ holdoverFocused: false }), helperText: this.state.holdoverFocused ? `Must be between 0 seconds and ${_Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.maxHoldoverTime / 3600} hours` : 'Time before releasing idle machines', minValue: 0, maxValue: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.maxHoldoverTime }))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            holdoverFocused: false,
            budgetFocused: false,
            recsFocused: false,
        };
    }
    getUserBudgetValue() { return _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.userBudget; }
    saveUserBudgetValue(userBudget) { _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.userBudget = userBudget; }
    getMaxJobsValue() { return _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.maxJobs; }
    saveMaxJobsValue(value) { _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.maxJobs = value; }
    getMaxMachinesValue() { return _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.maxMachines; }
    saveMaxMachinesValue(value) { _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.maxMachines = value; }
    getUserHoldoverTimeValue() { return _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.userHoldoverTime; }
    saveUserHoldoverTimeValue(userHoldoverTime) { _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.userHoldoverTime = userHoldoverTime; }
}
class AccountPaymentSubMenu extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.polling = false;
        this.getDuration = (record) => {
            var endTime = new Date(record.endTime);
            var startTime = new Date(record.startTime);
            var diff = endTime.getTime() - startTime.getTime();
            const stillRunning = diff < 0;
            if (stillRunning) {
                diff = new Date().getTime() - startTime.getTime();
            }
            var time = _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_9__.default.msToTime(diff).split(':');
            var formatted;
            if (time.length == 3) {
                formatted = time[0] + 'h ' + time[1] + 'm ' + time[2] + 's';
            }
            else {
                formatted = time[0] + 'm ' + time[1] + 's';
            }
            return stillRunning ? formatted + ' (still running)' : formatted;
        };
        this.getCost = (record) => {
            var endTime = new Date(record.endTime);
            var startTime = new Date(record.startTime);
            var diff = endTime.getTime() - startTime.getTime();
            const stillRunning = diff < 0;
            if (stillRunning) {
                diff = new Date().getTime() - startTime.getTime();
            }
            var formatted = '$' + ((diff / 3600000) * record.machine.rate).toFixed(2);
            return stillRunning ? formatted + ' (still running)' : formatted;
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({ padding: '6px' }, this.props.style) },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'inline-flex', width: '100%', padding: '3px 0px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                                lineHeight: '24px',
                                margin: '0px 12px',
                                flexGrow: 1,
                            } }, 'Remaining balance:'),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { padding: '0px 6px 0px 6px' } }, '$' + (-this.state.balance).toFixed(2))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_CheckoutForm__WEBPACK_IMPORTED_MODULE_10__.CheckoutForm, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { padding: '6px', width: '100%' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.Button, { variant: "outlined", color: "primary", startIcon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_GetApp__WEBPACK_IMPORTED_MODULE_11__.default, null), style: { width: '100%' }, onClick: () => this.getDetailedBilling(true) }, "Billing records")))));
        };
        this.getDetailedBilling = (save) => {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/get-detailed-billing";
            const now = new Date();
            const epoch = new Date(0);
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    startTime: epoch.toISOString(),
                    endTime: now.toISOString(),
                }),
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
                return response.json();
            }).then((body) => {
                if (body) {
                    this.safeSetState({ billing: body.records });
                    if (save) {
                        const data = [];
                        var sorted = body.records.sort((n1, n2) => {
                            if (n1.startTime > n2.startTime) {
                                return -1;
                            }
                            if (n1.startTime < n2.startTime) {
                                return 1;
                            }
                            return 0;
                        });
                        for (let record of sorted) {
                            const machine = record.machine;
                            data.push([
                                new Date(record.startTime).toLocaleString().replace(/,/g, ''),
                                new Date(0).toISOString() == new Date(record.endTime).toISOString() ? 'Still running' : new Date(record.endTime).toLocaleString().replace(/,/g, ''),
                                this.getDuration(record),
                                '$' + machine.rate.toFixed(2),
                                this.getCost(record),
                                machine.graphicsNumCards > 0 ? (machine.graphicsNumCards + 'x' + machine.graphicsCardType) : 'No GPU',
                                machine.computeCores + ' cores',
                                _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_9__.default.styleCapacityUnitValue()(machine.memorySize),
                                _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_9__.default.styleCapacityUnitValue()(machine.storageSize)
                            ]);
                        }
                        const headers = [
                            ["Start Time", "End Time", "Duration", "Rate ($/hr)", "Cost", "GPU", "CPU", "RAM", "Disk"]
                        ];
                        const csvContent = "data:text/csv;charset=utf-8,"
                            + headers.map(e => e.join(",")).join("\n") + '\n'
                            + data.map(e => e.join(",")).join("\n") + '\n';
                        var encodedUri = encodeURI(csvContent);
                        var link = document.createElement("a");
                        link.setAttribute("href", encodedUri);
                        link.setAttribute("download", "billing_records.csv");
                        document.body.appendChild(link); // Required for FF
                        link.click();
                    }
                }
            });
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            this.getDetailedBilling(false);
            this.polling = true;
            this.receiveUpdate();
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            this._isMounted = false;
            this.polling = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            balance: 0,
            billing: [],
        };
    }
    async receiveUpdate() {
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/get-total-billing";
        const now = new Date();
        const epoch = new Date(0);
        const init = {
            method: 'POST',
            body: JSON.stringify({
                startTime: epoch.toISOString(),
                endTime: now.toISOString(),
            }),
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            if (this.polling) {
                // If we are polling, send a new request in 2 seconds
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnPoll)
                    console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                setTimeout(() => this.receiveUpdate(), 2000);
            }
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
            return response.json();
        }).then((body) => {
            if (body) {
                this.safeSetState({ balance: body.balance });
            }
        });
    }
}
class AccountConnectorsSubMenu extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        // Use a key to force the data connector browser to refresh
        this.forceNewBrowser = () => {
            this.safeSetState({ browserKey: this.state.browserKey + 1 });
        };
        this.request = async () => {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
            const url = settings.baseUrl + 'optumi/get-data-connectors';
            return _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, {}, settings).then(response => {
                if (response.status !== 200)
                    throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.ResponseError(response);
                return response.json();
            });
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({}, this.props.style) },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'inline-flex', margin: '6px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_12__.Header, { title: 'Existing Connectors', style: { lineHeight: '24px', margin: '6px 6px 6px 11px' } })),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.Divider, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_dataConnectorBrowser_DataConnectorBrowser__WEBPACK_IMPORTED_MODULE_13__.default, { key: this.state.browserKey, style: {
                            maxHeight: 'calc(100% - 60px - 2px)',
                        }, handleDelete: (dataConnectorMetadata) => {
                            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
                            const url = settings.baseUrl + "optumi/remove-data-connector";
                            const init = {
                                method: 'POST',
                                body: JSON.stringify({
                                    name: dataConnectorMetadata.name,
                                }),
                            };
                            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
                            }).then(() => {
                                var newDataConnectors = [...this.state.dataConnectors];
                                newDataConnectors = newDataConnectors.filter(dataConnector => dataConnector.name !== dataConnectorMetadata.name);
                                this.safeSetState({ dataConnectors: newDataConnectors });
                                this.forceNewBrowser();
                            });
                        } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.Divider, { style: { marginTop: '33px' } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'inline-flex', margin: '6px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_12__.Header, { title: 'New Connectors', style: { lineHeight: '24px', margin: '6px 6px 6px 11px' } })),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.Divider, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { marginBottom: '6px' } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_AmazonS3ConnectorPopup__WEBPACK_IMPORTED_MODULE_14__.AmazonS3ConnectorPopup, { onClose: this.forceNewBrowser }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_GoogleCloudStorageConnectorPopup__WEBPACK_IMPORTED_MODULE_15__.GoogleCloudStorageConnectorPopup, { onClose: this.forceNewBrowser }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_GoogleDriveConnectorPopup__WEBPACK_IMPORTED_MODULE_16__.GoogleDriveConnectorPopup, { onClose: this.forceNewBrowser }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_KaggleConnectorPopup__WEBPACK_IMPORTED_MODULE_17__.KaggleConnectorPopup, { onClose: this.forceNewBrowser }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_WasabiConnectorPopup__WEBPACK_IMPORTED_MODULE_18__.WasabiConnectorPopup, { onClose: this.forceNewBrowser }))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            this.request().then(json => this.safeSetState({ dataConnectors: json.connectors }));
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            dataConnectors: [],
            browserKey: 0,
        };
    }
}
class TeamSubMenu extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_12__.Header, { title: 'Members' }));
        };
    }
}


/***/ }),

/***/ "./lib/core/BaseConnectorPopup.js":
/*!****************************************!*\
  !*** ./lib/core/BaseConnectorPopup.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BaseConnectorPopup": () => (/* binding */ BaseConnectorPopup)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/icons */ "webpack/sharing/consume/default/@material-ui/icons/@material-ui/icons");
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_icons__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core_DialogTitle__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @material-ui/core/DialogTitle */ "./node_modules/@material-ui/core/esm/DialogTitle/DialogTitle.js");
/* harmony import */ var _ShadowedDivider__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./ShadowedDivider */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _TextBox__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./TextBox */ "./lib/core/TextBox.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _components_deploy_DataConnectorIdentity__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../components/deploy/DataConnectorIdentity */ "./lib/components/deploy/DataConnectorIdentity.js");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _models_DataConnectorUploadConfig__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../models/DataConnectorUploadConfig */ "./lib/models/DataConnectorUploadConfig.js");
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/












const StyledDialog = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.withStyles)({
    paper: {
        width: 'calc(min(80%, 600px + 150px + 2px))',
        // width: '100%',
        height: '80%',
        overflowY: 'visible',
        backgroundColor: 'var(--jp-layout-color1)',
        maxWidth: 'inherit',
    },
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Dialog);
const StyledButton = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.withStyles)({
    startIcon: {
        marginRight: '0px',
    },
    iconSizeMedium: {
        '& > *:first-child': {
            fontSize: '12px',
        },
    }
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Button);
const defaultState = {
    waiting: false,
    open: false,
    addSpinning: false,
    createSpinning: false,
    name: '',
    errorMessage: '',
};
class BaseConnectorPopup extends react__WEBPACK_IMPORTED_MODULE_2__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClickOpen = () => {
            this.safeSetState({ open: true });
        };
        this.handleClose = () => {
            if (!this.state.waiting) {
                if (this.props.onClose)
                    this.props.onClose();
                this.safeSetState(defaultState);
            }
        };
        this.nameHasError = (name) => {
            const tracker = _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata;
            const optumi = tracker.getMetadata();
            const upload = optumi.config.upload;
            const dataConnectors = upload.dataConnectors;
            for (var i = 0; i < dataConnectors.length; i++) {
                if (dataConnectors[i].name === name)
                    return true;
            }
            return false;
        };
        this.handleCreate = (add) => {
            this.safeSetState({ waiting: true, addSpinning: false, createSpinning: false });
            if (add) {
                setTimeout(() => {
                    if (this.state.waiting)
                        this.safeSetState({ addSpinning: true });
                }, 1000);
            }
            else {
                setTimeout(() => {
                    if (this.state.waiting)
                        this.safeSetState({ createSpinning: true });
                }, 1000);
            }
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__.ServerConnection.makeSettings();
            const url = settings.baseUrl + 'optumi/add-data-connector';
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    dataService: this.props.dataService,
                    name: this.state.name,
                    info: JSON.stringify(this.props.getInfo()),
                }),
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_5__.Global.handleResponse(response);
            }).then(() => {
                this.safeSetState({ waiting: false, addSpinning: false, createSpinning: false });
                if (add && !this.nameHasError(this.state.name)) {
                    const tracker = _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata;
                    const optumi = tracker.getMetadata();
                    var dataConnectors = optumi.config.upload.dataConnectors;
                    dataConnectors.push(new _models_DataConnectorUploadConfig__WEBPACK_IMPORTED_MODULE_6__.DataConnectorUploadConfig({
                        name: this.state.name,
                        dataService: this.props.dataService,
                    }));
                    tracker.setMetadata(optumi);
                }
                // Success
                this.handleClose();
            }, (error) => {
                error.response.text().then((text) => {
                    // Show what went wrong
                    this.safeSetState({ waiting: false, addSpinning: false, createSpinning: false, errorMessage: text });
                });
            });
        };
        this.handleKeyDown = (event) => {
            if (!this.state.open)
                return;
            if (event.key === 'Enter')
                this.handleCreate();
            if (event.key === 'Escape')
                this.handleClose();
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                console.log('CreateConnectorPopup (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: Object.assign({}, this.props.style) },
                react__WEBPACK_IMPORTED_MODULE_2__.createElement(_components_deploy_DataConnectorIdentity__WEBPACK_IMPORTED_MODULE_7__.DataConnectorIdentity, { iconClass: this.props.iconClass, dataService: this.props.dataService, description: this.props.description, handleClick: this.handleClickOpen }),
                react__WEBPACK_IMPORTED_MODULE_2__.createElement(StyledDialog, { disableBackdropClick: true, open: this.state.open, onClose: this.handleClose, scroll: 'paper' },
                    react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_core_DialogTitle__WEBPACK_IMPORTED_MODULE_8__.default, { disableTypography: true, style: {
                            display: 'inline-flex',
                            backgroundColor: 'var(--jp-layout-color2)',
                            height: '60px',
                            padding: '6px',
                            borderRadius: '4px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: {
                                display: 'inline-flex',
                                flexGrow: 1,
                                marginLeft: '-6px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement(_components_deploy_DataConnectorIdentity__WEBPACK_IMPORTED_MODULE_7__.DataConnectorIdentity, { iconClass: this.props.iconClass, dataService: this.props.dataService, style: { zoom: 1.4 } })),
                        react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", null,
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement(StyledButton, { disableElevation: true, style: { margin: '6px', height: '36px' }, variant: 'outlined', onClick: this.handleClose, disabled: this.state.waiting, startIcon: react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_icons__WEBPACK_IMPORTED_MODULE_1__.ArrowBackIos, null) }, "Back")),
                        react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", null,
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Button, { disableElevation: true, style: { margin: '6px', height: '36px' }, variant: 'contained', color: 'primary', onClick: () => this.handleCreate(false), disabled: this.state.waiting }, this.state.waiting && this.state.createSpinning ? react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.CircularProgress, { size: '1.75em' }) : 'Create'),
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_9__.default, { reminder: 'Create and add to your notebook' },
                                react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Button, { disableElevation: true, style: { margin: '6px', height: '36px' }, variant: 'contained', color: 'primary', onClick: () => this.handleCreate(true), disabled: (!(_Global__WEBPACK_IMPORTED_MODULE_5__.Global.labShell.currentWidget instanceof _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_4__.NotebookPanel) && _Global__WEBPACK_IMPORTED_MODULE_5__.Global.tracker.currentWidget != null) || this.state.waiting }, this.state.waiting && this.state.addSpinning ? react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.CircularProgress, { size: '1.75em' }) : 'Create + Add')))),
                    react__WEBPACK_IMPORTED_MODULE_2__.createElement(_ShadowedDivider__WEBPACK_IMPORTED_MODULE_10__.ShadowedDivider, null),
                    react__WEBPACK_IMPORTED_MODULE_2__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.DialogContent, { style: { padding: '0px', display: 'flex' } },
                        react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: { padding: '12px', display: 'flex', flexDirection: 'column' } },
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: { margin: '12px 18px 18px 18px' } }, this.props.header + " Files from this connector will be accessible in your notebook's working directory."),
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement(_TextBox__WEBPACK_IMPORTED_MODULE_11__.TextBox, { getValue: () => this.state.name, saveValue: (value) => this.safeSetState({ name: value }), label: 'Connector Name', helperText: 'The unique identifier for this connector.', labelWidth: BaseConnectorPopup.LABEL_WIDTH, disabled: this.state.waiting, required: true }),
                            this.props.getContents(this.state.waiting),
                            this.state.errorMessage && (react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: {
                                    color: '#f48f8d',
                                    margin: '36px 12px',
                                    wordBreak: 'break-all',
                                    fontSize: '12px',
                                } }, this.state.errorMessage)),
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: { flexGrow: 1 } }),
                            react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", { style: {
                                    margin: '12px 18px',
                                    fontStyle: 'italic',
                                    fontSize: '14px',
                                    textAlign: 'end',
                                    // TODO:Beck how do I do this with the theme
                                    color: 'gray'
                                } }, "*required fields"))))));
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            document.addEventListener('keydown', this.handleKeyDown, false);
        };
        this.componentWillUnmount = () => {
            document.removeEventListener('keydown', this.handleKeyDown, false);
            this._isMounted = false;
        };
        this.state = defaultState;
    }
}
BaseConnectorPopup.LABEL_WIDTH = '144px';


/***/ }),

/***/ "./lib/core/Dropdown.js":
/*!******************************!*\
  !*** ./lib/core/Dropdown.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Dropdown": () => (/* binding */ Dropdown)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core_styles_withStyles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/core/styles/withStyles */ "./node_modules/@material-ui/core/styles/withStyles.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




const StyledMenuItem = (0,_material_ui_core_styles_withStyles__WEBPACK_IMPORTED_MODULE_2__.default)({
    root: {
        fontSize: 'var(--jp-ui-font-size1)',
        padding: '3px 3px 3px 6px',
        textAlign: 'start',
    }
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.MenuItem);
class Dropdown extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.getStyledSelect = () => {
            return (0,_material_ui_core_styles_withStyles__WEBPACK_IMPORTED_MODULE_2__.default)({
                root: {
                    fontSize: "var(--jp-ui-font-size1)",
                    padding: '3px 3px 3px 6px',
                    textAlign: 'start',
                },
                iconOutlined: {
                    right: '0px'
                }
            })(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Select);
        };
        this.handleValueChange = (event) => {
            const value = event.target.value;
            this.safeSetState({ value: value });
            this.props.saveValue(value);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({
                    display: 'inline-flex',
                    width: '100%',
                    padding: '6px 0px',
                    textAlign: 'center',
                    justifyContent: 'center'
                }, this.props.style) },
                this.props.label && react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                        minWidth: this.props.labelWidth || '68px',
                        margin: '0px 12px',
                        lineHeight: '24px',
                    } }, this.props.label),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.FormControl, { variant: 'outlined', style: { width: '100%', margin: '2px 6px', height: this.props.helperText ? '32px' : '20px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledSelect, { value: this.state.value, variant: 'outlined', onChange: this.handleValueChange, SelectDisplayProps: { style: { padding: '1px 20px 1px 6px' } }, MenuProps: { MenuListProps: { style: { paddingTop: '6px', paddingBottom: '6px' } } }, style: { width: '100%' }, disabled: this.props.disabled }, this.props.values.map(value => react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledMenuItem, { key: value.value, value: value.value }, value.value + (value.description ? (': ' + value.description) : '')))),
                    this.props.helperText &&
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.FormHelperText, { style: { fontSize: '10px', lineHeight: '10px', margin: '4px 6px', whiteSpace: 'nowrap' } }, this.props.helperText))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            value: this.props.getValue(),
        };
        this.StyledSelect = this.getStyledSelect();
    }
}


/***/ }),

/***/ "./lib/core/Header.js":
/*!****************************!*\
  !*** ./lib/core/Header.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Header": () => (/* binding */ Header),
/* harmony export */   "SubHeader": () => (/* binding */ SubHeader)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/


class Header extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({
                    textAlign: this.props.align || 'left',
                    fontSize: '16px',
                    fontWeight: 'bold',
                    lineHeight: '18px',
                    margin: '6px'
                }, this.props.style) }, this.props.title));
        };
    }
}
class SubHeader extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({
                    textAlign: this.props.align || 'left',
                    fontSize: '14px',
                    fontWeight: 'bold',
                    lineHeight: '18px',
                    margin: '6px',
                    opacity: this.props.grey ? 0.5 : 1,
                }, this.props.style) }, this.props.title));
        };
    }
}


/***/ }),

/***/ "./lib/core/IntentSlider.js":
/*!**********************************!*\
  !*** ./lib/core/IntentSlider.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "IntentSlider": () => (/* binding */ IntentSlider)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/icons */ "webpack/sharing/consume/default/@material-ui/icons/@material-ui/icons");
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_material_ui_icons__WEBPACK_IMPORTED_MODULE_2__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




let retrievingPreview = false;
let updatePreviewAgain = false;
let latestValue;
const icons = [
    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons__WEBPACK_IMPORTED_MODULE_2__.Eco, { style: { fill: 'var(--jp-layout-color2)' } }),
    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons__WEBPACK_IMPORTED_MODULE_2__.Equalizer, { style: { fill: 'var(--jp-layout-color2)' } }),
    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons__WEBPACK_IMPORTED_MODULE_2__.FlashOn, { style: { fill: 'var(--jp-layout-color2)' } })
];
class IntentSlider extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.isLightMode = false;
        this.getStyledSlider = () => {
            this.isLightMode = _Global__WEBPACK_IMPORTED_MODULE_3__.Global.themeManager == undefined || _Global__WEBPACK_IMPORTED_MODULE_3__.Global.themeManager.isLight(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.themeManager.theme);
            return (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.withStyles)({
                root: {
                    height: '16px',
                    width: '100%',
                    padding: '13px 0px',
                },
                thumb: {
                    position: 'relative',
                    height: '42px',
                    width: '42px',
                    margin: '-13px -21px',
                    transition: 'none',
                    backgroundColor: this.props.color,
                    padding: '0px',
                    zIndex: 2,
                    // '&$focusVisible,&:hover': {
                    //     boxShadow: 'none',
                    // },
                    '&$active': {
                        boxShadow: 'none',
                    },
                    '&::after': {
                        left: 0,
                        top: 0,
                        right: 0,
                        bottom: 0,
                    },
                },
                thumbColorPrimary: {
                    // '&$focusVisible,&:hover': {
                    //     boxShadow: 'none',
                    // },
                    '&$active': {
                        boxShadow: 'none',
                    },
                },
                active: {
                    boxShadow: 'none',
                },
                track: {
                    height: '16px',
                    color: this.props.color,
                    opacity: 0,
                    boxSizing: 'border-box',
                    border: "1px solid " + (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.darken)(this.props.color, 0.25),
                    borderRadius: '8px',
                },
                rail: {
                    height: '16px',
                    width: '100%',
                    opacity: 1,
                    color: (this.isLightMode ? '#eeeeee' : '#424242'),
                    boxSizing: 'border-box',
                    border: '1px solid ' + (this.isLightMode ? (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.darken)('#eeeeee', 0.25) : (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.lighten)('#424242', 0.25)),
                    borderRadius: '8px',
                },
                mark: {
                    opacity: 0,
                },
                markActive: {
                    opacity: 0,
                },
                markLabel: {},
                markLabelActive: {},
            })(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Slider);
        };
        this.handleChange = async (event, newValue) => {
            if (newValue instanceof Array) {
                // This is invalid
            }
            else {
                this.safeSetState({ value: newValue / 100 });
                this.slowDownSaveValue(newValue / 100);
            }
        };
        this.handleChangeCommitted = async (event, newValue) => {
            if (newValue instanceof Array) {
                // This is invalid
            }
            else {
                this.safeSetState({ value: newValue / 100 });
                this.props.saveValue(newValue / 100);
            }
        };
        this.delay = (ms) => { return new Promise(resolve => setTimeout(resolve, ms)); };
        this.slowDownSaveValue = (newValue, bypassLimiter) => {
            if (newValue != null)
                latestValue = newValue;
            if (bypassLimiter || !retrievingPreview) {
                retrievingPreview = true;
                this.delay(100).then(() => {
                    this.props.saveValue(latestValue);
                    if (updatePreviewAgain) {
                        updatePreviewAgain = false;
                        this.slowDownSaveValue(null, true);
                    }
                    else {
                        retrievingPreview = false;
                    }
                }, () => {
                    retrievingPreview = false;
                });
            }
            else {
                updatePreviewAgain = true;
            }
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const icon = this.state.value < 0.33 ? 0 : this.state.value < 0.66 ? 1 : 2;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: this.props.style },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { position: 'relative', margin: '3px 6px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledSlider
                    // style={{position: 'relative'}}
                    , { 
                        // style={{position: 'relative'}}
                        onChange: this.handleChange, onChangeCommitted: this.handleChangeCommitted, min: 0, max: 100, value: this.state.value * 100, ThumbComponent: (props) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", Object.assign({ style: { transform: 'translate(' + (50 - (100 * this.state.value)) + '%, 0px)', left: this.state.value + '%' } }, props), icons[icon])) }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                            position: 'absolute',
                            zIndex: 1,
                            top: 'calc(50% - 8px)',
                            left: '12px',
                            color: (this.isLightMode ? '#424242' : '#eeeeee'),
                            fontSize: '11px',
                            opacity: this.state.value < 0.37 ? 0 : 1,
                            transition: 'opacity 250ms ease 0s',
                            fontStyle: 'italic',
                            height: '0px', overflow: 'visible', pointerEvents: 'none' // Pass click events to the slider behind
                        } }, 'Cheaper'),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                            position: 'absolute',
                            zIndex: 1,
                            top: 'calc(50% - 8px)',
                            right: '12px',
                            color: (this.isLightMode ? '#424242' : '#eeeeee'),
                            fontSize: '11px',
                            opacity: this.state.value > 0.7 ? 0 : 1,
                            transition: 'opacity 250ms ease 0s',
                            fontStyle: 'italic',
                            height: '0px', overflow: 'visible', pointerEvents: 'none' // Pass click events to the slider behind    
                        } }, 'Faster'))));
        };
        this.handleMetadataChange = () => this.safeSetState({ value: this.props.getValue(), weGotADot: '' });
        this.handleThemeChange = () => {
            this.StyledSlider = this.getStyledSlider();
            if (this._isMounted)
                this.forceUpdate();
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.themeManager.themeChanged.connect(this.handleThemeChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.themeManager.themeChanged.disconnect(this.handleThemeChange);
            this._isMounted = false;
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.StyledSlider = this.getStyledSlider();
        this.state = {
            value: this.props.getValue(),
        };
    }
}


/***/ }),

/***/ "./lib/core/Label.js":
/*!***************************!*\
  !*** ./lib/core/Label.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Label": () => (/* binding */ Label)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/


class Label extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({ display: 'inline-flex', width: '100%', padding: '3px 0px' }, this.props.style) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                        minWidth: this.props.labelWidth || '68px',
                        maxWidth: this.props.labelWidth || '68px',
                        height: '24px',
                        margin: '0px 12px',
                        lineHeight: '24px',
                        textAlign: this.props.align || 'center',
                    } }, this.props.label),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                        width: '100%',
                        height: '24px',
                        margin: '0px 6px',
                        lineHeight: '24px',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { padding: '0px 6px', fontSize: '12px' } }, this.props.styledUnitValue(this.props.getValue())))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}
Label.defaultProps = {
    styledUnitValue: (value) => { return value.toString(); },
};


/***/ }),

/***/ "./lib/core/NotificationContent.js":
/*!*****************************************!*\
  !*** ./lib/core/NotificationContent.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "NotificationContent": () => (/* binding */ NotificationContent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! . */ "./lib/core/Switch.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! . */ "./lib/core/Dropdown.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/icons */ "webpack/sharing/consume/default/@material-ui/icons/@material-ui/icons");
/* harmony import */ var _material_ui_icons__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_material_ui_icons__WEBPACK_IMPORTED_MODULE_2__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





const LABEL_WIDTH = '80px';
const VALUES = [{ value: 'succeeds or fails', description: '' }, { value: 'fails', description: '' }];
class NotificationContent extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleJobStartedSMSChange = (value) => {
            const config = this.props.getValue().copy();
            config.notifications.jobStartedSMSEnabled = value;
            this.props.saveValue(config);
        };
        this.handleChange = (value, enabled) => {
            const config = this.props.getValue().copy();
            config.notifications.jobCompletedSMSEnabled = value == VALUES[0].value && enabled;
            config.notifications.jobFailedSMSEnabled = enabled;
            this.props.saveValue(config);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const disabled = !_Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.notificationsEnabled || _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.phoneNumber == null || _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.phoneNumber == "";
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(___WEBPACK_IMPORTED_MODULE_4__.Switch, { getValue: () => (disabled && !this.props.disabled) ? false : this.props.getValue().notifications.jobStartedSMSEnabled, saveValue: this.handleJobStartedSMSChange, label: 'Send a text when my job starts', labelWidth: LABEL_WIDTH, disabled: disabled || this.props.disabled || this.props.disabled }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'inline-flex' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(___WEBPACK_IMPORTED_MODULE_4__.Switch, { getValue: () => (disabled && !this.props.disabled) ? false : this.props.getValue().notifications.jobFailedSMSEnabled, saveValue: (enabled) => this.handleChange(this.state.value, enabled), label: 'Send a text when my job ', labelWidth: LABEL_WIDTH, disabled: disabled || this.props.disabled }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(___WEBPACK_IMPORTED_MODULE_5__.Dropdown, { getValue: () => this.state.value, saveValue: (value) => {
                            this.safeSetState({ value: value });
                            this.handleChange(value, this.props.getValue().notifications.jobFailedSMSEnabled);
                        }, values: VALUES, disabled: disabled || this.props.disabled, 
                        // Wipe out the width being set internally in Dropdown
                        style: { width: '', marginLeft: '-6px' } })),
                (disabled && !this.props.disabled) && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'inline-flex', width: '100%', margin: '12px 36px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { margin: 'auto 0px', fontStyle: 'italic' } }, "Notifications can be enabled in settings"),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.IconButton, { onClick: () => {
                            if (this.props.openUserDialogTo)
                                this.props.openUserDialogTo(0 /* GENERAL */);
                            if (this.props.handleClose)
                                this.props.handleClose();
                        }, style: {
                            display: 'inline-block',
                            width: '36px',
                            height: '36px',
                            padding: '3px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons__WEBPACK_IMPORTED_MODULE_2__.OpenInNew, { style: { height: '20px', width: '20px' } }))))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            value: this.props.getValue().notifications.jobCompletedSMSEnabled ? VALUES[0].value : VALUES[1].value,
        };
    }
}


/***/ }),

/***/ "./lib/core/PhoneTextBox.js":
/*!**********************************!*\
  !*** ./lib/core/PhoneTextBox.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PhoneTextBox": () => (/* binding */ PhoneTextBox)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var react_phone_input_2__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-phone-input-2 */ "webpack/sharing/consume/default/react-phone-input-2/react-phone-input-2");
/* harmony import */ var react_phone_input_2__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_phone_input_2__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_phone_input_2_lib_style_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-phone-input-2/lib/style.css */ "./node_modules/react-phone-input-2/lib/style.css");
/* harmony import */ var google_libphonenumber__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! google-libphonenumber */ "webpack/sharing/consume/default/google-libphonenumber/google-libphonenumber");
/* harmony import */ var google_libphonenumber__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(google_libphonenumber__WEBPACK_IMPORTED_MODULE_3__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




// import ExtraInfo from '../utils/ExtraInfo';

class PhoneTextBox extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        // This turns the textbox red if it is not a valid value determined by the unstyle function
        this.handleChange = async (value, data, event, formattedValue) => {
            this.safeSetState({ value: value, invalidTextMessage: '' });
        };
        // Saves value if it is a valid value
        this.saveChanges = () => {
            var value = this.state.value;
            var invalid = false;
            if (value == "" || value == "1") {
                this.props.saveValue("");
            }
            else {
                try {
                    const phoneUtil = google_libphonenumber__WEBPACK_IMPORTED_MODULE_3___default().PhoneNumberUtil.getInstance();
                    if (phoneUtil.isValidNumber(phoneUtil.parse(value, 'US'))) {
                        this.safeSetState({ editing: false, value: value });
                        this.props.saveValue(value);
                    }
                    else {
                        invalid = true;
                    }
                }
                catch (err) {
                    invalid = true;
                }
            }
            if (invalid) {
                this.safeSetState({ invalidTextMessage: 'Invalid phone number' });
            }
            if (this.props.validOnBlur) {
                this.props.validOnBlur(!invalid);
            }
        };
        this.handleFocus = (event) => {
            if (this.props.onFocus) {
                this.props.onFocus(event);
            }
        };
        this.handleBlur = (event) => {
            if (this.props.onBlur) {
                this.props.onBlur(event);
            }
            if (this.state.value == '')
                this.setState({ value: '1' });
            this.saveChanges();
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({ display: 'inline-flex', width: '100%', padding: '6px 0px' }, this.props.style) },
                this.props.label && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                        display: 'flex',
                        position: 'relative',
                        minWidth: this.props.labelWidth || '68px',
                        maxWidth: this.props.labelWidth || '68px',
                        height: '24px',
                        margin: '0px 12px',
                        lineHeight: '24px',
                        textAlign: 'center',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { style: { display: 'inline', width: '100%', color: !(this.props.disabledMessage == undefined || this.props.disabledMessage == '') ? 'var(--jp-ui-font-color3)' : 'var(--jp-ui-font-color1)' } }, this.props.label))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement((react_phone_input_2__WEBPACK_IMPORTED_MODULE_1___default()), { value: '+' + this.state.value, country: 'us', onChange: this.handleChange, preferredCountries: ['us'], containerStyle: { margin: 'auto 0px auto 6px' }, inputStyle: { height: '20.25px', width: '100%' }, onFocus: this.handleFocus, onBlur: this.handleBlur, buttonStyle: { height: '20.25px' }, isValid: this.state.invalidTextMessage == '' })));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        const value = this.props.getValue();
        this.state = {
            value: value == '' ? '1' : value,
            invalidTextMessage: '',
            editing: false,
            hovered: false,
            hidePassword: true,
        };
    }
}


/***/ }),

/***/ "./lib/core/ShadowedDivider.js":
/*!*************************************!*\
  !*** ./lib/core/ShadowedDivider.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ShadowedDivider": () => (/* binding */ ShadowedDivider)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class ShadowedDivider extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.isLightMode = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager == undefined || _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.isLight(_Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.theme);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const darkColor = this.isLightMode ? '#bbbbbb' : 'rgba(255, 255, 255, 0.18)';
            const lightColor = this.isLightMode ? (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.lighten)(darkColor, 2 / 3) : 'rgba(255, 255, 255, 0.12)';
            return this.props.orientation === undefined || this.props.orientation === 'horizontal' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Divider, { variant: 'fullWidth', style: { backgroundColor: darkColor } }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Divider, { variant: 'fullWidth', style: { backgroundColor: lightColor } }))) : this.props.orientation === 'vertical' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'flex', height: '100%' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Divider, { orientation: 'vertical', variant: 'fullWidth', style: { backgroundColor: darkColor } }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Divider, { orientation: 'vertical', variant: 'fullWidth', style: { backgroundColor: lightColor } })));
        };
        this.handleThemeChange = () => { this.isLightMode = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager == undefined || _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.isLight(_Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.theme); this.forceUpdate(); };
        this.componentDidMount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.themeChanged.connect(this.handleThemeChange);
        };
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.themeChanged.disconnect(this.handleThemeChange);
        };
    }
}


/***/ }),

/***/ "./lib/core/Slider.js":
/*!****************************!*\
  !*** ./lib/core/Slider.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Slider": () => (/* binding */ Slider)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



const enableThumbText = false;
const alwaysShowValue = false;
var retrievingPreview = false;
var updatePreviewAgain = false;
var latestValue;
class Slider extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.getStyledSlider = () => {
            const isLightMode = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager == undefined || _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.isLight(_Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.theme);
            return (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.withStyles)({
                root: {
                    height: '12px',
                    width: '100%',
                    margin: '0px 6px',
                    padding: '6px 0px',
                    overflow: 'hidden',
                },
                thumb: {
                    height: '12px',
                    width: '200%',
                    transform: 'translate(-50%, calc(25% + 2px))',
                    backgroundColor: 'transparent',
                    padding: '0px',
                    '&:focus, &:hover, &:active': {
                        boxShadow: 'none',
                    },
                    '&::after': {
                        left: -6,
                        top: -6,
                        right: -6,
                        bottom: -6,
                    },
                },
                track: {
                    height: '12px',
                    color: this.props.color,
                    boxSizing: 'border-box',
                    border: "1px solid " + (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.darken)(this.props.color, 0.25),
                    borderRadius: '4px',
                },
                rail: {
                    height: '12px',
                    width: '100%',
                    opacity: 1,
                    color: (isLightMode ? '#eeeeee' : '#424242'),
                    boxSizing: 'border-box',
                    border: '1px solid ' + (isLightMode ? (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.darken)('#eeeeee', 0.25) : (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.lighten)('#424242', 0.25)),
                    borderRadius: '4px',
                },
                mark: {
                    marginLeft: 0,
                    height: 4,
                    width: 1,
                    backgroundColor: 'currentColor',
                    opacity: 0,
                },
                markActive: {
                    marginLeft: -1,
                    height: 4,
                    width: 2,
                    backgroundColor: 'currentColor',
                    opacity: 0,
                },
            })(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Slider);
        };
        this.getStyledValueLabel = () => {
            return (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.withStyles)({
                root: {
                    padding: '0px 3px',
                    position: 'absolute',
                    color: '#ffffff',
                    whiteSpace: 'nowrap',
                    fontWeight: 'bold',
                    backgroundColor: this.props.color,
                    border: "1px solid " + (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.darken)(this.props.color, 0.25),
                },
            })(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Paper);
        };
        this.getStyledOutlinedInput = () => {
            return (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.withStyles)({
                input: {
                    fontSize: '12px',
                    padding: '6px 0px 3px 6px',
                },
                adornedEnd: {
                    paddingRight: '6px',
                },
            })(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.OutlinedInput);
        };
        this.getStyledInputLabel = () => {
            return (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.withStyles)({
                root: {
                    fontSize: '12px',
                },
                outlined: {
                    transform: 'translate(6px, 6px) scale(1)',
                    '&$shrink': {
                        transform: 'translate(10px, -4.5px) scale(0.8)',
                    }
                },
                formControl: {
                    transform: 'translate(6px, 6px) scale(1)',
                },
                shrink: {
                    transform: 'translate(10px, -4.5px) scale(0.8)',
                },
            })(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.InputLabel);
        };
        this.ValueLabelComponent = (props) => {
            var value = this.props.scale != undefined ? this.props.scale(props.value) : props.value;
            var fromLeft = 100 * props.value / this.max;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledValueLabel, { style: {
                        display: props.open && this.props.showUnit ? 'inline-block' : 'none',
                        left: fromLeft + '%',
                        transform: 'translate(-' + fromLeft + '%, -25%)',
                    } }, value),
                props.children));
        };
        this.handleTextBoxChange = async (event) => {
            var value = event.target.value;
            var unit = this.props.styledUnit(this.state.value);
            /// Do special character checks upfront before length checks
            if (value.length == 5 && value.startsWith('unsp')) {
                // If the value is unsp and the user types a number, change it to the number
                value = value.replace('unsp', '');
            }
            else if (value.includes('u')) {
                // Handle character change to unspecified
                this.safeSetState({ value: this.min, weGotADot: '' });
                this.slowDownSaveValue(this.min);
                return; // We are done here, do not go on
            }
            else if (value != '' && value.search(/[a-z]/i) != -1) {
                for (let c of value) {
                    if (c.match(/[a-z]/i)) {
                        unit = c;
                        value = value.replace(c, '');
                        break;
                    }
                }
            }
            if (value.endsWith('.') || value.endsWith('.0') /* || value.endsWith('.00')*/) {
                this.safeSetState({ weGotADot: value });
                return; // We do not want to save this value
            }
            this.parseTextAndSetValue(value, unit);
        };
        this.handleChange = async (event, newValue) => {
            if (newValue instanceof Array) {
                // This is invalid
            }
            else {
                var cappedValue = Math.min(Math.max(this.min, newValue), this.max);
                this.safeSetState({ value: cappedValue, weGotADot: '' });
                this.slowDownSaveValue(cappedValue);
            }
        };
        this.handleChangeCommitted = async (event, newValue) => {
            if (newValue instanceof Array) {
                // This is invalid
            }
            else {
                var cappedValue = Math.min(Math.max(this.min, newValue), this.max);
                this.safeSetState({ value: cappedValue, weGotADot: '' });
                this.props.saveValue(cappedValue);
            }
        };
        this.delay = (ms) => { return new Promise(resolve => setTimeout(resolve, ms)); };
        this.slowDownSaveValue = (newValue, bypassLimiter) => {
            if (newValue != null)
                latestValue = newValue;
            if (bypassLimiter || !retrievingPreview) {
                retrievingPreview = true;
                this.delay(100).then(() => {
                    this.props.saveValue(latestValue);
                    if (updatePreviewAgain) {
                        updatePreviewAgain = false;
                        this.slowDownSaveValue(null, true);
                    }
                    else {
                        retrievingPreview = false;
                    }
                }, () => {
                    retrievingPreview = false;
                });
            }
            else {
                updatePreviewAgain = true;
            }
        };
        this.startTyping = () => {
            this.safeSetState({ typing: true });
        };
        this.stopTyping = () => {
            if (this.state.weGotADot != '') {
                // Save the value with a dot, since the user is no longer typing
                this.parseTextAndSetValue(this.state.weGotADot, this.props.styledUnit(this.state.value));
            }
            this.safeSetState({ typing: false });
        };
        this.startHover = () => {
            this.safeSetState({ hovered: true });
        };
        this.stopHover = () => {
            this.safeSetState({ hovered: false });
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            var showValue = alwaysShowValue || this.state.hovered || this.state.typing || this.props.alwaysDisplayUnit;
            return this.max == 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null)) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({ display: 'inline-flex', width: '100%' }, this.props.style), onMouseOver: this.startHover, onMouseOut: this.stopHover },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledSlider, { style: { position: 'relative' }, onChange: this.handleChange, onChangeCommitted: this.handleChangeCommitted, min: 0, max: this.max, value: this.state.value, ValueLabelComponent: enableThumbText && (this.props.alwaysDisplayUnit || this.state.hovered) ? this.ValueLabelComponent : undefined, valueLabelDisplay: enableThumbText && (this.props.alwaysDisplayUnit || this.state.hovered) ? 'on' : 'off', marks: this.props.marks, step: this.props.step }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.FormControl, { variant: 'outlined', style: { maxWidth: this.props.labelWidth || '68px', minWidth: this.props.labelWidth || '68px', margin: '0px 6px', display: showValue ? 'block' : 'none' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledInputLabel, null, this.props.label),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledOutlinedInput, { inputRef: this.textField, value: this.state.weGotADot != '' ? this.state.weGotADot : this.formatTextForSmallBox(this.props.styledValue(this.props.scale(this.state.value))), labelWidth: _Global__WEBPACK_IMPORTED_MODULE_2__.Global.getStringWidth(this.props.label, '12px Roboto, Helvetica, Arial, sans-serif') - 8, onChange: this.handleTextBoxChange, onFocus: this.startTyping, onBlur: this.stopTyping, onKeyDown: (event) => { if (event.key == 'Enter' || event.key == 'Escape')
                            this.textField.current.blur(); }, endAdornment: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.InputAdornment, { position: "end", disableTypography: true, style: { fontSize: '12px', margin: '0px', height: '12px', paddingTop: '3px' } }, this.props.styledUnit(this.state.value)) })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                        minWidth: this.props.labelWidth || '68px',
                        lineHeight: '24px',
                        textAlign: 'center',
                        margin: '0px 6px',
                        display: !showValue ? 'block' : 'none'
                    } }, this.props.label)));
        };
        this.handleMetadataChange = () => this.safeSetState({ value: this.props.getValue(), weGotADot: '' });
        this.handleThemeChange = () => {
            this.StyledSlider = this.getStyledSlider();
            this.StyledValueLabel = this.getStyledValueLabel();
            this.StyledOutlinedInput = this.getStyledOutlinedInput();
            this.StyledInputLabel = this.getStyledInputLabel();
            if (this._isMounted)
                this.forceUpdate();
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.themeChanged.connect(this.handleThemeChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.themeChanged.disconnect(this.handleThemeChange);
            this._isMounted = false;
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.textField = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
        this.StyledSlider = this.getStyledSlider();
        this.StyledValueLabel = this.getStyledValueLabel();
        this.StyledOutlinedInput = this.getStyledOutlinedInput();
        this.StyledInputLabel = this.getStyledInputLabel();
        this.state = {
            value: this.props.getValue(),
            typing: false,
            hovered: false,
            weGotADot: '',
        };
        this.min = this.props.marks ? this.props.marks[0].value : this.props.minValue;
        this.max = this.props.marks ? this.props.marks[this.props.marks.length - 1].value : this.props.maxValue;
    }
    formatTextForSmallBox(value) {
        var ret = value;
        // Turn 1234 into 123, turn 1.234 into 1.23
        if (ret != 'unsp' && ret.length > length)
            ret = ret.substr(0, value.includes('.') ? 4 : 3);
        // turn 1.00 into 1. 1.50 into 1.5, 15.0 into 15.
        while (ret.includes('.') && ret.endsWith('0'))
            ret = ret.substr(0, ret.length - 1);
        // Turn 1. into 1
        if (ret.endsWith('.'))
            ret = ret.substr(0, ret.length - 1);
        return ret;
    }
    parseTextAndSetValue(value, unit) {
        if (!isNaN(+value)) {
            // Only allow the user to specify up to 2 decimal points
            if (value.includes('.') && value.split('.')[1].length > 2) {
                return;
            }
            var unscaledValue = this.props.unscale(this.props.unstyledValue ? this.props.unstyledValue(+value, unit) : +value);
            if (unscaledValue < this.min) {
                this.safeSetState({ value: this.min, weGotADot: '' });
                this.slowDownSaveValue(this.min);
            }
            else if (unscaledValue > this.max) {
                this.safeSetState({ value: this.max, weGotADot: '' });
                this.slowDownSaveValue(this.max);
            }
            else {
                this.safeSetState({ value: unscaledValue, weGotADot: '' });
                this.slowDownSaveValue(unscaledValue);
            }
        }
    }
}
Slider.defaultProps = {
    styledUnit: (value) => { return ''; },
    styledValue: (value) => { return value == -1 ? 'unsp' : value.toFixed(); },
    scale: (value) => { return value; },
    unscale: (value) => { return value; },
};


/***/ }),

/***/ "./lib/core/Switch.js":
/*!****************************!*\
  !*** ./lib/core/Switch.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getStyledSwitch": () => (/* binding */ getStyledSwitch),
/* harmony export */   "Switch": () => (/* binding */ Switch)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




const getStyledSwitch = () => {
    return (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.withStyles)({
        root: {
            width: '42px',
            height: '24px',
            padding: '0px',
        },
        thumb: {
            width: '20px',
            height: '20px',
            padding: '0px',
            margin: '2px',
        },
        switchBase: {
            padding: '0px',
        },
        track: {
            height: '12px',
            width: '34px',
            borderRadius: '6px',
            padding: '0px',
            margin: '6px',
        },
    })(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Switch);
};
class Switch extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({
                    display: 'inline-flex',
                    width: '100%',
                    padding: '6px 0px',
                    direction: this.props.flip ? 'rtl' : 'ltr'
                }, this.props.style), ref: this.props.ref, onMouseOver: this.props.onMouseOver, onMouseOut: this.props.onMouseOut },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_3__.default, { reminder: this.props.tooltip || '' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                            minWidth: this.props.labelWidth || '68px',
                            lineHeight: '24px',
                            textAlign: 'center',
                            margin: '0px 12px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledSwitch, { color: 'primary', inputProps: { style: { height: '24px' } }, checked: this.state.value, onChange: (event) => {
                                this.safeSetState({ value: event.currentTarget.checked });
                                this.props.saveValue(event.currentTarget.checked);
                            }, disabled: this.props.disabled }))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { width: '100%', textAlign: this.props.flip ? 'right' : 'left', margin: 'auto 6px' } }, this.props.label)));
        };
        this.handleMetadataChange = () => { this.safeSetState({ value: this.props.getValue() }); };
        this.handleThemeChange = () => {
            this.StyledSwitch = getStyledSwitch();
            this.forceUpdate();
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.themeChanged.connect(this.handleThemeChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.themeChanged.disconnect(this.handleThemeChange);
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.StyledSwitch = getStyledSwitch();
        this.state = { value: this.props.getValue() };
    }
}


/***/ }),

/***/ "./lib/core/TextBox.js":
/*!*****************************!*\
  !*** ./lib/core/TextBox.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TextBox": () => (/* binding */ TextBox)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core_styles_withStyles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/core/styles/withStyles */ "./node_modules/@material-ui/core/styles/withStyles.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _material_ui_icons_Close__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material-ui/icons/Close */ "./node_modules/@material-ui/icons/Close.js");
/* harmony import */ var _material_ui_icons_Done__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material-ui/icons/Done */ "./node_modules/@material-ui/icons/Done.js");
/* harmony import */ var _material_ui_icons_Visibility__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @material-ui/icons/Visibility */ "./node_modules/@material-ui/icons/Visibility.js");
/* harmony import */ var _material_ui_icons_VisibilityOff__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @material-ui/icons/VisibilityOff */ "./node_modules/@material-ui/icons/VisibilityOff.js");
/* harmony import */ var _material_ui_icons_Lock__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @material-ui/icons/Lock */ "./node_modules/@material-ui/icons/Lock.js");
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/










class TextBox extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.getStyledOutlinedInput = () => {
            return (0,_material_ui_core_styles_withStyles__WEBPACK_IMPORTED_MODULE_2__.default)({
                root: {
                    padding: '0px',
                },
                input: {
                    fontSize: '12px',
                    padding: '3px 6px 3px 6px',
                },
                adornedEnd: {
                    paddingRight: '0px',
                },
            })(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.OutlinedInput);
        };
        this.getStyledInputLabel = () => {
            return (0,_material_ui_core_styles_withStyles__WEBPACK_IMPORTED_MODULE_2__.default)({
                root: {
                    fontSize: '12px',
                    backgroundColor: 'var(--jp-layout-color1)',
                    padding: '1px 2px',
                },
                outlined: {
                    transform: 'translate(6px, 6px) scale(1)',
                    '&$shrink': {
                        transform: 'translate(9px, -6px) scale(0.8)',
                    }
                },
                formControl: {
                    transform: 'translate(6px, 6px) scale(1)',
                },
                shrink: {
                    transform: 'translate(9px, -6px) scale(0.8)',
                },
            })(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.InputLabel);
        };
        // This turns the textbox red if it is not a valid value determined by the unstyle function
        this.handleChange = async (event) => {
            const value = event.currentTarget.value;
            this.safeSetState({ textValue: value });
            if (this.props.unstyleUnitValue == undefined) {
                if (typeof value === 'number') {
                    if (this.props.minValue !== undefined && value < this.props.minValue) {
                        this.safeSetState({ invalidTextMessage: 'Minimum value is ' + this.props.styledUnitValue(this.props.minValue) });
                    }
                    else if (this.props.maxValue !== undefined && value > this.props.maxValue) {
                        this.safeSetState({ invalidTextMessage: 'Maximum value is ' + this.props.styledUnitValue(this.props.maxValue) });
                    }
                    else {
                        if (!this.props.editPressRequired)
                            this.safeSetState({ value: value, invalidTextMessage: '' });
                    }
                }
                else {
                    if (!this.props.editPressRequired)
                        this.safeSetState({ value: value, invalidTextMessage: '' });
                }
            }
            else {
                var unstyledValue = this.props.unstyleUnitValue(value);
                if (!isNaN(unstyledValue)) {
                    if (this.props.minValue !== undefined && unstyledValue < this.props.minValue) {
                        this.safeSetState({ invalidTextMessage: 'Minimum value is ' + this.props.styledUnitValue(this.props.minValue) });
                    }
                    else if (this.props.maxValue !== undefined && unstyledValue > this.props.maxValue) {
                        this.safeSetState({ invalidTextMessage: 'Maximum value is ' + this.props.styledUnitValue(this.props.maxValue) });
                    }
                    else {
                        if (!this.props.editPressRequired)
                            this.safeSetState({ value: unstyledValue, invalidTextMessage: '' });
                    }
                }
                else {
                    this.safeSetState({ invalidTextMessage: 'Invalid format' });
                }
            }
        };
        this.startEdit = () => {
            this.safeSetState({ editing: true });
            this.textField.current.disabled = false;
            this.textField.current.focus();
        };
        this.discardChanges = () => {
            this.safeSetState({
                editing: false,
                textValue: this.props.styledUnitValue(this.state.value),
                invalidTextMessage: '',
            });
        };
        // If save clicked, or if unfocused if save not required. Saves value if it is a valid value determined by the unstyle function or lack thereof
        this.saveChanges = () => {
            var invalidTextMessage = '';
            var unstyledValue = this.state.textValue;
            if (this.props.unstyleUnitValue != undefined) {
                unstyledValue = this.props.unstyleUnitValue(this.state.textValue);
                if (isNaN(unstyledValue)) {
                    invalidTextMessage = 'Invalid format';
                }
                else if (this.props.minValue !== undefined && unstyledValue < this.props.minValue) {
                    invalidTextMessage = 'Minimum value is ' + this.props.styledUnitValue(this.props.minValue);
                }
                else if (this.props.maxValue !== undefined && unstyledValue > this.props.maxValue) {
                    invalidTextMessage = 'Maximum value is ' + this.props.styledUnitValue(this.props.maxValue);
                }
            }
            this.safeSetState({ invalidTextMessage: invalidTextMessage });
            if (invalidTextMessage == '') {
                this.safeSetState({ editing: false, value: unstyledValue, textValue: this.props.styledUnitValue(unstyledValue) });
                var saveReturn = this.props.saveValue(unstyledValue);
                this.safeSetState({ invalidTextMessage: saveReturn == undefined ? '' : saveReturn });
            }
        };
        this.startHover = () => {
            this.safeSetState({ hovered: true });
        };
        this.stopHover = () => {
            this.safeSetState({ hovered: false });
        };
        this.renderPopupButton = (render) => {
            return this.props.editPopup !== undefined ? react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(this.props.editPopup, {
                style: {
                    display: render ? 'flex' : 'none',
                },
                onOpen: () => {
                    this.safeSetState({ editing: true });
                },
                onClose: () => {
                    this.safeSetState({ hovered: false, editing: false });
                }
            }) : react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null);
        };
        this.renderEditButton = (render) => {
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Button, { onClick: this.startEdit, style: {
                    display: render ? 'flex' : 'none',
                    width: '100%',
                    minWidth: '0px',
                    paddingTop: '6px',
                }, variant: "outlined" }, "Edit"));
        };
        this.renderConfirmCancelButtons = (render) => {
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Button, { onClick: this.discardChanges, variant: "outlined", color: "primary", style: {
                        display: render ? 'flex' : 'none',
                        width: '50%',
                        minWidth: '0px',
                        paddingTop: '6px',
                        borderTopRightRadius: '0px',
                        borderBottomRightRadius: '0px',
                        borderRight: '0px',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_Close__WEBPACK_IMPORTED_MODULE_3__.default, { style: { width: '20px', height: '20px' } })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Button, { onClick: this.saveChanges, variant: "outlined", color: "primary", style: {
                        display: render ? 'flex' : 'none',
                        width: '50%',
                        minWidth: '0px',
                        paddingTop: '6px',
                        borderTopLeftRadius: '0px',
                        borderBottomLeftRadius: '0px',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_Done__WEBPACK_IMPORTED_MODULE_4__.default, { style: { width: '20px', height: '20px' } }))));
        };
        this.renderLabelOverButton = (render) => {
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledInputLabel, { shrink: true, style: { display: render ? 'flex' : 'none', position: 'absolute' } }, this.props.label));
        };
        this.renderLabel = (render) => {
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { style: { display: render ? 'inline' : 'none', width: '100%', color: !(this.props.disabledMessage == undefined || this.props.disabledMessage == '') ? 'var(--jp-ui-font-color3)' : 'var(--jp-ui-font-color1)' } }, this.props.label + (this.props.required ? '*' : '')));
        };
        this.handleFocus = (event) => {
            if (this.props.onFocus) {
                this.props.onFocus(event);
            }
        };
        this.handleBlur = (event) => {
            if (this.props.onBlur) {
                this.props.onBlur(event);
            }
            if (!(this.props.editPressRequired || this.props.editPopup !== undefined)) {
                this.saveChanges();
            }
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            var showPopupButton = false, showEditButton = false, showConfirmCancelButtons = false, showLabel = false;
            // There should never be an if without an else. That could lead to nothing being rendered to the left of the textbox
            if (this.props.editPopup === undefined && !this.props.editPressRequired) {
                showLabel = true;
            }
            else if (!this.state.hovered && !this.state.editing) {
                showLabel = true;
            }
            else {
                if (this.props.editPopup !== undefined) {
                    showPopupButton = true;
                }
                else {
                    if (this.state.editing) {
                        showConfirmCancelButtons = true;
                    }
                    else {
                        showEditButton = true;
                    }
                }
            }
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({ display: 'inline-flex', width: '100%', padding: '6px 0px' }, this.props.style), onMouseOver: this.startHover, onMouseOut: this.stopHover },
                this.props.label && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                        display: 'flex',
                        position: 'relative',
                        minWidth: this.props.labelWidth || '68px',
                        maxWidth: this.props.labelWidth || '68px',
                        height: '24px',
                        margin: '0px 12px',
                        lineHeight: '24px',
                        textAlign: 'center',
                    } },
                    this.renderLabel(showLabel),
                    this.renderPopupButton(showPopupButton),
                    this.renderEditButton(showEditButton),
                    this.renderConfirmCancelButtons(showConfirmCancelButtons),
                    this.renderLabelOverButton(!showLabel))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_6__.default, { reminder: this.state.invalidTextMessage },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.FormControl, { error: this.state.invalidTextMessage != '', variant: 'outlined', style: { width: '100%', margin: '2px 6px', height: this.props.multiline ? '' : (this.props.helperText ? '32px' : '20px') } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledOutlinedInput, { inputRef: this.textField, value: this.state.textValue, placeholder: this.props.placeholder, disabled: this.props.disabled ||
                                (!(this.props.disabledMessage == undefined || this.props.disabledMessage == '') ||
                                    (this.props.editPressRequired && !this.state.editing) ||
                                    this.props.editPopup !== undefined), onChange: this.handleChange, onKeyDown: (event) => { if ((!this.props.multiline && event.key == 'Enter') || event.key == 'Escape')
                                this.textField.current.blur(); }, onFocus: this.handleFocus, onBlur: this.handleBlur, type: this.props.password && this.state.hidePassword ? 'password' : 'text', multiline: this.props.multiline, required: this.props.required, rows: (() => {
                                const lines = this.state.textValue.split('\n').length;
                                if (this.props.minLines && lines < this.props.minLines)
                                    return this.props.minLines;
                                return lines;
                            })(), endAdornment: (this.props.disabled || !(this.props.disabledMessage == undefined || this.props.disabledMessage == '')) ? (
                            // <ExtraInfo reminder={this.props.disabledMessage}>
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.InputAdornment, { position: "end", style: { height: '20px', margin: '0px 3px 0px 0px' } },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.IconButton, { disabled: true, style: { padding: '3px 3px 3px 0px' } },
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_Lock__WEBPACK_IMPORTED_MODULE_7__.default, { style: { width: '14px', height: '14px' } })))
                            // </ExtraInfo>
                            ) : this.props.password && (
                            // <ExtraInfo reminder={this.state.hidePassword ? 'Show Password' : 'Hide Password'}>
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.InputAdornment, { position: "end", style: { height: '20px', margin: '0px 3px 0px 0px' } },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.IconButton, { onClick: () => this.safeSetState({ hidePassword: !this.state.hidePassword }), style: { padding: '3px 3px 3px 0px' } }, this.state.hidePassword ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_VisibilityOff__WEBPACK_IMPORTED_MODULE_8__.default, { style: { width: '14px', height: '14px' } })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_Visibility__WEBPACK_IMPORTED_MODULE_9__.default, { style: { width: '14px', height: '14px' } }))))
                            // </ExtraInfo>
                            ) }),
                        this.props.helperText &&
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.FormHelperText, { style: { fontSize: '10px', lineHeight: '10px', margin: '4px 6px', whiteSpace: 'nowrap', display: 'inline-flex' } },
                                this.props.helperText,
                                this.props.helperLink && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("a", { href: this.props.helperLink.link, target: "_blank", style: { flexGrow: 1, textAlign: 'end', fontStyle: 'italic' } }, this.props.helperLink.text)))))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.StyledOutlinedInput = this.getStyledOutlinedInput();
        this.StyledInputLabel = this.getStyledInputLabel();
        this.textField = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
        const value = this.props.getValue();
        this.state = {
            value: value,
            textValue: this.props.styledUnitValue(value),
            editing: false,
            hovered: false,
            invalidTextMessage: '',
            hidePassword: true,
        };
    }
}
TextBox.defaultProps = {
    styledUnitValue: (value) => { return value.toString(); },
};


/***/ }),

/***/ "./lib/core/TextBoxDropdown.js":
/*!*************************************!*\
  !*** ./lib/core/TextBoxDropdown.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TextBoxDropdown": () => (/* binding */ TextBoxDropdown)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core_styles_withStyles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/core/styles/withStyles */ "./node_modules/@material-ui/core/styles/withStyles.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





const StyledMenuItem = (0,_material_ui_core_styles_withStyles__WEBPACK_IMPORTED_MODULE_2__.default)({
    root: {
        fontSize: 'var(--jp-ui-font-size1)',
        padding: '3px 3px 3px 6px',
        justifyContent: 'center',
    }
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.MenuItem);
const StyledOutlinedInput = (0,_material_ui_core_styles_withStyles__WEBPACK_IMPORTED_MODULE_2__.default)({
    input: {
        fontSize: '12px',
        padding: '3px 6px 3px 6px',
    },
    adornedEnd: {
        paddingRight: '0px',
    },
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.OutlinedInput);
class TextBoxDropdown extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.getStyledSelect = () => {
            return (0,_material_ui_core_styles_withStyles__WEBPACK_IMPORTED_MODULE_2__.default)({
                root: {
                    fontSize: "var(--jp-ui-font-size1)",
                    width: '68px',
                },
                iconOutlined: {
                    right: '0px'
                }
            })(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.Select);
        };
        this.handleValueChange = (event) => {
            try {
                let unit = this.state.unit;
                const charTyped = event.currentTarget.value.replace(/[0-9\.]/g, '');
                if (charTyped.length > 0) {
                    for (let unitValue of this.props.unitValues) {
                        if (unitValue.unit.charAt(0) === charTyped[0]) {
                            unit = unitValue.unit;
                            break;
                        }
                    }
                }
                let value = event.currentTarget.value === '' ? 0 : Number.parseFloat(event.currentTarget.value.replace(/[^0-9\.]/g, ''));
                const denormalizedValue = this.denormalize(unit, value);
                let errorMessage = '';
                if (this.props.minValue && denormalizedValue < this.props.minValue) {
                    const [minUnit, minValue] = this.normalize(this.props.minValue);
                    errorMessage = `Minimum value is ${minValue}${minUnit}`;
                }
                else if (this.props.maxValue && denormalizedValue > this.props.maxValue) {
                    const [maxUnit, maxValue] = this.normalize(this.props.maxValue);
                    errorMessage = `Maximum value is ${maxValue}${maxUnit}`;
                }
                this.safeSetState({ unit: unit, value: value === NaN ? this.state.value : value, errorMessage: errorMessage });
            }
            catch (error) {
                // If Number.parseFloat fails, we don't want to update the values
            }
        };
        this.handleValueFocus = (event) => {
            if (this.props.onFocus) {
                this.props.onFocus(event);
            }
        };
        this.handleValueBlur = (event) => {
            if (this.props.onBlur) {
                this.props.onBlur(event);
            }
            const [normalizedUnit, normalizedValue] = this.normalize(this.denormalize(this.state.unit, this.state.value));
            this.safeSetState({ unit: normalizedUnit, value: normalizedValue });
            this.saveChanges();
        };
        this.handleUnitChange = (event) => {
            const unit = event.target.value;
            const value = this.state.value;
            const denormalizedValue = this.denormalize(unit, value);
            let errorMessage = '';
            if (this.props.minValue && denormalizedValue < this.props.minValue) {
                const [minUnit, minValue] = this.normalize(this.props.minValue);
                errorMessage = `Minimum value is ${minValue}${minUnit}`;
            }
            else if (this.props.maxValue && denormalizedValue > this.props.maxValue) {
                const [maxUnit, maxValue] = this.normalize(this.props.maxValue);
                errorMessage = `Maximum value is ${maxValue}${maxUnit}`;
            }
            this.safeSetState({ unit: unit, errorMessage: errorMessage });
        };
        this.handleUnitBlur = () => {
            const [normalizedUnit, normalizedValue] = this.normalize(this.denormalize(this.state.unit, this.state.value));
            this.safeSetState({ unit: normalizedUnit, value: normalizedValue });
            this.saveChanges();
        };
        this.saveChanges = () => {
            if (this.state.errorMessage === '') {
                var saveErrorMessage = this.props.saveValue(this.denormalize(this.state.unit, this.state.value));
                if (typeof saveErrorMessage === 'string' && saveErrorMessage !== '') {
                    this.safeSetState({ errorMessage: saveErrorMessage });
                }
            }
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({
                    display: 'inline-flex',
                    width: '100%',
                    padding: '6px 0px',
                    textAlign: 'center',
                    justifyContent: 'center'
                }, this.props.style) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                        minWidth: this.props.labelWidth || '68px',
                        margin: '0px 12px',
                        lineHeight: '24px',
                    } }, this.props.label),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_4__.default, { reminder: this.state.errorMessage },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.FormControl, { error: this.state.errorMessage != '', variant: 'outlined', style: {
                            width: '100%',
                            margin: '2px 3px 2px 6px',
                            height: this.props.helperText ? '32px' : '20px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledOutlinedInput, { inputRef: this.textField, value: this.state.value, placeholder: this.props.placeholder, onChange: this.handleValueChange, onFocus: this.handleValueFocus, onBlur: this.handleValueBlur, onKeyDown: (event) => { if (event.key == 'Enter' || event.key == 'Escape')
                                this.textField.current.blur(); } }),
                        this.props.helperText &&
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.FormHelperText, { style: { fontSize: '10px', lineHeight: '10px', margin: '4px 6px', whiteSpace: 'nowrap' } }, this.props.helperText))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledSelect, { value: this.state.unit, variant: 'outlined', onChange: this.handleUnitChange, onBlur: this.handleUnitBlur, SelectDisplayProps: { style: { padding: '3px 20px 3px 6px' } }, MenuProps: { MenuListProps: { style: { paddingTop: '6px', paddingBottom: '7px' } } }, style: { margin: '2px 6px 2px 3px', height: '20px' } }, this.props.unitValues.map(unitValue => react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledMenuItem, { key: unitValue.unit, value: unitValue.unit }, unitValue.unit)))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.textField = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
        const [unit, value] = this.normalize(this.props.getValue());
        this.state = {
            unit: unit,
            value: value,
            errorMessage: '',
        };
        this.StyledSelect = this.getStyledSelect();
    }
    normalize(value) {
        let largestSmallerUnit = this.props.unitValues[0].unit;
        let largestSmallerValue = this.props.unitValues[0].value;
        for (let unitValue of this.props.unitValues) {
            if (unitValue.value <= value && unitValue.value > largestSmallerValue) {
                largestSmallerUnit = unitValue.unit;
                largestSmallerValue = unitValue.value;
            }
        }
        return [largestSmallerUnit, Number.parseFloat((value / largestSmallerValue).toPrecision(3))];
    }
    denormalize(unit, value) {
        for (let unitValue of this.props.unitValues) {
            if (unitValue.unit === unit) {
                return unitValue.value * value;
            }
        }
        return value;
    }
}


/***/ }),

/***/ "./lib/core/WarningPopup.js":
/*!**********************************!*\
  !*** ./lib/core/WarningPopup.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WarningPopup)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Header__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Header */ "./lib/core/Header.js");
/* harmony import */ var _ShadowedDivider__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ShadowedDivider */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





const StyledDialog = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.withStyles)((theme) => ({
    root: {
        margin: '12px',
        padding: '0px',
    },
    paper: {
        backgroundColor: 'var(--jp-layout-color1)',
    },
}))(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Dialog);
class WarningPopup extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(StyledDialog, { disableBackdropClick: true, disableEscapeKeyDown: true, open: this.props.open },
                this.props.headerText &&
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.DialogTitle, { disableTypography: true, style: {
                            backgroundColor: 'var(--jp-layout-color2)',
                            height: '48px',
                            padding: '6px 30px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_Header__WEBPACK_IMPORTED_MODULE_3__.Header, { title: this.props.headerText, style: { lineHeight: '24px' } })),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_ShadowedDivider__WEBPACK_IMPORTED_MODULE_4__.ShadowedDivider, null),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { padding: '18px' } },
                    this.props.bodyText &&
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.DialogContent, { style: { padding: '6px 18px' } }, this.props.bodyText),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.DialogActions, { style: { padding: '12px 6px 6px 6px' } },
                        this.props.preventText &&
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null,
                                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Checkbox, { checked: this.state.prevent, onClick: () => this.safeSetState({ prevent: !this.state.prevent }) }),
                                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.ListItemText, { disableTypography: true, primary: this.props.preventText, style: { marginLeft: '0px', fontSize: '14px' } })),
                        this.props.cancel &&
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Button, { variant: 'contained', onClick: () => {
                                    this.safeSetState({ prevent: false });
                                    this.props.cancel.onCancel(this.state.prevent);
                                }, color: 'default' }, this.props.cancel.text),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(this.ContinueButton, { variant: 'contained', onClick: () => this.props.continue.onContinue(this.state.prevent), style: { marginLeft: '18px' } }, this.props.continue.text)))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            prevent: false,
        };
        this.ContinueButton = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.withStyles)((theme) => {
            const paletteColor = (() => {
                switch (this.props.continue.color) {
                    case 'primary': return theme.palette.primary;
                    case 'secondary': return theme.palette.secondary;
                    case 'success': return theme.palette.success;
                    case 'error': return theme.palette.error;
                    case 'warning': return theme.palette.warning;
                    case 'info': return theme.palette.info;
                }
            })();
            return ({
                root: {
                    color: paletteColor.contrastText,
                    backgroundColor: paletteColor.main,
                    '&:hover': {
                        backgroundColor: paletteColor.dark,
                        // Reset on touch devices, it doesn't add specificity
                        '@media (hover: none)': {
                            backgroundColor: paletteColor.main,
                        },
                    },
                },
            });
        })(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Button);
    }
}


/***/ }),

/***/ "./lib/core/notebook/CodeCell.js":
/*!***************************************!*\
  !*** ./lib/core/notebook/CodeCell.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CodeCell)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _InputArea__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./InputArea */ "./lib/core/notebook/InputArea.js");
/* harmony import */ var _OutputArea__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./OutputArea */ "./lib/core/notebook/OutputArea.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class CodeCell extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'p-Widget lm-Widget jp-Cell jp-CodeCell jp-Notebook-cell', onContextMenu: (e) => e.preventDefault() },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_InputArea__WEBPACK_IMPORTED_MODULE_2__.default, { cell: this.props.cell, metadata: this.props.metadata, renderInColor: this.props.renderInColor }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_OutputArea__WEBPACK_IMPORTED_MODULE_3__.default, { cell: this.props.cell, metadata: this.props.metadata })));
        };
    }
}


/***/ }),

/***/ "./lib/core/notebook/Editor.js":
/*!*************************************!*\
  !*** ./lib/core/notebook/Editor.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Editor)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_codemirror2__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-codemirror2 */ "webpack/sharing/consume/default/react-codemirror2/react-codemirror2");
/* harmony import */ var react_codemirror2__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_codemirror2__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



// This code did not work to enable supporting all languages, though they don't recommend enabling all of them
// import glob from 'glob'
// import path from 'path'
// glob.sync('codemirror/mode/**/*').forEach((file: string) => require(path.resolve(file)))
__webpack_require__(/*! codemirror/mode/julia/julia */ "./node_modules/codemirror/mode/julia/julia.js");
__webpack_require__(/*! codemirror/mode/python/python */ "./node_modules/codemirror/mode/python/python.js");
__webpack_require__(/*! codemirror/mode/r/r */ "./node_modules/codemirror/mode/r/r.js");
class Editor extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return this.props.renderInColor ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'p-Widget lm-Widget jp-Editor jp-CodeMirrorEditor jp-InputArea-editor' },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_codemirror2__WEBPACK_IMPORTED_MODULE_1__.UnControlled, { value: this.props.cell.source, options: {
                        readOnly: 'nocursor',
                        screenReaderLabel: 'jp-mod-readOnly',
                        theme: 'jupyter',
                        mode: this.props.metadata.language_info.name,
                    } }))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { whiteSpace: 'pre-wrap' }, className: 'p-Widget lm-Widget jp-Editor jp-CodeMirrorEditor jp-InputArea-editor' }, this.props.cell.source));
        };
    }
}


/***/ }),

/***/ "./lib/core/notebook/InputArea.js":
/*!****************************************!*\
  !*** ./lib/core/notebook/InputArea.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ InputArea)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Editor */ "./lib/core/notebook/Editor.js");
/* harmony import */ var _Markdown__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Markdown */ "./lib/core/notebook/Markdown.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class InputArea extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'p-Widget lm-Widget jp-Cell-inputWrapper' },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'p-Widget lm-Widget jp-InputArea jp-Cell-inputArea' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'p-Widget lm-Widget jp-InputPrompt jp-InputArea-prompt' }, this.props.cell.cell_type === 'code' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, this.props.cell.execution_count !== undefined && `[${this.props.cell.execution_count === null ? ' ' : this.props.cell.execution_count}]:`)) : this.props.cell.cell_type === 'markdown' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null)) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null))),
                    this.props.cell.cell_type === 'code' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Editor__WEBPACK_IMPORTED_MODULE_2__.default, { cell: this.props.cell, metadata: this.props.metadata, renderInColor: this.props.renderInColor })) : this.props.cell.cell_type === 'markdown' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Markdown__WEBPACK_IMPORTED_MODULE_3__.default, { cell: this.props.cell, metadata: this.props.metadata })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null)))));
        };
    }
}


/***/ }),

/***/ "./lib/core/notebook/Markdown.js":
/*!***************************************!*\
  !*** ./lib/core/notebook/Markdown.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Markdown)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_markdown__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-markdown */ "webpack/sharing/consume/default/react-markdown/react-markdown");
/* harmony import */ var react_markdown__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_markdown__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var remark_gfm__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! remark-gfm */ "webpack/sharing/consume/default/remark-gfm/remark-gfm");
/* harmony import */ var remark_gfm__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(remark_gfm__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class Markdown extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'jp-RenderedMarkdown jp-MarkdownOutput jp-RenderedHTMLCommon' },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement((react_markdown__WEBPACK_IMPORTED_MODULE_1___default()), { plugins: [(remark_gfm__WEBPACK_IMPORTED_MODULE_2___default())], allowDangerousHtml: true }, this.props.cell.source)));
        };
    }
}


/***/ }),

/***/ "./lib/core/notebook/MarkdownCell.js":
/*!*******************************************!*\
  !*** ./lib/core/notebook/MarkdownCell.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MarkdownCell)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _InputArea__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./InputArea */ "./lib/core/notebook/InputArea.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class MarkdownCell extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'p-Widget lm-Widget jp-Cell jp-MarkdownCell jp-Notebook-cell' },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_InputArea__WEBPACK_IMPORTED_MODULE_2__.default, { cell: this.props.cell, metadata: this.props.metadata, renderInColor: this.props.renderInColor })));
        };
    }
}


/***/ }),

/***/ "./lib/core/notebook/Notebook.js":
/*!***************************************!*\
  !*** ./lib/core/notebook/Notebook.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Notebook)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _CodeCell__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CodeCell */ "./lib/core/notebook/CodeCell.js");
/* harmony import */ var _MarkdownCell__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MarkdownCell */ "./lib/core/notebook/MarkdownCell.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class Notebook extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const notebook = this.props.notebook;
            // const words = notebook.cells.map(cell => (cell.source as string).split(/\b/).length).reduce((a, b) => a + b, 0)
            const words = notebook.cells.map(cell => cell.source.length).reduce((a, b) => a + b, 0) / 5;
            const renderInColor = words < 2500;
            let i = 0;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'p-Widget lm-Widget jp-Notebook jp-NotebookPanel-notebook jp-mod-scrollPastEnd jp-mod-commandMode' }, notebook.cells.map(cell => cell.cell_type === 'code' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_CodeCell__WEBPACK_IMPORTED_MODULE_2__.default, { key: i++, cell: cell, metadata: notebook.metadata, renderInColor: renderInColor })) : cell.cell_type === 'markdown' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_MarkdownCell__WEBPACK_IMPORTED_MODULE_3__.default, { key: i++, cell: cell, metadata: notebook.metadata, renderInColor: renderInColor })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null)))));
        };
        this.componentDidMount = () => {
            // Override the JupyterLab context menu open (disable it)
            this.oldOpen = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.lab.contextMenu.open;
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.lab.contextMenu.open = () => false;
        };
        // Add context menu items back
        this.componentWillUnmount = () => {
            // Restore the old JupyterLab context menu open
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.lab.contextMenu.open = this.oldOpen;
        };
    }
}


/***/ }),

/***/ "./lib/core/notebook/OutputArea.js":
/*!*****************************************!*\
  !*** ./lib/core/notebook/OutputArea.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ OutputArea)
/* harmony export */ });
/* harmony import */ var ansi_to_react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ansi-to-react */ "webpack/sharing/consume/default/ansi-to-react/ansi-to-react");
/* harmony import */ var ansi_to_react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(ansi_to_react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_linkify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-linkify */ "webpack/sharing/consume/default/react-linkify/react-linkify");
/* harmony import */ var react_linkify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_linkify__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class OutputArea extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            let i = 0;
            return (react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { className: 'p-Widget lm-Widget jp-Cell-outputWrapper' },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { className: 'p-Widget lm-Widget jp-OutputArea jp-Cell-outputArea' },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { className: 'p-Widget lm-Widget jp-OutputArea-child' },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { className: 'p-Widget lm-Widget jp-OutputPrompt jp-OutputArea-prompt' }),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { display: 'block', width: '100%' } }, this.props.cell.outputs.map((output) => (react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { key: i++, "data-mime-type": output.name === 'stderr' || output.output_type === 'error' ? 'application/vnd.jupyter.stderr' : 'application/vnd.jupyter.stdout', className: 'p-Widget lm-Widget jp-RenderedText jp-OutputArea-output' }, output.output_type === 'stream' ? (react__WEBPACK_IMPORTED_MODULE_1__.createElement((react_linkify__WEBPACK_IMPORTED_MODULE_2___default()), { componentDecorator: (decoratedHref, decoratedText, key) => {
                                return (react__WEBPACK_IMPORTED_MODULE_1__.createElement("a", { key: key, href: decoratedHref, rel: `noopener`, target: `_blank` }, decoratedText));
                            } },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement("pre", null, output.text.map((x) => x.replace(/\x08/g, ''))))) : output.output_type === 'error' ? (output.traceback.map((line) => (react__WEBPACK_IMPORTED_MODULE_1__.createElement("pre", { key: line },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement((ansi_to_react__WEBPACK_IMPORTED_MODULE_0___default()), null, line))))) : output.output_type === 'display_data' ? (react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null)) : (react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null))))))))));
        };
    }
}


/***/ }),

/***/ "./lib/index.js":
/*!**********************!*\
  !*** ./lib/index.js ***!
  \**********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _widget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./widget */ "./lib/widget.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ([
    _widget__WEBPACK_IMPORTED_MODULE_0__.default,
]);


/***/ }),

/***/ "./lib/models/AWSRegions.js":
/*!**********************************!*\
  !*** ./lib/models/AWSRegions.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AWSRegion": () => (/* binding */ AWSRegion),
/* harmony export */   "AWSRegions": () => (/* binding */ AWSRegions)
/* harmony export */ });
class AWSRegion {
    constructor(region, description) {
        this.region = region;
        this.description = description;
    }
}
class AWSRegions {
    static get GovCloud() { return AWSRegions.regions.GovCloud; }
    static get US_GOV_EAST_1() { return AWSRegions.regions.US_GOV_EAST_1; }
    static get US_EAST_1() { return AWSRegions.regions.US_EAST_1; }
    static get US_EAST_2() { return AWSRegions.regions.US_EAST_2; }
    static get US_WEST_1() { return AWSRegions.regions.US_WEST_1; }
    static get US_WEST_2() { return AWSRegions.regions.US_WEST_2; }
    static get EU_WEST_1() { return AWSRegions.regions.EU_WEST_1; }
    static get EU_WEST_2() { return AWSRegions.regions.EU_WEST_2; }
    static get EU_WEST_3() { return AWSRegions.regions.EU_WEST_3; }
    static get EU_CENTRAL_1() { return AWSRegions.regions.EU_CENTRAL_1; }
    static get EU_NORTH_1() { return AWSRegions.regions.EU_NORTH_1; }
    static get EU_SOUTH_1() { return AWSRegions.regions.EU_SOUTH_1; }
    static get AP_EAST_1() { return AWSRegions.regions.AP_EAST_1; }
    static get AP_SOUTH_1() { return AWSRegions.regions.AP_SOUTH_1; }
    static get AP_SOUTHEAST_1() { return AWSRegions.regions.AP_SOUTHEAST_1; }
    static get AP_SOUTHEAST_2() { return AWSRegions.regions.AP_SOUTHEAST_2; }
    static get AP_NORTHEAST_1() { return AWSRegions.regions.AP_NORTHEAST_1; }
    static get AP_NORTHEAST_2() { return AWSRegions.regions.AP_NORTHEAST_2; }
    static get AP_NORTHEAST_3() { return AWSRegions.regions.AP_NORTHEAST_3; }
    static get SA_EAST_1() { return AWSRegions.regions.SA_EAST_1; }
    static get CN_NORTH_1() { return AWSRegions.regions.CN_NORTH_1; }
    static get CN_NORTHWEST_1() { return AWSRegions.regions.CN_NORTHWEST_1; }
    static get CA_CENTRAL_1() { return AWSRegions.regions.CA_CENTRAL_1; }
    static get ME_SOUTH_1() { return AWSRegions.regions.ME_SOUTH_1; }
    static get AF_SOUTH_1() { return AWSRegions.regions.AF_SOUTH_1; }
    static get US_ISO_EAST_1() { return AWSRegions.regions.US_ISO_EAST_1; }
    static get US_ISOB_EAST_1() { return AWSRegions.regions.US_ISOB_EAST_1; }
    static get US_ISO_WEST_1() { return AWSRegions.regions.US_ISO_WEST_1; }
    static get values() {
        return [
            AWSRegions.GovCloud,
            AWSRegions.US_GOV_EAST_1,
            AWSRegions.US_EAST_1,
            AWSRegions.US_EAST_2,
            AWSRegions.US_WEST_1,
            AWSRegions.US_WEST_2,
            AWSRegions.EU_WEST_1,
            AWSRegions.EU_WEST_2,
            AWSRegions.EU_WEST_3,
            AWSRegions.EU_CENTRAL_1,
            AWSRegions.EU_NORTH_1,
            AWSRegions.EU_SOUTH_1,
            AWSRegions.AP_EAST_1,
            AWSRegions.AP_SOUTH_1,
            AWSRegions.AP_SOUTHEAST_1,
            AWSRegions.AP_SOUTHEAST_2,
            AWSRegions.AP_NORTHEAST_1,
            AWSRegions.AP_NORTHEAST_2,
            AWSRegions.AP_NORTHEAST_3,
            AWSRegions.SA_EAST_1,
            AWSRegions.CN_NORTH_1,
            AWSRegions.CN_NORTHWEST_1,
            AWSRegions.CA_CENTRAL_1,
            AWSRegions.ME_SOUTH_1,
            AWSRegions.AF_SOUTH_1,
            AWSRegions.US_ISOB_EAST_1,
            AWSRegions.US_ISO_WEST_1
        ];
    }
}
AWSRegions.regions = {
    GovCloud: new AWSRegion("us-gov-west-1", "AWS GovCloud (US)"),
    US_GOV_EAST_1: new AWSRegion("us-gov-east-1", "AWS GovCloud (US-East)"),
    US_EAST_1: new AWSRegion("us-east-1", "US East (N. Virginia)"),
    US_EAST_2: new AWSRegion("us-east-2", "US East (Ohio)"),
    US_WEST_1: new AWSRegion("us-west-1", "US West (N. California)"),
    US_WEST_2: new AWSRegion("us-west-2", "US West (Oregon)"),
    EU_WEST_1: new AWSRegion("eu-west-1", "EU (Ireland)"),
    EU_WEST_2: new AWSRegion("eu-west-2", "EU (London)"),
    EU_WEST_3: new AWSRegion("eu-west-3", "EU (Paris)"),
    EU_CENTRAL_1: new AWSRegion("eu-central-1", "EU (Frankfurt)"),
    EU_NORTH_1: new AWSRegion("eu-north-1", "EU (Stockholm)"),
    EU_SOUTH_1: new AWSRegion("eu-south-1", "EU (Milan)"),
    AP_EAST_1: new AWSRegion("ap-east-1", "Asia Pacific (Hong Kong)"),
    AP_SOUTH_1: new AWSRegion("ap-south-1", "Asia Pacific (Mumbai)"),
    AP_SOUTHEAST_1: new AWSRegion("ap-southeast-1", "Asia Pacific (Singapore)"),
    AP_SOUTHEAST_2: new AWSRegion("ap-southeast-2", "Asia Pacific (Sydney)"),
    AP_NORTHEAST_1: new AWSRegion("ap-northeast-1", "Asia Pacific (Tokyo)"),
    AP_NORTHEAST_2: new AWSRegion("ap-northeast-2", "Asia Pacific (Seoul)"),
    AP_NORTHEAST_3: new AWSRegion("ap-northeast-3", "Asia Pacific (Osaka)"),
    SA_EAST_1: new AWSRegion("sa-east-1", "South America (Sao Paulo)"),
    CN_NORTH_1: new AWSRegion("cn-north-1", "China (Beijing)"),
    CN_NORTHWEST_1: new AWSRegion("cn-northwest-1", "China (Ningxia)"),
    CA_CENTRAL_1: new AWSRegion("ca-central-1", "Canada (Central)"),
    ME_SOUTH_1: new AWSRegion("me-south-1", "Middle East (Bahrain)"),
    AF_SOUTH_1: new AWSRegion("af-south-1", "Africa (Cape Town)"),
    US_ISO_EAST_1: new AWSRegion("us-iso-east-1", "US ISO East"),
    US_ISOB_EAST_1: new AWSRegion("us-isob-east-1", "US ISOB East (Ohio)"),
    US_ISO_WEST_1: new AWSRegion("us-iso-west-1", "US ISO West"),
};


/***/ }),

/***/ "./lib/models/ComputeConfig.js":
/*!*************************************!*\
  !*** ./lib/models/ComputeConfig.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ComputeConfig": () => (/* binding */ ComputeConfig)
/* harmony export */ });
/* harmony import */ var _OptumiConfig__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./OptumiConfig */ "./lib/models/OptumiConfig.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/

class ComputeConfig {
    // Dev Ops properties
    // TODO:JJ
    constructor(map = {}, user = null) {
        this.expertise = map.expertise || _OptumiConfig__WEBPACK_IMPORTED_MODULE_0__.Expertise.BASIC;
        this.required = map.required || false;
        this.rating = map.rating || [-1, -1, -1];
        this.score = map.score || [-1, -1, -1];
        this.cores = map.cores || [-1, -1, -1];
        this.frequency = map.frequency || [-1, -1, -1];
    }
}


/***/ }),

/***/ "./lib/models/DataConnectorUploadConfig.js":
/*!*************************************************!*\
  !*** ./lib/models/DataConnectorUploadConfig.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DataConnectorUploadConfig": () => (/* binding */ DataConnectorUploadConfig)
/* harmony export */ });
/* harmony import */ var _components_deploy_dataConnectorBrowser_DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../components/deploy/dataConnectorBrowser/DataConnectorDirListingItemIcon */ "./lib/components/deploy/dataConnectorBrowser/DataConnectorDirListingItemIcon.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/

class DataConnectorUploadConfig {
    constructor(map) {
        this.name = map.name;
        this.dataService = map.dataService || _components_deploy_dataConnectorBrowser_DataConnectorDirListingItemIcon__WEBPACK_IMPORTED_MODULE_0__.DataService.GOOGLE_DRIVE;
    }
}


/***/ }),

/***/ "./lib/models/FileUploadConfig.js":
/*!****************************************!*\
  !*** ./lib/models/FileUploadConfig.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FileUploadConfig": () => (/* binding */ FileUploadConfig)
/* harmony export */ });
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
class FileUploadConfig {
    constructor(map) {
        this.path = map.path;
        this.type = map.type || 'file';
        this.mimetype = map.mimetype || 'text/plain';
    }
}


/***/ }),

/***/ "./lib/models/GraphicsCard.js":
/*!************************************!*\
  !*** ./lib/models/GraphicsCard.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GraphicsCard": () => (/* binding */ GraphicsCard)
/* harmony export */ });
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
class GraphicsCard {
    constructor(name, configs) {
        this._name = name;
        this._configs = configs;
    }
    get name() {
        return this._name;
    }
    get configs() {
        return this._configs;
    }
    addConfig(value) {
        if (!this._configs.includes(value)) {
            this._configs.push(value);
        }
    }
}


/***/ }),

/***/ "./lib/models/GraphicsConfig.js":
/*!**************************************!*\
  !*** ./lib/models/GraphicsConfig.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GraphicsConfig": () => (/* binding */ GraphicsConfig)
/* harmony export */ });
/* harmony import */ var _OptumiConfig__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./OptumiConfig */ "./lib/models/OptumiConfig.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/

class GraphicsConfig {
    constructor(map = {}, user = null) {
        this.expertise = map.expertise || _OptumiConfig__WEBPACK_IMPORTED_MODULE_0__.Expertise.BASIC;
        this.required = map.required || false;
        this.rating = map.rating || [-1, -1, -1];
        this.score = map.score || [-1, -1, -1];
        this.cores = map.cores || [-1, -1, -1];
        this.memory = map.memory || [-1, -1, -1];
        this.frequency = map.frequency || [-1, -1, -1];
        this.boardCount = map.boardCount || [1, -1, -1];
        this.boardType = map.boardType || "K80";
    }
}


/***/ }),

/***/ "./lib/models/Machines.js":
/*!********************************!*\
  !*** ./lib/models/Machines.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Machines": () => (/* binding */ Machines)
/* harmony export */ });
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ "webpack/sharing/consume/default/@lumino/signaling");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _GraphicsCard__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./GraphicsCard */ "./lib/models/GraphicsCard.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/


class Machines {
    constructor(machines, maxCost) {
        this._changed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);
        // Max compute values
        this.absoluteComputeMaxCores = 0;
        this.absoluteComputeMaxScore = 0;
        this.absoluteComputeMaxFrequency = 0;
        // Max graphics values
        this.absoluteGraphicsMaxScore = 0;
        this.absoluteGraphicsMaxCores = 0;
        this.absoluteGraphicsMaxMemory = 0;
        this.absoluteGraphicsMaxFrequency = 0;
        this.absoluteGraphicsMaxCards = [];
        // Max memory values
        this.absoluteMemoryMaxSize = 0;
        // Max storage values
        this.absoluteStorageMaxSize = 0;
        this.absoluteStorageMaxIops = 0;
        this.absoluteStorageMaxThroughput = 0;
        // Min compute values
        this.absoluteComputeMinCores = 0;
        this.absoluteComputeMinScore = 0;
        this.absoluteComputeMinFrequency = 0;
        // Min graphics values
        this.absoluteGraphicsMinScore = 0;
        this.absoluteGraphicsMinCores = 0;
        this.absoluteGraphicsMinMemory = 0;
        this.absoluteGraphicsMinFrequency = 0;
        // public absoluteGraphicsMinCards: GraphicsCard[] = [];
        // Min memory values
        this.absoluteMemoryMinSize = 0;
        // Min storage values
        this.absoluteStorageMinSize = 0;
        this.absoluteStorageMinIops = 0;
        this.absoluteStorageMinThroughput = 0;
        // The cheapest machine available, so we can adjust the resource cap slider
        this.cheapestMachine = null;
        // The most expensive machine available, incase we want to adjust the max resource cap in the future
        this.mostExpensiveMachine = null;
        // A list of all graphics cards
        this.graphicsCards = [];
        this.inventory = machines;
        this.setAbsoluteMaxResources(maxCost);
        // Global.onUserChange.connect(() => this.setAbsoluteMaxResources());
    }
    get changed() {
        return this._changed;
    }
    //  It is useful for us to know what the cost of the cheapest machine is
    getCheapestMachineCost() {
        if (this.cheapestMachine != null) {
            return this.cheapestMachine.rate;
        }
        return 0;
    }
    getMostExpensiveMachineCost() {
        if (this.mostExpensiveMachine != null) {
            return this.mostExpensiveMachine.rate;
        }
        return 0;
    }
    setAbsoluteMaxResources(maxCost) {
        for (let machine of this.inventory) {
            if (machine.rate > maxCost)
                continue;
            if (machine.graphicsNumCards != 0) {
                // Try to get card from list we have info about
                var graphicsCard = this.absoluteGraphicsMaxCards.filter(x => x.name == machine.graphicsCardType).pop();
                if (graphicsCard) {
                    // If we already have info about the card, add the new info about the card to the old info
                    graphicsCard.addConfig(machine.graphicsNumCards);
                }
                else {
                    // If this is a new card, add it to the list along with its info
                    this.absoluteGraphicsMaxCards.push(new _GraphicsCard__WEBPACK_IMPORTED_MODULE_1__.GraphicsCard(machine.graphicsCardType, [machine.graphicsNumCards]));
                }
            }
            var computeCores = machine.computeCores;
            if (computeCores > this.absoluteComputeMaxCores)
                this.absoluteComputeMaxCores = computeCores;
            if (computeCores < this.absoluteComputeMinCores)
                this.absoluteComputeMinCores = computeCores;
            var computeScore = machine.computeScore;
            if (computeScore > this.absoluteComputeMaxScore)
                this.absoluteComputeMaxScore = computeScore;
            if (computeScore < this.absoluteComputeMinScore)
                this.absoluteComputeMinScore = computeScore;
            var computeFrequency = machine.computeFrequency;
            if (computeFrequency > this.absoluteComputeMaxFrequency)
                this.absoluteComputeMaxFrequency = computeFrequency;
            if (computeFrequency < this.absoluteComputeMinFrequency)
                this.absoluteComputeMinFrequency = computeFrequency;
            var graphicsScore = machine.graphicsScore;
            if (graphicsScore > this.absoluteGraphicsMaxScore)
                this.absoluteGraphicsMaxScore = graphicsScore;
            if (graphicsScore < this.absoluteGraphicsMinScore)
                this.absoluteGraphicsMinScore = graphicsScore;
            var graphicsCores = machine.graphicsCores;
            if (graphicsCores > this.absoluteGraphicsMaxCores)
                this.absoluteGraphicsMaxCores = graphicsCores;
            if (graphicsCores < this.absoluteGraphicsMinCores)
                this.absoluteGraphicsMinCores = graphicsCores;
            var graphicsMemory = machine.graphicsMemory;
            if (graphicsMemory > this.absoluteGraphicsMaxMemory)
                this.absoluteGraphicsMaxMemory = graphicsMemory;
            if (graphicsMemory < this.absoluteGraphicsMinMemory)
                this.absoluteGraphicsMinMemory = graphicsMemory;
            var graphicsFrequency = machine.graphicsFrequency;
            if (graphicsFrequency > this.absoluteGraphicsMaxFrequency)
                this.absoluteGraphicsMaxFrequency = graphicsFrequency;
            if (graphicsFrequency < this.absoluteGraphicsMinFrequency)
                this.absoluteGraphicsMinFrequency = graphicsFrequency;
            var memorySize = machine.memorySize;
            if (memorySize > this.absoluteMemoryMaxSize)
                this.absoluteMemoryMaxSize = memorySize;
            if (memorySize < this.absoluteMemoryMinSize)
                this.absoluteMemoryMinSize = memorySize;
            var storageSize = machine.storageSize;
            if (storageSize > this.absoluteStorageMaxSize)
                this.absoluteStorageMaxSize = storageSize;
            if (storageSize < this.absoluteStorageMinSize)
                this.absoluteStorageMinSize = storageSize;
            var storageIops = machine.storageIops;
            if (storageIops > this.absoluteStorageMaxIops)
                this.absoluteStorageMaxIops = storageIops;
            if (storageIops < this.absoluteStorageMinIops)
                this.absoluteStorageMinIops = storageIops;
            var storageThroughput = machine.storageThroughput;
            if (storageThroughput > this.absoluteStorageMaxThroughput)
                this.absoluteStorageMaxThroughput = storageThroughput;
            if (storageThroughput < this.absoluteStorageMinThroughput)
                this.absoluteStorageMinThroughput = storageThroughput;
            var rate = machine.rate;
            if (this.mostExpensiveMachine == null || rate > this.mostExpensiveMachine.rate)
                this.mostExpensiveMachine = machine;
            if (this.cheapestMachine == null || rate < this.cheapestMachine.rate)
                this.cheapestMachine = machine;
        }
    }
}


/***/ }),

/***/ "./lib/models/MemoryConfig.js":
/*!************************************!*\
  !*** ./lib/models/MemoryConfig.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MemoryConfig": () => (/* binding */ MemoryConfig)
/* harmony export */ });
/* harmony import */ var _OptumiConfig__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./OptumiConfig */ "./lib/models/OptumiConfig.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/

class MemoryConfig {
    // Dev Ops properties
    // TODO:JJ
    constructor(map = {}, user = null) {
        this.expertise = map.expertise || _OptumiConfig__WEBPACK_IMPORTED_MODULE_0__.Expertise.BASIC;
        this.required = map.required || false;
        this.rating = map.rating || [-1, -1, -1];
        this.size = map.size || [-1, -1, -1];
    }
}


/***/ }),

/***/ "./lib/models/Module.js":
/*!******************************!*\
  !*** ./lib/models/Module.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Status": () => (/* binding */ Status),
/* harmony export */   "Module": () => (/* binding */ Module)
/* harmony export */ });
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _Update__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Update */ "./lib/models/Update.js");
/* harmony import */ var _OutputFile__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./OutputFile */ "./lib/models/OutputFile.js");
/* harmony import */ var _machine_Machine__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./machine/Machine */ "./lib/models/machine/Machine.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





var Status;
(function (Status) {
    Status[Status["INITIALIZING"] = 0] = "INITIALIZING";
    Status[Status["RUNNING"] = 1] = "RUNNING";
    Status[Status["COMPLETED"] = 2] = "COMPLETED";
})(Status || (Status = {}));
class Module {
    constructor(uuid, workloadUUID, addOutput, machine = null, sessionToken = null, output = [], updates = [], files = []) {
        this._sessionReady = false;
        this.pushModuleInput = (line) => {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/push-module-input";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    workloadUUID: this._workloadUUID,
                    moduleUUID: this._uuid,
                    line: line,
                }),
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_1__.Global.handleResponse(response);
            });
        };
        this._uuid = uuid;
        this._workloadUUID = workloadUUID;
        this.addOutput = addOutput;
        this._sessionToken = sessionToken;
        this._machine = machine;
        this._output = output;
        for (var l of this._output) {
            this.addOutput(l.line, l.modifier);
        }
        this._sessionReady = output.map(x => x.line.includes('Jupyter Server ') && x.line.includes(' is running at:')).includes(true);
        this._updates = updates;
        this._files = files;
    }
    get sessionReady() {
        return this._sessionReady;
    }
    get uuid() {
        return this._uuid;
    }
    ////
    /// We are not using the module stdin yet
    //
    get sessionToken() {
        return this._sessionToken;
    }
    get sessionPort() {
        return this._sessionPort;
    }
    get machine() {
        return this._machine;
    }
    get updates() {
        return this._updates;
    }
    get output() {
        return this._output;
    }
    get files() {
        return this._files;
    }
    get modStatus() {
        for (var update of this._updates) {
            if (update.modifier == "stop")
                return Status.COMPLETED;
        }
        return Status.RUNNING;
    }
    get error() {
        for (var update of this._updates) {
            if (update.line == "error")
                return true;
        }
        return false;
    }
    handleUpdate(body) {
        let updated = false;
        if (body.output != null) {
            if (body.output.length > 0)
                updated = true;
            for (let i = 0; i < body.output.length; i++) {
                this.addOutput(body.output[i], body.outputmod[i]);
                this._output.push(new _Update__WEBPACK_IMPORTED_MODULE_2__.Update(body.output[i], body.outputmod[i]));
                if (body.output[i].includes('Jupyter Server ') && body.output[i].includes(' is running at:')) {
                    this._sessionReady = true;
                    window.open('http://localhost:' + this._sessionPort + '?token=' + this._sessionToken, '_blank');
                }
            }
        }
        if (body.files != null) {
            this._files = [];
            for (let i = 0; i < body.files.length; i++) {
                if (body.files[i] != '') {
                    updated = true;
                    this._files.push(new _OutputFile__WEBPACK_IMPORTED_MODULE_3__.OutputFile(body.files[i], body.filesmod[i], body.filessize[i]));
                }
            }
        }
        if (body.token != null) {
            updated = true;
            this._sessionToken = body.token;
        }
        if (body.updates != null) {
            if (body.updates.length > 0)
                updated = true;
            for (let i = 0; i < body.updates.length; i++) {
                this._updates.push(new _Update__WEBPACK_IMPORTED_MODULE_2__.Update(body.updates[i], body.updatesmod[i]));
                if (body.updatesmod[i] == "stop") {
                    this.stopSessionHandler();
                }
                else if (body.updates[i] == "launched") {
                }
                else if (body.updates[i] == "closed") {
                    this.stopSessionHandler();
                }
            }
        }
        if (body.machine != null) {
            updated = true;
            this._machine = Object.setPrototypeOf(body.machine, _machine_Machine__WEBPACK_IMPORTED_MODULE_4__.Machine.prototype);
        }
        return updated;
    }
    startSessionHandler() {
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/connect-session";
        const init = {
            method: 'POST',
            body: JSON.stringify({
                module: this._uuid,
            }),
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.handleResponse(response);
            return response.json();
        }).then((body) => {
            if (body.port) {
                this._sessionPort = body.port;
            }
        });
    }
    stopSessionHandler() {
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/disconnect-session";
        const init = {
            method: 'POST',
            body: JSON.stringify({
                module: this._uuid,
            }),
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.handleResponse(response);
            return response.text();
        });
    }
}


/***/ }),

/***/ "./lib/models/NotificationConfig.js":
/*!******************************************!*\
  !*** ./lib/models/NotificationConfig.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "NotificationConfig": () => (/* binding */ NotificationConfig)
/* harmony export */ });
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
class NotificationConfig {
    constructor(map = {}, user = null) {
        this.jobStartedSMSEnabled = map.jobStartedSMSEnabled || false;
        this.jobCompletedSMSEnabled = map.jobCompletedSMSEnabled || false;
        this.jobFailedSMSEnabled = map.jobFailedSMSEnabled || false;
    }
}


/***/ }),

/***/ "./lib/models/OptumiConfig.js":
/*!************************************!*\
  !*** ./lib/models/OptumiConfig.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Expertise": () => (/* binding */ Expertise),
/* harmony export */   "OptumiConfig": () => (/* binding */ OptumiConfig)
/* harmony export */ });
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _ComputeConfig__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ComputeConfig */ "./lib/models/ComputeConfig.js");
/* harmony import */ var _GraphicsConfig__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./GraphicsConfig */ "./lib/models/GraphicsConfig.js");
/* harmony import */ var _MemoryConfig__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MemoryConfig */ "./lib/models/MemoryConfig.js");
/* harmony import */ var _NotificationConfig__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./NotificationConfig */ "./lib/models/NotificationConfig.js");
/* harmony import */ var _StorageConfig__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./StorageConfig */ "./lib/models/StorageConfig.js");
/* harmony import */ var _UploadConfig__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./UploadConfig */ "./lib/models/UploadConfig.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/







var Expertise;
(function (Expertise) {
    Expertise["BASIC"] = "basic";
    Expertise["RATING"] = "rating";
    Expertise["SIMPLIFIED"] = "simplified";
    Expertise["COMPONENT"] = "component";
    Expertise["EQUIPMENT"] = "equipment";
})(Expertise || (Expertise = {}));
class OptumiConfig {
    constructor(map = {}, version = _Global__WEBPACK_IMPORTED_MODULE_0__.Global.version, user = null) {
        switch (version) {
            case "0.3.0":
            case "0.3.1":
            case "0.3.2":
            case "0.3.3":
            case "0.3.4":
            case "0.3.5":
            case "0.3.6":
            case "0.3.7":
            case "0.3.8":
            case "0.3.9":
            case "0.3.10":
            case "0.3.11":
            case "0.3.12":
            case "0.3.13":
            case "0.3.14":
            case "0.3.15":
            case "0.3.16":
            case "0.3.17":
            case "20.9.0-0":
            case "20.9.1-0":
            case "20.9.1-1":
            case "20.10.0-0":
            case "20.10.1":
            case "20.10.1-1":
            case "20.10.1-2":
            case "20.10.1-3":
            case "20.10.1-4":
            case "20.10.1-5":
                /// Anything before this will result in default metadata
                map = {};
            case "20.12.0":
            case "20.12.0-1":
            case "2.1.0":
            case "2.1.1":
            case "2.1.2":
            case "2.2.0":
            case "3.3.0":
            case "3.3.1":
            case "3.3.2":
            case "3.5.0":
            case "3.5.1":
            case "3.6.0":
                break;
            default:
                if (!version.includes("DEV"))
                    console.log("Unknown map version: " + version);
        }
        this.intent = (map.intent != undefined ? map.intent : ((user) ? user.intent : 0));
        this.compute = new _ComputeConfig__WEBPACK_IMPORTED_MODULE_1__.ComputeConfig(map.compute || {}, user);
        this.graphics = new _GraphicsConfig__WEBPACK_IMPORTED_MODULE_2__.GraphicsConfig(map.graphics || {}, user);
        this.memory = new _MemoryConfig__WEBPACK_IMPORTED_MODULE_3__.MemoryConfig(map.memory || {}, user);
        this.storage = new _StorageConfig__WEBPACK_IMPORTED_MODULE_4__.StorageConfig(map.storage || {});
        this.upload = new _UploadConfig__WEBPACK_IMPORTED_MODULE_5__.UploadConfig(map.upload || {});
        this.notifications = new _NotificationConfig__WEBPACK_IMPORTED_MODULE_6__.NotificationConfig(map.notifications || {});
        this.interactive = map.interactive == undefined ? true : map.interactive;
        this.annotation = map.annotation || "";
    }
    copy() {
        return new OptumiConfig(JSON.parse(JSON.stringify(this)));
    }
}


/***/ }),

/***/ "./lib/models/OptumiMetadata.js":
/*!**************************************!*\
  !*** ./lib/models/OptumiMetadata.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OptumiMetadata": () => (/* binding */ OptumiMetadata)
/* harmony export */ });
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var uuid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! uuid */ "webpack/sharing/consume/default/uuid/uuid");
/* harmony import */ var uuid__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(uuid__WEBPACK_IMPORTED_MODULE_0__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/


class OptumiMetadata {
    constructor(map = {}) {
        this.version = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.version;
        this.nbKey = map.nbKey || (0,uuid__WEBPACK_IMPORTED_MODULE_0__.v4)();
        this.version = map.version || "None";
        if (this.version.includes("DEV"))
            this.version = "DEV";
    }
}


/***/ }),

/***/ "./lib/models/OptumiMetadataTracker.js":
/*!*********************************************!*\
  !*** ./lib/models/OptumiMetadataTracker.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OptumiMetadataTracker": () => (/* binding */ OptumiMetadataTracker),
/* harmony export */   "TrackedOptumiMetadata": () => (/* binding */ TrackedOptumiMetadata)
/* harmony export */ });
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/signaling */ "webpack/sharing/consume/default/@lumino/signaling");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _OptumiConfig__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./OptumiConfig */ "./lib/models/OptumiConfig.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _OptumiMetadata__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./OptumiMetadata */ "./lib/models/OptumiMetadata.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





class OptumiMetadataTracker {
    constructor(tracker) {
        this._optumiMetadata = new Map();
        this.handleCurrentChanged = async (current) => {
            if (current == null) {
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnPoll)
                    console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                setTimeout(() => this.handleCurrentChanged(this._tracker.currentWidget), 250);
                return;
            }
            if (!current.context.isReady)
                await current.context.ready;
            // If the path changes we need to add a new entry into our map
            current.context.pathChanged.connect(() => this.handleCurrentChanged(current));
            const path = current.context.path;
            const rawMetadata = current.model.metadata;
            var metadata = new _OptumiMetadata__WEBPACK_IMPORTED_MODULE_3__.OptumiMetadata(rawMetadata.get("optumi") || {});
            var trackedMetadata;
            // Handle conversion from old metadata stored in file
            const fromFile = (rawMetadata.get("optumi") || {});
            if ("intent" in fromFile &&
                "compute" in fromFile &&
                "graphics" in fromFile &&
                "memory" in fromFile &&
                "storage" in fromFile &&
                "upload" in fromFile &&
                "interactive" in fromFile &&
                "version" in fromFile) {
                // Take the metadata from the file
                trackedMetadata = new TrackedOptumiMetadata(path, metadata, new _OptumiConfig__WEBPACK_IMPORTED_MODULE_4__.OptumiConfig(fromFile, fromFile.version));
            }
            else {
                // Get the metadata from the controller
                const config = (await this.fetchConfig(metadata));
                // If this is a duplicated notebook, we want to give it a new uuid, but we will use the old uuid to pick up the config
                for (var entry of this._optumiMetadata) {
                    if (entry[1].metadata.nbKey == metadata.nbKey && entry[0] != path) {
                        metadata = new _OptumiMetadata__WEBPACK_IMPORTED_MODULE_3__.OptumiMetadata();
                    }
                }
                trackedMetadata = new TrackedOptumiMetadata(path, metadata, config);
            }
            trackedMetadata.metadata.version = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.version;
            this._optumiMetadata.set(path, trackedMetadata);
            // Save the metadata in the file to make sure all files have valid metadata
            rawMetadata.set("optumi", JSON.parse(JSON.stringify(metadata)));
            // Save the metadata to the controller, in case something was updated above
            this.setMetadata(trackedMetadata);
            // Once all of this is done, emit a signal that the metadata changed
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnEmit)
                console.log('SignalEmit (' + new Date().getSeconds() + ')');
            this._metadataChanged.emit(void 0);
        };
        this.fetchConfig = (metadata) => {
            // If there is no user signed in, there is no config
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.user == null)
                return Promise.resolve(new _OptumiConfig__WEBPACK_IMPORTED_MODULE_4__.OptumiConfig());
            // Fetch the config for this user + notebook from the controller
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/get-notebook-config";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    nbKey: metadata.nbKey,
                }),
            };
            return _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_2__.Global.handleResponse(response);
                return response.text();
            }).then((response) => {
                try {
                    var map = {};
                    map = JSON.parse(response);
                    return new _OptumiConfig__WEBPACK_IMPORTED_MODULE_4__.OptumiConfig(map, metadata.version);
                }
                catch (err) {
                    console.log(err);
                }
                return new _OptumiConfig__WEBPACK_IMPORTED_MODULE_4__.OptumiConfig();
            }, () => new _OptumiConfig__WEBPACK_IMPORTED_MODULE_4__.OptumiConfig());
        };
        this.refreshMetadata = async () => {
            // When the user logs in, we need to refresh metadata for them
            for (var entry of this._optumiMetadata.entries()) {
                const path = entry[0];
                const metadata = entry[1].metadata;
                this._optumiMetadata.set(path, new TrackedOptumiMetadata(path, metadata, (await this.fetchConfig(metadata))));
            }
            return Promise.resolve();
        };
        this.getMetadata = () => {
            const path = this._tracker.currentWidget.context.path;
            if (!this._optumiMetadata.has(path)) {
                return undefined;
            }
            return this._optumiMetadata.get(path);
        };
        this.setMetadata = (optumi) => {
            const rawMetadata = this._tracker.find(x => x.context.path == optumi.path).model.metadata;
            rawMetadata.set("optumi", JSON.parse(JSON.stringify(optumi.metadata)));
            this._optumiMetadata.set(optumi.path, optumi);
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnEmit)
                console.log('SignalEmit (' + new Date().getSeconds() + ')');
            this._metadataChanged.emit(void 0);
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.user == null)
                return;
            // Tell the controller about the change
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/set-notebook-config";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    nbKey: optumi.metadata.nbKey,
                    nbConfig: JSON.stringify(optumi.config),
                }),
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_2__.Global.handleResponse(response);
            });
        };
        this.getMetadataChanged = () => {
            return this._metadataChanged;
        };
        this._metadataChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);
        this._tracker = tracker;
        tracker.currentChanged.connect(() => {
            this.handleCurrentChanged(this._tracker.currentWidget);
        });
        this.handleCurrentChanged(this._tracker.currentWidget);
    }
}
class TrackedOptumiMetadata {
    constructor(path, metadata, config) {
        this.path = path;
        this.metadata = metadata;
        this.config = config;
    }
    get uuid() {
        return this.metadata.nbKey;
    }
}


/***/ }),

/***/ "./lib/models/OutputFile.js":
/*!**********************************!*\
  !*** ./lib/models/OutputFile.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OutputFile": () => (/* binding */ OutputFile)
/* harmony export */ });
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
class OutputFile {
    constructor(path, lastModified, size) {
        this.path = path;
        this.lastModified = lastModified;
        this.size = +size;
        this.lastDownloaded = "";
    }
}


/***/ }),

/***/ "./lib/models/ProgressMessage.js":
/*!***************************************!*\
  !*** ./lib/models/ProgressMessage.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ProgressMessage": () => (/* binding */ ProgressMessage)
/* harmony export */ });
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/* harmony import */ var _utils_NotebookUtils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/NotebookUtils */ "./lib/utils/NotebookUtils.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class ProgressMessage {
    constructor(statusType, updates = []) {
        this._appUUID = "";
        this.loaded = 0;
        this.total = 0;
        this.sending = false;
        this.sendQueue = [];
        this.sendNextMessage = () => {
            const nextUpdate = this.sendQueue.shift();
            if (nextUpdate) {
                this.sendMessage(nextUpdate);
            }
            else {
                this.sending = false;
            }
        };
        this.phase = statusType;
        this._updates = updates;
    }
    set appUUID(appUUID) {
        this._appUUID = appUUID;
    }
    get message() {
        for (let i = this._updates.length - 1; i >= 0; i--) {
            const update = this._updates[i];
            if (update.line != 'error' && update.line != 'stop' && update.line != '' && update.modifier != 'detail') {
                return update.line;
            }
        }
        return "";
    }
    get messages() {
        var messages = "";
        var lastNonDetail = "";
        for (let update of this._updates) {
            if (update.line != 'error' && update.line != 'stop' && update.line != '') {
                if (update.modifier == 'detail') {
                    if (update.line.startsWith('\b')) {
                        messages += ('\b\b\b\b' + update.line);
                    }
                    else {
                        messages += ('    ' + update.line);
                    }
                }
                else {
                    // Suppress duplicate update messages
                    if (update.line != lastNonDetail) {
                        messages += update.line + '\n';
                        lastNonDetail = update.line;
                    }
                }
            }
        }
        return _utils_NotebookUtils__WEBPACK_IMPORTED_MODULE_1__.default.fixOverwrittenChars(messages);
    }
    // There are cases where we do not want to send an update to the controller
    addUpdate(update, send = true) {
        if (this._updates.length == 0 || this._updates[this._updates.length - 1].line != update.line) {
            // We do not want to record the same update twice
            this._updates.push(update);
            if (send)
                this.pushStatusUpdate(update);
        }
    }
    get length() {
        return this._updates.length;
    }
    get started() {
        return this._updates.length > 0;
    }
    get elapsed() {
        try {
            const start = Date.parse(this._updates[0].modifier);
            var end = new Date().getTime();
            if (this.completed) {
                for (let update of this._updates) {
                    // If the update does not have a valid date, ignore it
                    try {
                        var date = Date.parse(update.modifier);
                        if (!isNaN(date)) {
                            end = date;
                        }
                    }
                    catch (err) { }
                }
            }
            return _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_2__.default.msToTime(end - start);
        }
        catch (err) {
            return undefined;
        }
    }
    get endTime() {
        var end = new Date().getTime();
        if (this.completed) {
            for (let update of this._updates) {
                // If the update does not have a valid date, ignore it
                try {
                    var date = Date.parse(update.modifier);
                    if (!isNaN(date)) {
                        end = date;
                    }
                }
                catch (err) { }
            }
            return new Date(end);
        }
        return undefined;
    }
    get completed() {
        for (let update of this._updates) {
            if (update.line == "stop")
                return true;
        }
        return false;
    }
    get error() {
        for (let update of this._updates) {
            if (update.line == "error")
                return true;
        }
        return false;
    }
    pushStatusUpdate(update) {
        if (this._appUUID == "") {
            console.log("Status update not pushed because app UUID is empty");
            return;
        }
        // If we are already sending a message, queue this new message
        if (this.sending) {
            this.sendQueue.push(update);
        }
        else {
            this.sending = true;
            this.sendMessage(update);
        }
    }
    sendMessage(update) {
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/push-workload-status-update";
        const init = {
            method: 'POST',
            body: JSON.stringify({
                uuid: this._appUUID,
                phase: this.phase,
                update: update.line,
            }),
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            // Send the next message (in order to try to be robust, we will send the next message even if we encountered an error sending the previous one)
            this.sendNextMessage();
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
        }, () => {
            // If we encounter an error, we will want to send the next message...
            this.sendNextMessage();
        });
    }
}


/***/ }),

/***/ "./lib/models/Snackbar.js":
/*!********************************!*\
  !*** ./lib/models/Snackbar.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "providerOptions": () => (/* binding */ providerOptions),
/* harmony export */   "Snackbar": () => (/* binding */ Snackbar)
/* harmony export */ });
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
/// NOTE: Look here for possible props: https://iamhosseindhv.com/notistack/api#enqueuesnackbar-options
const providerOptions = {
    success: { backgroundColor: '#68da7c!important' },
    error: { backgroundColor: '#f48f8d!important' },
    warning: { backgroundColor: '#ffba7d!important' },
    info: { backgroundColor: '#10A0F9!important' },
};
class Snackbar {
    constructor(message, options) {
        this.standardOptions = {
            anchorOrigin: {
                vertical: 'bottom',
                horizontal: 'center',
            },
        };
        this.message = message;
        this.options = Object.assign({}, options, this.standardOptions);
    }
}


/***/ }),

/***/ "./lib/models/StorageConfig.js":
/*!*************************************!*\
  !*** ./lib/models/StorageConfig.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StorageConfig": () => (/* binding */ StorageConfig)
/* harmony export */ });
/* harmony import */ var _OptumiConfig__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./OptumiConfig */ "./lib/models/OptumiConfig.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/

class StorageConfig {
    // Dev Ops properties
    // TODO:JJ
    constructor(map = {}, user = null) {
        this.expertise = map.expertise || _OptumiConfig__WEBPACK_IMPORTED_MODULE_0__.Expertise.BASIC;
        this.required = map.required || false;
        this.rating = map.rating || [-1, -1, -1];
        this.size = map.size || [-1, -1, -1];
        this.iops = map.iops || [-1, -1, -1];
        this.throughput = map.throughput || [-1, -1, -1];
    }
}


/***/ }),

/***/ "./lib/models/Update.js":
/*!******************************!*\
  !*** ./lib/models/Update.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Update": () => (/* binding */ Update)
/* harmony export */ });
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
class Update {
    constructor(line, modifier) {
        this.line = line;
        this.modifier = modifier;
    }
}


/***/ }),

/***/ "./lib/models/UploadConfig.js":
/*!************************************!*\
  !*** ./lib/models/UploadConfig.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "UploadConfig": () => (/* binding */ UploadConfig)
/* harmony export */ });
/* harmony import */ var _DataConnectorUploadConfig__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./DataConnectorUploadConfig */ "./lib/models/DataConnectorUploadConfig.js");
/* harmony import */ var _FileUploadConfig__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FileUploadConfig */ "./lib/models/FileUploadConfig.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/


class UploadConfig {
    constructor(map = {}) {
        this.files = [];
        this.dataConnectors = [];
        this.requirements = "";
        // Handle backwards compatible 'fileVars'
        if (map.fileVars) {
            for (let file of map.fileVars) {
                this.files.push(new _FileUploadConfig__WEBPACK_IMPORTED_MODULE_0__.FileUploadConfig(file));
            }
        }
        if (map.files) {
            for (let file of map.files) {
                this.files.push(new _FileUploadConfig__WEBPACK_IMPORTED_MODULE_0__.FileUploadConfig(file));
            }
        }
        if (map.dataConnectors) {
            for (let dataConnector of map.dataConnectors) {
                this.dataConnectors.push(new _DataConnectorUploadConfig__WEBPACK_IMPORTED_MODULE_1__.DataConnectorUploadConfig(dataConnector));
            }
        }
        this.requirements = map.requirements || "";
    }
}


/***/ }),

/***/ "./lib/models/User.js":
/*!****************************!*\
  !*** ./lib/models/User.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "User": () => (/* binding */ User)
/* harmony export */ });
/* harmony import */ var _application_App__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./application/App */ "./lib/models/application/App.js");
/* harmony import */ var _application_AppTracker__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./application/AppTracker */ "./lib/models/application/AppTracker.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/signaling */ "webpack/sharing/consume/default/@lumino/signaling");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Machines__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Machines */ "./lib/models/Machines.js");
/* harmony import */ var _machine_Machine__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./machine/Machine */ "./lib/models/machine/Machine.js");
/* harmony import */ var _components_deploy_RequirementsBar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../components/deploy/RequirementsBar */ "./lib/components/deploy/RequirementsBar.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/








class User {
    constructor(unsignedAgreement, name, phoneNumber, intent, userBudget, maxBudget, budgetCap, userRate, maxRate, rateCap, userAggregateRate, maxAggregateRate, aggregateRateCap, userHoldoverTime, maxHoldoverTime, holdoverTimeCap, userRecommendations, maxRecommendations, recommendationsCap, maxJobs, jobsCap, maxMachines, machinesCap, userExpertise, proactiveUploadsEnabled, compressFilesEnabled, lastPage, stopJobPreventEnabled, deleteJobPreventEnabled, noRequirementsPreventEnabled, noFileUploadsPreventEnabled, startSessionPreventEnabled, notificationsEnabled, appTracker, machines) {
        this._deploySubMenuChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);
        this._selectedSettingsSubMenuChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);
        this._deploySubMenu = _components_deploy_RequirementsBar__WEBPACK_IMPORTED_MODULE_2__.Page.RESOURCES;
        this._unsignedAgreement = unsignedAgreement === undefined ? true : unsignedAgreement;
        this._name = name;
        this._phoneNumber = phoneNumber;
        this._intent = intent;
        this._userBudget = userBudget;
        this._maxBudget = maxBudget;
        this._budgetCap = budgetCap;
        this._userRate = userRate;
        this._maxRate = maxRate;
        this._rateCap = rateCap;
        this._userAggregateRate = userAggregateRate;
        this._maxAggregateRate = maxAggregateRate;
        this._aggregateRateCap = aggregateRateCap;
        this._userHoldoverTime = userHoldoverTime;
        this._maxHoldoverTime = maxHoldoverTime;
        this._holdoverTimeCap = holdoverTimeCap;
        this._userRecommendations = userRecommendations;
        this._maxRecommendations = maxRecommendations;
        this._recommendationsCap = recommendationsCap;
        this._maxJobs = maxJobs;
        this._jobsCap = jobsCap;
        this._maxMachines = maxMachines;
        this._machinesCap = machinesCap;
        this._userExpertise = userExpertise;
        this._proactiveUploadsEnabled = proactiveUploadsEnabled;
        this._compressFilesEnabled = compressFilesEnabled;
        this._lastPage = lastPage;
        this._stopJobPreventEnabled = stopJobPreventEnabled;
        this._deleteJobPreventEnabled = deleteJobPreventEnabled;
        this._noRequirementsPreventEnabled = noRequirementsPreventEnabled;
        this._noFileUploadsPreventEnabled = noFileUploadsPreventEnabled;
        this._startSessionPreventEnabled = startSessionPreventEnabled;
        this._notificationsEnabled = notificationsEnabled;
        this._appTracker = appTracker;
        this._machines = machines;
    }
    // Helper function to avoid duplicate code when logging in
    static handleLogin(responseData) {
        var machines = [];
        for (var i = 0; i < responseData.machines.length; i++) {
            machines.push(Object.setPrototypeOf(responseData.machines[i], _machine_Machine__WEBPACK_IMPORTED_MODULE_3__.Machine.prototype));
        }
        const newUser = new User(responseData.newAgreement, responseData.name, responseData.phoneNumber, responseData.intent, responseData.userBudget, responseData.maxBudget, responseData.budgetCap, responseData.userRate, responseData.maxRate, responseData.rateCap, responseData.userAggregateRate, responseData.maxAggregateRate, responseData.aggregateRateCap, responseData.userHoldoverTime, responseData.maxHoldoverTime, responseData.holdoverTimeCap, responseData.userRecommendations, responseData.maxRecommendations, responseData.recommendationsCap, responseData.maxJobs, responseData.jobsCap, responseData.maxMachines, responseData.machinesCap, responseData.userExpertise, responseData.proactiveUploadsEnabled, responseData.compressFilesEnabled, responseData.lastPage, responseData.stopJobPreventEnabled, responseData.deleteJobPreventEnabled, responseData.noRequirementsPreventEnabled, responseData.noFileUploadsPreventEnabled, responseData.startSessionPreventEnabled, responseData.notificationsEnabled, new _application_AppTracker__WEBPACK_IMPORTED_MODULE_4__.AppTracker(), new _Machines__WEBPACK_IMPORTED_MODULE_5__.Machines(machines, responseData.maxRate));
        if (!newUser.unsignedAgreement)
            newUser.synchronize(responseData);
        return newUser;
    }
    get deploySubMenuChanged() {
        return this._deploySubMenuChanged;
    }
    get selectedSettingsSubMenuChanged() {
        return this._selectedSettingsSubMenuChanged;
    }
    get unsignedAgreement() {
        return this._unsignedAgreement;
    }
    set unsignedAgreement(unsignedAgreement) {
        if (unsignedAgreement === this._unsignedAgreement) {
            return;
        }
        this._unsignedAgreement = unsignedAgreement;
    }
    get name() {
        return this._name;
    }
    set name(name) {
        if (name === this._name) {
            return;
        }
        this._name = name;
    }
    get phoneNumber() {
        return this._phoneNumber;
    }
    set phoneNumber(phoneNumber) {
        if (phoneNumber === this._phoneNumber) {
            return;
        }
        this.setUserInformation("phoneNumber", phoneNumber);
        this._phoneNumber = phoneNumber;
    }
    get deploySubMenu() {
        return this._deploySubMenu;
    }
    set deploySubMenu(deploySubMenu) {
        if (deploySubMenu === this._deploySubMenu) {
            return;
        }
        this._deploySubMenu = deploySubMenu;
        if (_Global__WEBPACK_IMPORTED_MODULE_6__.Global.shouldLogOnEmit)
            console.log('SignalEmit (' + new Date().getSeconds() + ')');
        this._deploySubMenuChanged.emit(this);
    }
    get intent() {
        return this._intent;
    }
    set intent(intent) {
        if (intent === this._intent) {
            return;
        }
        this._intent = intent;
        this.setUserInformation("intent", intent.toString());
    }
    get userBudget() {
        return this._userBudget;
    }
    set userBudget(userBudget) {
        if (userBudget === this._userBudget) {
            return;
        }
        this._userBudget = userBudget;
        this.setUserInformation("userBudget", userBudget.toString());
    }
    get maxBudget() {
        return this._maxBudget;
    }
    set maxBudget(maxBudget) {
        if (maxBudget === this._maxBudget) {
            return;
        }
        this._maxBudget = maxBudget;
        this.setUserInformation("maxBudget", maxBudget.toString());
    }
    get budgetCap() {
        return this._budgetCap;
    }
    get userRate() {
        return this._userRate;
    }
    set userRate(userRate) {
        if (userRate === this._userRate) {
            return;
        }
        this._userRate = userRate;
        this.setUserInformation("userRate", userRate.toString());
    }
    get maxRate() {
        return this._maxRate;
    }
    set maxRate(maxRate) {
        if (maxRate === this._maxRate) {
            return;
        }
        this._maxRate = maxRate;
        this.setUserInformation("maxRate", maxRate.toString());
    }
    get rateCap() {
        return this._rateCap;
    }
    get userAggregateRate() {
        return this._userAggregateRate;
    }
    set userAggregateRate(userAggregateRate) {
        if (userAggregateRate === this._userAggregateRate) {
            return;
        }
        this._userAggregateRate = userAggregateRate;
        this.setUserInformation("userAggregateRate", userAggregateRate.toString());
    }
    get maxAggregateRate() {
        return this._maxAggregateRate;
    }
    set maxAggregateRate(maxAggregateRate) {
        if (maxAggregateRate === this._maxAggregateRate) {
            return;
        }
        this._maxAggregateRate = maxAggregateRate;
        this.setUserInformation("maxAggregateRate", maxAggregateRate.toString());
    }
    get aggregateRateCap() {
        return this._aggregateRateCap;
    }
    get userHoldoverTime() {
        return this._userHoldoverTime;
    }
    set userHoldoverTime(userHoldoverTime) {
        if (userHoldoverTime === this._userHoldoverTime) {
            return;
        }
        this._userHoldoverTime = userHoldoverTime;
        this.setUserInformation("userHoldoverTime", userHoldoverTime.toString());
    }
    get maxHoldoverTime() {
        return this._maxHoldoverTime;
    }
    set maxHoldoverTime(maxHoldoverTime) {
        if (maxHoldoverTime === this._maxHoldoverTime) {
            return;
        }
        this._maxHoldoverTime = maxHoldoverTime;
        this.setUserInformation("maxHoldoverTime", maxHoldoverTime.toString());
    }
    get holdoverTimeCap() {
        return this._holdoverTimeCap;
    }
    get userRecommendations() {
        return this._userRecommendations;
    }
    set userRecommendations(userRecommendations) {
        if (userRecommendations === this._userRecommendations) {
            return;
        }
        this._userRecommendations = userRecommendations;
        this.setUserInformation("userRecommendations", userRecommendations.toString());
    }
    get maxRecommendations() {
        return this._maxRecommendations;
    }
    set maxRecommendations(maxRecommendations) {
        if (maxRecommendations === this._maxRecommendations) {
            return;
        }
        this._maxRecommendations = maxRecommendations;
        this.setUserInformation("maxRecommendations", maxRecommendations.toString());
    }
    get recommendationsCap() {
        return this._recommendationsCap;
    }
    get maxJobs() {
        return this._maxJobs;
    }
    set maxJobs(maxJobs) {
        if (maxJobs === this._maxJobs) {
            return;
        }
        this._maxJobs = maxJobs;
        this.setUserInformation("maxJobs", maxJobs.toString());
    }
    get jobsCap() {
        return this._jobsCap;
    }
    get maxMachines() {
        return this._maxMachines;
    }
    set maxMachines(maxMachines) {
        if (maxMachines === this._maxMachines) {
            return;
        }
        this._maxMachines = maxMachines;
        this.setUserInformation("maxMachines", maxMachines.toString());
    }
    get machinesCap() {
        return this._machinesCap;
    }
    get userExpertise() {
        return this._userExpertise;
    }
    set userExpertise(userExpertise) {
        if (userExpertise === this._userExpertise) {
            return;
        }
        this._userExpertise = userExpertise;
        this.setUserInformation("userExpertise", userExpertise.toString());
    }
    get proactiveUploadsEnabled() {
        return this._proactiveUploadsEnabled;
    }
    set proactiveUploadsEnabled(proactiveUploadsEnabled) {
        if (proactiveUploadsEnabled === this._proactiveUploadsEnabled) {
            return;
        }
        this._proactiveUploadsEnabled = proactiveUploadsEnabled;
        this.setUserInformation("proactiveUploadsEnabled", proactiveUploadsEnabled.toString());
    }
    get compressFilesEnabled() {
        return this._compressFilesEnabled;
    }
    set compressFilesEnabled(compressFilesEnabled) {
        if (compressFilesEnabled === this._compressFilesEnabled) {
            return;
        }
        this._compressFilesEnabled = compressFilesEnabled;
        this.setUserInformation("compressFilesEnabled", compressFilesEnabled.toString());
    }
    get lastPage() {
        return this._lastPage;
    }
    set lastPage(lastPage) {
        if (lastPage === this.lastPage) {
            return;
        }
        this._lastPage = lastPage;
        this.setUserInformation("lastPage", lastPage.toString());
    }
    get stopJobPreventEnabled() {
        return this._stopJobPreventEnabled;
    }
    set stopJobPreventEnabled(stopJobPreventEnabled) {
        if (stopJobPreventEnabled === this._stopJobPreventEnabled) {
            return;
        }
        this._stopJobPreventEnabled = stopJobPreventEnabled;
        this.setUserInformation("stopJobPreventEnabled", stopJobPreventEnabled.toString());
    }
    get deleteJobPreventEnabled() {
        return this._deleteJobPreventEnabled;
    }
    set deleteJobPreventEnabled(deleteJobPreventEnabled) {
        if (deleteJobPreventEnabled === this._deleteJobPreventEnabled) {
            return;
        }
        this._deleteJobPreventEnabled = deleteJobPreventEnabled;
        this.setUserInformation("deleteJobPreventEnabled", deleteJobPreventEnabled.toString());
    }
    get noRequirementsPreventEnabled() {
        return this._noRequirementsPreventEnabled;
    }
    set noRequirementsPreventEnabled(noRequirementsPreventEnabled) {
        if (noRequirementsPreventEnabled === this._noRequirementsPreventEnabled) {
            return;
        }
        this._noRequirementsPreventEnabled = noRequirementsPreventEnabled;
        this.setUserInformation("noRequirementsPreventEnabled", noRequirementsPreventEnabled.toString());
    }
    get noFileUploadsPreventEnabled() {
        return this._noFileUploadsPreventEnabled;
    }
    set noFileUploadsPreventEnabled(noFileUploadsPreventEnabled) {
        if (noFileUploadsPreventEnabled === this._noFileUploadsPreventEnabled) {
            return;
        }
        this._noFileUploadsPreventEnabled = noFileUploadsPreventEnabled;
        this.setUserInformation("noFileUploadsPreventEnabled", noFileUploadsPreventEnabled.toString());
    }
    get startSessionPreventEnabled() {
        return this._startSessionPreventEnabled;
    }
    set startSessionPreventEnabled(startSessionPreventEnabled) {
        if (startSessionPreventEnabled === this._startSessionPreventEnabled) {
            return;
        }
        this._startSessionPreventEnabled = startSessionPreventEnabled;
        this.setUserInformation("startSessionPreventEnabled", startSessionPreventEnabled.toString());
    }
    get notificationsEnabled() {
        return this._notificationsEnabled;
    }
    set notificationsEnabled(notificationsEnabled) {
        if (notificationsEnabled === this._notificationsEnabled) {
            return;
        }
        this._notificationsEnabled = notificationsEnabled;
        this.setUserInformation("notificationsEnabled", notificationsEnabled.toString());
    }
    get appTracker() {
        return this._appTracker;
    }
    set machines(machines) {
        if (machines === this._machines) {
            return;
        }
        this._machines = machines;
    }
    get machines() {
        return this._machines;
    }
    synchronize(responseData) {
        // Add apps from user information if they don't already exist
        if (responseData.jobs) {
            NEW_APPS: for (let newApp of responseData.jobs) {
                // Ignore this app if we already have an object for it
                for (let app of this.appTracker.finishedSessions) {
                    if (app.uuid == newApp.uuid)
                        continue NEW_APPS;
                }
                for (let app of this.appTracker.finishedJobs) {
                    if (app.uuid == newApp.uuid)
                        continue NEW_APPS;
                }
                for (let app of this.appTracker.activeSessions) {
                    if (app.uuid == newApp.uuid)
                        continue NEW_APPS;
                }
                for (let app of this.appTracker.activeJobs) {
                    if (app.uuid == newApp.uuid)
                        continue NEW_APPS;
                }
                this.appTracker.addApp(_application_App__WEBPACK_IMPORTED_MODULE_7__.App.reconstruct(newApp));
            }
        }
    }
    setUserInformation(param, value) {
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/set-user-information";
        const init = {
            method: 'POST',
            body: JSON.stringify({
                'param': param,
                'value': value,
            })
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            _Global__WEBPACK_IMPORTED_MODULE_6__.Global.handleResponse(response);
        });
    }
    changePassword(loginName, oldPassword, newPassword) {
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/change-password";
        const init = {
            method: 'POST',
            body: JSON.stringify({
                'loginName': loginName,
                'oldPassword': oldPassword,
                'newPassword': newPassword,
            })
        };
        return _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            _Global__WEBPACK_IMPORTED_MODULE_6__.Global.handleResponse(response);
        });
    }
}


/***/ }),

/***/ "./lib/models/WasabiRegions.js":
/*!*************************************!*\
  !*** ./lib/models/WasabiRegions.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WasabiRegion": () => (/* binding */ WasabiRegion),
/* harmony export */   "WasabiRegions": () => (/* binding */ WasabiRegions)
/* harmony export */ });
class WasabiRegion {
    constructor(region, description) {
        this.region = region;
        this.description = description;
    }
}
class WasabiRegions {
    static get US_EAST_1() { return WasabiRegions.regions.US_EAST_1; }
    static get US_EAST_2() { return WasabiRegions.regions.US_EAST_2; }
    static get US_CENTRAL_1() { return WasabiRegions.regions.US_CENTRAL_1; }
    static get US_WEST_1() { return WasabiRegions.regions.US_WEST_1; }
    static get EU_CENTRAL_1() { return WasabiRegions.regions.EU_CENTRAL_1; }
    static get AP_NORTHEAST_1() { return WasabiRegions.regions.AP_NORTHEAST_1; }
    static get values() {
        return [
            WasabiRegions.US_EAST_1,
            WasabiRegions.US_EAST_2,
            WasabiRegions.US_CENTRAL_1,
            WasabiRegions.US_WEST_1,
            WasabiRegions.EU_CENTRAL_1,
            WasabiRegions.AP_NORTHEAST_1,
        ];
    }
}
WasabiRegions.regions = {
    US_EAST_1: new WasabiRegion("us-east-1", "US East (N. Virginia)"),
    US_EAST_2: new WasabiRegion("us-east-2", "US East (N. Virginia)"),
    US_CENTRAL_1: new WasabiRegion("us-central-1", "US Central (Texas)"),
    US_WEST_1: new WasabiRegion("us-west-1", "US West (Oregon)"),
    EU_CENTRAL_1: new WasabiRegion("eu-central-1", "EU (Amsterdam)"),
    AP_NORTHEAST_1: new WasabiRegion("ap-northeast-1", "AP (Tokyo)"),
};


/***/ }),

/***/ "./lib/models/application/App.js":
/*!***************************************!*\
  !*** ./lib/models/application/App.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Phase": () => (/* binding */ Phase),
/* harmony export */   "App": () => (/* binding */ App)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ProgressMessage__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../ProgressMessage */ "./lib/models/ProgressMessage.js");
/* harmony import */ var _Module__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Module */ "./lib/models/Module.js");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/signaling */ "webpack/sharing/consume/default/@lumino/signaling");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _OptumiConfig__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../OptumiConfig */ "./lib/models/OptumiConfig.js");
/* harmony import */ var _machine_Machine__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../machine/Machine */ "./lib/models/machine/Machine.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _Update__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Update */ "./lib/models/Update.js");
/* harmony import */ var _OutputFile__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../OutputFile */ "./lib/models/OutputFile.js");
/* harmony import */ var _Snackbar__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../Snackbar */ "./lib/models/Snackbar.js");
/* harmony import */ var _utils_FileServerUtils__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../utils/FileServerUtils */ "./lib/utils/FileServerUtils.js");
/* harmony import */ var _utils_NotebookUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/NotebookUtils */ "./lib/utils/NotebookUtils.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/* harmony import */ var _IdentityAppComponent__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./IdentityAppComponent */ "./lib/models/application/IdentityAppComponent.js");
/* harmony import */ var _AppComponent__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./AppComponent */ "./lib/models/application/AppComponent.js");
/* harmony import */ var _PopupAppComponent__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./PopupAppComponent */ "./lib/models/application/PopupAppComponent.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/

















var Phase;
(function (Phase) {
    Phase["Initializing"] = "initializing";
    Phase["Uploading"] = "uploading";
    Phase["Requisitioning"] = "requisitioning";
    Phase["Running"] = "running";
})(Phase || (Phase = {}));
class App {
    constructor(path, notebook = {}, config = new _OptumiConfig__WEBPACK_IMPORTED_MODULE_3__.OptumiConfig(), uuid = "", initializing = [], uploading = [], requisitioning = [], running = [], timestamp = new Date(), runNum = 0) {
        this._changed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);
        // Callback for module to add output to the notebook
        this.formatForNotebook = (text) => {
            // We will not fix overwritten characters in the last line, in case the last line we have wipes out all the characters without writing new ones
            // We will leave the task of removing backspace characters from the last line to the component that renders the lines
            var lastLine = text.pop();
            // Remove overwritten characters and split into lines
            const formatted = _utils_NotebookUtils__WEBPACK_IMPORTED_MODULE_4__.default.fixOverwrittenChars(text).split('\n').map(x => x + '\n');
            // Remove the extra '\n'
            formatted[formatted.length - 1] = formatted[formatted.length - 1].substr(0, formatted[formatted.length - 1].length - 1);
            // Add the last line back
            formatted.push(lastLine);
            return formatted;
        };
        this.addOutput = (line, modifier) => {
            // We do not want to add output to the notebook for an interactive session
            if (!this.interactive) {
                // TODO:JJ If modifier is input, we can not parse it
                if (modifier == 'input')
                    return;
                // TODO:JJ We could get the info that this line is error from either the modifier or the metadata
                try {
                    const parsed = JSON.parse(line);
                    const metadata = parsed.metadata;
                    const outputs = this._notebook.cells[metadata.cell].outputs;
                    // Ignore messages for markdown or raw cells
                    if (this._notebook.cells[metadata.cell].cell_type != 'code')
                        return;
                    if (metadata.status) {
                        if (metadata.status == 'started') {
                            this._notebook.cells[metadata.cell].execution_count = '*';
                        }
                        else if (metadata.status == 'ended') {
                            var count = 1;
                            for (let i = 0; i < metadata.cell; i++) {
                                if (this._notebook.cells[i].cell_type == ['code'])
                                    count++;
                            }
                            this._notebook.cells[metadata.cell].execution_count = count;
                        }
                    }
                    else {
                        if (modifier == 'output') {
                            // We will write our other status updates to output
                            if (outputs.length == 0 || outputs[outputs.length - 1].name != 'stdout') {
                                outputs.push({
                                    name: 'stdout',
                                    output_type: 'stream',
                                    text: this.formatForNotebook([parsed.text]),
                                });
                            }
                            else {
                                const text = outputs[outputs.length - 1].text;
                                text.push(parsed.text);
                                outputs[outputs.length - 1].text = this.formatForNotebook(text);
                            }
                        }
                        else if (modifier == 'error') {
                            // This could be a print to stderr (like a log message) or it could be a caught and formatted exception
                            if (parsed.text) {
                                if (outputs.length == 0 || outputs[outputs.length - 1].name != 'stderr') {
                                    outputs.push({
                                        name: 'stderr',
                                        output_type: 'stream',
                                        text: this.formatForNotebook([parsed.text]),
                                    });
                                }
                                else {
                                    const text = outputs[outputs.length - 1].text;
                                    text.push(parsed.text);
                                    outputs[outputs.length - 1].text = this.formatForNotebook(text);
                                }
                            }
                            else {
                                outputs.push({
                                    "ename": parsed.ename,
                                    "evalue": parsed.evalue,
                                    "output_type": "error",
                                    "traceback": parsed.traceback,
                                });
                            }
                        }
                        else if (modifier == 'input') {
                            // TODO:JJ
                        }
                        else {
                            console.error('Unknown modifier' + modifier);
                        }
                    }
                }
                catch (err) {
                    console.warn('Unable to add update line: ' + line);
                }
            }
        };
        this._uuid = "";
        this._modules = [];
        this.pollingDelay = 500;
        this._notebook = notebook;
        this._config = config.copy();
        this._path = path;
        this._uuid = uuid;
        this._initializing = new _ProgressMessage__WEBPACK_IMPORTED_MODULE_5__.ProgressMessage(Phase.Initializing, initializing);
        this._uploading = new _ProgressMessage__WEBPACK_IMPORTED_MODULE_5__.ProgressMessage(Phase.Uploading, uploading);
        this._requisitioning = new _ProgressMessage__WEBPACK_IMPORTED_MODULE_5__.ProgressMessage(Phase.Requisitioning, requisitioning);
        this._running = new _ProgressMessage__WEBPACK_IMPORTED_MODULE_5__.ProgressMessage(Phase.Running, running);
        if (this._uuid != "") {
            this._initializing.appUUID = this._uuid;
            this._uploading.appUUID = this._uuid;
            this._requisitioning.appUUID = this._uuid;
            this._running.appUUID = this._uuid;
        }
        this._timestamp = timestamp;
        this._runNum = runNum;
        // Handle errors where we were unable to load some of the updates
        if (this._running.started) {
            if (!this._requisitioning.completed) {
                this._requisitioning.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("Unable to retrieve requisitioning updates", ""));
                this._requisitioning.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("stop", ""));
            }
            if (!this._uploading.completed) {
                this._uploading.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("Unable to retrieve uploading updates", ""));
                this._uploading.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("stop", ""));
            }
            if (!this._initializing.completed) {
                this._initializing.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("Unable to retrieve initializing updates", ""));
                this._initializing.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("stop", ""));
            }
        }
        else if (this._requisitioning.started) {
            if (!this._uploading.completed) {
                this._uploading.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("Unable to retrieve uploading updates", ""));
                this._uploading.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("stop", ""));
            }
            if (!this._initializing.completed) {
                this._initializing.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("Unable to retrieve initializing updates", ""));
                this._initializing.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("stop", ""));
            }
        }
        else if (this._uploading.started) {
            if (!this._initializing.completed) {
                this._initializing.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("Unable to retrieve initializing updates", ""));
                this._initializing.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("stop", ""));
            }
        }
        // Handle some errors with requests failing while we get an application up and running
        if (initializing != null) {
            if (this._initializing.started && !this._initializing.completed) {
                if (this._initializing.message == "Compressing files")
                    this._initializing.total = -1;
                this.getCompressionProgress();
                return;
            }
        }
        if (uploading != null) {
            if (this._uploading.started && !this._uploading.completed) {
                this.getUploadProgress();
                return;
            }
        }
        if (requisitioning != null) {
            if (this._requisitioning.started && !this._requisitioning.completed) {
                if (this._requisitioning.message == "Waiting for cloud provider")
                    this._requisitioning.total = -1;
                return;
            }
        }
    }
    get changed() {
        return this._changed;
    }
    // Static function for generating an app from controller synchronization structure
    static reconstruct(appMap) {
        // Reconstruct the app
        const initializing = [];
        for (let i = 0; i < appMap.initializing.length; i++) {
            initializing.push(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update(appMap.initializing[i], appMap.initializingmod[i]));
        }
        const uploading = [];
        for (let i = 0; i < appMap.uploading.length; i++) {
            uploading.push(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update(appMap.uploading[i], appMap.uploadingmod[i]));
        }
        const requisitioning = [];
        for (let i = 0; i < appMap.requisitioning.length; i++) {
            requisitioning.push(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update(appMap.requisitioning[i], appMap.requisitioningmod[i]));
        }
        const running = [];
        for (let i = 0; i < appMap.running.length; i++) {
            running.push(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update(appMap.running[i], appMap.runningmod[i]));
        }
        var app = new App(appMap.name, JSON.parse(appMap.notebook), new _OptumiConfig__WEBPACK_IMPORTED_MODULE_3__.OptumiConfig(JSON.parse(appMap.nbConfig)), appMap.uuid, initializing, uploading, requisitioning, running, new Date(appMap.timestamp), appMap.runNum);
        // Add modules
        for (let module of appMap.modules) {
            const output = [];
            for (let i = 0; i < module.output.length; i++) {
                output.push(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update(module.output[i], module.outputmod[i]));
            }
            const updates = [];
            for (let i = 0; i < module.updates.length; i++) {
                updates.push(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update(module.updates[i], module.updatesmod[i]));
            }
            const files = [];
            for (let i = 0; i < module.files.length; i++) {
                if (module.files[i] != '') {
                    files.push(new _OutputFile__WEBPACK_IMPORTED_MODULE_7__.OutputFile(module.files[i], module.filesmod[i], module.filessize[i]));
                }
            }
            var mod = new _Module__WEBPACK_IMPORTED_MODULE_8__.Module(module.uuid, appMap.uuid, app.addOutput, module.machine ? Object.setPrototypeOf(module.machine, _machine_Machine__WEBPACK_IMPORTED_MODULE_9__.Machine.prototype) : null, module.token, output, updates, files);
            app._modules.push(mod);
            if (mod.modStatus == _Module__WEBPACK_IMPORTED_MODULE_8__.Status.RUNNING) {
                // The module is still running
                if (!app._initializing.completed || !app._uploading.completed || !app._requisitioning.completed || !app._running.completed) {
                    // Don't poll the module if the app is not running
                    if (app.interactive)
                        mod.startSessionHandler();
                }
            }
        }
        return app;
    }
    handleUpdate(body) {
        let updated = false;
        if (body.initializing != null) {
            if (body.initializing.length > 0)
                updated = true;
            for (let i = 0; i < body.initializing.length; i++) {
                this._initializing.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update(body.initializing[i], body.initializingmod[i]), false);
            }
        }
        if (body.uploading != null) {
            if (body.uploading.length > 0)
                updated = true;
            for (let i = 0; i < body.uploading.length; i++) {
                this._uploading.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update(body.uploading[i], body.uploadingmod[i]), false);
            }
        }
        if (body.requisitioning != null) {
            if (body.requisitioning.length > 0)
                updated = true;
            for (let i = 0; i < body.requisitioning.length; i++) {
                this._requisitioning.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update(body.requisitioning[i], body.requisitioningmod[i]), false);
                // Special case a warning when we fail to get a machine and start trying a new one
                if (body.requisitioning[i].startsWith('Machine unavailable, trying another')) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnEmit)
                        console.log('SignalEmit (' + new Date().getSeconds() + ')');
                    _Global__WEBPACK_IMPORTED_MODULE_10__.Global.snackbarChange.emit(new _Snackbar__WEBPACK_IMPORTED_MODULE_11__.Snackbar(this.name + ": " + body.requisitioning[i], { variant: 'warning', }));
                }
                // Special case loading bar while waiting for a server
                if (this._requisitioning.message == "Waiting for cloud provider") {
                    this._requisitioning.total = -1;
                }
                else {
                    this._requisitioning.total = 0;
                }
            }
        }
        if (body.running != null) {
            if (body.running.length > 0)
                updated = true;
            for (let i = 0; i < body.running.length; i++) {
                if (body.running[i] == 'Completed') {
                    if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnEmit)
                        console.log('SignalEmit (' + new Date().getSeconds() + ')');
                    _Global__WEBPACK_IMPORTED_MODULE_10__.Global.snackbarChange.emit(new _Snackbar__WEBPACK_IMPORTED_MODULE_11__.Snackbar(this.name + ": " + body.running[i], { variant: 'success', }));
                }
                else if (body.running[i] == 'Failed') {
                    if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnEmit)
                        console.log('SignalEmit (' + new Date().getSeconds() + ')');
                    _Global__WEBPACK_IMPORTED_MODULE_10__.Global.snackbarChange.emit(new _Snackbar__WEBPACK_IMPORTED_MODULE_11__.Snackbar(this.name + ": " + body.running[i], { variant: 'error', }));
                }
                else if (body.running[i] == 'Terminated') {
                    // We will proactively disconnect the session here
                    for (var module of this._modules) {
                        module.stopSessionHandler();
                    }
                }
                this._running.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update(body.running[i], body.runningmod[i]), false);
            }
        }
        return updated;
    }
    get notebook() {
        return this._notebook;
    }
    get config() {
        return this._config;
    }
    set config(config) {
        // Make sure we don't have a reference to configuration that will be changed
        this._config = config.copy();
        // Tell the controller about the change
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/push-workload-config";
        const init = {
            method: 'POST',
            body: JSON.stringify({
                workload: this._uuid,
                nbConfig: JSON.stringify(config),
            }),
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            _Global__WEBPACK_IMPORTED_MODULE_10__.Global.handleResponse(response);
        });
    }
    get path() {
        return this._path;
    }
    get name() {
        return this._path.split('/').pop().replace('.ipynb', '');
    }
    get uuid() {
        return this._uuid;
    }
    get modules() {
        return this._modules;
    }
    get initializing() {
        return this._initializing;
    }
    get uploading() {
        return this._uploading;
    }
    get requisitioning() {
        return this._requisitioning;
    }
    get running() {
        return this._running;
    }
    get timestamp() {
        return this._timestamp;
    }
    get runNum() {
        return this._runNum;
    }
    get failed() {
        for (let mod of this.modules) {
            if (mod.error)
                return true;
        }
        return this._initializing.error || this._uploading.error || this._requisitioning.error || this._running.error;
    }
    get interactive() {
        return this._config.interactive;
    }
    get sessionToken() {
        for (let mod of this.modules) {
            if (mod.sessionToken)
                return mod.sessionToken;
        }
        return undefined;
    }
    get sessionPort() {
        for (let mod of this.modules) {
            if (mod.sessionPort)
                return mod.sessionPort;
        }
        return undefined;
    }
    get machine() {
        for (let mod of this.modules) {
            if (mod.machine)
                return mod.machine;
        }
        return undefined;
    }
    getComponent(openUserDialogTo) {
        return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AppComponent__WEBPACK_IMPORTED_MODULE_12__.AppComponent, { key: this.uuid, app: this, openUserDialogTo: openUserDialogTo });
    }
    getPopupComponent(onOpen, onClose, openUserDialogTo) {
        return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_PopupAppComponent__WEBPACK_IMPORTED_MODULE_13__.PopupAppComponent, { key: this.uuid, app: this, onOpen: onOpen, onClose: onClose, openUserDialogTo: openUserDialogTo });
    }
    getIdentityComponent() {
        return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_IdentityAppComponent__WEBPACK_IMPORTED_MODULE_14__.IdentityAppComponent, { key: this.path, app: this });
    }
    async previewNotebook(printRecommendations) {
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/preview-notebook";
        const init = {
            method: 'POST',
            body: JSON.stringify({
                nbConfig: JSON.stringify(this._config),
            }),
        };
        return _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            _Global__WEBPACK_IMPORTED_MODULE_10__.Global.handleResponse(response);
            return response.json();
        }).then((body) => {
            if (printRecommendations) {
                console.log("////");
                console.log("///  Start Recommendations: ");
                console.log("//");
                for (let machine of body.machines) {
                    console.log(Object.setPrototypeOf(machine, _machine_Machine__WEBPACK_IMPORTED_MODULE_9__.Machine.prototype));
                }
                console.log("//");
                console.log("///  End Recommendations: ");
                console.log("////");
            }
            if (body.machines.length == 0)
                return [new _machine_Machine__WEBPACK_IMPORTED_MODULE_9__.NoMachine()]; // we have no recommendations
            const machines = [];
            for (let machine of body.machines) {
                machines.push(Object.setPrototypeOf(machine, _machine_Machine__WEBPACK_IMPORTED_MODULE_9__.Machine.prototype));
            }
            return machines;
        });
    }
    // We only want to add this app to the app tracker if the initialization succeeds
    async setupNotebook(appTracker) {
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/setup-notebook";
        const init = {
            method: 'POST',
            body: JSON.stringify({
                name: this._path,
                timestamp: this._timestamp.toISOString(),
                notebook: {
                    path: this._path,
                    content: JSON.stringify(this._notebook),
                },
                nbConfig: JSON.stringify(this._config),
            }),
        };
        return _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            _Global__WEBPACK_IMPORTED_MODULE_10__.Global.handleResponse(response);
            return response.json();
        }).then((body) => {
            if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnEmit)
                console.log('SignalEmit (' + new Date().getSeconds() + ')');
            _Global__WEBPACK_IMPORTED_MODULE_10__.Global.jobLaunched.emit(void 0);
            this._uuid = body.uuid;
            this._runNum = body.runNum;
            this._initializing.appUUID = this._uuid;
            this._uploading.appUUID = this._uuid;
            this._requisitioning.appUUID = this._uuid;
            this._running.appUUID = this._uuid;
            this._initializing.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("Initializing", ""));
            appTracker.addApp(this);
            if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnEmit)
                console.log('SignalEmit (' + new Date().getSeconds() + ')');
            this._changed.emit(this);
            this.launchNotebook();
        });
    }
    getLaunchStatus() {
        // If there is an unsigned agreement, do not poll
        if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.user != null && _Global__WEBPACK_IMPORTED_MODULE_10__.Global.user.unsignedAgreement) {
            if (!this.failed) {
                if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnPoll)
                    console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                setTimeout(() => this.getLaunchStatus(), this.pollingDelay);
            }
            return;
        }
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/get-launch-status";
        const init = {
            method: 'POST',
            body: JSON.stringify({
                uuid: this._uuid,
            }),
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            _Global__WEBPACK_IMPORTED_MODULE_10__.Global.handleResponse(response);
            if (response.status == 204) {
                if (!this.failed) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnPoll)
                        console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                    setTimeout(() => this.getLaunchStatus(), this.pollingDelay);
                }
                return;
            }
            return response.json();
        }).then((body) => {
            if (body) {
                if (body.status == "Finished") {
                    for (let i = 0; i < body.modules.length; i++) {
                        const mod = new _Module__WEBPACK_IMPORTED_MODULE_8__.Module(body.modules[i], this._uuid, this.addOutput);
                        this._modules.push(mod);
                        if (this.interactive)
                            mod.startSessionHandler();
                    }
                }
                else if (body.status == "Failed") {
                    if (!this._initializing.completed) {
                        this._initializing.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update(body.message || 'Initialization failed', ""));
                        this._initializing.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("error", ""));
                        this._initializing.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("stop", ""));
                    }
                    else if (!this._uploading.completed) {
                        this._uploading.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update(body.message || 'File upload failed', ""));
                        this._uploading.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("error", ""));
                        this._uploading.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("stop", ""));
                    }
                    if (body.snackbar) {
                        if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnEmit)
                            console.log('SignalEmit (' + new Date().getSeconds() + ')');
                        _Global__WEBPACK_IMPORTED_MODULE_10__.Global.snackbarChange.emit(new _Snackbar__WEBPACK_IMPORTED_MODULE_11__.Snackbar(this.name + ": " + body.snackbar, { variant: 'error', }));
                    }
                }
                else {
                    if (!this.failed) {
                        if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnPoll)
                            console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                        setTimeout(() => this.getLaunchStatus(), this.pollingDelay);
                    }
                }
                if (JSON.stringify(body) !== JSON.stringify(this.previousLaunchStatus)) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnEmit)
                        console.log('SignalEmit (' + new Date().getSeconds() + ')');
                    this._changed.emit(this);
                    this.previousLaunchStatus = body;
                }
            }
        }, (error) => {
            if (!this.failed) {
                if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnPoll)
                    console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                setTimeout(() => this.getLaunchStatus(), this.pollingDelay);
            }
        });
    }
    getCompressionProgress() {
        // If there is an unsigned agreement, do not poll
        if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.user != null && _Global__WEBPACK_IMPORTED_MODULE_10__.Global.user.unsignedAgreement) {
            if (!this.failed) {
                if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnPoll)
                    console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                setTimeout(() => this.getCompressionProgress(), this.pollingDelay);
            }
            return;
        }
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/get-launch-compression-progress";
        const init = {
            method: 'POST',
            body: JSON.stringify({
                uuid: this._uuid,
            }),
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            _Global__WEBPACK_IMPORTED_MODULE_10__.Global.handleResponse(response);
            if (response.status == 204) {
                if (!this.failed) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnPoll)
                        console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                    setTimeout(() => this.getCompressionProgress(), this.pollingDelay);
                }
                return;
            }
            return response.json();
        }).then((body) => {
            if (body) {
                if (this._initializing.message != "Compressing files") {
                    this._initializing.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("Compressing files", ""));
                }
                this._initializing.loaded = body.read;
                this._initializing.total = body.total;
                if (body.read != 0 && body.read == body.total) {
                    // Do nothing
                }
                else {
                    if (!this.failed) {
                        if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnPoll)
                            console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                        setTimeout(() => this.getCompressionProgress(), this.pollingDelay);
                    }
                }
                if (JSON.stringify(body) !== JSON.stringify(this.previousCompressionProgress)) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnEmit)
                        console.log('SignalEmit (' + new Date().getSeconds() + ')');
                    this._changed.emit(this);
                    this.previousCompressionProgress = body;
                }
            }
        }, (error) => {
            if (!this.failed) {
                if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnPoll)
                    console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                setTimeout(() => this.getCompressionProgress(), this.pollingDelay);
            }
        });
    }
    getUploadProgress() {
        // If there is an unsigned agreement, do not poll
        if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.user != null && _Global__WEBPACK_IMPORTED_MODULE_10__.Global.user.unsignedAgreement) {
            if (!this.failed) {
                if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnPoll)
                    console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                setTimeout(() => this.getUploadProgress(), this.pollingDelay);
            }
            return;
        }
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/get-launch-upload-progress";
        const init = {
            method: 'POST',
            body: JSON.stringify({
                uuid: this._uuid,
            }),
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            _Global__WEBPACK_IMPORTED_MODULE_10__.Global.handleResponse(response);
            if (response.status == 204) {
                if (!this.failed) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnPoll)
                        console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                    setTimeout(() => this.getUploadProgress(), this.pollingDelay);
                }
                return;
            }
            return response.json();
        }).then((body) => {
            if (body) {
                if (!this._initializing.completed) {
                    this._initializing.total = 0;
                    this._initializing.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("stop", ""));
                    this._uploading.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("Uploading files", ""));
                }
                this._uploading.loaded = body.read;
                this._uploading.total = body.total;
                if (body.read != 0 && body.read == body.total) {
                    this._uploading.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update("stop", ""));
                }
                else {
                    if (!this.failed) {
                        if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnPoll)
                            console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                        setTimeout(() => this.getUploadProgress(), this.pollingDelay);
                    }
                }
                if (JSON.stringify(body) !== JSON.stringify(this.previousUploadProgress)) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnEmit)
                        console.log('SignalEmit (' + new Date().getSeconds() + ')');
                    this._changed.emit(this);
                    this.previousUploadProgress = body;
                }
            }
        }, (error) => {
            if (!this.failed) {
                if (_Global__WEBPACK_IMPORTED_MODULE_10__.Global.shouldLogOnPoll)
                    console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                setTimeout(() => this.getUploadProgress(), this.pollingDelay);
            }
        });
    }
    // Convert and send a python notebook to the REST interface for deployment
    async launchNotebook() {
        const uploadFiles = this._config.upload.files;
        const requirements = this._config.upload.requirements;
        const compressFiles = _Global__WEBPACK_IMPORTED_MODULE_10__.Global.user.compressFilesEnabled;
        var data = {};
        if (requirements != null) {
            data.requirementsFile = requirements;
        }
        data.dataFiles = [];
        for (var uploadEntry of uploadFiles) {
            if (uploadEntry.type == 'directory') {
                for (var file of (await _utils_FileServerUtils__WEBPACK_IMPORTED_MODULE_15__.default.getRecursiveTree(uploadEntry.path))) {
                    data.dataFiles.push(file);
                }
            }
            else {
                data.dataFiles.push(uploadEntry.path);
            }
        }
        data.compress = compressFiles;
        data.uuid = this._uuid;
        data.notebook = {
            path: this._path,
            content: JSON.stringify(this._notebook),
        };
        data.timestamp = this._timestamp.toISOString();
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/launch-notebook";
        const init = {
            method: 'POST',
            body: JSON.stringify(data),
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            _Global__WEBPACK_IMPORTED_MODULE_10__.Global.handleResponse(response);
        }, (error) => {
            this._initializing.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update('Initialization failed', ""));
            this._initializing.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update('error', ""));
            this._initializing.addUpdate(new _Update__WEBPACK_IMPORTED_MODULE_6__.Update('stop', ""));
        });
        this.getLaunchStatus();
        if (compressFiles && data.dataFiles.length != 0)
            this.getCompressionProgress();
        this.getUploadProgress();
    }
    getAppStatus() {
        if (this.initializing.error && !this.uploading.started)
            return _Module__WEBPACK_IMPORTED_MODULE_8__.Status.COMPLETED;
        if (this.uploading.error && !this.requisitioning.started)
            return _Module__WEBPACK_IMPORTED_MODULE_8__.Status.COMPLETED;
        if (this.requisitioning.error && !this.running.started)
            return _Module__WEBPACK_IMPORTED_MODULE_8__.Status.COMPLETED;
        for (var mod of this._modules) {
            if (mod.modStatus == _Module__WEBPACK_IMPORTED_MODULE_8__.Status.RUNNING)
                return _Module__WEBPACK_IMPORTED_MODULE_8__.Status.RUNNING;
        }
        if (this.running.completed)
            return _Module__WEBPACK_IMPORTED_MODULE_8__.Status.COMPLETED;
        if (this.uploading.completed)
            return _Module__WEBPACK_IMPORTED_MODULE_8__.Status.RUNNING;
        return _Module__WEBPACK_IMPORTED_MODULE_8__.Status.INITIALIZING;
    }
    getAppMessage() {
        var message = "";
        if (this._initializing.message != "")
            message = this._initializing.message;
        if (this._uploading.message != "")
            message = this._uploading.message;
        if (this._requisitioning.message != "")
            message = this._requisitioning.message;
        if (this._running.message != "")
            message = this._running.message;
        // We will say a session is starting until we can connect to it
        if (this.interactive && message == 'Running' && !(this.modules.length > 0 && this.modules[0].sessionReady))
            return 'Starting';
        // We call a terminated app 'closed'
        if (this.interactive && message == 'Terminated')
            return 'Closed';
        return message;
    }
    getTimeElapsed() {
        if (!this._initializing.completed)
            return undefined;
        if (!this._uploading.completed)
            return undefined;
        if (!this._requisitioning.completed)
            return undefined;
        return this._running.elapsed;
    }
    getEndTime() {
        if (!this._initializing.completed)
            return undefined;
        if (!this._uploading.completed)
            return undefined;
        if (!this._requisitioning.completed)
            return undefined;
        return this._running.endTime;
    }
    getCost() {
        if (this.getTimeElapsed() == undefined)
            return undefined;
        if (this.machine == undefined)
            return undefined;
        var rate = this.machine.rate;
        const split = this.getTimeElapsed().split(':');
        if (split.length == 3) {
            const hours = +split[0];
            const minutes = +split[1];
            const seconds = +split[2];
            const cost = ((hours * rate) + (minutes * rate / 60) + (seconds * rate / 3600));
            return (cost.toFixed(2) == '0.00' ? '< $0.01' : '~ $' + cost.toFixed(2));
        }
        else {
            const minutes = +split[0];
            const seconds = +split[1];
            const cost = ((minutes * rate / 60) + (seconds * rate / 3600));
            return (cost.toFixed(2) == '0.00' ? '< $0.01' : '~ $' + cost.toFixed(2));
        }
    }
    getShowLoading() {
        if (this._running.started)
            return this._running.loaded != this._running.total;
        if (this._requisitioning.started)
            return this._requisitioning.loaded != this._requisitioning.total;
        if (this._uploading.started)
            return this._uploading.loaded != this._uploading.total;
        if (this._initializing.started)
            return this._initializing.loaded != this._initializing.total;
        return false;
    }
    getPercentLoaded() {
        if (!this._initializing.completed)
            return undefined;
        if (!this._uploading.completed)
            return this._uploading.total == -1 ? undefined : this._uploading.loaded / this._uploading.total;
        if (!this._requisitioning.completed)
            return this._requisitioning.total == -1 ? undefined : this._requisitioning.loaded / this._requisitioning.total;
        if (!this._running.completed)
            return this._running.total == -1 ? undefined : this._running.loaded / this._running.total;
        return undefined;
    }
    getLoadingTooltip() {
        if (!this.getShowLoading())
            return undefined;
        if (!this._initializing.completed)
            return this._initializing.loaded + '/' + this._initializing.total + ' files';
        if (!this._uploading.completed)
            return this._uploading.total == -1 ? '' : _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_16__.default.styleCapacityUnitValue()(this._uploading.loaded) + '/' + _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_16__.default.styleCapacityUnitValue()(this._uploading.total);
        if (!this._requisitioning.completed)
            return this._requisitioning.total == -1 ? '' : _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_16__.default.styleCapacityUnitValue()(this._requisitioning.loaded / Math.pow(1024, 2)) + '/' + _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_16__.default.styleCapacityUnitValue()(this._requisitioning.total / Math.pow(1024, 2));
        if (!this._running.completed)
            return this._running.total == -1 ? '' : _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_16__.default.styleCapacityUnitValue()(this._running.loaded / Math.pow(1024, 2)) + '/' + _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_16__.default.styleCapacityUnitValue()(this._running.total / Math.pow(1024, 2));
    }
    getError() {
        if (this.failed) {
            return true;
        }
        for (var mod of this._modules) {
            if (mod.error) {
                return true;
            }
        }
        return false;
    }
}


/***/ }),

/***/ "./lib/models/application/AppComponent.js":
/*!************************************************!*\
  !*** ./lib/models/application/AppComponent.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppComponent": () => (/* binding */ AppComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Module__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Module */ "./lib/models/Module.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _components_InfoSkirt__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../components/InfoSkirt */ "./lib/components/InfoSkirt.js");
/* harmony import */ var _components_StatusWrapper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../components/StatusWrapper */ "./lib/components/StatusWrapper.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _material_ui_icons_Clear__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @material-ui/icons/Clear */ "./node_modules/@material-ui/icons/Clear.js");
/* harmony import */ var _material_ui_icons_Check__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @material-ui/icons/Check */ "./node_modules/@material-ui/icons/Check.js");
/* harmony import */ var _material_ui_icons_Delete__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @material-ui/icons/Delete */ "./node_modules/@material-ui/icons/Delete.js");
/* harmony import */ var _material_ui_icons_Stop__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @material-ui/icons/Stop */ "./node_modules/@material-ui/icons/Stop.js");
/* harmony import */ var _components_Tag__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../components/Tag */ "./lib/components/Tag.js");
/* harmony import */ var _core_WarningPopup__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/WarningPopup */ "./lib/core/WarningPopup.js");
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/














class AppComponent extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.getDeleteJobPreventValue = () => {
            return _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.deleteJobPreventEnabled;
        };
        this.saveDeleteJobPreventValue = (prevent) => {
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.deleteJobPreventEnabled = prevent;
        };
        this.handleDeleteClicked = () => {
            this.safeSetState({ waiting: true, spinning: false });
            setTimeout(() => this.safeSetState({ spinning: true }), 1000);
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/teardown-notebook";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    uuid: this.props.app.uuid,
                }),
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                this.safeSetState({ waiting: false });
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.appTracker.removeApp(this.props.app.uuid);
            });
        };
        this.getStopJobPreventValue = () => {
            return _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.stopJobPreventEnabled;
        };
        this.saveStopJobPreventValue = (prevent) => {
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.stopJobPreventEnabled = prevent;
        };
        this.handleStopClicked = () => {
            this.safeSetState({ waiting: true, spinning: false });
            setTimeout(() => this.safeSetState({ spinning: true }), 1000);
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/stop-notebook";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    uuid: this.props.app.uuid,
                }),
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                this.safeSetState({ waiting: false });
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
            });
        };
        this.getStatusColor = () => {
            if (this.props.app.getAppMessage() == 'Closed' || this.props.app.getAppMessage() == 'Terminated') {
                return _components_StatusWrapper__WEBPACK_IMPORTED_MODULE_4__.StatusColor.DARK_GRAY;
            }
            if (this.props.app.getError()) {
                return _components_StatusWrapper__WEBPACK_IMPORTED_MODULE_4__.StatusColor.RED;
            }
            else {
                const appStatus = this.props.app.getAppStatus();
                if (appStatus == _Module__WEBPACK_IMPORTED_MODULE_5__.Status.INITIALIZING) {
                    return _components_StatusWrapper__WEBPACK_IMPORTED_MODULE_4__.StatusColor.BLUE;
                }
                else {
                    return _components_StatusWrapper__WEBPACK_IMPORTED_MODULE_4__.StatusColor.GREEN;
                }
            }
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            var tags = [];
            var app = this.props.app;
            // Get the right progress message...
            var appMessage = app.getAppMessage();
            const loadingTooltip = this.props.app.getLoadingTooltip();
            tags.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_6__.default, { key: 'appMessage', reminder: (loadingTooltip === '' || loadingTooltip === undefined) ? 'Status' : loadingTooltip },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_Tag__WEBPACK_IMPORTED_MODULE_7__.Tag, { key: 'appMessage', id: app.uuid + appMessage, icon: app.getAppStatus() == _Module__WEBPACK_IMPORTED_MODULE_5__.Status.COMPLETED ? (app.getError() ? ((app.getAppMessage() == 'Closed' || app.getAppMessage() == 'Terminated' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_Clear__WEBPACK_IMPORTED_MODULE_8__.default, { style: {
                            height: '14px',
                            width: '14px',
                            fill: 'gray',
                        } })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_Clear__WEBPACK_IMPORTED_MODULE_8__.default, { style: {
                            height: '14px',
                            width: '14px',
                            fill: '#ffffff',
                        } })))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_Check__WEBPACK_IMPORTED_MODULE_9__.default, { style: {
                            height: '14px',
                            width: '14px',
                            fill: '#ffffff',
                        } }))) : undefined, label: appMessage, color: (this.props.app.getShowLoading() || app.getAppStatus() == _Module__WEBPACK_IMPORTED_MODULE_5__.Status.COMPLETED) ? this.getStatusColor() : undefined, solid: app.getAppStatus() == _Module__WEBPACK_IMPORTED_MODULE_5__.Status.COMPLETED && (app.getAppMessage() != 'Closed' && app.getAppMessage() != 'Terminated'), showLoading: this.props.app.getShowLoading(), percentLoaded: this.props.app.getPercentLoaded() })));
            var appElapsed = app.getTimeElapsed();
            tags.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_6__.default, { key: 'appElapsed', reminder: 'Duration' },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_Tag__WEBPACK_IMPORTED_MODULE_7__.Tag, { key: 'appElapsed', label: appElapsed })));
            var appCost = app.getCost();
            if (appCost) {
                tags.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_6__.default, { key: 'appCost', reminder: 'Cost' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_Tag__WEBPACK_IMPORTED_MODULE_7__.Tag, { key: 'appCost', label: appCost })));
            }
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_StatusWrapper__WEBPACK_IMPORTED_MODULE_4__.StatusWrapper, { key: this.props.app.uuid, statusColor: app.getAppStatus() == _Module__WEBPACK_IMPORTED_MODULE_5__.Status.COMPLETED ? 'var(--jp-layout-color2)' : this.getStatusColor(), opened: this.state.opened },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_InfoSkirt__WEBPACK_IMPORTED_MODULE_10__.InfoSkirt, { leftButton: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_6__.default, { reminder: 'See details' }, this.props.app.getPopupComponent(() => this.safeSetState({ opened: true }), () => this.safeSetState({ opened: false }), this.props.openUserDialogTo)), rightButton: (this.props.app.requisitioning.completed && !this.props.app.requisitioning.error) && !this.props.app.running.completed ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_WarningPopup__WEBPACK_IMPORTED_MODULE_11__.default, { open: this.state.showStopJobPopup, headerText: "Are you sure?", bodyText: (() => {
                                    if (this.props.app.interactive) {
                                        return "This session is active. If you close it, the session cannot be resumed.";
                                    }
                                    else {
                                        return "This job is running. If you terminate it, the job cannot be resumed.";
                                    }
                                })(), preventText: "Don't ask me again", cancel: {
                                    text: `Cancel`,
                                    onCancel: (prevent) => {
                                        // this.saveStopJobPreventValue(prevent)
                                        this.safeSetState({ showStopJobPopup: false });
                                    },
                                }, continue: {
                                    text: (() => {
                                        if (this.props.app.interactive) {
                                            return "Close it";
                                        }
                                        else {
                                            return "Terminate it";
                                        }
                                    })(),
                                    onContinue: (prevent) => {
                                        this.safeSetState({ showStopJobPopup: false });
                                        this.saveStopJobPreventValue(prevent);
                                        this.handleStopClicked();
                                    },
                                    color: `error`,
                                } }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.IconButton, { disabled: this.state.waiting, onClick: () => {
                                    if (this.getStopJobPreventValue()) {
                                        this.handleStopClicked();
                                    }
                                    else {
                                        this.safeSetState({ showStopJobPopup: true });
                                    }
                                }, style: {
                                    position: 'relative',
                                    display: 'inline-block',
                                    width: '36px',
                                    height: '36px',
                                    padding: '3px',
                                } },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_6__.default, { reminder: this.props.app.interactive ? 'Stop' : 'Terminate' },
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_Stop__WEBPACK_IMPORTED_MODULE_12__.default, { style: {
                                            position: 'relative',
                                            width: '30px',
                                            height: '30px',
                                            padding: '3px',
                                        } })),
                                this.state.waiting && this.state.spinning && react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.CircularProgress, { size: '30px', style: { position: 'absolute' } })))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_WarningPopup__WEBPACK_IMPORTED_MODULE_11__.default, { open: this.state.showDeleteJobPopup, headerText: "Are you sure?", bodyText: (() => {
                                    if (this.props.app.interactive) {
                                        return "You will lose all session information and any files that have not been downloaded. This cannot be undone.";
                                    }
                                    else {
                                        return "You will lose all job information and any files that have not been downloaded. This cannot be undone.";
                                    }
                                })(), preventText: "Don't ask me again", cancel: {
                                    text: `Cancel`,
                                    onCancel: (prevent) => {
                                        // this.saveDeleteJobPreventValue(prevent)
                                        this.safeSetState({ showDeleteJobPopup: false });
                                    },
                                }, continue: {
                                    text: `Delete it`,
                                    onContinue: (prevent) => {
                                        this.safeSetState({ showDeleteJobPopup: false });
                                        this.saveDeleteJobPreventValue(prevent);
                                        this.handleDeleteClicked();
                                    },
                                    color: `error`,
                                } }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_6__.default, { reminder: 'Delete' },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.IconButton, { disabled: this.state.waiting || !this.props.app.initializing.completed, onClick: () => {
                                        if (this.getDeleteJobPreventValue() || !this.props.app.running.started) {
                                            this.handleDeleteClicked();
                                        }
                                        else {
                                            this.safeSetState({ showDeleteJobPopup: true });
                                        }
                                    }, style: { position: 'relative', display: 'inline-block', width: '36px', height: '36px', padding: '3px' } },
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_Delete__WEBPACK_IMPORTED_MODULE_13__.default, { style: { position: 'relative', width: '30px', height: '30px', padding: '3px' } }),
                                    this.state.waiting && this.state.spinning && react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.CircularProgress, { size: '30px', style: { position: 'absolute' } }))))), tags: tags }, this.props.app.getIdentityComponent()))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.state = {
            opened: false,
            waiting: false,
            spinning: false,
            showDeleteJobPopup: false,
            showStopJobPopup: false,
        };
    }
}


/***/ }),

/***/ "./lib/models/application/AppLaunchComponent.js":
/*!******************************************************!*\
  !*** ./lib/models/application/AppLaunchComponent.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppLaunchComponent": () => (/* binding */ AppLaunchComponent)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _core_WarningPopup__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/WarningPopup */ "./lib/core/WarningPopup.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/* harmony import */ var _App__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./App */ "./lib/models/application/App.js");
/* harmony import */ var _components_LaunchSkirt__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../components/LaunchSkirt */ "./lib/components/LaunchSkirt.js");
/* harmony import */ var _components_Tag__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../components/Tag */ "./lib/components/Tag.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/








class AppLaunchComponent extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleLaunchClick = async () => {
            const current = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.tracker.currentWidget;
            if (current != null) {
                this.safeSetState({ waiting: true, spinning: false });
                setTimeout(() => this.safeSetState({ spinning: true }), 1000);
                const notebook = current.model.toJSON();
                // Clear any cell outputs and execution counts
                const config = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata.getMetadata().config;
                if (!config.interactive) {
                    for (var cell of notebook.cells) {
                        cell.outputs = [];
                        cell.execution_count = null;
                    }
                }
                // Save the notebook before transferring
                await current.context.save();
                const app = new _App__WEBPACK_IMPORTED_MODULE_3__.App(current.context.path, notebook, config);
                app.setupNotebook(_Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.appTracker).then(
                // on success or error, we stop waiting
                () => this.safeSetState({ waiting: false }), () => this.safeSetState({ waiting: false }));
            }
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            var tags = [];
            var left = 'Concurrent launches: ';
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.appTracker.getDisplayNum() == 0) {
                left += 'Max ' + _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.maxMachines.toString();
            }
            else {
                left += _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.appTracker.getDisplayNum().toString() + ' of ' + _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.maxMachines.toString();
            }
            tags.push(react__WEBPACK_IMPORTED_MODULE_1__.createElement(_components_Tag__WEBPACK_IMPORTED_MODULE_4__.Tag, { key: 'left', label: left }));
            const user = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user;
            return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_components_LaunchSkirt__WEBPACK_IMPORTED_MODULE_5__.LaunchSkirt, { launchButton: react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core_WarningPopup__WEBPACK_IMPORTED_MODULE_6__.default, { open: this.state.showNoRequirementsPopup && this.state.showNoFileUploadsPopup, headerText: "Heads up!", bodyText: `If your notebook imports packages or reads local data files, you'll want to add them under "Packages" and "Files".`, preventText: "Don't warn me again", cancel: {
                            text: `Cancel`,
                            onCancel: (prevent) => {
                                this.safeSetState({ showNoRequirementsPopup: false, showNoFileUploadsPopup: false });
                            },
                        }, continue: {
                            text: `Launch it`,
                            onContinue: (prevent) => {
                                this.safeSetState({ showNoRequirementsPopup: false, showNoFileUploadsPopup: false });
                                _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.noRequirementsPreventEnabled = prevent;
                                _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.noFileUploadsPreventEnabled = prevent;
                                this.handleLaunchClick();
                            },
                            color: `primary`,
                        } }),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core_WarningPopup__WEBPACK_IMPORTED_MODULE_6__.default, { open: this.state.showNoRequirementsPopup && !this.state.showNoFileUploadsPopup, headerText: "Heads up!", bodyText: `If your notebook imports packages, you'll want to add them under "Packages".`, preventText: "Don't warn me again", cancel: {
                            text: `Cancel`,
                            onCancel: (prevent) => {
                                this.safeSetState({ showNoRequirementsPopup: false });
                            },
                        }, continue: {
                            text: `Launch it`,
                            onContinue: (prevent) => {
                                this.safeSetState({ showNoRequirementsPopup: false });
                                _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.noRequirementsPreventEnabled = prevent;
                                this.handleLaunchClick();
                            },
                            color: `primary`,
                        } }),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core_WarningPopup__WEBPACK_IMPORTED_MODULE_6__.default, { open: this.state.showNoFileUploadsPopup && !this.state.showNoRequirementsPopup, headerText: "Heads up!", bodyText: `If your notebook reads local data files, you'll want to add them under "Files".`, preventText: "Don't warn me again", cancel: {
                            text: `Cancel`,
                            onCancel: (prevent) => {
                                this.safeSetState({ showNoFileUploadsPopup: false });
                            },
                        }, continue: {
                            text: `Launch it`,
                            onContinue: (prevent) => {
                                this.safeSetState({ showNoFileUploadsPopup: false });
                                _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.noFileUploadsPreventEnabled = prevent;
                                this.handleLaunchClick();
                            },
                            color: `primary`,
                        } }),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core_WarningPopup__WEBPACK_IMPORTED_MODULE_6__.default, { open: this.state.showStartSessionPopup, headerText: "Heads up!", bodyText: `You are about to launch a session which will remain active until you manually close it.`, preventText: "Don't warn me again", cancel: {
                            text: `Cancel`,
                            onCancel: (prevent) => {
                                this.safeSetState({ showStartSessionPopup: false });
                            },
                        }, continue: {
                            text: `Launch it`,
                            onContinue: (prevent) => {
                                this.safeSetState({ showStartSessionPopup: false });
                                _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.startSessionPreventEnabled = prevent;
                                this.handleLaunchClick();
                            },
                            color: `primary`,
                        } }),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_7__.default, { reminder: 'Launch' },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Button, { variant: 'contained', color: 'primary', disabled: this.props.disabled || this.state.waiting || user.appTracker.getDisplayNum() >= _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.maxJobs, onClick: () => {
                                const optumi = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.metadata.getMetadata().config;
                                const requirementsEmpty = optumi.upload.requirements == null || optumi.upload.requirements == "";
                                const fileUploadsEmpty = optumi.upload.files.length == 0 && optumi.upload.dataConnectors.length == 0;
                                const user = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user;
                                if (optumi.interactive) {
                                    if (!user.startSessionPreventEnabled) {
                                        this.safeSetState({ showStartSessionPopup: true });
                                    }
                                    else {
                                        this.handleLaunchClick();
                                    }
                                }
                                else {
                                    if (requirementsEmpty && fileUploadsEmpty) {
                                        if (user.noRequirementsPreventEnabled && user.noFileUploadsPreventEnabled) {
                                            this.handleLaunchClick();
                                        }
                                        else if (user.noRequirementsPreventEnabled) {
                                            this.safeSetState({ showNoFileUploadsPopup: true });
                                        }
                                        else if (user.noFileUploadsPreventEnabled) {
                                            this.safeSetState({ showNoRequirementsPopup: true });
                                        }
                                        else {
                                            this.safeSetState({ showNoRequirementsPopup: true, showNoFileUploadsPopup: true });
                                        }
                                    }
                                    else if (requirementsEmpty) {
                                        if (user.noRequirementsPreventEnabled) {
                                            this.handleLaunchClick();
                                        }
                                        else {
                                            this.safeSetState({ showNoRequirementsPopup: true });
                                        }
                                    }
                                    else if (fileUploadsEmpty) {
                                        if (user.noFileUploadsPreventEnabled) {
                                            this.handleLaunchClick();
                                        }
                                        else {
                                            this.safeSetState({ showNoFileUploadsPopup: true });
                                        }
                                    }
                                    else {
                                        this.handleLaunchClick();
                                    }
                                }
                            }, style: {
                                position: 'relative',
                                minWidth: '0px',
                                minHeight: '0px',
                                width: '52px',
                                height: '52px',
                                borderRadius: '26px',
                                color: 'var(--jp-layout-color2)',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.SvgIcon, { viewBox: "0, 0, 400,446", style: { position: 'relative', width: '36px', height: '36px' } },
                                react__WEBPACK_IMPORTED_MODULE_1__.createElement("path", { d: "M348.000 58.232 C 324.618 61.984,306.000 66.674,306.000 68.813 C 306.000 71.851,369.545 135.122,371.067 133.599 C 372.905 131.761,382.000 74.336,382.000 64.567 L 382.000 56.000 370.500 56.234 C 364.175 56.362,354.050 57.262,348.000 58.232 M261.029 86.235 C 214.374 111.539,184.827 137.455,151.438 182.354 C 131.859 208.683,134.247 207.280,105.973 209.077 C 77.646 210.877,78.107 210.586,46.111 246.944 C 14.709 282.628,13.657 285.006,24.595 295.608 C 33.914 304.640,38.535 303.841,62.774 289.000 C 74.453 281.850,85.356 276.000,87.004 276.000 C 90.397 276.000,91.021 279.133,88.000 281.000 C 80.966 285.347,86.211 293.260,115.524 322.525 C 145.290 352.241,154.153 357.842,159.000 350.000 C 161.093 346.613,163.948 347.791,162.638 351.500 C 161.957 353.425,155.685 364.580,148.700 376.288 C 133.629 401.551,133.207 405.011,144.006 414.767 C 155.049 424.744,153.659 425.401,190.701 392.696 C 227.821 359.922,227.156 360.976,229.004 332.000 C 230.748 304.673,229.916 306.203,252.454 288.864 C 308.578 245.687,341.585 206.858,361.005 161.165 C 368.325 143.941,367.373 141.488,347.134 125.396 C 330.680 112.314,319.724 100.874,305.577 82.000 C 295.803 68.959,292.260 69.296,261.029 86.235 M281.518 145.989 C 295.397 154.451,299.651 169.944,291.460 182.204 C 279.075 200.744,254.612 198.973,245.060 178.845 C 234.650 156.906,260.788 133.350,281.518 145.989 M65.116 318.984 C 41.834 327.278,33.655 343.820,22.828 404.507 C 19.046 425.702,19.740 429.180,26.337 422.099 C 32.573 415.406,48.022 408.969,72.496 402.867 C 109.336 393.683,120.097 382.787,119.904 354.869 L 119.808 341.000 116.404 347.823 C 111.679 357.294,105.398 361.342,88.000 366.125 C 79.750 368.394,70.975 371.564,68.500 373.171 C 63.012 376.734,63.005 376.424,68.070 354.701 C 73.737 330.396,81.234 320.000,93.094 320.000 C 94.692 320.000,96.000 319.100,96.000 318.000 C 96.000 315.041,74.239 315.734,65.116 318.984 " })),
                            this.state.waiting && this.state.spinning && react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.CircularProgress, { size: '54px', style: { position: 'absolute' } })))), tags: tags }, this.props.lightweightApp.getIdentityComponent()));
        };
        this.handleAppsChanged = () => this.forceUpdate();
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.appTracker.appsChanged.connect(this.handleAppsChanged);
        };
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.appTracker.appsChanged.disconnect(this.handleAppsChanged);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            waiting: false,
            spinning: false,
            showNoRequirementsPopup: false,
            showNoFileUploadsPopup: false,
            showStartSessionPopup: false,
        };
    }
}


/***/ }),

/***/ "./lib/models/application/AppTracker.js":
/*!**********************************************!*\
  !*** ./lib/models/application/AppTracker.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppTracker": () => (/* binding */ AppTracker)
/* harmony export */ });
/* harmony import */ var _Module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Module */ "./lib/models/Module.js");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ "webpack/sharing/consume/default/@lumino/signaling");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class AppTracker {
    constructor() {
        this._polling = false;
        this._apps = [];
        this._appsChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);
        // If we are polling, send a new request 2 seconds after completing the previous request
        this.appPollDelay = 2000;
        // If we are polling, send a new request 2 seconds after completing the previous request
        this.modPollingDelay = 500;
        this._polling = true;
        this.receiveAppUpdates();
        this.receiveModuleUpdates();
        for (var app of this.activeSessions) {
            for (var module of app.modules) {
                module.startSessionHandler();
            }
        }
    }
    get appsChanged() {
        return this._appsChanged;
    }
    get activeJobsOrSessions() {
        return this._apps.filter((app) => app.getAppStatus() != _Module__WEBPACK_IMPORTED_MODULE_2__.Status.COMPLETED);
    }
    get activeSessions() {
        return this._apps.filter((app) => app.getAppStatus() != _Module__WEBPACK_IMPORTED_MODULE_2__.Status.COMPLETED && app.interactive);
    }
    get finishedSessions() {
        return this._apps.filter((app) => app.getAppStatus() == _Module__WEBPACK_IMPORTED_MODULE_2__.Status.COMPLETED && app.interactive);
    }
    get activeJobs() {
        return this._apps.filter((app) => app.getAppStatus() != _Module__WEBPACK_IMPORTED_MODULE_2__.Status.COMPLETED && !app.interactive);
    }
    get finishedJobs() {
        return this._apps.filter((app) => app.getAppStatus() == _Module__WEBPACK_IMPORTED_MODULE_2__.Status.COMPLETED && !app.interactive);
    }
    addApp(app) {
        this._apps.unshift(app);
        if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnEmit)
            console.log('SignalEmit (' + new Date().getSeconds() + ')');
        this._appsChanged.emit(this._apps);
        app.changed.connect(() => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnEmit)
                console.log('SignalEmit (' + new Date().getSeconds() + ')');
            return this._appsChanged.emit(this._apps);
        }, this);
    }
    removeApp(uuid) {
        var app = this._apps.filter((app) => app.uuid == uuid)[0];
        this._apps = this._apps.filter((app) => app.uuid != uuid);
        app.changed.disconnect(() => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnEmit)
                console.log('SignalEmit (' + new Date().getSeconds() + ')');
            return this._appsChanged.emit(this._apps);
        }, this);
        if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnEmit)
            console.log('SignalEmit (' + new Date().getSeconds() + ')');
        this._appsChanged.emit(this._apps);
    }
    getDisplayNum() {
        return this._apps.filter((app) => app.getAppStatus() != _Module__WEBPACK_IMPORTED_MODULE_2__.Status.COMPLETED).length;
    }
    receiveAppUpdates() {
        if (!this._polling)
            return;
        // If there is an unsigned agreement, do not poll
        if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.user != null && _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.unsignedAgreement) {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnPoll)
                console.log('FunctionPoll (' + new Date().getSeconds() + ')');
            setTimeout(() => this.receiveAppUpdates(), this.appPollDelay);
            return;
        }
        const uuids = [];
        const lastInitializingLines = [];
        const lastUploadingLines = [];
        const lastRequisitioningLines = [];
        const lastRunningLines = [];
        for (var app of this.activeJobsOrSessions) {
            uuids.push(app.uuid);
            lastInitializingLines.push(app.initializing.length);
            lastUploadingLines.push(app.uploading.length);
            lastRequisitioningLines.push(app.requisitioning.length);
            lastRunningLines.push(app.running.length);
        }
        // There is no need to make an empty request
        if (uuids.length > 0) {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/pull-workload-status-updates";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    uuids: uuids,
                    lastInitializingLines: lastInitializingLines,
                    lastUploadingLines: lastUploadingLines,
                    lastRequisitioningLines: lastRequisitioningLines,
                    lastRunningLines: lastRunningLines,
                }),
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnPoll)
                    console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                setTimeout(() => this.receiveAppUpdates(), this.appPollDelay);
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
                return response.json();
            }).then((body) => {
                var updated = false;
                for (var app of this._apps) {
                    if (body[app.uuid]) {
                        const appUpdated = app.handleUpdate(body[app.uuid]);
                        updated = updated || appUpdated;
                    }
                }
                if (updated)
                    this._appsChanged.emit(this._apps);
            });
        }
        else {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnPoll)
                console.log('FunctionPoll (' + new Date().getSeconds() + ')');
            setTimeout(() => this.receiveAppUpdates(), this.appPollDelay);
        }
    }
    async receiveModuleUpdates() {
        if (!this._polling)
            return;
        // If there is an unsigned agreement, do not poll
        if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.user != null && _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.unsignedAgreement) {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnPoll)
                console.log('FunctionPoll (' + new Date().getSeconds() + ')');
            setTimeout(() => this.receiveModuleUpdates(), this.modPollingDelay);
            return;
        }
        const workloadUUIDs = [];
        const moduleUUIDs = [];
        const lastUpdateLines = [];
        const lastOutputLines = [];
        for (var app of this.activeJobsOrSessions) {
            for (var module of app.modules) {
                if (module.modStatus != _Module__WEBPACK_IMPORTED_MODULE_2__.Status.COMPLETED) {
                    workloadUUIDs.push(app.uuid);
                    moduleUUIDs.push(module.uuid);
                    lastUpdateLines.push(module.updates.length);
                    lastOutputLines.push(module.output.length);
                }
            }
        }
        // There is no need to make an empty request
        if (workloadUUIDs.length > 0) {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/pull-module-status-updates";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    workloadUUIDs: workloadUUIDs,
                    moduleUUIDs: moduleUUIDs,
                    lastUpdateLines: lastUpdateLines,
                    lastOutputLines: lastOutputLines,
                }),
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnPoll)
                    console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                setTimeout(() => this.receiveModuleUpdates(), this.modPollingDelay);
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
                return response.json();
            }).then((body) => {
                var updated = false;
                for (var app of this._apps) {
                    for (var module of app.modules) {
                        if (body[module.uuid]) {
                            const modUpdated = module.handleUpdate(body[module.uuid]);
                            updated = updated || modUpdated;
                        }
                    }
                }
                if (updated)
                    this._appsChanged.emit(this._apps);
            });
        }
        else {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnPoll)
                console.log('FunctionPoll (' + new Date().getSeconds() + ')');
            setTimeout(() => this.receiveModuleUpdates(), this.modPollingDelay);
        }
    }
    stopPolling() {
        this._polling = false;
        for (var app of this.activeSessions) {
            for (var module of app.modules) {
                module.stopSessionHandler();
            }
        }
    }
}


/***/ }),

/***/ "./lib/models/application/IdentityAppComponent.js":
/*!********************************************************!*\
  !*** ./lib/models/application/IdentityAppComponent.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "IdentityAppComponent": () => (/* binding */ IdentityAppComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_deploy_AnnotationInput__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../components/deploy/AnnotationInput */ "./lib/components/deploy/AnnotationInput.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class IdentityAppComponent extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const lightweightApp = this.props.app;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { paddingLeft: '3px' } },
                " ",
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_2__.default, { reminder: lightweightApp.path },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { paddingBottom: '7px', fontSize: 'var(--jp-ui-font-size1)', lineHeight: '1', fontWeight: 'normal', whiteSpace: 'nowrap', overflow: 'hidden', textOverflow: 'ellipsis' } }, lightweightApp.name)),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_deploy_AnnotationInput__WEBPACK_IMPORTED_MODULE_3__.AnnotationInput, { getValue: () => lightweightApp.config.annotation, saveValue: (value) => {
                        const config = lightweightApp.config.copy();
                        config.annotation = value;
                        lightweightApp.config = config;
                    }, placeholder: lightweightApp.runNum == 0 ? 'Add annotation' : 'Run #' + lightweightApp.runNum })));
        };
    }
}


/***/ }),

/***/ "./lib/models/application/LightweightApp.js":
/*!**************************************************!*\
  !*** ./lib/models/application/LightweightApp.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LightweightApp": () => (/* binding */ LightweightApp)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _AppLaunchComponent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./AppLaunchComponent */ "./lib/models/application/AppLaunchComponent.js");
/* harmony import */ var _IdentityAppComponent__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./IdentityAppComponent */ "./lib/models/application/IdentityAppComponent.js");
/* harmony import */ var _OptumiMetadataTracker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../OptumiMetadataTracker */ "./lib/models/OptumiMetadataTracker.js");
/* harmony import */ var _OptumiMetadata__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../OptumiMetadata */ "./lib/models/OptumiMetadata.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






class LightweightApp {
    constructor(uuid, path, config) {
        this.uuid = uuid;
        this.path = path;
        this._config = config;
    }
    get name() {
        return this.path.split('/').pop().replace('.ipynb', '');
    }
    get config() {
        return this._config;
    }
    set config(config) {
        this._config = config.copy();
        // Update the metadata tracker
        _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.setMetadata(new _OptumiMetadataTracker__WEBPACK_IMPORTED_MODULE_2__.TrackedOptumiMetadata(this.path, new _OptumiMetadata__WEBPACK_IMPORTED_MODULE_3__.OptumiMetadata({ nbKey: this.uuid }), config.copy()));
    }
    get runNum() {
        return 0;
    }
    getLaunchComponent(disabled) {
        return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AppLaunchComponent__WEBPACK_IMPORTED_MODULE_4__.AppLaunchComponent, { key: this.path, lightweightApp: this, disabled: disabled });
    }
    getIdentityComponent() {
        return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_IdentityAppComponent__WEBPACK_IMPORTED_MODULE_5__.IdentityAppComponent, { key: this.path, app: this });
    }
}


/***/ }),

/***/ "./lib/models/application/PopupAppComponent.js":
/*!*****************************************************!*\
  !*** ./lib/models/application/PopupAppComponent.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PopupAppComponent": () => (/* binding */ PopupAppComponent)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_icons_MoreVert__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material-ui/icons/MoreVert */ "./node_modules/@material-ui/icons/MoreVert.js");
/* harmony import */ var _material_ui_core_DialogTitle__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material-ui/core/DialogTitle */ "./node_modules/@material-ui/core/esm/DialogTitle/DialogTitle.js");
/* harmony import */ var _material_ui_icons_Close__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @material-ui/icons/Close */ "./node_modules/@material-ui/icons/Close.js");
/* harmony import */ var _components_monitor_ScrollableDiv__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../components/monitor/ScrollableDiv */ "./lib/components/monitor/ScrollableDiv.js");
/* harmony import */ var _components_deploy_OutputFileList__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/deploy/OutputFileList */ "./lib/components/deploy/OutputFileList.js");
/* harmony import */ var _material_ui_icons_Code__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @material-ui/icons/Code */ "./node_modules/@material-ui/icons/Code.js");
/* harmony import */ var _Module__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Module */ "./lib/models/Module.js");
/* harmony import */ var _machine_MachineCapabilities__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../machine/MachineCapabilities */ "./lib/models/machine/MachineCapabilities.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _material_ui_icons_OpenInNew__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @material-ui/icons/OpenInNew */ "./node_modules/@material-ui/icons/OpenInNew.js");
/* harmony import */ var _core_notebook_Notebook__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../core/notebook/Notebook */ "./lib/core/notebook/Notebook.js");
/* harmony import */ var _utils_FileServerUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/FileServerUtils */ "./lib/utils/FileServerUtils.js");
/* harmony import */ var _core_NotificationContent__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/NotificationContent */ "./lib/core/NotificationContent.js");
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/

















const StyledDialog = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.withStyles)({
    paper: {
        width: '80%',
        height: '80%',
        overflowY: 'visible',
        backgroundColor: 'var(--jp-layout-color1)',
        maxWidth: 'inherit',
    },
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Dialog);
// TODO:Beck The popup needs to be abstracted out, there is too much going on to reproduce it in more than one file
class PopupAppComponent extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClickOpen = () => {
            if (this.props.onOpen)
                this.props.onOpen();
            this.safeSetState({ open: true });
        };
        this.handleClose = () => {
            this.safeSetState({ open: false });
            if (this.props.onClose)
                this.props.onClose();
        };
        this.handleInputLineChange = (event) => {
            this.safeSetState({ inputLine: event.target.value });
        };
        this.handleKeyDown = (event) => {
            if (event.key == 'Enter') {
                this.safeSetState({ inputLine: '' }),
                    this.props.app.modules[0].pushModuleInput(this.state.inputLine);
            }
        };
        this.handleMouseOver = (event) => {
            if (this.props.onMouseOver)
                this.props.onMouseOver(event);
        };
        this.handleMouseOut = (event) => {
            if (this.props.onMouseOut)
                this.props.onMouseOut(event);
        };
        this.openSession = () => {
            window.open('http://localhost:' + this.props.app.sessionPort + '?token=' + this.props.app.sessionToken, '_blank');
        };
        this.openAsNewNotebook = () => {
            const path = this.props.app.path.replace('.ipynb', '-run' + (this.props.app.runNum) + '.ipynb');
            var notebook = this.props.app.notebook;
            _utils_FileServerUtils__WEBPACK_IMPORTED_MODULE_2__.default.saveNotebook(path, notebook).then((success) => { _Global__WEBPACK_IMPORTED_MODULE_3__.Global.docManager.open(path); });
            // Close the dialog
            this.handleClose();
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            var i = 0;
            return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.IconButton, { onClick: this.handleClickOpen, style: {
                        display: 'inline-block',
                        width: '36px',
                        height: '36px',
                        padding: '3px',
                    }, onMouseOver: this.handleMouseOver, onMouseOut: this.handleMouseOut },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_icons_MoreVert__WEBPACK_IMPORTED_MODULE_4__.default, { style: {
                            width: '30px',
                            height: '30px',
                            padding: '3px',
                        } })),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(StyledDialog, { open: this.state.open, onClose: this.handleClose, scroll: 'paper' },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core_DialogTitle__WEBPACK_IMPORTED_MODULE_5__.default, { disableTypography: true, style: {
                            display: 'inline-flex',
                            backgroundColor: 'var(--jp-layout-color2)',
                            height: '60px',
                            padding: '6px',
                            borderRadius: '4px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: {
                                display: 'inline-flex',
                                minWidth: '150px',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                paddingRight: '12px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { margin: 'auto', paddingLeft: '12px' } }, this.props.app.interactive ? "Session" : "Job")),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { width: '100%', display: 'inline-flex', overflowX: 'hidden', fontSize: '16px', paddingLeft: '8px' } },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { flexGrow: 1, margin: 'auto 0px' } }, this.props.app.path),
                            this.props.app.interactive && (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Button, { style: { margin: '6px' }, disableElevation: true, variant: 'contained', color: 'primary', onClick: this.openSession, disabled: this.props.app.getAppStatus() == _Module__WEBPACK_IMPORTED_MODULE_6__.Status.COMPLETED || !(this.props.app.modules.length > 0 && this.props.app.modules[0].sessionReady), endIcon: react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_icons_OpenInNew__WEBPACK_IMPORTED_MODULE_7__.default, null) }, "Open session")),
                            !this.props.app.interactive && (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_8__.default, { reminder: 'Create as a new notebook' },
                                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Button, { style: { margin: '6px' }, disableElevation: true, variant: 'contained', color: 'primary', onClick: this.openAsNewNotebook, disabled: this.props.app.getAppStatus() != _Module__WEBPACK_IMPORTED_MODULE_6__.Status.COMPLETED, endIcon: react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_icons_OpenInNew__WEBPACK_IMPORTED_MODULE_7__.default, null) }, "Create")))),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.IconButton, { onClick: this.handleClose, style: {
                                display: 'inline-block',
                                width: '36px',
                                height: '36px',
                                padding: '3px',
                                margin: '6px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_icons_Close__WEBPACK_IMPORTED_MODULE_9__.default, { style: {
                                    width: '30px',
                                    height: '30px',
                                    padding: '3px',
                                } }))),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_10__.ShadowedDivider, null),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { display: 'flex', height: 'calc(100% - 60px - 2px' } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { width: '150px' } },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.DialogContent, { style: { padding: '0px' } },
                                react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { padding: '12px 6px' } },
                                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Tabs, { value: this.state.selectedPanel, onChange: (event, newValue) => this.safeSetState({ selectedPanel: newValue }), orientation: 'vertical', variant: 'fullWidth', indicatorColor: 'primary', textColor: 'primary', style: { minHeight: '24px' } },
                                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Tab, { label: 'SUMMARY', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            }, value: 0 /* SUMMARY */ }),
                                        !this.props.app.interactive && react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Tab, { label: 'NOTIFICATIONS', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            }, value: 1 /* NOTIFICATIONS */ }),
                                        !this.props.app.interactive && react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Tab, { label: 'NOTEBOOK', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            }, value: 2 /* NOTEBOOK */ }),
                                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Tab, { label: 'FILES', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            }, value: 3 /* FILES */ }),
                                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Tab, { label: 'MACHINE', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            }, value: 4 /* MACHINE */ }),
                                        this.props.app.modules.length > 0 && this.props.app.interactive && react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Tab, { label: 'TERMINAL', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            }, value: 5 /* TERMINAL */ }))))),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_10__.ShadowedDivider, { orientation: 'vertical' }),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { display: 'flex', flexFlow: 'column', overflow: 'hidden', width: 'calc(100% - 150px)', height: '100%' } },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.DialogContent, { style: {
                                    flexGrow: 1,
                                    overflowY: 'auto',
                                    width: '100%',
                                    height: '100%',
                                    padding: '0px',
                                    marginBottom: '0px',
                                    // lineHeight: 'var(--jp-code-line-height)',
                                    fontSize: 'var(--jp-ui-font-size1)',
                                } }, this.state.selectedPanel == 0 /* SUMMARY */ ? (react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { padding: '20px' } },
                                this.props.app.interactive ? 'Session' : 'Job',
                                " launched at ",
                                this.props.app.timestamp.toLocaleTimeString('en-US', {
                                    hour: 'numeric', minute: 'numeric',
                                }),
                                " on ",
                                this.props.app.timestamp.toLocaleDateString('en-US', {
                                    weekday: 'long', year: 'numeric', month: 'long', day: 'numeric'
                                }),
                                react__WEBPACK_IMPORTED_MODULE_1__.createElement("br", null),
                                this.props.app.runNum ? (react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null,
                                    "Run #",
                                    this.props.app.runNum + (this.props.app.config.annotation != '' ? ': ' + this.props.app.config.annotation : ''),
                                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("br", null))) : (react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null)),
                                this.props.app.getTimeElapsed() ? (react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null,
                                    "Duration: ",
                                    this.props.app.getTimeElapsed(),
                                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("br", null))) : (react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null)),
                                this.props.app.getCost() ? (react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null,
                                    "Estimated cost: ",
                                    this.props.app.getCost(),
                                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("br", null))) : (react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null)),
                                react__WEBPACK_IMPORTED_MODULE_1__.createElement("br", null),
                                (this.props.app.initializing.messages + this.props.app.uploading.messages + this.props.app.requisitioning.messages + this.props.app.running.messages).split('\n').map((value) => (react__WEBPACK_IMPORTED_MODULE_1__.createElement("span", { style: { whiteSpace: 'pre' }, key: value + i++ },
                                    value,
                                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("br", null)))))) : this.state.selectedPanel == 1 /* NOTIFICATIONS */ ? (react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { padding: '20px' } },
                                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core_NotificationContent__WEBPACK_IMPORTED_MODULE_11__.NotificationContent, { getValue: () => this.props.app.config, saveValue: (config) => this.props.app.config = config, disabled: this.props.app.getAppStatus() == _Module__WEBPACK_IMPORTED_MODULE_6__.Status.COMPLETED, openUserDialogTo: this.props.openUserDialogTo, handleClose: this.handleClose }))) : this.state.selectedPanel == 2 /* NOTEBOOK */ ? (react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { overflow: 'hidden', width: '100%', height: '100%' } },
                                react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { width: '100%', height: 'calc(100% - 68px)', overflow: 'auto' } },
                                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core_notebook_Notebook__WEBPACK_IMPORTED_MODULE_12__.default, { notebook: this.props.app.notebook })),
                                react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { padding: '6px', width: '100%' } },
                                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.TextField, { variant: 'outlined', disabled: this.props.app.modules.length > 0 && this.props.app.modules[0].modStatus == _Module__WEBPACK_IMPORTED_MODULE_6__.Status.COMPLETED, value: this.state.inputLine, onChange: this.handleInputLineChange, onKeyDown: this.handleKeyDown, style: { height: '56px', width: '100%' }, InputProps: { startAdornment: (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.InputAdornment, { position: "start" },
                                                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_icons_Code__WEBPACK_IMPORTED_MODULE_13__.default, null)))
                                        } })))) : this.state.selectedPanel == 3 /* FILES */ ? (react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { padding: '8px' } }, this.props.app.interactive && this.props.app.getAppStatus() != _Module__WEBPACK_IMPORTED_MODULE_6__.Status.COMPLETED ? (react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { padding: '12px' } }, "Files will appear here after your session has completed. Until then, you can upload/download files directly from the session tab.")) : (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_components_deploy_OutputFileList__WEBPACK_IMPORTED_MODULE_14__.OutputFileList, { app: this.props.app })))) : this.state.selectedPanel == 4 /* MACHINE */ ? (react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { padding: '14px 8px' } }, this.props.app.machine ? (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_machine_MachineCapabilities__WEBPACK_IMPORTED_MODULE_15__.MachineCapability, { machine: this.props.app.machine })) : (react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { padding: '6px 12px' } },
                                "Machine information will appear when the ",
                                this.props.app.interactive ? ' session ' : ' job ',
                                " starts.")))) : this.state.selectedPanel == 5 /* TERMINAL */ && (react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { overflow: 'hidden', width: '100%', height: '100%' } },
                                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_components_monitor_ScrollableDiv__WEBPACK_IMPORTED_MODULE_16__.ScrollableDiv, { key: 'output', source: Object.assign([], this.props.app.modules[0].output), autoScroll: true })))))))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            open: false,
            selectedPanel: 0 /* SUMMARY */,
            inputLine: ''
        };
    }
}


/***/ }),

/***/ "./lib/models/machine/IdentityMachineComponent.js":
/*!********************************************************!*\
  !*** ./lib/models/machine/IdentityMachineComponent.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "IdentityMachineComponent": () => (/* binding */ IdentityMachineComponent)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/* harmony import */ var _Machine__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Machine */ "./lib/models/machine/Machine.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






const GraphicsBar = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.withStyles)(forBar('Graphics'))(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Slider);
const ComputeBar = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.withStyles)(forBar('Compute'))(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Slider);
const MemoryBar = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.withStyles)(forBar('Memory'))(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Slider);
const DiskBar = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.withStyles)(forBar('Disk'))(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Slider);
function forBar(type) {
    var color, trackRadius, railRadius;
    if (type == 'Graphics') {
        color = '#ffba7d';
        trackRadius = '4px 4px 4px 0px';
        railRadius = '4px 4px 0px 0px';
    }
    else if (type == 'Compute') {
        color = '#f48f8d';
        trackRadius = '0px 4px 4px 0px';
        railRadius = '0px';
    }
    else if (type == 'Memory') {
        color = '#afaab0';
        trackRadius = '0px 4px 4px 0px';
        railRadius = '0px';
    }
    else if (type == 'Disk') {
        color = '#68da7c';
        trackRadius = '0px 4px 4px 4px';
        railRadius = '0px 0px 4px 4px';
    }
    return {
        root: {
            marginRight: '4px',
            height: type == 'Disk' ? '14px' : '13px',
            width: '100%',
            padding: '0px',
            lineHeight: 1,
            fontSize: '14px',
        },
        thumb: {
            height: '14px',
            top: '6px',
            backgroundColor: 'transparent',
            padding: '0px',
            '&:focus, &:hover, &:active': {
                boxShadow: 'none',
            },
            '&::after': {
                left: -6,
                top: -6,
                right: -6,
                bottom: -6,
            },
        },
        track: {
            height: '14px',
            color: color,
            boxSizing: 'border-box',
            border: "1px solid " + (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.darken)(color, 0.25),
            borderRadius: trackRadius,
        },
        rail: {
            // display: 'none',
            height: '14px',
            color: color,
            borderRadius: railRadius,
        },
    };
}
const FONT_SIZE = '12px';
const COLUMN_WIDTH_1 = '30px';
const COLUMN_WIDTH_2 = '52px';
const COLUMN_MARGIN = '1px 0px 0px 0px';
class IdentityMachineComponent extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const machine = this.props.machine;
            const title = machine instanceof _Machine__WEBPACK_IMPORTED_MODULE_3__.NoMachine ? 'No matching machines' : '';
            return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_4__.default, { reminder: title },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { width: '100%', lineHeight: '9px' } },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { width: '100%', display: 'inline-flex' } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(GraphicsBar, { value: machine.graphicsRating, max: 1, step: 0.01, disabled: true }),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { minWidth: COLUMN_WIDTH_1, margin: COLUMN_MARGIN, fontSize: FONT_SIZE, lineHeight: FONT_SIZE } }, "GPU"),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { minWidth: COLUMN_WIDTH_2, textAlign: 'right', margin: COLUMN_MARGIN, fontSize: FONT_SIZE, lineHeight: FONT_SIZE } }, (machine.graphicsNumCards > 0 ? (machine.graphicsNumCards + ' ' + machine.graphicsCardType) : 'None'))),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { width: '100%', display: 'inline-flex' } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(ComputeBar, { value: machine.computeRating, max: 1, step: 0.01, disabled: true }),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { minWidth: COLUMN_WIDTH_1, margin: COLUMN_MARGIN, fontSize: FONT_SIZE, lineHeight: FONT_SIZE } }, "CPU"),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { minWidth: COLUMN_WIDTH_2, textAlign: 'right', margin: COLUMN_MARGIN, fontSize: FONT_SIZE, lineHeight: FONT_SIZE } },
                            machine.computeCores,
                            " core")),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { width: '100%', display: 'inline-flex' } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(MemoryBar, { value: machine.memoryRating, max: 1, step: 0.01, disabled: true }),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { minWidth: COLUMN_WIDTH_1, margin: COLUMN_MARGIN, fontSize: FONT_SIZE, lineHeight: FONT_SIZE } }, "RAM"),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { minWidth: COLUMN_WIDTH_2, textAlign: 'right', margin: COLUMN_MARGIN, fontSize: FONT_SIZE, lineHeight: FONT_SIZE } }, _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_5__.default.styleCapacityUnitValue()(machine.memorySize))),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { width: '100%', display: 'inline-flex' } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(DiskBar, { value: machine.storageRating, max: 1, step: 0.01, disabled: true }),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { minWidth: COLUMN_WIDTH_1, margin: COLUMN_MARGIN, fontSize: FONT_SIZE, lineHeight: FONT_SIZE } }, "DISK"),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { minWidth: COLUMN_WIDTH_2, textAlign: 'right', margin: COLUMN_MARGIN, fontSize: FONT_SIZE, lineHeight: FONT_SIZE } }, machine.storageSize != 0 ? _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_5__.default.styleCapacityUnitValue()(machine.storageSize) : 'None')))));
        };
    }
}


/***/ }),

/***/ "./lib/models/machine/Machine.js":
/*!***************************************!*\
  !*** ./lib/models/machine/Machine.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Machine": () => (/* binding */ Machine),
/* harmony export */   "NoMachine": () => (/* binding */ NoMachine)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _IdentityMachineComponent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./IdentityMachineComponent */ "./lib/models/machine/IdentityMachineComponent.js");
/* harmony import */ var _MachineComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./MachineComponent */ "./lib/models/machine/MachineComponent.js");
/* harmony import */ var _MachinePreviewComponent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MachinePreviewComponent */ "./lib/models/machine/MachinePreviewComponent.js");
/* harmony import */ var _PopupMachineComponent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./PopupMachineComponent */ "./lib/models/machine/PopupMachineComponent.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





class Machine {
    constructor() {
        this.computeCores = 0;
        this.computeFrequency = 0;
        this.computeRating = 0;
        this.computeScore = 0;
        this.graphicsCardType = 'None';
        this.graphicsCores = 0;
        this.graphicsFrequency = 0;
        this.graphicsMemory = 0;
        this.graphicsNumCards = 0;
        this.graphicsRating = 0;
        this.graphicsScore = 0;
        this.memoryRating = 0;
        this.memorySize = 0;
        this.storageRating = 0;
        this.storageSize = 0;
        this.storageIops = 0;
        this.storageThroughput = 0;
    }
    getComponent() {
        return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_MachineComponent__WEBPACK_IMPORTED_MODULE_1__.MachineComponent, { key: this.uuid, machine: this });
    }
    getPreviewComponent() {
        return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_MachinePreviewComponent__WEBPACK_IMPORTED_MODULE_2__.MachinePreviewComponent, { key: this.uuid, machine: this });
    }
    getIdentityComponent() {
        return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_IdentityMachineComponent__WEBPACK_IMPORTED_MODULE_3__.IdentityMachineComponent, { key: this.uuid, machine: this });
    }
    getPopupComponent() {
        return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_PopupMachineComponent__WEBPACK_IMPORTED_MODULE_4__.PopupMachineComponent, { key: this.uuid, machine: this });
    }
    static getStateMessage(state) {
        switch (state) {
            case 'requisition requested':
            case 'requisition in progress':
                return 'Acquiring';
            case 'requisition completed':
            case 'setup completed':
                return 'Ready';
            case 'teardown requested':
            case 'sequestration requested':
            case 'sequestration in progress':
            case 'sequestration completed':
                return 'Releasing';
            case 'unused':
            default:
                return '';
        }
    }
}
class NoMachine extends Machine {
}


/***/ }),

/***/ "./lib/models/machine/MachineCapabilities.js":
/*!***************************************************!*\
  !*** ./lib/models/machine/MachineCapabilities.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MachineCapability": () => (/* binding */ MachineCapability)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core */ "./lib/core/Header.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core */ "./lib/core/Label.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





class MachineCapability extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const machine = this.props.machine;
            return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null,
                machine.graphicsNumCards > 0 && (react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { margin: '6px' } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_3__.Header, { title: 'GPU', align: 'left' }),
                        machine.graphicsCardType !== 'None' && react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.Label, { align: 'left', getValue: () => machine.graphicsCardType, label: 'Type' }),
                        machine.graphicsNumCards > 0 && react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.Label, { align: 'left', getValue: () => machine.graphicsNumCards, label: 'Count' }),
                        _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.userExpertise >= 2 && machine.graphicsCores > 0 && react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.Label, { align: 'left', getValue: () => machine.graphicsCores, label: 'Cores' }),
                        _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.userExpertise >= 2 && machine.graphicsScore > 0 && react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.Label, { align: 'left', getValue: () => machine.graphicsScore, label: 'Score' }),
                        _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.userExpertise >= 2 && machine.graphicsFrequency > 0 && react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.Label, { align: 'left', getValue: () => machine.graphicsFrequency, label: 'Frequency', styledUnitValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_5__.default.styleFrequencyUnitValue() })),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Divider, { variant: 'middle' }))),
                machine.computeCores > 0 && (react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { margin: '6px' } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_3__.Header, { title: 'CPU', align: 'left' }),
                        machine.computeCores > 0 && react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.Label, { align: 'left', getValue: () => machine.computeCores, label: 'Cores' }),
                        _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.userExpertise >= 2 && machine.computeScore > 0 && react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.Label, { align: 'left', getValue: () => machine.computeScore, label: 'Score' }),
                        _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.userExpertise >= 2 && machine.computeFrequency > 0 && react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.Label, { align: 'left', getValue: () => machine.computeFrequency, label: 'Frequency', styledUnitValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_5__.default.styleFrequencyUnitValue() })),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Divider, { variant: 'middle' }))),
                machine.memorySize > 0 && (react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { margin: '6px' } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_3__.Header, { title: 'RAM', align: 'left' }),
                        machine.memorySize > 0 && react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.Label, { align: 'left', getValue: () => machine.memorySize, label: 'Size', styledUnitValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_5__.default.styleCapacityUnitValue() })),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Divider, { variant: 'middle' }))),
                machine.storageSize > 0 && (react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { margin: '6px' } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_3__.Header, { title: 'DSK', align: 'left' }),
                        machine.storageSize > 0 && react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.Label, { align: 'left', getValue: () => machine.storageSize, label: 'Size', styledUnitValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_5__.default.styleCapacityUnitValue() }),
                        _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.userExpertise >= 2 && machine.storageIops > 0 && react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.Label, { align: 'left', getValue: () => machine.storageIops, label: 'IOPS' }),
                        _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.userExpertise >= 2 && machine.storageThroughput > 0 && react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.Label, { align: 'left', getValue: () => machine.storageThroughput, label: 'Throughput', styledUnitValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_5__.default.styleThroughputUnitValue() })),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Divider, { variant: 'middle' })))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.state = {};
    }
}


/***/ }),

/***/ "./lib/models/machine/MachineComponent.js":
/*!************************************************!*\
  !*** ./lib/models/machine/MachineComponent.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MachineComponent": () => (/* binding */ MachineComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Machine__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Machine */ "./lib/models/machine/Machine.js");
/* harmony import */ var _components_Tag__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../components/Tag */ "./lib/components/Tag.js");
/* harmony import */ var _components_InfoSkirt__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../components/InfoSkirt */ "./lib/components/InfoSkirt.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _material_ui_icons_Delete__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @material-ui/icons/Delete */ "./node_modules/@material-ui/icons/Delete.js");
/* harmony import */ var _core_WarningPopup__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/WarningPopup */ "./lib/core/WarningPopup.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/











class MachineComponent extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.stopApp = (uuid) => {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/stop-notebook";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    uuid: uuid,
                }),
            };
            return _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
                return response.text();
            });
        };
        this.deleteApp = (uuid) => {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/teardown-notebook";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    uuid: uuid,
                }),
            };
            return _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.appTracker.removeApp(uuid);
                return response.text();
            });
        };
        this.handleDeleteClicked = (tries = 0) => {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/delete-machine";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    uuid: this.props.machine.uuid,
                }),
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
                this.safeSetState({ waiting: false, deleting: true });
            }).then(() => {
                // Nothing to do on success
            }, () => {
                // We can hit an error here by asking too soon for a machines deletion, so we will wait a little and ask again
                // We will give up after 30 tries (30 seconds)
                if (tries < 30) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnPoll)
                        console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                    setTimeout(() => this.handleDeleteClicked(tries++), 1000);
                }
            });
        };
        this.showLoading = (machineState) => {
            switch (machineState) {
                case 'Acquiring':
                case 'Releasing':
                    return true;
                default:
                    return false;
            }
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            var machine = this.props.machine;
            var tags = [];
            var machineState = _Machine__WEBPACK_IMPORTED_MODULE_4__.Machine.getStateMessage(this.props.machine.state);
            if (machineState != '') {
                tags.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_5__.default, { key: 'machineState', reminder: 'Status' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_Tag__WEBPACK_IMPORTED_MODULE_6__.Tag, { key: 'machineState', label: machineState, showLoading: this.showLoading(machineState) })));
            }
            if (machine.rate != undefined) {
                tags.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_5__.default, { key: 'machineRate', reminder: 'Cost' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_Tag__WEBPACK_IMPORTED_MODULE_6__.Tag, { key: 'machineRate', label: (machine.promo ? 'Promo: ' : '') + _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__.default.styleRateUnitValue()(machine.rate) })));
            }
            const user = _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_InfoSkirt__WEBPACK_IMPORTED_MODULE_8__.InfoSkirt, { rightButton: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_WarningPopup__WEBPACK_IMPORTED_MODULE_9__.default, { open: this.state.showDeleteMachinePopup, headerText: "Are you sure?", bodyText: (() => {
                            for (var app of user.appTracker.activeJobsOrSessions) {
                                if (app.uuid == machine.app) {
                                    const appWord = app.interactive ? "session" : "job";
                                    const appAction = app.interactive ? "closed" : "terminated";
                                    // if (app is running) {
                                    if ((app.requisitioning.completed && !app.requisitioning.error) && !app.running.completed) {
                                        return "Your " + appWord + " '" + app.name + "' is active on this machine. It will be " + appAction + " if the machine is released.";
                                    }
                                    else {
                                        return "Your " + appWord + " '" + app.name + "' is waiting for this machine. It will be deleted if the machine is released.";
                                    }
                                }
                            }
                            return "";
                        })(), cancel: {
                            text: `Cancel`,
                            onCancel: () => {
                                this.safeSetState({ showDeleteMachinePopup: false });
                            },
                        }, continue: {
                            text: `Release it`,
                            onContinue: () => {
                                if (user.appTracker.activeJobsOrSessions.length == 0) {
                                    // Workloads completed while this popup was open
                                    setTimeout(() => this.safeSetState({ spinning: true }), 1000);
                                    this.handleDeleteClicked();
                                }
                                else {
                                    for (var app of user.appTracker.activeJobsOrSessions) {
                                        if (app.uuid == machine.app) {
                                            // if (app is running) {
                                            if ((app.requisitioning.completed && !app.requisitioning.error) && !app.running.completed) {
                                                // Only delete the machine after the job is stopped to avoid a race condition
                                                // We set these outside so they will span the job stop/delete as well
                                                this.safeSetState({ waiting: true, spinning: false });
                                                setTimeout(() => this.safeSetState({ spinning: true }), 1000);
                                                this.stopApp(app.uuid).then(() => this.handleDeleteClicked());
                                            }
                                            else {
                                                // Only delete the machine after the job is deleted to avoid a race condition
                                                // We set these outside so they will span the job stop/delete as well
                                                this.safeSetState({ waiting: true, spinning: false });
                                                setTimeout(() => this.safeSetState({ spinning: true }), 1000);
                                                this.deleteApp(app.uuid).then(() => this.handleDeleteClicked());
                                            }
                                            break;
                                        }
                                    }
                                }
                                this.safeSetState({ showDeleteMachinePopup: false });
                            },
                            color: `error`,
                        } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_5__.default, { reminder: 'Release' },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.IconButton, { onClick: () => {
                                if (machine.app) {
                                    this.safeSetState({ showDeleteMachinePopup: true });
                                }
                                else {
                                    this.safeSetState({ waiting: true, spinning: false });
                                    setTimeout(() => this.safeSetState({ spinning: true }), 1000);
                                    this.handleDeleteClicked();
                                }
                            }, disabled: this.state.deleting || this.state.waiting || this.props.machine.state.includes('sequestration'), style: { position: 'relative', display: 'inline-block', width: '36px', height: '36px', padding: '3px' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_icons_Delete__WEBPACK_IMPORTED_MODULE_10__.default, { style: { position: 'relative', width: '30px', height: '30px', padding: '3px' } }),
                            (this.state.deleting || this.state.waiting) && this.state.spinning && react__WEBPACK_IMPORTED_MODULE_0__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_2__.CircularProgress, { size: '30px', style: { position: 'absolute' } })))), tags: tags }, this.props.machine.getIdentityComponent()));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            showDeleteMachinePopup: false,
            waiting: false,
            spinning: false,
            deleting: false,
        };
    }
}


/***/ }),

/***/ "./lib/models/machine/MachinePreviewComponent.js":
/*!*******************************************************!*\
  !*** ./lib/models/machine/MachinePreviewComponent.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MachinePreviewComponent": () => (/* binding */ MachinePreviewComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/* harmony import */ var _Machine__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Machine */ "./lib/models/machine/Machine.js");

// import { Tag } from '../../components/Tag'


class MachinePreviewComponent extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            const machine = this.props.machine;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: Object.assign({ padding: '6px 20px 9px 20px' }, this.props.style) },
                machine.getIdentityComponent(),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: {
                        display: 'inline-flex',
                        flexWrap: 'wrap',
                        width: '100%',
                        margin: '3px 0px',
                        fontSize: 'var(--jp-ui-font-size1)',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { flexGrow: 1, margin: '3px 0px' } },
                        "Machine",
                        _Machine__WEBPACK_IMPORTED_MODULE_1__.Machine.getStateMessage(machine.state) != '' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, ' (' + _Machine__WEBPACK_IMPORTED_MODULE_1__.Machine.getStateMessage(machine.state) + ')')),
                        ":"),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { display: 'inline-block', minWidth: '57px', margin: '3px 0px', textAlign: 'right' } },
                        machine.rate !== undefined && (machine.promo ? 'promo ' : ''),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { style: { fontWeight: 'bold' } }, machine.rate !== undefined && (_utils_FormatUtils__WEBPACK_IMPORTED_MODULE_2__.default.styleRateUnitValue()(machine.rate)))))));
        };
    }
}


/***/ }),

/***/ "./lib/models/machine/PopupMachineComponent.js":
/*!*****************************************************!*\
  !*** ./lib/models/machine/PopupMachineComponent.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PopupMachineComponent": () => (/* binding */ PopupMachineComponent)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _Machine__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Machine */ "./lib/models/machine/Machine.js");
/* harmony import */ var _material_ui_icons_MoreVert__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material-ui/icons/MoreVert */ "./node_modules/@material-ui/icons/MoreVert.js");
/* harmony import */ var _material_ui_core_DialogTitle__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material-ui/core/DialogTitle */ "./node_modules/@material-ui/core/esm/DialogTitle/DialogTitle.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _material_ui_icons_Close__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @material-ui/icons/Close */ "./node_modules/@material-ui/icons/Close.js");
/* harmony import */ var _MachineCapabilities__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./MachineCapabilities */ "./lib/models/machine/MachineCapabilities.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/










const StyledDialog = (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.withStyles)({
    paper: {
        width: 'calc(min(80%, 600px + 150px + 2px))',
        height: '80%',
        overflowY: 'visible',
        backgroundColor: 'var(--jp-layout-color1)',
        maxWidth: 'inherit',
    },
})(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Dialog);
// TODO:Beck The popup needs to be abstracted out, there is too much going on to reproduce it in more than one file
class PopupMachineComponent extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClickOpen = () => {
            if (this.props.onOpen)
                this.props.onOpen();
            this.safeSetState({ open: true });
        };
        this.handleClose = () => {
            this.safeSetState({ open: false });
            if (this.props.onClose)
                this.props.onClose();
        };
        this.handleMouseOver = (event) => {
            if (this.props.onMouseOver)
                this.props.onMouseOver(event);
        };
        this.handleMouseOut = (event) => {
            if (this.props.onMouseOut)
                this.props.onMouseOut(event);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const machine = this.props.machine;
            var placedApp;
            if (machine.app) {
                for (var app of _Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.appTracker.activeJobsOrSessions) {
                    if (app.uuid == machine.app) {
                        placedApp = app;
                    }
                }
            }
            return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.IconButton, { disabled: machine instanceof _Machine__WEBPACK_IMPORTED_MODULE_3__.NoMachine, onClick: this.handleClickOpen, style: {
                        display: 'inline-block',
                        width: '36px',
                        height: '36px',
                        padding: '3px',
                    }, onMouseOver: this.handleMouseOver, onMouseOut: this.handleMouseOut },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_icons_MoreVert__WEBPACK_IMPORTED_MODULE_4__.default, { style: {
                            width: '30px',
                            height: '30px',
                            padding: '3px',
                        } })),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(StyledDialog, { open: this.state.open, onClose: this.handleClose, scroll: 'paper' },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core_DialogTitle__WEBPACK_IMPORTED_MODULE_5__.default, { disableTypography: true, style: {
                            display: 'inline-flex',
                            backgroundColor: 'var(--jp-layout-color2)',
                            height: '60px',
                            padding: '6px',
                            borderRadius: '4px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: {
                                display: 'inline-flex',
                                minWidth: '150px',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                paddingRight: '12px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { margin: 'auto' } }, "Machine")),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: {
                                width: '100%',
                                display: 'inline-flex',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                padding: '10px',
                            } }),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.IconButton, { onClick: this.handleClose, style: {
                                display: 'inline-block',
                                width: '36px',
                                height: '36px',
                                padding: '3px',
                                margin: '6px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_icons_Close__WEBPACK_IMPORTED_MODULE_6__.default, { style: {
                                    width: '30px',
                                    height: '30px',
                                    padding: '3px',
                                } }))),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_7__.ShadowedDivider, null),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: {
                            display: 'flex',
                            height: 'calc(100% - 60px - 2px',
                            fontSize: 'var(--jp-ui-font-size1)',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { width: '150px' } },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.DialogContent, { style: { padding: '0px' } },
                                react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { padding: '6px' } },
                                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Tabs, { value: this.state.selectedPanel, onChange: (event, newValue) => this.safeSetState({ selectedPanel: newValue }), orientation: 'vertical', variant: 'fullWidth', indicatorColor: 'primary', textColor: 'primary', style: { minHeight: '24px' } },
                                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Tab, { label: 'CAPABILITY', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            } }),
                                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Tab, { label: 'STATUS', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            } }),
                                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.Tab, { label: 'COST', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            } }))))),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_core__WEBPACK_IMPORTED_MODULE_7__.ShadowedDivider, { orientation: 'vertical' }),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { display: 'flex', flexFlow: 'column', overflow: 'hidden', width: 'calc(100% - 150px)', height: '100%' } },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_0__.DialogContent, { style: { padding: '0px', flexGrow: 1, overflowY: 'auto' } }, this.state.selectedPanel == 0 /* CAPABILITY */ ? (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_MachineCapabilities__WEBPACK_IMPORTED_MODULE_8__.MachineCapability, { machine: machine })) : this.state.selectedPanel == 1 /* STATUS */ ? (react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null,
                                react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { margin: '6px' } }, _Machine__WEBPACK_IMPORTED_MODULE_3__.Machine.getStateMessage(this.props.machine.state) == '' ? 'Machine currently has no status' : 'Machine is currently ' + _Machine__WEBPACK_IMPORTED_MODULE_3__.Machine.getStateMessage(this.props.machine.state).toLowerCase()),
                                placedApp && (react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { margin: '6px' } }, (placedApp.interactive ? 'Session' : 'Job') + " '" + placedApp.name + "' is " + (((placedApp.requisitioning.completed && !placedApp.requisitioning.error) && !placedApp.running.completed) ? 'running on' : 'waiting for') + ' this machine')))) : this.state.selectedPanel == 2 /* COST */ && (react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { margin: '6px' } },
                                "Machine costs ",
                                _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_9__.default.styleRateUnitValue()(machine.rate) + (machine.promo ? ' (promotional price)' : '')))))))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            open: false,
            selectedPanel: 0 /* CAPABILITY */,
        };
    }
}


/***/ }),

/***/ "./lib/utils/ExtraInfo.js":
/*!********************************!*\
  !*** ./lib/utils/ExtraInfo.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ExtraInfo)
/* harmony export */ });
/* harmony import */ var react_bootstrap_OverlayTrigger__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-bootstrap/OverlayTrigger */ "./node_modules/react-bootstrap/esm/OverlayTrigger.js");
/* harmony import */ var react_bootstrap_Popover__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-bootstrap/Popover */ "./node_modules/react-bootstrap/esm/Popover.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "webpack/sharing/consume/default/@material-ui/core/@material-ui/core");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
var __rest = (undefined && undefined.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};





const REMOVE_EXTRA_INFO_CAUSE_ISSUE = false;
// Include the bootstrap styles once
if (!REMOVE_EXTRA_INFO_CAUSE_ISSUE)
    document.body.innerHTML += `<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css" integrity="sha384-9aIt2nRpC12Uk9gS9baDl411NQApFmC26EwAOH8WgZl5MYYxFfc+NcPb1dKGj7Sk" crossorigin="anonymous" />`;
function ExtraInfo(props) {
    const _a = Object.assign({
        // Defaults
        reminder: '',
        overview: '',
        documentation: '',
    }, props), { 
    // Props
    children, reminder, overview, documentation, onMouseOver, onMouseOut } = _a, other = __rest(_a, ["children", "reminder", "overview", "documentation", "onMouseOver", "onMouseOut"]);
    // To make this feel more familiar
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => { componentDidMount(); return componentWillUnmount; }, []);
    const [, reRender] = react__WEBPACK_IMPORTED_MODULE_0__.useReducer(x => x + 1, 0);
    const forceUpdate = () => reRender();
    const componentDidMount = () => {
        _Global__WEBPACK_IMPORTED_MODULE_2__.Global.onInQuestionModeChange.connect(forceUpdate);
        _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.themeChanged.connect(forceUpdate);
    };
    const componentWillUnmount = () => {
        _Global__WEBPACK_IMPORTED_MODULE_2__.Global.onInQuestionModeChange.disconnect(forceUpdate);
        _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.themeChanged.disconnect(forceUpdate);
    };
    const handleMouseOver = (triggerHandler, ...args) => {
        if (reminder !== undefined || (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.inQuestionMode && overview !== undefined))
            triggerHandler.onFocus(args);
        if (onMouseOver)
            return onMouseOver(args);
    };
    const handleMouseOut = (triggerHandler, ...args) => {
        if (reminder !== undefined || (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.inQuestionMode && overview !== undefined))
            triggerHandler.onBlur(args);
        if (onMouseOut)
            return onMouseOut(args);
    };
    const StyledPopover = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => (0,_material_ui_core__WEBPACK_IMPORTED_MODULE_1__.withStyles)({
        '@global': {
            '#styled-popover *': {
                color: `var(--jp-ui-font-color1)`,
            },
            '#styled-popover:not(:last-of-type) *': {
                display: 'none',
            },
            '#styled-popover': {
                zIndex: `1300`,
                borderColor: `var(--jp-ui-font-color1)`,
                maxWidth: `none`,
            },
            '#styled-popover .popover-header': {
                backgroundColor: `var(--jp-layout-color2)`,
                borderRadius: '.3rem',
                borderBottom: 'none',
                fontWeight: _Global__WEBPACK_IMPORTED_MODULE_2__.Global.inQuestionMode ? 'bold' : undefined,
                fontSize: !_Global__WEBPACK_IMPORTED_MODULE_2__.Global.inQuestionMode ? '14px' : undefined,
                padding: !_Global__WEBPACK_IMPORTED_MODULE_2__.Global.inQuestionMode ? '3px 6px' : undefined,
            },
            '#styled-popover .popover-body': {
                backgroundColor: `var(--jp-layout-color1)`,
            },
            '#styled-popover .arrow': {
                left: !_Global__WEBPACK_IMPORTED_MODULE_2__.Global.inQuestionMode ? '-4px !important' : undefined,
                top: _Global__WEBPACK_IMPORTED_MODULE_2__.Global.inQuestionMode ? '-5px !important' : undefined,
            },
            '#styled-popover .arrow::before': {
                borderRightColor: _Global__WEBPACK_IMPORTED_MODULE_2__.Global.inQuestionMode ? `var(--jp-ui-font-color1)` : undefined,
                borderTopColor: !_Global__WEBPACK_IMPORTED_MODULE_2__.Global.inQuestionMode ? `var(--jp-ui-font-color1)` : undefined,
            },
            '#styled-popover .arrow::after': {
                borderRightColor: _Global__WEBPACK_IMPORTED_MODULE_2__.Global.inQuestionMode ? `var(--jp-layout-color1)` : undefined,
                borderTopColor: !_Global__WEBPACK_IMPORTED_MODULE_2__.Global.inQuestionMode ? `var(--jp-layout-color2)` : undefined,
                left: !_Global__WEBPACK_IMPORTED_MODULE_2__.Global.inQuestionMode ? undefined : (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager == undefined || _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.isLight(_Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.theme)) ? '1px' : '2px',
                bottom: _Global__WEBPACK_IMPORTED_MODULE_2__.Global.inQuestionMode ? undefined : (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager == undefined || _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.isLight(_Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.theme)) ? '1px' : '2px',
            },
        }
    })(react_bootstrap_Popover__WEBPACK_IMPORTED_MODULE_3__.default), [_Global__WEBPACK_IMPORTED_MODULE_2__.Global.inQuestionMode, _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager]);
    const hasReminder = reminder !== undefined && reminder !== '';
    const hasOverview = overview !== undefined && overview !== '';
    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
        console.log('ComponentRender (' + new Date().getSeconds() + ')');
    return (REMOVE_EXTRA_INFO_CAUSE_ISSUE || (!hasReminder && !hasOverview)) ? children : ( // Render
    react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_bootstrap_OverlayTrigger__WEBPACK_IMPORTED_MODULE_4__.default, { delay: { show: _Global__WEBPACK_IMPORTED_MODULE_2__.Global.inQuestionMode ? 10 : 500, hide: 10 }, placement: _Global__WEBPACK_IMPORTED_MODULE_2__.Global.inQuestionMode ? 'right' : 'top', overlay: _Global__WEBPACK_IMPORTED_MODULE_2__.Global.inQuestionMode ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledPopover /*key={'questionMode' + reminder + overview}*/, { id: 'styled-popover' },
            reminder && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_bootstrap_Popover__WEBPACK_IMPORTED_MODULE_3__.default.Title, { as: 'h3' }, reminder)),
            overview && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_bootstrap_Popover__WEBPACK_IMPORTED_MODULE_3__.default.Content, null, overview)))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledPopover /*key={reminder + overview}*/, { id: 'styled-popover' }, reminder && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_bootstrap_Popover__WEBPACK_IMPORTED_MODULE_3__.default.Title, { as: 'h3' }, reminder)))) }, (_a) => {
        var { ref } = _a, triggerHandler = __rest(_a, ["ref"]);
        // If you can't see triggerHandler.onBlur(args), expose it in OverlayInjectedProps in node_modules/react-bootstrap/esm/OverlayTrigger.d.ts
        triggerHandler.onFocus;
        triggerHandler.onBlur; // Duplicate onFocus for onBlur: !!! CONTROL CLICK THIS FOR QUICK NAVIGATION TO THE FILE !!! => node_modules/react-bootstrap/esm/OverlayTrigger.d.ts:10:5
        return react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(children, Object.assign({
            ref: ref,
            onMouseOver: (...args) => handleMouseOver(triggerHandler, args),
            onMouseOut: (...args) => handleMouseOut(triggerHandler, args),
        }, Object.assign({}, other)));
    }));
} /*, (props: ExtraInfoProps, nextProps: ExtraInfoProps) => {
    if (props.reminder !== nextProps.reminder) return false;
    if (props.overview !== nextProps.overview) return false;
    if (props.documentation !== nextProps.documentation) return false;
    props.children.props
    if (JSON.stringify(props.children) !== JSON.stringify(nextProps.children)) return false;
    if (Global.shouldLogOnRender) console.log('SuppressedRender (' + new Date().getSeconds() + ')');
    return true
})*/


/***/ }),

/***/ "./lib/utils/FileServerUtils.js":
/*!**************************************!*\
  !*** ./lib/utils/FileServerUtils.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FileServerUtils)
/* harmony export */ });
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/

class FileServerUtils {
    // Return two booleans, the first is if the path exists, the second is if it is a file (true) or directory (false)
    static async checkIfPathExists(filePath) {
        const splitPath = filePath.split("/");
        let path = "";
        for (let i = 0; i < splitPath.length - 1; i++) {
            path += splitPath[i];
            if (i != splitPath.length - 2) {
                path += "/";
            }
        }
        const fileName = splitPath[splitPath.length - 1];
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "api/contents/" + path;
        const response = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeRequest(url, {}, settings).then((response) => {
            if (response.status !== 200) {
                throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.ResponseError(response);
            }
            return response.json();
        });
        try {
            const body = (await response);
            return [body.content.some((x) => x.name === fileName), body.content.some((x) => x.name == fileName && x.type != 'directory')];
        }
        catch (e) {
            // If we can't find the file, the second value is invalid
            return [false, undefined];
        }
    }
    static async getRecursiveTree(fileName) {
        var files = [];
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "api/contents/" + fileName;
        const response = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeRequest(url, {}, settings).then((response) => {
            if (response.status !== 200 && response.status !== 201) {
                throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.ResponseError(response);
            }
            return response.json();
        });
        const body = (await response);
        if (body.type == 'directory') {
            const promises = [];
            for (var file of body.content) {
                if (file.type == 'directory') {
                    promises.push(this.getRecursiveTree(file.path));
                }
                else {
                    files.push(file.path);
                }
            }
            for (var promise of promises) {
                files = files.concat(await promise);
            }
        }
        else {
            files.push(body.path);
        }
        return files;
    }
    static async saveNotebook(path, notebook) {
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "api/contents/" + path;
        const response = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeRequest(url, {
            body: JSON.stringify({
                content: notebook,
                'format': 'json',
                'type': 'notebook',
            }),
            method: 'PUT'
        }, settings).then(response => {
            if (response.status !== 200 && response.status !== 201) {
                throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.ResponseError(response);
            }
            return response.json();
        });
        const body = (await response);
        if (body)
            return true;
        return false;
    }
}


/***/ }),

/***/ "./lib/utils/FormatUtils.js":
/*!**********************************!*\
  !*** ./lib/utils/FormatUtils.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FormatUtils)
/* harmony export */ });
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
class FormatUtils {
    static msToTime(s) {
        var ms = s % 1000;
        s = (s - ms) / 1000;
        var secs = s % 60;
        s = (s - secs) / 60;
        var mins = s % 60;
        var hrs = (s - mins) / 60;
        return (hrs == 0 ? '' : (hrs < 10 ? '0' + hrs : hrs) + ':') + (mins < 10 ? '0' + mins : mins) + ':' + (secs < 10 ? '0' + secs : secs) /* + '.' + ms*/;
    }
    static styleCapacityUnit() {
        return (value) => {
            if (value == -1)
                return '';
            if (value < Math.pow(1024, 3)) {
                return 'MiB';
            }
            else if (value < Math.pow(1024, 4)) {
                return 'GiB';
            }
            else if (value < Math.pow(1024, 5)) {
                return 'TiB';
            }
            else {
                return 'PiB';
            }
        };
    }
    static styleCapacityValue() {
        return (value) => {
            if (value == -1)
                return 'unsp';
            if (value < Math.pow(1024, 3)) {
                return (value / Math.pow(1024, 2)).toFixed(3);
            }
            else if (value < Math.pow(1024, 4)) {
                return (value / Math.pow(1024, 3)).toFixed(3);
            }
            else if (value < Math.pow(1024, 5)) {
                return (value / Math.pow(1024, 4)).toFixed(3);
            }
            else {
                return (value / Math.pow(1024, 5)).toFixed(3);
            }
        };
    }
    static unstyleCapacityValue() {
        return (value, unit) => {
            if (value == -1)
                return value;
            if (isNaN(value))
                return Number.NaN;
            switch (unit.toLowerCase()) {
                case 'm':
                case 'mib':
                    return value * Math.pow(1024, 2);
                case 'g':
                case 'gib':
                    return value * Math.pow(1024, 3);
                case 't':
                case 'tib':
                    return value * Math.pow(1024, 4);
                case 'p':
                case 'pib':
                    return value * Math.pow(1024, 5);
                default:
                    return value;
            }
        };
    }
    static styleCapacityUnitValue() {
        return (value) => {
            if (value == -1)
                return 'unsp';
            if (value < Math.pow(1024, 2)) {
                return FormatUtils.customPrecision(value / Math.pow(1024, 1)) + ' KiB';
            }
            else if (value < Math.pow(1024, 3)) {
                return FormatUtils.customPrecision(value / Math.pow(1024, 2)) + ' MiB';
            }
            else if (value < Math.pow(1024, 4)) {
                return FormatUtils.customPrecision(value / Math.pow(1024, 3)) + ' GiB';
            }
            else if (value < Math.pow(1024, 5)) {
                return FormatUtils.customPrecision(value / Math.pow(1024, 4)) + ' TiB';
            }
            else {
                return FormatUtils.customPrecision(value / Math.pow(1024, 5)) + ' PiB';
            }
        };
    }
    // export function possibleCapacityUnitValue() {
    //     return (unitValue: string): boolean => {
    //         return unitValue.includes(/^(\d{1,4}|\d{1,2}\.\d|\d\.\d{2}) ?[mgtpezy]ib$/i)
    //     }
    // }
    // export function unstyleCapacityUnitValue() {
    //     return (unitValue: string): number => {
    //         if (unitValue == 'unsp') return -1
    //         var value: number = Number.parseFloat(unitValue.replace(/[^0-9\.]+/, ''))
    //         if (isNaN(value)) return Number.NaN
    //         var unit: string = unitValue.replace(/[0-9\.]+/, '').trim()
    //         switch (unit.toLowerCase()) {
    //         case 'mib':
    //             return value * Math.pow(1024, 2)
    //         case 'gib':
    //             return value * Math.pow(1024, 3)
    //         case 'tib':
    //             return value * Math.pow(1024, 4)
    //         case 'pib':
    //             return value * Math.pow(1024, 5)
    //         default:
    //             return Number.NaN
    //         }
    //     }
    // }
    static styleThroughputUnit() {
        return (value) => {
            if (value == -1)
                return '';
            if (value < Math.pow(1000, 3)) {
                return 'MBps';
            }
            else if (value < Math.pow(1000, 4)) {
                return 'GBps';
            }
            else if (value < Math.pow(1000, 5)) {
                return 'TBps';
            }
            else {
                return 'PiB';
            }
        };
    }
    static styleThroughputValue() {
        return (value) => {
            if (value == -1)
                return 'unsp';
            if (value < Math.pow(1000, 3)) {
                return (value / Math.pow(1000, 2)).toFixed(3);
            }
            else if (value < Math.pow(1000, 4)) {
                return (value / Math.pow(1000, 3)).toFixed(3);
            }
            else if (value < Math.pow(1000, 5)) {
                return (value / Math.pow(1000, 4)).toFixed(3);
            }
            else {
                return (value / Math.pow(1000, 5)).toFixed(3);
            }
        };
    }
    static unstyleThroughputValue() {
        return (value, unit) => {
            if (value == -1)
                return value;
            if (isNaN(value))
                return Number.NaN;
            switch (unit.toLowerCase()) {
                case 'm':
                case 'mbps':
                    return value * Math.pow(1000, 2);
                case 'g':
                case 'gbps':
                    return value * Math.pow(1000, 3);
                case 't':
                case 'tbps':
                    return value * Math.pow(1000, 4);
                case 'p':
                case 'pbps':
                    return value * Math.pow(1000, 5);
                default:
                    return value;
            }
        };
    }
    static styleThroughputUnitValue() {
        return (value) => {
            if (value == -1)
                return 'unsp';
            if (value < Math.pow(1000, 3)) {
                return FormatUtils.customPrecision(value / Math.pow(1000, 2)) + ' MBps';
            }
            else if (value < Math.pow(1000, 4)) {
                return FormatUtils.customPrecision(value / Math.pow(1000, 3)) + ' GBps';
            }
            else if (value < Math.pow(1000, 5)) {
                return FormatUtils.customPrecision(value / Math.pow(1000, 4)) + ' TBps';
            }
            else {
                return FormatUtils.customPrecision(value / Math.pow(1000, 5)) + ' PBps';
            }
        };
    }
    // export function unstyleThroughputUnitValue() {
    //     return (unitValue: string): number => {
    //         if (unitValue == 'unsp') return -1
    //         var value: number = Number.parseFloat(unitValue.replace(/[^0-9\.]+/, ''))
    //         if (isNaN(value)) return Number.NaN
    //         var unit: string = unitValue.replace(/[0-9\.]+/, '').trim()
    //         switch (unit.toLowerCase()) {
    //         case 'mbps':
    //             return value * Math.pow(1000, 2)
    //         case 'gbps':
    //             return value * Math.pow(1000, 3)
    //         case 'tbps':
    //             return value * Math.pow(1000, 4)
    //         case 'pbps':
    //             return value * Math.pow(1000, 5)
    //         default:
    //             return Number.NaN
    //         }
    //     }
    // }
    static styleFrequencyUnit() {
        return (value) => {
            if (value == -1)
                return '';
            if (value < Math.pow(1000, 3)) {
                return 'MHz';
            }
            else if (value < Math.pow(1000, 4)) {
                return 'GHz';
            }
            else if (value < Math.pow(1000, 5)) {
                return 'THz';
            }
            else {
                return 'PHz';
            }
        };
    }
    static styleFrequencyValue() {
        return (value) => {
            if (value == -1)
                return 'unsp';
            if (value < Math.pow(1000, 3)) {
                return (value / Math.pow(1000, 2)).toFixed(3);
            }
            else if (value < Math.pow(1000, 4)) {
                return (value / Math.pow(1000, 3)).toFixed(3);
            }
            else if (value < Math.pow(1000, 5)) {
                return (value / Math.pow(1000, 4)).toFixed(3);
            }
            else {
                return (value / Math.pow(1000, 5)).toFixed(3);
            }
        };
    }
    static unstyleFrequencyValue() {
        return (value, unit) => {
            if (value == -1)
                return value;
            if (isNaN(value))
                return Number.NaN;
            switch (unit.toLowerCase()) {
                case 'm':
                case 'mhz':
                    return value * Math.pow(1000, 2);
                case 'g':
                case 'ghz':
                    return value * Math.pow(1000, 3);
                case 't':
                case 'thz':
                    return value * Math.pow(1000, 4);
                case 'p':
                case 'phz':
                    return value * Math.pow(1000, 5);
                default:
                    return value;
            }
        };
    }
    static styleFrequencyUnitValue() {
        return (value) => {
            if (value == -1)
                return 'unsp';
            if (value < Math.pow(1000, 3)) {
                return FormatUtils.customPrecision(value / Math.pow(1000, 2)) + ' MHz';
            }
            else if (value < Math.pow(1000, 4)) {
                return FormatUtils.customPrecision(value / Math.pow(1000, 3)) + ' GHz';
            }
            else if (value < Math.pow(1000, 5)) {
                return FormatUtils.customPrecision(value / Math.pow(1000, 4)) + ' THz';
            }
            else {
                return FormatUtils.customPrecision(value / Math.pow(1000, 5)) + ' PHz';
            }
        };
    }
    // export function unstyleFrequencyUnitValue() {
    //     return (unitValue: string): number => {
    //         if (unitValue == 'unsp') return -1
    //         var value: number = Number.parseFloat(unitValue.replace(/[^0-9\.]+/, ''))
    //         if (isNaN(value)) return Number.NaN
    //         var unit: string = unitValue.replace(/[0-9\.]+/, '').trim()
    //         switch (unit.toLowerCase()) {
    //         case 'mhz':
    //             return value * Math.pow(1000, 2)
    //         case 'ghz':
    //             return value * Math.pow(1000, 3)
    //         case 'thz':
    //             return value * Math.pow(1000, 4)
    //         case 'phz':
    //             return value * Math.pow(1000, 5)
    //         default:
    //             return Number.NaN
    //         }
    //     }
    // }
    static styleDurationUnitValue() {
        return (value) => {
            if (value == -1)
                return 'unsp';
            if (value < 60) {
                return FormatUtils.customPrecision(value, 2) + ' s';
            }
            else if (value / 60 < 60) {
                return FormatUtils.customPrecision(value / 60, 2) + ' min';
            }
            else if (value / 60 / 60 < 24) {
                return FormatUtils.customPrecision(value / 60 / 60, 2) + ' hr';
            }
            else {
                return FormatUtils.customPrecision(value / 60 / 60 / 24) + ' d';
            }
        };
    }
    // export function unstyleDurationUnitValue() {
    //     return (unitValue: string): number => {
    //         if (unitValue == 'unsp') return -1
    //         var value: number = Number.parseFloat(unitValue.replace(/[^0-9\.]+/, ''))
    //         if (isNaN(value)) return Number.NaN
    //         var unit: string = unitValue.replace(/[0-9\.]+/, '').trim()
    //         switch (unit.toLowerCase()) {
    //         case 's':
    //             return value
    //         case 'min':
    //         case 'm':
    //             return value * 60
    //         case 'hr':
    //         case 'h':
    //             return value * 60 * 60
    //         case 'd':
    //             return value * 60 * 60 * 24
    //         default:
    //             return Number.NaN
    //         }
    //     }
    // }
    static styleRatingUnit() {
        return (value) => {
            if (value == -1)
                return '';
            return '%';
        };
    }
    static styleRatingValue() {
        return (value) => {
            if (value == -1)
                return 'unsp';
            return (value * 100).toFixed(3);
        };
    }
    static unstyleRatingValue() {
        return (value, unit) => {
            if (value == -1)
                return value;
            if (isNaN(value))
                return Number.NaN;
            return value / 100;
        };
    }
    // export function styleRatingUnitValue() {
    //     return (value: number): string => {
    //         if (value == -1) return 'unsp'
    //         return FormatUtils.customPrecision(value, 2) + '%';
    //     }
    // }
    // export function unstyleRatingUnitValue() {
    //     return (unitValue: string): number => {
    //         if (unitValue == 'unsp') return -1
    //         var value: number = Number.parseFloat(unitValue.replace(/[^0-9\.]+/, ''))
    //         if (isNaN(value)) return Number.NaN
    //         if (unitValue.replace(/[0-9\.%]/g, '') != '') return Number.NaN
    //         return value;
    //     }
    // }
    static styleRateUnit() {
        return (value) => {
            return '$/hr';
        };
    }
    static styleRateValue() {
        return (value) => {
            return value.toString();
        };
    }
    static styleRateUnitValue() {
        return (value) => {
            return '$' + value.toFixed(2) + '/hr';
        };
    }
    // export function unstyleRateUnitValue() {
    //     return (unitValue: string): number => {
    //         var value: number = Number.parseFloat(unitValue.replace(/[^0-9\.]/g, ''))
    //         if (isNaN(value)) return Number.NaN
    //         var unit: string = unitValue.replace(/[0-9\.]+/, '').trim()
    //         switch (unit.toLowerCase()) {
    //         case '$/min':
    //             return value * 60;
    //         case '$/hr':
    //             return value * 1;
    //         case '$/day':
    //             return value / 24;
    //         default:
    //             return Number.NaN
    //         }
    //     }
    // }
    static styleRate() {
        return (value) => {
            if (isNaN(value)) {
                return 'no match';
            }
            else if (value >= 0.1) {
                return '$' + value.toFixed(2) + '/hr';
            }
            else {
                return (value * 100).toFixed(1) + '¢/hr';
            }
        };
    }
    static customPrecision(value, maxPrecision = 3) {
        var places = Math.floor(value).toString().length;
        if (places <= maxPrecision) {
            var ret = value.toPrecision(maxPrecision);
            // Shorten the text if it ends in 0 or .
            while (ret.endsWith('0'))
                ret = ret.substr(0, ret.length - 1);
            if (ret.endsWith('.'))
                ret = ret.substr(0, ret.length - 1);
            return ret;
        }
        else {
            return value.toString();
        }
    }
}


/***/ }),

/***/ "./lib/utils/LogScaleUtils.js":
/*!************************************!*\
  !*** ./lib/utils/LogScaleUtils.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ LogScaleUtils)
/* harmony export */ });
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
class LogScaleUtils {
    constructor(min, max, step, logBase, ignoreLabel) {
        // Externally we will represent with the same number of decimals as in 'step'
        this.scale = (x) => this.round(x ** this.logBase, this.countDecimals(this.step));
        // Internally we will represent with 5 decimal places. This can be increased if necessary	
        this.unscale = (x) => this.round(x ** (1 / this.logBase), 5);
        this.min = min;
        this.max = max;
        this.step = step;
        this.logBase = logBase;
        this.marks = this.generateMarks(ignoreLabel);
    }
    getMarks() {
        return this.marks;
    }
    getScale() {
        return this.scale;
    }
    getUnscale() {
        return this.unscale;
    }
    countDecimals(value) {
        if (Math.floor(value) === value)
            return 0;
        return value.toString().split(".")[1].length || 0;
    }
    isWhole(value) {
        const ret = value % 1 == 0;
        return ret;
    }
    round(value, precision) {
        var multiplier = Math.pow(10, precision || 0);
        return Math.round(value * multiplier) / multiplier;
    }
    generateMarks(ignoreLabel) {
        const marks = [];
        const roundDigits = this.countDecimals(this.step);
        var i = this.min;
        while (i <= this.max) {
            if (this.isWhole(i) && !ignoreLabel) {
                marks.push({
                    value: this.round(i ** (1 / this.logBase), 5),
                    label: "$" + i.toFixed(0),
                });
            }
            else {
                marks.push({
                    value: this.round(i ** (1 / this.logBase), 5),
                });
            }
            i += this.step;
            i = this.round(i, roundDigits);
        }
        return marks;
    }
}


/***/ }),

/***/ "./lib/utils/NotebookUtils.js":
/*!************************************!*\
  !*** ./lib/utils/NotebookUtils.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ NotebookUtils)
/* harmony export */ });
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
class NotebookUtils {
    // Remove chunks that should be overridden by the effect of
    // carriage return characters
    static fixCarriageReturn(txt) {
        txt = txt.replace(/\r+\n/gm, '\n'); // \r followed by \n --> newline
        while (txt.search(/\r[^$]/g) > -1) {
            var base = txt.match(/^(.*)\r+/m)[1];
            var insert = txt.match(/\r+(.*)$/m)[1];
            insert = insert + base.slice(insert.length, base.length);
            txt = txt.replace(/\r+.*$/m, '\r').replace(/^.*\r/m, insert);
        }
        return txt;
    }
    // Remove characters that are overridden by backspace characters
    static fixBackspace(txt) {
        var tmp = txt;
        do {
            txt = tmp;
            // Cancel out anything-but-newline followed by backspace
            tmp = txt.replace(/\n?[^\x08]\x08/g, '');
        } while (tmp.length < txt.length);
        return txt;
    }
    // Remove characters overridden by backspace and carriage return
    static fixOverwrittenChars(txt) {
        if (Array.isArray(txt)) {
            return NotebookUtils.fixBackspace(NotebookUtils.fixCarriageReturn(txt.join('')));
        }
        