"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalTable = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const dynamodb = require("@aws-cdk/aws-dynamodb");
const cdk = require("@aws-cdk/core");
const global_table_coordinator_1 = require("./global-table-coordinator");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("@aws-cdk/core");
/**
 * (deprecated) This class works by deploying an AWS DynamoDB table into each region specified in  GlobalTableProps.regions[], then triggering a CloudFormation Custom Resource Lambda to link them all together to create linked AWS Global DynamoDB tables.
 *
 * @deprecated use `@aws-cdk/aws-dynamodb.Table.replicationRegions` instead
 */
class GlobalTable extends core_1.Construct {
    /**
     * @deprecated
     */
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Creates dynamoDB tables across regions that will be able to be globbed together into a global table
         */
        this._regionalTables = new Array();
        cdk.Annotations.of(this).addWarning('The @aws-cdk/aws-dynamodb-global module has been deprecated in favor of @aws-cdk/aws-dynamodb.Table.replicationRegions');
        this._regionalTables = [];
        if (props.stream != null && props.stream !== dynamodb.StreamViewType.NEW_AND_OLD_IMAGES) {
            throw new Error('dynamoProps.stream MUST be set to dynamodb.StreamViewType.NEW_AND_OLD_IMAGES');
        }
        // need to set this stream specification, otherwise global tables don't work
        // And no way to set a default value in an interface
        const regionalTableProps = {
            ...props,
            removalPolicy: props.removalPolicy,
            stream: dynamodb.StreamViewType.NEW_AND_OLD_IMAGES,
        };
        this.lambdaGlobalTableCoordinator = new global_table_coordinator_1.GlobalTableCoordinator(scope, id + '-CustomResource', props);
        const scopeStack = cdk.Stack.of(scope);
        // here we loop through the configured regions.
        // in each region we'll deploy a separate stack with a DynamoDB Table with identical properties in the individual stacks
        for (const region of props.regions) {
            const regionalStack = new cdk.Stack(this, id + '-' + region, { env: { region, account: scopeStack.account } });
            const regionalTable = new dynamodb.Table(regionalStack, `${id}-GlobalTable-${region}`, regionalTableProps);
            this._regionalTables.push(regionalTable);
            // deploy the regional stack before the Lambda coordinator stack
            this.lambdaGlobalTableCoordinator.addDependency(regionalStack);
        }
    }
    /**
     * (deprecated) Obtain tables deployed in other each region.
     *
     * @deprecated
     */
    get regionalTables() {
        return this._regionalTables.map(x => x);
    }
}
exports.GlobalTable = GlobalTable;
_a = JSII_RTTI_SYMBOL_1;
GlobalTable[_a] = { fqn: "@aws-cdk/aws-dynamodb-global.GlobalTable", version: "1.95.0" };
//# sourceMappingURL=data:application/json;base64,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