/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.iom.orb.ThreadPool;
import com.sas.iom.orb.WorkException;
import com.sas.iom.orb.WorkInterface;
import com.sas.security.BaseSecuritySupport;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ClusterEnvelope;
import com.sas.services.connection.ConnectionEnvelope;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryKernel;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionFactoryRequest;
import com.sas.services.connection.ConnectionRequest;
import com.sas.services.connection.ConnectionResources;
import com.sas.services.connection.Credential;
import com.sas.services.connection.FatalConnectionFactoryException;
import com.sas.services.connection.Puddle;
import com.sas.services.connection.RB;
import com.sas.services.connection.Server;
import com.sas.text.Message;
import java.lang.ref.WeakReference;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;

@SASScope
public class PuddleEnvelope {
    private static final String _threadNameBase = PuddleEnvelope.class.getName() + ".cxCreation ";
    private Puddle _puddle;
    private Set _userCache;
    private ConnectionFactoryKernel _lock;
    private int _puddleIndex;
    private String _msgPrefix;
    private boolean[] _clusterStatus;
    private Delegate _delegate;
    private int _clients;
    private int _waiting;
    private boolean _shutdown;
    private ClusterEnvelope[] _clEnvs;

    public PuddleEnvelope(Puddle puddle) {
        Set userCredentials = puddle.getUserCredentials();
        if (userCredentials != null) {
            this._userCache = new HashSet(userCredentials.size());
            this._userCache.addAll(userCredentials);
        } else if (puddle.getUsers() != null) {
            this._userCache = new HashSet();
        }
        this._puddle = puddle;
        String classID = puddle.getClassID();
        int serverType = Server.clsidToServerType(classID);
        if (serverType != 1) {
            throw new IllegalArgumentException("All servers in a puddle must be SAS Workspace servers.");
        }
        this._delegate = new PoolingDelegate();
        Cluster[] clusters = puddle.getClusterArray();
        this._clusterStatus = new boolean[clusters.length];
        for (int i = 0; i < this._clusterStatus.length; ++i) {
            this._clusterStatus[i] = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserToCache(Credential user) {
        if (this._userCache != null) {
            Set set = this._userCache;
            synchronized (set) {
                this._userCache.add(user);
            }
        }
    }

    public Puddle getPuddle() {
        return this._puddle;
    }

    public Set getUserCache() {
        return this._userCache;
    }

    protected void setLock(ConnectionFactoryKernel lock) {
        this._lock = lock;
        Cluster[] clusters = this._puddle.getClusterArray();
        this._clEnvs = new ClusterEnvelope[clusters.length];
        for (int i = 0; i < clusters.length; ++i) {
            this._clEnvs[i] = new ClusterEnvelope(lock, clusters[i]);
        }
    }

    protected void setPuddleIndex(int puddleIndex) {
        this._puddleIndex = puddleIndex;
        String id = Integer.toHexString(puddleIndex);
        this._msgPrefix = "(p" + id + ") ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        this._delegate.init();
        ConnectionFactoryKernel connectionFactoryKernel = this._lock;
        synchronized (connectionFactoryKernel) {
            this._delegate.checkMinimums();
        }
    }

    protected double getLoad() {
        int available = this._delegate.available();
        if (available > this._waiting) {
            return 0.0;
        }
        int pending = this._delegate.pending();
        if (pending + available > this._waiting) {
            return Double.MIN_VALUE;
        }
        int capacity = this._delegate.capacity();
        return (2.0 * (double)this._clients + 1.0) / (double)capacity;
    }

    protected int getClients() {
        return this._clients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionEnvelope getConnection(ConnectionRequest cxReq) throws ConnectionFactoryException {
        ConnectionEnvelope cxEnv = null;
        ConnectionFactoryKernel connectionFactoryKernel = this._lock;
        synchronized (connectionFactoryKernel) {
            long waitMilliseconds;
            long timer = waitMilliseconds = cxReq.getWaitMilliseconds();
            do {
                int cap = this._delegate.capacity();
                int ms = this._puddle.getMinSize();
                if (cap == 0 || cap < ms && this._clients + this._waiting >= cap) {
                    Throwable cause = this._delegate.getCause();
                    String messageIndex = "cxf.300.ex.fmt";
                    String messagePattern = RB.getStringResource(messageIndex);
                    String message = Message.format((String)messagePattern, (java.lang.Object)messageIndex);
                    throw new FatalConnectionFactoryException(message, cause);
                }
                try {
                    if (waitMilliseconds == 0L) {
                        while (this._clients + this._waiting >= this._delegate.capacity() && !this._shutdown) {
                            this._lock.wait();
                        }
                    } else {
                        while (timer > 0L && this._clients + this._waiting >= this._delegate.capacity() && !this._shutdown) {
                            long start = System.currentTimeMillis();
                            this._lock.wait(timer);
                            long stop = System.currentTimeMillis();
                            timer -= stop - start;
                        }
                        if (this._clients + this._waiting >= this._delegate.capacity()) {
                            String messageIndex = "cxf.301.ex.fmt";
                            String messagePattern = RB.getStringResource(messageIndex);
                            String message = Message.format((String)messagePattern, (java.lang.Object)messageIndex);
                            throw new ConnectionFactoryException(message);
                        }
                    }
                    if (this._shutdown) {
                        String messageIndex = "cxf.302.ex.fmt";
                        String messagePattern = RB.getStringResource(messageIndex);
                        String message = Message.format((String)messagePattern, (java.lang.Object)messageIndex);
                        throw new ConnectionFactoryException(message);
                    }
                }
                catch (InterruptedException ie) {
                    String messageIndex = "cxf.303.ex.fmt";
                    String messagePattern = RB.getStringResource(messageIndex);
                    String message = Message.format((String)messagePattern, (java.lang.Object)messageIndex);
                    throw new ConnectionFactoryException(message);
                }
                while (this._waiting >= this._delegate.available() + this._delegate.pending()) {
                    this._delegate.createConnection("request");
                }
                while (this._delegate.available() == 0 && !this._shutdown) {
                    try {
                        ++this._waiting;
                        this._lock.wait();
                    }
                    catch (InterruptedException ie) {
                        String messageIndex = "cxf.304.ex.fmt";
                        String messagePattern = RB.getStringResource(messageIndex);
                        String message = Message.format((String)messagePattern, (java.lang.Object)messageIndex);
                        throw new ConnectionFactoryException(message);
                    }
                    finally {
                        --this._waiting;
                    }
                }
                if (!this._shutdown) continue;
                String messageIndex = "cxf.305.ex.fmt";
                String messagePattern = RB.getStringResource(messageIndex);
                String message = Message.format((String)messagePattern, (java.lang.Object)messageIndex);
                throw new ConnectionFactoryException(message);
            } while ((cxEnv = this._delegate.getAvailableConnection(cxReq)) == null);
            ++this._clients;
        }
        return cxEnv;
    }

    protected void reactivateConnection(ConnectionEnvelope cxEnv, int reason) {
        this._delegate.reactivateConnection(cxEnv, reason);
    }

    protected void shutdown() {
        this._shutdown = true;
        this._delegate.shutdown();
    }

    protected void destroy() {
        this._shutdown = true;
        this._delegate.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeUserFromCache(Credential user) {
        if (this._userCache != null) {
            Set set = this._userCache;
            synchronized (set) {
                this._userCache.remove(user);
            }
        }
    }

    private boolean isLoggableFINE() {
        ConnectionFactoryRequest cxfReq = this._lock.getRequest();
        boolean result = cxfReq.isLoggableFINE();
        return result;
    }

    private boolean isLoggableWARNING() {
        ConnectionFactoryRequest cxfReq = this._lock.getRequest();
        boolean result = cxfReq.isLoggableWARNING();
        return result;
    }

    private void logFINE(String msg) {
        ConnectionFactoryRequest cxfReq = this._lock.getRequest();
        cxfReq.logFINE(this._msgPrefix + msg);
    }

    private void logWARNING(String msg) {
        ConnectionFactoryRequest cxfReq = this._lock.getRequest();
        cxfReq.logWARNING(this._msgPrefix + msg);
    }

    @SASScope
    private class PoolingDelegate
    extends Delegate {
        private Set _cxSet;
        private Set _trackingSet;
        private List _avail;
        private int _pend;
        private int[] _clusterUsage;
        private Thread _shutdownTimer;
        private boolean _shutdownTimerDone;
        private Throwable _cause;
        private ThreadPool _threadPool;
        private boolean _myThreadPool;

        private PoolingDelegate() {
            this._cxSet = new HashSet();
            this._trackingSet = new HashSet();
            this._avail = new ArrayList();
            Cluster[] clusters = PuddleEnvelope.this._puddle.getClusterArray();
            this._clusterUsage = new int[clusters.length];
        }

        @Override
        protected void init() {
            ConnectionFactoryManager cxfManager = PuddleEnvelope.this._lock.getManager();
            ConnectionResources cxResources = cxfManager.getConnectionResources();
            if (cxResources != null) {
                this._threadPool = cxResources.getThreadPool();
            }
            if (this._threadPool == null) {
                this._threadPool = new ThreadPool(_threadNameBase);
                this._myThreadPool = true;
            }
        }

        @Override
        protected int capacity() {
            int cap = 0;
            Cluster[] clusters = PuddleEnvelope.this._puddle.getClusterArray();
            for (int i = 0; i < clusters.length; ++i) {
                if (!PuddleEnvelope.this._clusterStatus[i]) continue;
                int maxClients = clusters[i].getMaxClients();
                if (Integer.MAX_VALUE - maxClients < cap) {
                    return Integer.MAX_VALUE;
                }
                cap += maxClients;
            }
            return cap;
        }

        @Override
        protected int available() {
            return this._avail.size();
        }

        @Override
        protected int pending() {
            return this._pend;
        }

        @Override
        protected void createConnection(String cause) {
            final int clusterIndex = this.chooseCluster();
            final Credential serverCredential = PuddleEnvelope.this._puddle.getServerCredential();
            int n = clusterIndex;
            this._clusterUsage[n] = this._clusterUsage[n] + 1;
            ++this._pend;
            WorkInterface r = new WorkInterface(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String msg;
                    ConnectionEnvelope cxEnv;
                    ConnectionRequest cxReq = ConnectionRequest.wrap(PuddleEnvelope.this._lock, serverCredential);
                    if (cxReq.isLoggableFINE()) {
                        String msg2 = PuddleEnvelope.this._msgPrefix + "internal connection request";
                        cxReq.logFINE(msg2);
                    }
                    if ((cxEnv = PuddleEnvelope.this._clEnvs[clusterIndex].getConnection(cxReq)).isBogus()) {
                        if (cxReq.isLoggableFINE()) {
                            msg = PuddleEnvelope.this._msgPrefix + "internal connection request failed";
                            cxReq.logFINE(msg);
                        }
                    } else {
                        if (cxReq.isLoggableFINE()) {
                            msg = PuddleEnvelope.this._msgPrefix + "internal connection request OK";
                            cxReq.logFINE(msg);
                        }
                        cxEnv.setClusterIndex(clusterIndex);
                        cxEnv.setPuddleEnvelope(PuddleEnvelope.this);
                        cxEnv.setOwnerCredential(serverCredential);
                        cxEnv.setPuddleIndex(PuddleEnvelope.this._puddleIndex);
                    }
                    ConnectionFactoryKernel connectionFactoryKernel = PuddleEnvelope.this._lock;
                    synchronized (connectionFactoryKernel) {
                        if (!cxEnv.isBogus()) {
                            PoolingDelegate.this._cxSet.add(cxEnv.getRootObject());
                            PoolingDelegate.this._trackingSet.add(new WeakReference<ConnectionEnvelope>(cxEnv));
                        } else {
                            ((PuddleEnvelope)PuddleEnvelope.this)._clusterStatus[clusterIndex] = false;
                        }
                        PoolingDelegate.this.addAvail(cxEnv);
                        PoolingDelegate.this._pend--;
                    }
                }

                @Override
                public void release() {
                }
            };
            try {
                this._threadPool.executeDaemon(r);
            }
            catch (WorkException we) {
                r.run();
            }
        }

        @Override
        protected ConnectionEnvelope getAvailableConnection(ConnectionRequest cxReq) {
            while (this._avail.size() > 0) {
                ConnectionEnvelope cxEnv = (ConnectionEnvelope)this._avail.remove(0);
                String connectionID = cxEnv.getConnectionID();
                if (PuddleEnvelope.this.isLoggableFINE()) {
                    PuddleEnvelope.this.logFINE("removing connection from available queue " + connectionID);
                }
                if (cxEnv.isBogus()) {
                    this.destroyConnection(cxEnv, null);
                    continue;
                }
                cxEnv.incrClientCount();
                cxEnv.incrReactivationCount();
                this.checkMinimums();
                return cxEnv;
            }
            return null;
        }

        @Override
        protected void reactivateConnection(ConnectionEnvelope cxEnv, int reason) {
            int reactCount;
            Object userObject;
            ConnectionFactoryRequest cxfReq;
            String whom = null;
            String cause = null;
            if (reason == 0) {
                whom = "(user)";
                cause = "return";
            } else if (reason == 2) {
                whom = "(internal - refresh failed)";
                cause = "refresh";
            } else if (reason == 3) {
                whom = "(internal - no permission)";
                cause = "no_permission";
            } else if (reason == 4) {
                whom = "(internal - bad option)";
                cause = "bad_option";
            } else {
                whom = "(garbage collector)";
                cause = "garbage_collection";
            }
            String connectionID = cxEnv.getConnectionID();
            if (PuddleEnvelope.this.isLoggableFINE()) {
                String msg = "connection returned " + connectionID + whom;
                PuddleEnvelope.this.logFINE(msg);
            }
            if ((cxfReq = PuddleEnvelope.this._lock.getRequest()).isTraceable()) {
                String msg = "traceback for connection returned " + connectionID;
                Throwable tb = new Throwable("This traceback is for information only. It is not an error.");
                cxfReq.trace(msg, tb);
            }
            if (reason == 1 && PuddleEnvelope.this.isLoggableWARNING()) {
                PuddleEnvelope.this.logWARNING("A connection was returned to the factory by the garbage collector " + connectionID);
            }
            if ((userObject = cxEnv.getUserObject()) != null && userObject != cxEnv.getRootObject()) {
                cxEnv.setUserObject(null);
                IWorkspace userWorkspace = IWorkspaceHelper.narrow(userObject);
                try {
                    userWorkspace.Close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (reason == 2 || reason == 3) {
                this.destroyConnection(cxEnv, cause);
                PuddleEnvelope.this._clients--;
                if (reason == 3) {
                    int clusterIndex = cxEnv.getClusterIndex();
                    ((PuddleEnvelope)PuddleEnvelope.this)._clusterStatus[clusterIndex] = false;
                    this._cause = cxEnv.getCause();
                }
                return;
            }
            if (PuddleEnvelope.this._shutdown) {
                if (PuddleEnvelope.this.isLoggableFINE()) {
                    String msg = "connection will be destroyed due to factory shutdown " + connectionID;
                    PuddleEnvelope.this.logFINE(msg);
                }
                this.destroyConnection(cxEnv, cause);
                PuddleEnvelope.this._clients--;
                return;
            }
            int limit = cxEnv.getServer().getReactivationLimit();
            if (limit > 0 && (reactCount = cxEnv.getReactivationCount()) >= limit) {
                if (PuddleEnvelope.this.isLoggableFINE()) {
                    String msg = "connection will be destroyed due to reactivation limit " + connectionID;
                    PuddleEnvelope.this.logFINE(msg);
                }
                this.destroyConnection(cxEnv, cause);
                PuddleEnvelope.this._clients--;
                this.checkMinimums();
                return;
            }
            PuddleEnvelope.this._clients--;
            cxEnv.decrClientCount();
            cxEnv.setUserCredential(null);
            this.addAvail(cxEnv);
        }

        @Override
        protected void checkMinimums() {
            int minSize = PuddleEnvelope.this._puddle.getMinSize();
            while (this._cxSet.size() + this._pend < minSize && this._cxSet.size() + this._pend < this.capacity()) {
                if (PuddleEnvelope.this.isLoggableFINE()) {
                    PuddleEnvelope.this.logFINE("creating a connection to satisfy minSize");
                }
                this.createConnection("min_size");
            }
            int minAvail = PuddleEnvelope.this._puddle.getMinAvail();
            while (this._avail.size() + this._pend < minAvail && this._cxSet.size() + this._pend < this.capacity()) {
                if (PuddleEnvelope.this.isLoggableFINE()) {
                    PuddleEnvelope.this.logFINE("creating a connection to satisfy minAvail");
                }
                this.createConnection("min_avail");
            }
        }

        @Override
        protected Throwable getCause() {
            return this._cause;
        }

        @Override
        protected void shutdown() {
            this._shutdownTimerDone = true;
            PuddleEnvelope.this._lock.notifyAll();
            Iterator availItor = this._avail.iterator();
            while (availItor.hasNext()) {
                ConnectionEnvelope cxEnv = (ConnectionEnvelope)availItor.next();
                availItor.remove();
                this.destroyConnection(cxEnv, "shutdown");
            }
        }

        @Override
        protected void destroy() {
            this._shutdownTimerDone = true;
            PuddleEnvelope.this._lock.notifyAll();
            int trackingSetSize = this._trackingSet.size();
            HashSet copy = new HashSet(trackingSetSize);
            copy.addAll(this._trackingSet);
            for (WeakReference ref : copy) {
                ConnectionEnvelope cxEnv = (ConnectionEnvelope)ref.get();
                if (cxEnv == null) continue;
                this.destroyConnection(cxEnv, "destroy");
            }
            PuddleEnvelope.this._clients = 0;
            try {
                while (this._pend > 0) {
                    PuddleEnvelope.this._lock.wait();
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (this._myThreadPool) {
                this._threadPool.term();
            }
        }

        @Override
        protected int chooseCluster() {
            int bestCluster = -1;
            double bestLoad = Double.POSITIVE_INFINITY;
            Cluster[] clusters = PuddleEnvelope.this._puddle.getClusterArray();
            for (int i = 0; i < clusters.length; ++i) {
                double maxClients;
                double curClients;
                double load;
                if (!PuddleEnvelope.this._clusterStatus[i] || !((load = ((curClients = (double)this._clusterUsage[i]) * 2.0 + 1.0) / (maxClients = (double)clusters[i].getMaxClients())) < bestLoad) || !(load <= 2.0)) continue;
                bestLoad = load;
                bestCluster = i;
            }
            return bestCluster;
        }

        private void addAvail(ConnectionEnvelope cxEnv) {
            if (PuddleEnvelope.this._shutdown) {
                this.destroyConnection(cxEnv, "shutdown");
                PuddleEnvelope.this._lock.notifyAll();
                return;
            }
            if (!cxEnv.isBogus()) {
                int shutdownAfterMins = cxEnv.getServer().getShutdownAfterMinutes();
                if (shutdownAfterMins >= 0) {
                    BaseSecuritySupport secSup = BaseSecuritySupport.securitySupport;
                    long nowMillis = System.currentTimeMillis();
                    long offsetMillis = shutdownAfterMins == 0 ? 500L : (long)shutdownAfterMins * 60L * 1000L;
                    cxEnv.setShutdownTime(nowMillis + offsetMillis);
                    if (this._shutdownTimer == null) {
                        this._shutdownTimer = secSup.createThread((Runnable)new ShutdownTimer());
                        PrivilegedAction daemonAction = new PrivilegedAction(){

                            public java.lang.Object run() {
                                PoolingDelegate.this._shutdownTimer.setName("com.sas.services.connection.PuddleEnvelope.shutdown_timer");
                                PoolingDelegate.this._shutdownTimer.setDaemon(true);
                                return null;
                            }
                        };
                        secSup.doThreadPrivileged(daemonAction);
                        this._shutdownTimer.start();
                    }
                }
            } else {
                this._cause = cxEnv.getCause();
            }
            this._avail.add(cxEnv);
            PuddleEnvelope.this._lock.notifyAll();
            if (PuddleEnvelope.this.isLoggableFINE()) {
                String connectionID = cxEnv.getConnectionID();
                String msg = "adding connection to available queue " + connectionID;
                PuddleEnvelope.this.logFINE(msg);
            }
        }

        private void destroyConnection(ConnectionEnvelope cxEnv, String cause) {
            if (!cxEnv.isBogus()) {
                int n = cxEnv.getClusterIndex();
                this._clusterUsage[n] = this._clusterUsage[n] - 1;
                ObjectImpl obj = (ObjectImpl)cxEnv.getRootObject();
                Iterator cxSetItor = this._cxSet.iterator();
                while (cxSetItor.hasNext()) {
                    Object t = (Object)cxSetItor.next();
                    if (!obj._is_equivalent(t)) continue;
                    cxSetItor.remove();
                    break;
                }
                Iterator trackingSetItor = this._trackingSet.iterator();
                while (trackingSetItor.hasNext()) {
                    WeakReference ref = (WeakReference)trackingSetItor.next();
                    java.lang.Object reft = ref.get();
                    if (!cxEnv.equals(reft)) continue;
                    trackingSetItor.remove();
                    break;
                }
                ORB orb = obj._orb();
                orb.shutdown(true);
            }
            if (PuddleEnvelope.this.isLoggableFINE()) {
                String connectionID = cxEnv.getConnectionID();
                String msg = "connection destroyed " + connectionID;
                PuddleEnvelope.this.logFINE(msg);
            }
        }

        @SASScope
        private class ShutdownTimer
        implements Runnable {
            private ShutdownTimer() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ConnectionFactoryKernel connectionFactoryKernel = PuddleEnvelope.this._lock;
                synchronized (connectionFactoryKernel) {
                    while (!PoolingDelegate.this._shutdownTimerDone) {
                        long nowMillis = System.currentTimeMillis();
                        long nextCheck = Long.MAX_VALUE;
                        Iterator availItor = PoolingDelegate.this._avail.iterator();
                        while (availItor.hasNext()) {
                            ConnectionEnvelope cxEnv = (ConnectionEnvelope)availItor.next();
                            long shutdownTime = cxEnv.getShutdownTime();
                            if (shutdownTime < nowMillis) {
                                availItor.remove();
                                if (PuddleEnvelope.this.isLoggableFINE()) {
                                    String connectionID = cxEnv.getConnectionID();
                                    String msg = "shutdown timer expired " + connectionID;
                                    PuddleEnvelope.this.logFINE(msg);
                                }
                                PoolingDelegate.this.destroyConnection(cxEnv, "timeout");
                                continue;
                            }
                            if (shutdownTime >= nextCheck) continue;
                            nextCheck = shutdownTime;
                        }
                        try {
                            PuddleEnvelope.this._lock.wait(nextCheck - nowMillis);
                        }
                        catch (InterruptedException ie) {
                            return;
                        }
                    }
                }
            }
        }
    }

    @SASScope
    private abstract class Delegate {
        private Delegate() {
        }

        protected abstract void init();

        protected abstract int capacity();

        protected abstract int available();

        protected abstract int pending();

        protected abstract int chooseCluster();

        protected abstract void createConnection(String var1);

        protected abstract ConnectionEnvelope getAvailableConnection(ConnectionRequest var1);

        protected abstract void reactivateConnection(ConnectionEnvelope var1, int var2);

        protected abstract void checkMinimums();

        protected abstract Throwable getCause();

        protected abstract void shutdown();

        protected abstract void destroy();
    }
}

