/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb.brg;

import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.brg.BufferManager;
import com.sas.iom.orb.brg.Conversation;
import com.sas.iom.orb.brg.Packet;
import java.nio.ByteBuffer;

@SASScope
public final class InboundPacket
extends Packet {
    private ByteBuffer _mapBuf;
    private ByteBuffer _dataBuf;
    private ByteBuffer _headerBuf;

    protected InboundPacket(Conversation conversation) {
    }

    @Override
    public Object clone() {
        ByteBuffer oldDataBuf;
        ByteBuffer oldMapBuf;
        InboundPacket cln = (InboundPacket)super.clone();
        ByteBuffer oldHeaderBuf = cln.getHeaderBuf();
        if (oldHeaderBuf != null) {
            ByteBuffer newHeaderBuf = BufferManager.asReadOnlyBuffer(oldHeaderBuf);
            cln.setHeaderBuf(newHeaderBuf);
        }
        if ((oldMapBuf = cln.getMapBuf()) != null) {
            ByteBuffer newMapBuf = BufferManager.asReadOnlyBuffer(oldMapBuf);
            cln.setMapBuf(newMapBuf);
        }
        if ((oldDataBuf = cln.getDataBuf()) != null) {
            ByteBuffer newDataBuf = BufferManager.asReadOnlyBuffer(oldDataBuf);
            cln.setDataBuf(newDataBuf);
        }
        return cln;
    }

    @Override
    protected boolean isInbound() {
        return true;
    }

    protected ByteBuffer getMapBuf() {
        return this._mapBuf;
    }

    protected ByteBuffer getDataBuf() {
        return this._dataBuf;
    }

    protected ByteBuffer getHeaderBuf() {
        return this._headerBuf;
    }

    protected void setMapBuf(ByteBuffer buffer) {
        InboundPacket.checkForReadOnlyBuffer(buffer);
        this._mapBuf = buffer;
    }

    protected void setDataBuf(ByteBuffer buffer) {
        InboundPacket.checkForReadOnlyBuffer(buffer);
        this._dataBuf = buffer;
    }

    protected void setHeaderBuf(ByteBuffer buffer) {
        InboundPacket.checkForReadOnlyBuffer(buffer);
        this._headerBuf = buffer;
    }
}

