/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.RB;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS._portable_stub_IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.WorkspaceConnector;
import com.sas.iom.WorkspaceFactoryException;
import com.sas.iom.WorkspacePool;
import com.sas.iom.WorkspacePoolCookie;
import com.sas.iom.orb.brg.ORBImpl;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionFactoryUtil;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.Credential;
import com.sas.services.connection.FailoverCluster;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.PasswordCredential;
import com.sas.services.connection.Puddle;
import com.sas.services.connection.Server;
import com.sas.services.connection.jndi.JNDIConnectionFactoryConfiguration;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class WorkspaceFactory
implements Serializable {
    static final long serialVersionUID = 5794004025788357148L;
    private static final Long Zero = new Long(0L);
    private static SearchControls searchControls = new SearchControls();
    private WorkspacePoolCookie cookie;
    private boolean closeContext;

    public WorkspaceFactory(java.lang.Object jndiInformation, String baseDN, String logicalName, boolean userAuthorizationRequired, boolean adminAuthorizationRequired, PrintWriter logWriter) throws WorkspaceFactoryException {
        DirContext ctx = null;
        if (jndiInformation instanceof Hashtable) {
            try {
                ctx = new InitialDirContext((Hashtable)jndiInformation);
            }
            catch (NamingException ne) {
                throw new WorkspaceFactoryException(ne);
            }
            this.closeContext = true;
        } else {
            ctx = (DirContext)jndiInformation;
        }
        JNDIConnectionFactoryConfiguration cxfConfig = new JNDIConnectionFactoryConfiguration(ctx, baseDN, logicalName, "", userAuthorizationRequired, adminAuthorizationRequired, false);
        this.cookie = WorkspacePool.startPool(cxfConfig, logWriter);
        if (this.closeContext) {
            WorkspacePool.stashContext(this.cookie, ctx);
        }
    }

    public WorkspaceFactory(Properties[] connectionDescriptors, Properties poolParameters, PrintWriter logWriter) throws WorkspaceFactoryException {
        if (connectionDescriptors == null || connectionDescriptors.length == 0) {
            throw new IllegalArgumentException("\"connectionDescriptors\" cannot be null or empty.");
        }
        HashMap puddleMap = new HashMap();
        long maxClientsPool = 0L;
        for (int i = 0; i < connectionDescriptors.length; ++i) {
            Properties cd = connectionDescriptors[i];
            Credential iomLogin = WorkspaceFactory.propertiesToLogin(cd);
            List newClusterList = WorkspaceFactory.propertiesToClusterList(cd);
            Iterator newClusterItor = newClusterList.iterator();
            long maxClientsPuddle = 0L;
            while (newClusterItor.hasNext()) {
                FailoverCluster iomCluster = (FailoverCluster)newClusterItor.next();
                int maxClients = iomCluster.getMaxClients();
                maxClientsPuddle += (long)maxClients;
                maxClientsPool += (long)maxClients;
            }
            LinkedList<Serializable> curClusterList = (LinkedList<Serializable>)puddleMap.get(iomLogin);
            if (curClusterList == null) {
                curClusterList = new LinkedList<Serializable>();
                curClusterList.add(Zero);
                curClusterList.add(iomLogin);
                puddleMap.put(iomLogin, curClusterList);
            }
            Long CurMaxClients = (Long)curClusterList.get(0);
            long newMaxClients = CurMaxClients + maxClientsPuddle;
            Long NewMaxClients = new Long(newMaxClients);
            curClusterList.set(0, NewMaxClients);
            curClusterList.addAll(newClusterList);
        }
        Set puddleSet = puddleMap.entrySet();
        int puddleCount = puddleSet.size();
        ArrayList<List> puddleList = new ArrayList<List>(puddleCount);
        for (Map.Entry puddleEntry : puddleSet) {
            List iomClusterList = (List)puddleEntry.getValue();
            puddleList.add(iomClusterList);
        }
        Comparator comparator = new Comparator(){

            public int compare(java.lang.Object o1, java.lang.Object o2) {
                List l1 = (List)o1;
                List l2 = (List)o2;
                if (l1 == l2) {
                    return 0;
                }
                Long M1 = (Long)l1.get(0);
                Long M2 = (Long)l2.get(0);
                int result = M1.compareTo(M2);
                return result;
            }
        };
        Collections.sort(puddleList, comparator);
        int[][] minimums = new int[puddleCount][2];
        int minSize = 0;
        int minAvail = 0;
        if (poolParameters != null) {
            String minSizeString = poolParameters.getProperty("sasMinSize", "0");
            minSize = Integer.parseInt(minSizeString);
            String minAvailString = poolParameters.getProperty("sasMinAvail", "0");
            minAvail = Integer.parseInt(minAvailString);
        }
        Iterator puddleItor = puddleList.iterator();
        int minSizeTally = 0;
        int minAvailTally = 0;
        int i = 0;
        while (puddleItor.hasNext()) {
            List puddleInfo = (List)((java.lang.Object)puddleItor.next());
            Long MaxClients = (Long)puddleInfo.get(0);
            double ratio = MaxClients.doubleValue() / (double)maxClientsPool;
            int ms = (int)Math.floor((double)minSize * ratio);
            int ma = (int)Math.floor((double)minAvail * ratio);
            minimums[i][0] = ms;
            minimums[i][1] = ma;
            minSizeTally += ms;
            minAvailTally += ma;
            ++i;
        }
        int[] errs = new int[]{minSize - minSizeTally, minAvail - minAvailTally};
        for (int j = 0; j < 2; ++j) {
            for (i = 0; i < errs[j]; ++i) {
                int[] nArray = minimums[i];
                int n = j;
                nArray[n] = nArray[n] + 1;
            }
        }
        puddleItor = puddleList.iterator();
        ArrayList<Puddle> iomPuddleList = new ArrayList<Puddle>(puddleCount);
        i = 0;
        while (puddleItor.hasNext()) {
            List puddleInfo = (List)((java.lang.Object)puddleItor.next());
            Credential iomLogin = (Credential)puddleInfo.get(1);
            List iomClusterList = puddleInfo.subList(2, puddleInfo.size());
            int iomClusterCount = iomClusterList.size();
            Cluster[] iomClusterArray = new FailoverCluster[iomClusterCount];
            iomClusterArray = iomClusterList.toArray(iomClusterArray);
            Puddle iomPuddle = new Puddle(iomClusterArray, iomLogin);
            iomPuddle.setMinSize(minimums[i][0]);
            iomPuddle.setMinAvail(minimums[i][1]);
            ++i;
            iomPuddleList.add(iomPuddle);
        }
        Puddle[] iomPuddleArray = new Puddle[puddleCount];
        iomPuddleArray = iomPuddleList.toArray(iomPuddleArray);
        ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration(iomPuddleArray);
        this.cookie = WorkspacePool.startPool(cxfConfig, logWriter);
    }

    public WorkspaceFactory() {
    }

    private WorkspaceFactory(WorkspacePoolCookie cookie) {
        this.cookie = cookie;
    }

    public boolean equals(java.lang.Object that) {
        if (this == that) {
            return true;
        }
        if (this.cookie == null || that == null || !that.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        WorkspaceFactory thatFactory = (WorkspaceFactory)that;
        WorkspacePoolCookie thatCookie = thatFactory.getCookie();
        return this.cookie.equals(thatCookie);
    }

    public int hashCode() {
        int hc = 0;
        if (this.cookie == null) {
            hc = super.hashCode();
        } else {
            hc = this.getClass().getName().hashCode();
            hc ^= this.cookie.hashCode();
        }
        return hc;
    }

    public static WorkspaceFactory getFactory(Hashtable repositoryProperties, String baseDN, String logicalName) {
        return WorkspaceFactory.getFactory(null, null, repositoryProperties, baseDN, logicalName);
    }

    public static WorkspaceFactory getFactory(String userDN, String userPassword, Hashtable repositoryProperties, String baseDN, String logicalName) {
        WorkspacePoolCookie cookie = WorkspacePool.matchPool(userDN, userPassword, repositoryProperties, baseDN, logicalName);
        if (cookie == null) {
            return null;
        }
        return new WorkspaceFactory(cookie);
    }

    public WorkspaceConnector getWorkspaceConnector(long waitMilliseconds) throws WorkspaceFactoryException {
        if (this.cookie == null) {
            String messageIndex = "IOM.S206.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (java.lang.Object)messageIndex);
            throw new WorkspaceFactoryException(message);
        }
        WorkspacePool pool = WorkspacePool.lookupPool(this.cookie);
        if (pool == null) {
            String messageIndex = "IOM.S208.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (java.lang.Object)messageIndex);
            throw new WorkspaceFactoryException(message);
        }
        return pool.getConnector(null, null, waitMilliseconds);
    }

    public WorkspaceConnector getWorkspaceConnector(String userDN, String userPassword, long waitMilliseconds) throws WorkspaceFactoryException {
        if (this.cookie == null) {
            String messageIndex = "IOM.S207.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (java.lang.Object)messageIndex);
            throw new WorkspaceFactoryException(message);
        }
        WorkspacePool pool = WorkspacePool.lookupPool(this.cookie);
        if (pool == null) {
            String messageIndex = "IOM.S209.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (java.lang.Object)messageIndex);
            throw new WorkspaceFactoryException(message);
        }
        return pool.getConnector(userDN, userPassword, waitMilliseconds);
    }

    public static WorkspaceConnector getWorkspaceConnectorByUUID(String uuid) {
        return WorkspaceFactory.getWorkspaceConnectorByUUID(null, null, uuid);
    }

    public static WorkspaceConnector getWorkspaceConnectorByUUID(String userDN, String userPassword, String uuid) throws WorkspaceFactoryException {
        if (uuid == null) {
            return null;
        }
        return WorkspacePool.getConnectorByUUID(userDN, userPassword, uuid);
    }

    public IWorkspace createWorkspaceByLogicalName(String logicalName, String sasReferenceDN, String protocol, String ldapProviderUrl, Properties ldapProperties) throws WorkspaceFactoryException {
        String baseDN = null;
        if (ldapProperties != null) {
            baseDN = ldapProperties.getProperty("baseDN");
        }
        Hashtable env = new Hashtable();
        DirContext ctx = WorkspaceFactory.createContext(env, ldapProviderUrl, ldapProperties, baseDN);
        JNDIConnectionFactoryConfiguration cxfConfig = new JNDIConnectionFactoryConfiguration(ctx, baseDN, logicalName, "", true, false, true);
        ConnectionFactoryManager cxfManager = new ConnectionFactoryManager();
        ConnectionFactoryInterface cxf = null;
        try {
            cxf = cxfManager.getFactory(cxfConfig);
        }
        catch (ConnectionFactoryException cfe) {
            throw new WorkspaceFactoryException(cfe);
        }
        List domainList = cxf.getDomains();
        List iomLoginList = WorkspaceFactory.findLogins(ctx, env, domainList, sasReferenceDN, baseDN);
        Iterator iomLoginItor = iomLoginList.iterator();
        WorkspaceFactoryException wfe = null;
        while (iomLoginItor.hasNext()) {
            Credential iomLogin = (Credential)iomLoginItor.next();
            ConnectionInterface cx = null;
            try {
                cx = cxf.getConnection(iomLogin);
            }
            catch (ConnectionFactoryException cfe) {
                if (wfe != null) continue;
                wfe = new WorkspaceFactoryException(cfe);
                continue;
            }
            try {
                Object obj = cx.getObject();
                IWorkspace iWorkspace = WorkspaceFactory.iWorkspaceNarrow(obj);
                return iWorkspace;
            }
            catch (SystemException se) {
                cx.close();
                if (wfe != null) continue;
                wfe = new WorkspaceFactoryException(se);
            }
        }
        throw wfe;
    }

    public IWorkspace createWorkspaceByServer(Properties serverInfo) throws WorkspaceFactoryException {
        if (serverInfo == null) {
            String messageIndex = "IOM.S202.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (java.lang.Object)messageIndex);
            throw new WorkspaceFactoryException(message);
        }
        String hosts = serverInfo.getProperty("host");
        if (hosts == null || hosts.length() == 0) {
            String messageIndex = "IOM.S203.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (java.lang.Object)messageIndex);
            throw new WorkspaceFactoryException(message);
        }
        String portString = serverInfo.getProperty("port");
        if (portString == null || portString.length() == 0) {
            String messageIndex = "IOM.S204.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (java.lang.Object)messageIndex);
            throw new WorkspaceFactoryException(message);
        }
        int port = Integer.parseInt(portString);
        String encryptionPolicy = serverInfo.getProperty("encryptionPolicy");
        String encryptionContent = serverInfo.getProperty("encryptionContent");
        String encryptionAlgorithms = serverInfo.getProperty("encryptionAlgorithms");
        if (encryptionPolicy == null && encryptionContent == null && encryptionAlgorithms == null) {
            String sasRequiredEncryptionLevel = serverInfo.getProperty("sasrequiredencryptionlevel");
            if (sasRequiredEncryptionLevel != null) {
                if ((sasRequiredEncryptionLevel = sasRequiredEncryptionLevel.toLowerCase(Locale.US)).equals("authentication") || sasRequiredEncryptionLevel.equals("credentials")) {
                    encryptionPolicy = "required";
                    encryptionContent = "authentication";
                } else if (sasRequiredEncryptionLevel.equals("all") || sasRequiredEncryptionLevel.equals("everything")) {
                    encryptionPolicy = "required";
                    encryptionContent = "all";
                }
            }
            encryptionAlgorithms = serverInfo.getProperty("sasclientencryptionalgorithm");
        }
        String serverName = serverInfo.getProperty("serverName");
        StringTokenizer hostTok = new StringTokenizer(hosts, ",");
        int hostCount = hostTok.countTokens();
        ArrayList<BridgeServer> iomServerList = new ArrayList<BridgeServer>(hostCount);
        while (hostTok.hasMoreTokens()) {
            String host = hostTok.nextToken().trim();
            if (host.length() <= 0) continue;
            BridgeServer iomServer = new BridgeServer("440196d4-90f0-11d0-9f41-00a024bb830c", host, port);
            if (encryptionPolicy != null) {
                iomServer.setEncryptionPolicy(encryptionPolicy);
            }
            if (encryptionContent != null) {
                iomServer.setEncryptionContent(encryptionContent);
            }
            if (encryptionAlgorithms != null) {
                iomServer.setEncryptionAlgorithms(encryptionAlgorithms);
            }
            if (serverName != null) {
                iomServer.setServerName(serverName);
            }
            iomServerList.add(iomServer);
        }
        int iomServerListSize = iomServerList.size();
        if (iomServerListSize == 0) {
            String messageIndex = "IOM.S205.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (java.lang.Object)messageIndex);
            throw new WorkspaceFactoryException(message);
        }
        Server[] iomServerArray = new Server[iomServerListSize];
        iomServerArray = iomServerList.toArray(iomServerArray);
        FailoverCluster iomCluster = new FailoverCluster(iomServerArray);
        ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration(iomCluster);
        PrintWriter logWriter = (PrintWriter)serverInfo.get("logWriter");
        String debugLevelString = serverInfo.getProperty("debugLevel", "0");
        int debugLevel = Integer.parseInt(debugLevelString);
        if (debugLevel > 0 && logWriter == null) {
            logWriter = new PrintWriter(System.out);
        }
        ConnectionFactoryManager cxfManager = new ConnectionFactoryManager();
        String loggerName = ORBImpl.class.getPackage().getName();
        WorkspacePool.configLogger(loggerName, logWriter, debugLevel);
        String userName = serverInfo.getProperty("userName");
        String password = serverInfo.getProperty("password");
        ConnectionInterface cx = null;
        try {
            ConnectionFactoryInterface cxf = cxfManager.getFactory(cxfConfig);
            cx = cxf.getConnection(userName, password);
        }
        catch (ConnectionFactoryException cfe) {
            throw new WorkspaceFactoryException(cfe);
        }
        try {
            Object obj = cx.getObject();
            IWorkspace iWorkspace = WorkspaceFactory.iWorkspaceNarrow(obj);
            return iWorkspace;
        }
        catch (SystemException se) {
            throw new WorkspaceFactoryException(se);
        }
    }

    public Properties[] getServersByLogicalName(String logicalName, String protocol, String ldapProviderUrl, Properties ldapProperties) throws WorkspaceFactoryException {
        String baseDN = null;
        if (ldapProperties != null) {
            baseDN = ldapProperties.getProperty("baseDN");
        }
        Hashtable env = new Hashtable();
        DirContext ctx = WorkspaceFactory.createContext(env, ldapProviderUrl, ldapProperties, baseDN);
        Properties[] serverArray = WorkspaceFactory.findServers(ctx, env, baseDN, logicalName);
        return serverArray;
    }

    public void shutdown() throws WorkspaceFactoryException {
        this.shutdown(null, null);
    }

    public void shutdown(String adminDN, String adminPassword) throws WorkspaceFactoryException {
        if (this.cookie != null) {
            WorkspacePool pool = WorkspacePool.lookupPool(this.cookie);
            if (pool != null) {
                pool.shutdown(adminDN, adminPassword);
            }
            this.closeCtx();
        }
    }

    public void destroy() throws WorkspaceFactoryException {
        this.destroy(null, null);
    }

    public void destroy(String adminDN, String adminPassword) throws WorkspaceFactoryException {
        if (this.cookie != null) {
            WorkspacePool pool = WorkspacePool.lookupPool(this.cookie);
            if (pool != null) {
                pool.destroy(adminDN, adminPassword);
            }
            this.closeCtx();
        }
    }

    protected WorkspacePoolCookie getCookie() {
        return this.cookie;
    }

    private void closeCtx() {
        DirContext ctx;
        if (this.cookie != null && this.closeContext && (ctx = WorkspacePool.removeContext(this.cookie)) != null) {
            try {
                ctx.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    private static Credential propertiesToLogin(Properties p) {
        String userName = p.getProperty("userName", "");
        String password = p.getProperty("password", "");
        PasswordCredential iomLogin = new PasswordCredential(userName, password);
        return iomLogin;
    }

    private static List propertiesToClusterList(Properties p) {
        StringTokenizer hostTok;
        int hostCount;
        String hosts = p.getProperty("host");
        if (hosts == null) {
            throw new IllegalArgumentException("\"host\" cannot be unspecified in a connection descriptor.");
        }
        String portString = p.getProperty("port");
        if (portString == null) {
            throw new IllegalArgumentException("\"port\" cannot be unspecified in a connection descriptor.");
        }
        int port = Integer.parseInt(portString);
        String encryptionPolicy = p.getProperty("encryptionPolicy");
        String encryptionContent = p.getProperty("encryptionContent");
        String encryptionAlgorithms = p.getProperty("encryptionAlgorithms");
        String maxClientsString = p.getProperty("sasMaxPerWorkspacePool", "10");
        int maxClients = Integer.parseInt(maxClientsString);
        String reactivationLimitString = p.getProperty("sas-RecycleActivationLimit", "0");
        int reactivationLimit = Integer.parseInt(reactivationLimitString);
        String runForeverString = p.getProperty("sas-ServerRunForever", "true");
        Boolean runForever = new Boolean(runForeverString);
        int shutdownAfter = -1;
        String serverName = p.getProperty("serverName");
        if (!runForever.booleanValue()) {
            String shutdownAfterString = p.getProperty("sas-ServerShutdownAfter", "3");
            shutdownAfter = Integer.parseInt(shutdownAfterString);
        }
        if ((hostCount = (hostTok = new StringTokenizer(hosts, ",")).countTokens()) == 0) {
            throw new IllegalArgumentException("\"host\" cannot be empty in a connection descriptor.");
        }
        ArrayList<FailoverCluster> iomClusterList = new ArrayList<FailoverCluster>(hostCount);
        while (hostTok.hasMoreTokens()) {
            String host = hostTok.nextToken();
            host = host.trim();
            BridgeServer iomServer = new BridgeServer("440196d4-90f0-11d0-9f41-00a024bb830c", host, port);
            if (encryptionPolicy != null) {
                iomServer.setEncryptionPolicy(encryptionPolicy);
            }
            if (encryptionContent != null) {
                iomServer.setEncryptionContent(encryptionContent);
            }
            if (encryptionAlgorithms != null) {
                iomServer.setEncryptionAlgorithms(encryptionAlgorithms);
            }
            iomServer.setMaxClients(maxClients);
            iomServer.setReactivationLimit(reactivationLimit);
            iomServer.setShutdownAfterMinutes(shutdownAfter);
            if (serverName != null) {
                iomServer.setServerName(serverName);
            }
            FailoverCluster iomCluster = new FailoverCluster(iomServer);
            iomClusterList.add(iomCluster);
        }
        return iomClusterList;
    }

    private static DirContext createContext(Hashtable env, String providerURL, Properties ldapProperties, String baseDN) throws WorkspaceFactoryException {
        String securityAuthentication = null;
        String securityPrincipal = null;
        String securityCredentials = null;
        if (ldapProperties != null) {
            securityAuthentication = ldapProperties.getProperty("authentication", "none").toLowerCase(Locale.US);
            securityPrincipal = ldapProperties.getProperty("ldapUserName");
            securityCredentials = ldapProperties.getProperty("ldapPassword");
        }
        if ("simple".equals(securityAuthentication)) {
            env.put("java.naming.security.principal", securityPrincipal);
            env.put("java.naming.security.credentials", securityCredentials);
        }
        env.put("java.naming.security.authentication", securityAuthentication);
        env.put("java.naming.provider.url", providerURL);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        InitialDirContext ctx = null;
        try {
            ctx = new InitialDirContext(env);
        }
        catch (NamingException ne) {
            if ("none".equals(securityAuthentication)) {
                throw new WorkspaceFactoryException(ne);
            }
            StringBuffer oldStylePrincipalBuffer = new StringBuffer();
            oldStylePrincipalBuffer.append("cn=").append(securityPrincipal);
            if (baseDN != null) {
                oldStylePrincipalBuffer.append(",").append(baseDN);
            }
            String oldStylePrincipal = oldStylePrincipalBuffer.toString();
            env.put("java.naming.security.principal", oldStylePrincipal);
            try {
                ctx = new InitialDirContext(env);
            }
            catch (NamingException ne2) {
                throw new WorkspaceFactoryException(ne2);
            }
        }
        return ctx;
    }

    private static Properties[] findServers(DirContext ctx, Hashtable env, String baseDN, String logicalName) throws WorkspaceFactoryException {
        LinkedList<Properties> serverList = new LinkedList<Properties>();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(&(objectclass=sasServer)(sasProtocol=bridge)(sasLogicalName=");
            String filter = stringBuffer.append(logicalName).append("))").toString();
            NamingEnumeration<SearchResult> serverEnumeration = null;
            try {
                serverEnumeration = ctx.search(baseDN, filter, searchControls);
            }
            catch (CommunicationException ce) {
                ctx = WorkspaceFactory.reconnect(ctx, env, ce);
                serverEnumeration = ctx.search(baseDN, filter, searchControls);
            }
            while (serverEnumeration.hasMore()) {
                Properties cd = new Properties();
                Attribute attr = null;
                NamingEnumeration<?> ne = null;
                SearchResult serverResult = serverEnumeration.next();
                Attributes serverAttributes = serverResult.getAttributes();
                attr = serverAttributes.get("sasMachineDNSName");
                if (attr != null) {
                    ne = attr.getAll();
                    StringBuffer nameListBuffer = new StringBuffer();
                    boolean hasMore = ne.hasMore();
                    while (hasMore) {
                        nameListBuffer.append((String)ne.next());
                        hasMore = ne.hasMore();
                        if (!hasMore) continue;
                        nameListBuffer.append(",");
                    }
                    cd.put("host", nameListBuffer.toString());
                }
                if ((attr = serverAttributes.get("sasPort")) != null) {
                    ne = attr.getAll();
                    while (ne.hasMore()) {
                        cd.put("port", ne.next());
                    }
                }
                if ((attr = serverAttributes.get("sasdomainname")) != null) {
                    ne = attr.getAll();
                    while (ne.hasMore()) {
                        cd.put("sasdomainname", ne.next());
                    }
                }
                if ((attr = serverAttributes.get("sasrequiredencryptionlevel")) != null) {
                    ne = attr.getAll();
                    while (ne.hasMore()) {
                        cd.put("sasrequiredencryptionlevel", ne.next());
                    }
                }
                if ((attr = serverAttributes.get("sasclientencryptionalgorithm")) != null) {
                    ne = attr.getAll();
                    while (ne.hasMore()) {
                        cd.put("sasclientencryptionalgorithm", ne.next());
                    }
                }
                if ((attr = serverAttributes.get("saslogicalname")) != null) {
                    ne = attr.getAll();
                    while (ne.hasMore()) {
                        cd.put("saslogicalname", ne.next());
                    }
                }
                if ((attr = serverAttributes.get("sasProtocol")) != null) {
                    ne = attr.getAll();
                    while (ne.hasMore()) {
                        cd.put("protocol", ne.next());
                    }
                }
                serverList.add(cd);
            }
        }
        catch (NamingException e0) {
            throw new WorkspaceFactoryException(e0);
        }
        int serverListSize = serverList.size();
        Properties[] serverArray = new Properties[serverListSize];
        serverArray = serverList.toArray(serverArray);
        return serverArray;
    }

    private static List findLogins(DirContext ctx, Hashtable env, List domainList, String referenceDN, String baseDN) throws WorkspaceFactoryException {
        int domainListSize = domainList.size();
        ArrayList<PasswordCredential> iomLoginList = new ArrayList<PasswordCredential>(domainListSize);
        Iterator domainItor = domainList.iterator();
        try {
            while (domainItor.hasNext()) {
                String domain = (String)domainItor.next();
                StringBuffer stringBuffer = new StringBuffer("(&(objectclass=sasLogin)(sasReferenceDN=").append(referenceDN).append(")");
                if (domain != null) {
                    stringBuffer.append("(sasDomainName=").append(domain).append(")");
                } else {
                    stringBuffer.append("(!(sasDomainName=*))");
                }
                String filter = stringBuffer.append(")").toString();
                NamingEnumeration<SearchResult> loginEnumeration = null;
                try {
                    loginEnumeration = ctx.search(baseDN, filter, searchControls);
                }
                catch (CommunicationException ce) {
                    ctx = WorkspaceFactory.reconnect(ctx, env, ce);
                    loginEnumeration = ctx.search(baseDN, filter, searchControls);
                }
                if (!loginEnumeration.hasMore()) {
                    filter = stringBuffer.append("objectclass=top)").toString();
                    try {
                        loginEnumeration = ctx.search(baseDN, filter, searchControls);
                    }
                    catch (CommunicationException ce) {
                        ctx = WorkspaceFactory.reconnect(ctx, env, ce);
                        loginEnumeration = ctx.search(baseDN, filter, searchControls);
                    }
                }
                if (!loginEnumeration.hasMore()) {
                    PasswordCredential iomLogin = new PasswordCredential("", "", domain);
                    iomLoginList.add(iomLogin);
                    continue;
                }
                while (loginEnumeration.hasMore()) {
                    SearchResult searchResult = loginEnumeration.next();
                    Attributes loginAttributes = searchResult.getAttributes();
                    Attribute userNameAttr = loginAttributes.get("sasLoginName");
                    String userName = (String)userNameAttr.get();
                    Attribute passwordAttr = loginAttributes.get("sasUserPassword");
                    String codedPassword = (String)passwordAttr.get();
                    String password = SasPasswordString.decode((String)codedPassword);
                    PasswordCredential iomLogin = new PasswordCredential(userName, password, domain);
                    iomLoginList.add(iomLogin);
                }
            }
        }
        catch (NamingException e0) {
            throw new WorkspaceFactoryException(e0);
        }
        catch (SasPasswordEncodingException e1) {
            throw new WorkspaceFactoryException(e1);
        }
        return iomLoginList;
    }

    private static DirContext reconnect(DirContext ctx, Hashtable env, CommunicationException ce) throws NamingException {
        try {
            ctx.close();
        }
        catch (NamingException e) {
            // empty catch block
        }
        try {
            ctx = new InitialDirContext(env);
        }
        catch (NamingException e) {
            throw ce;
        }
        return ctx;
    }

    private static IWorkspace iWorkspaceNarrow(Object obj) {
        IWorkspaceStub iWork = new IWorkspaceStub();
        Delegate del = ((ObjectImpl)obj)._get_delegate();
        iWork._set_delegate(del);
        return iWork;
    }

    static {
        searchControls.setSearchScope(2);
    }

    @SASScope
    private static class IWorkspaceStub
    extends _portable_stub_IWorkspace {
        private IWorkspaceStub() {
        }

        @Override
        public void Close() throws GenericError {
            super.Close();
            ConnectionInterface cx = ConnectionFactoryUtil.extractConnectionHandle(this);
            cx.close();
        }
    }
}

