/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.codepolicy.SASScope;
import com.sas.util.transforms.TransformInputOutputInterface;

@SASScope
public class StringEchoTransform
implements TransformInputOutputInterface {
    private static final long serialVersionUID = 8931902064916612130L;
    public static final StringEchoTransform defaultInstance = new StringEchoTransform();
    private char echoChar;

    public StringEchoTransform() {
        this('*');
    }

    public StringEchoTransform(char echoChar) {
        this.echoChar = echoChar;
    }

    @Override
    public Object transform(Object input) {
        if (input == null) {
            return "";
        }
        String trimmedInput = ((String)input).trim();
        int trimmedLength = trimmedInput.length();
        if (trimmedLength == 0) {
            return "";
        }
        StringBuffer echoString = new StringBuffer("");
        for (int i = 0; i < trimmedLength; ++i) {
            echoString.append(this.echoChar);
        }
        return echoString.toString();
    }

    @Override
    public Class getInputClass() {
        return String.class;
    }

    @Override
    public Class getOutputClass() {
        return String.class;
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public void setEchoChar(char echoChar) {
        if (this.echoChar != echoChar) {
            this.echoChar = echoChar;
        }
    }
}

