/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.codepolicy.SASScope;
import com.sas.util.ColorNames;
import com.sas.util.transforms.TransformInputOutputInterface;
import java.awt.Color;
import java.util.NoSuchElementException;

@SASScope
public class ColorToStringTransform2
implements TransformInputOutputInterface {
    static final long serialVersionUID = -6407236784643700732L;
    public static final ColorToStringTransform2 defaultInstance = new ColorToStringTransform2();
    protected static ColorNames colorNames = null;

    @Override
    public Object transform(Object input) {
        return this.transform((Color)input, true);
    }

    public String transform(Color input, boolean searchSystemColors) {
        String colorName;
        if (colorNames == null) {
            colorNames = new ColorNames(searchSystemColors);
        } else {
            colorNames.setShowSystemColors(searchSystemColors);
        }
        try {
            colorName = colorNames.getColorName(input);
        }
        catch (NoSuchElementException e) {
            colorName = this.getName(input);
        }
        return colorName;
    }

    private String getName(Color color) {
        String name = Integer.toHexString(color.getRGB());
        name = name.substring(2, name.length());
        name = name.toUpperCase();
        return name;
    }

    @Override
    public Class getInputClass() {
        return Color.class;
    }

    @Override
    public Class getOutputClass() {
        return String.class;
    }
}

