/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.MissingValues;
import com.sas.codepolicy.SASScope;
import com.sas.text.PictureFormatDescription;
import com.sas.text.PictureOptions;
import com.sas.text.PictureRangeSegment;
import com.sas.text.ValueEntry;
import com.sas.util.MissingValueRangeSegment;
import com.sas.util.NumericRangeSegment;
import com.sas.util.RangeSegment;
import java.text.FieldPosition;
import java.text.Format;
import java.util.Hashtable;

@SASScope
class PictureEntry
extends ValueEntry
implements PictureFormatDescription {
    private boolean round;
    private PictureOptions options;
    private FieldPosition position = new FieldPosition(0);
    private StringBuffer result = new StringBuffer();

    public PictureEntry(String format, String className) {
        super(format, className);
        if (this.isCharacterFormat()) {
            throw new RuntimeException("Error: Invalid format type.  Pictures format cannot be character");
        }
        this.options = new PictureOptions();
        this.round = false;
    }

    @Override
    public boolean addRangeSegment(RangeSegment rs) {
        boolean result = true;
        if (rs instanceof MissingValueRangeSegment) {
            this.missingRangeSegments.addElement(new PictureRangeSegment((MissingValueRangeSegment)rs));
        } else if (rs instanceof PictureRangeSegment) {
            if (((PictureRangeSegment)rs).getSegment() instanceof MissingValueRangeSegment) {
                this.missingRangeSegments.addElement(rs);
            } else {
                this.rangeSegments.addElement(rs);
            }
        } else if (rs instanceof NumericRangeSegment) {
            this.rangeSegments.addElement(new PictureRangeSegment((NumericRangeSegment)rs));
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public void init(Hashtable table) {
        super.init(table);
        if (!this.fmt) {
            if (Double.isNaN(this.options.mult)) {
                this.options.mult = this.calMult(this.otherLabel);
            }
        } else {
            this.options.setNoEdit(true);
        }
    }

    @Override
    protected int parseValue(RangeSegment segment, Hashtable table) {
        int length = 0;
        PictureRangeSegment seg = (PictureRangeSegment)segment;
        if (seg.getValue(null) instanceof String) {
            length = super.parseValue(segment, table);
            PictureOptions options = seg.getPictureOptions();
            if (Double.isNaN(options.mult)) {
                options.mult = this.calMult((String)seg.getValue(null));
            }
        }
        return length;
    }

    @Override
    public boolean isRound() {
        return this.round;
    }

    @Override
    public void setRound(boolean round) {
        this.round = round;
    }

    private double calMult(String value) {
        double mult = 1.0;
        int index = value.indexOf(".");
        if (index != -1) {
            char c;
            for (int i = index + 1; i < value.length() && Character.isDigit(c = value.charAt(i)); ++i) {
                mult *= 10.0;
            }
        }
        return mult;
    }

    @Override
    public void setPictureOptions(PictureOptions options) {
        if (options != null) {
            this.options = options;
        }
    }

    @Override
    public PictureOptions getPictureOptions() {
        return this.options;
    }

    @Override
    public String getValue(Object value) {
        this.result.setLength(0);
        int width = this.getWidth();
        boolean isMissing = value instanceof MissingValues;
        if (value instanceof Number || isMissing) {
            PictureRangeSegment segment = (PictureRangeSegment)this.getRangeSegment(value);
            if (segment != null) {
                Object svalue = segment.getValue(value);
                if (svalue instanceof Format) {
                    this.result.append(((Format)svalue).format(value, new StringBuffer(), this.position));
                } else if (isMissing) {
                    this.result.append(svalue.toString());
                    this.insertLeadingBlanks(this.result, 0, width);
                } else {
                    this.loadPicture(svalue.toString(), segment.getPictureOptions(), ((Number)value).doubleValue(), this.result);
                }
            } else if (isMissing) {
                this.result.append(value.toString());
                this.insertLeadingBlanks(this.result, 0, width);
            } else {
                this.loadPicture(this.getOtherValue(value), this.getPictureOptions(), ((Number)value).doubleValue(), this.result);
            }
        } else {
            throw new IllegalArgumentException("Value should be a Numeric or a MissingValue");
        }
        return this.result.toString();
    }

    private void loadPicture(String picture, PictureOptions options, double value, StringBuffer result) {
        int width = this.getWidth();
        if (!options.getNoEdit()) {
            int length;
            char c;
            int vIndex;
            String sValue;
            boolean appendPrefix = false;
            double v = Math.abs(value) * options.getMult();
            if (v != 0.0) {
                sValue = String.valueOf((long)(this.isRound() ? (double)Math.round(v) : v));
                vIndex = sValue.length() - 1;
            } else {
                sValue = null;
                vIndex = -1;
            }
            int nonZeroIndex = picture.length() + 1;
            for (int i = picture.length() - 1; i >= 0; --i) {
                c = picture.charAt(i);
                if (Character.isDigit(c)) {
                    if (vIndex >= 0) {
                        result.insert(0, sValue.charAt(vIndex--));
                    } else {
                        result.insert(0, '0');
                    }
                    if (c != '0') {
                        nonZeroIndex = i;
                    }
                    appendPrefix = true;
                    continue;
                }
                result.insert(0, c);
            }
            int lastChar = 32;
            int substringIndex = 0;
            for (int i = 0; i < result.length() && appendPrefix && (!Character.isDigit(c = result.charAt(i)) || c == '0' && i < nonZeroIndex); ++i) {
                lastChar = c;
                ++substringIndex;
            }
            if (substringIndex > 0) {
                if (substringIndex == result.length()) {
                    result.setLength(0);
                } else {
                    String str = result.toString().substring(substringIndex);
                    result.setLength(0);
                    result.append(str);
                }
            }
            if (appendPrefix && result.length() != 0) {
                result.insert(0, options.getPrefix());
            }
            if (width - (length = result.length()) < 0) {
                String str = result.toString().substring(length - width);
                result.setLength(0);
                result.append(str);
            } else if (width - length != 0) {
                char fill = options.getFill();
                for (int j = 0; j < width - length; ++j) {
                    result.insert(0, fill);
                }
            }
        } else {
            int length = picture.length();
            result.append(picture);
            if (width - length < 0) {
                result.setLength(width);
            } else {
                this.insertLeadingBlanks(result, 0, width);
            }
        }
    }

    private void insertLeadingBlanks(StringBuffer str, int index, int width) {
        int numOfSpaces = width - str.length();
        if (numOfSpaces > 0) {
            str.ensureCapacity(width);
            for (int i = 0; i < numOfSpaces; ++i) {
                str.insert(index, ' ');
            }
        }
    }
}

