/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.codepolicy.SASScope;
import com.sas.text.FormatPatternData;
import com.sas.text.IGetFormats;
import com.sas.text.LoadDateFormats;
import com.sas.text.LoadDateTimeFormats;
import com.sas.text.LoadMonthDayFormats;
import com.sas.text.LoadMonthYearFormats;
import com.sas.text.LoadTimeFormats;
import com.sas.text.LoadWeekFormats;
import com.sas.text.LoadYearFormats;
import com.sas.text.NLFormats;
import com.sas.text.SingleEntry;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SASScope
public class NLInformats {
    public static final String LONG_YEAR_NAME = "NLDATEYR";
    public static final String SHORT_YEAR_NAME = "NLDATEYR2";
    public static final String DATETIME_AP = "NLTIME";
    public static final String DATETIME = "NLDATM";
    public static final String DATETIME_SHORT = "NLDATMS";
    public static final String DATETIME_MED = "NLDATMM";
    public static final String DATETIME_LONG = "NLDATML";
    public static final String DATETIME_WEEK = "NLDATMW";
    public static final String DATETIME_WEEK2 = "NLDATMW2";
    public static final String LONG_MONTH_YEAR_NAME = "NLDATEYM";
    public static final String SHORT_MONTH_YEAR_NAME = "NLDATEYM2";
    public static final String LONG_MONTH_DAY_NAME = "NLDATEMD";
    public static final String SHORT_MONTH_DAY_NAME = "NLDATEMD2";
    public static final String LONG_WEEK_NAME = "NLDATEYW";
    public static final String SHORT_WEEK_NAME = "NLDATEYW2";
    public static final String HMS_24_NAME = "NLTIMENS";
    public static final String HMS_12_NAME = "NLTIMNAP";
    public static final String HM_24_NAME = "NLTIMENHMS";
    public static final String HM_12_NAME = "NLTIMNHMAP";
    public static final String NLDATE = "NLDATE";
    public static final String NLDATES = "NLDATES";
    public static final String NLDATEM = "NLDATEM";
    public static final String NLDATEL = "NLDATEL";
    public static final String NLDATE_WEEK = "NLDATE_WEEK";
    public static final String NLDATE_WEEKS = "NLDATE_WEEKS";
    public static final String LONG_QUARTER_NAME = "NLDATEYQ";
    public static final String SHORT_QUARTER_NAME = "NLDATEYQ2";
    public static final String XML_SCHEMA_NAME = "NLDATMXML";
    public static final String MTHDAYYRSLASH = "MTHDAYYRSLASH";
    public static final String MTHDAYYRSLASH2 = "MTHDAYYRSLASH2";
    public static final String MTHDAYYRDOT = "MTHDAYYRDOT";
    public static final String MTHDAYYRDOT2 = "MTHDAYYRDOT2";
    public static final String MTHDAYYRDASH = "MTHDAYYRDASH";
    public static final String MTHDAYYRDASH2 = "MTHDAYYRDASH2";
    public static final String MTHDAYYRSLASHL = "MTHDAYYRSLASHL";
    public static final String MTHDAYYRSLASHL2 = "MTHDAYYRSLASHL2";
    public static final String MTHDAYYRDOTL = "MTHDAYYRDOTL";
    public static final String MTHDAYYRDOTL2 = "MTHDAYYRDOTL2";
    public static final String MTHDAYYRDASHL = "MTHDAYYRDASHL";
    public static final String MTHDAYYRDASHL2 = "MTHDAYYRDASHL2";
    public static final String MTHYEARSLASH = "MTHYEARSLASH";
    public static final String MTHYEARSLASH2 = "MTHYEARSLASH2";
    public static final String MTHYEARDOT = "MTHYEARDOT";
    public static final String MTHYEARDOT2 = "MTHYEARDOT2";
    public static final String MTHYEARDASH = "MTHYEARDASH";
    public static final String MTHYEARDASH2 = "MTHYEARDASH2";
    public static final String MTHYEARSLASHL = "MTHYEARSLASHL";
    public static final String MTHYEARSLASHL2 = "MTHYEARSLASHL2";
    public static final String MTHYEARDOTL = "MTHYEARDOTL";
    public static final String MTHYEARDOTL2 = "MTHYEARDOTL2";
    public static final String MTHYEARDASHL = "MTHYEARDASHL";
    public static final String MTHYEARDASHL2 = "MTHYEARDASHL2";
    public static final String DATEMTHSLASH = "DATEMTHSLASH";
    public static final String DATEMTHSLASH2 = "DATEMTHSLASH2";
    public static final String DATEMTHDOT = "DATEMTHDOT";
    public static final String DATEMTHDOT2 = "DATEMTHDOT2";
    public static final String DATEMTHDASH = "DATEMTHDASH";
    public static final String DATEMTHDASH2 = "DATEMTHDASH2";
    private static final String SHORT_QUARTER = "QQ";
    private static final int[] quarterMonths = new int[]{0, 3, 6, 9};
    private static final String XML_SCHEMA_PATTERN = "yyyy-M-d'T'H:mm:ss";
    private static final Pattern NLTIME_PATTERN = Pattern.compile("(.*mm[^:.]*)('[:.]'|[:.])?ss(\\s*'o''clock'|\\s*'uur'|\\s*'Uhr')?");
    private static final Pattern NLTIMAP_PATTERN = Pattern.compile("(.*mm[^:.]*)('[:.]'|[:.])?ss(.*)");
    private static final Pattern SUFFIX_PATTERN = Pattern.compile("a|'o''clock'|'uur'|'Uhr'");
    private static final Map dateTimeFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Map dateFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Map timeFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Map quarterFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Map monthYearFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Map monthDayFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Map weekFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Map yearFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Map allDateFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Map allDateMap = Collections.synchronizedMap(new WeakHashMap());
    private static final Map bundles = Collections.synchronizedMap(new WeakHashMap());
    private static final String BUNDLE_NAME = "com.sas.text.locale.NLDateTime";
    private static final Pattern YDMPattern;
    private static final Pattern YMDPattern;
    private static final Pattern MDYPattern;
    private static final Pattern DMYPattern;
    static final Map patterns;
    private static final String YDM = "YDM";
    private static final String YMD = "YMD";
    private static final String MDY = "MDY";
    private static final String DMY = "DMY";
    private static final List STANDARD_DATE_FORMATS;
    private static final List YDM_STANDARD_DATE_FORMATS;
    private static boolean useFallback;
    private static final IGetFormats TIME_FORMATS;
    private static final IGetFormats DATE_FORMATS;
    private static final IGetFormats DATETIME_FORMATS;
    private static final IGetFormats MONTHYEAR_FORMATS;
    private static final IGetFormats MONTHDAY_FORMATS;
    private static final IGetFormats WEEK_FORMATS;
    private static final IGetFormats YEAR_FORMATS;

    private NLInformats() {
    }

    public static void setFallback(boolean b) {
        useFallback = b;
    }

    public static boolean isFallback() {
        return useFallback;
    }

    public static String getPattern(String name) {
        return NLInformats.getPattern(name, Locale.getDefault());
    }

    public static String getPattern(String name, Locale locale) {
        Map map = NLInformats.loadAllDateMap(locale);
        return (String)map.get(name);
    }

    public static Collection getAllNLDateFormats() {
        return NLInformats.getAllNLDateFormats(Locale.getDefault());
    }

    public static Collection getAllNLDateFormats(Locale locale) {
        Collection cached = (Collection)allDateFormats.get(locale);
        if (cached != null) {
            return cached;
        }
        return NLInformats.loadAllNLDateFormats(locale);
    }

    public static Collection getNLDateFormats() {
        return NLInformats.getNLDateFormats(Locale.getDefault());
    }

    public static Collection getNLDateFormats(Locale locale) {
        Collection cached = (Collection)dateFormats.get(locale);
        if (cached != null) {
            return cached;
        }
        return NLInformats.loadNLDateFormats(locale);
    }

    public static Collection getNLBusinessDateFormats(Locale locale) {
        if (NLInformats.getDateStyle(locale).equals(YDM)) {
            return YDM_STANDARD_DATE_FORMATS;
        }
        return STANDARD_DATE_FORMATS;
    }

    public static Collection getNLDateTimeFormats() {
        return NLInformats.getNLDateTimeFormats(Locale.getDefault());
    }

    public static Collection getNLDateTimeFormats(Locale locale) {
        Collection cached = (Collection)dateTimeFormats.get(locale);
        if (cached != null) {
            return cached;
        }
        return NLInformats.loadNLDateTimeFormats(locale);
    }

    public static Collection getNLMonthYearFormats() {
        return NLInformats.getNLMonthYearFormats(Locale.getDefault());
    }

    public static Collection getNLMonthYearFormats(Locale locale) {
        Collection cached = (Collection)monthYearFormats.get(locale);
        if (cached != null) {
            return cached;
        }
        return NLInformats.loadNLMonthYearFormats(locale);
    }

    public static Collection getNLMonthDayFormats() {
        return NLInformats.getNLMonthDayFormats(Locale.getDefault());
    }

    public static Collection getNLMonthDayFormats(Locale locale) {
        Collection cached = (Collection)monthDayFormats.get(locale);
        if (cached != null) {
            return cached;
        }
        return NLInformats.loadNLMonthDayFormats(locale);
    }

    public static Collection getNLQuarterFormats() {
        return NLInformats.getNLQuarterFormats(Locale.getDefault());
    }

    public static Collection getNLQuarterFormats(Locale locale) {
        Collection cached = (Collection)quarterFormats.get(locale);
        if (cached != null) {
            return cached;
        }
        return NLInformats.loadNLQuarterFormats(locale);
    }

    public static Collection getNLTimeFormats() {
        return NLInformats.getNLTimeFormats(Locale.getDefault());
    }

    public static Collection getNLTimeFormats(Locale locale) {
        Collection cached = (Collection)timeFormats.get(locale);
        if (cached != null) {
            return cached;
        }
        return NLInformats.loadNLTimeFormats(locale);
    }

    public static Collection getNLWeekFormats() {
        return NLInformats.getNLWeekFormats(Locale.getDefault());
    }

    public static Collection getNLWeekFormats(Locale locale) {
        Collection cached = (Collection)weekFormats.get(locale);
        if (cached != null) {
            return cached;
        }
        return NLInformats.loadNLWeekFormats(locale);
    }

    public static Collection getNLYearFormats() {
        return NLInformats.getNLYearFormats(Locale.getDefault());
    }

    public static Collection getNLYearFormats(Locale locale) {
        Collection cached = (Collection)yearFormats.get(locale);
        if (cached != null) {
            return cached;
        }
        return NLInformats.loadNLYearFormats(locale);
    }

    public static Date parseDateString(String str) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, locale, DATE_FORMATS);
    }

    public static Date parseDateString(String str, Calendar cal) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, locale, cal, DATE_FORMATS);
    }

    public static Date parseDateString(String str, ParsePosition pos) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, pos, locale, DATE_FORMATS);
    }

    public static Date parseDateString(String str, ParsePosition pos, Calendar cal) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, pos, locale, cal, DATE_FORMATS);
    }

    public static Date parseDateString(String str, Locale locale) throws ParseException {
        return NLInformats.parse(str, locale, DATE_FORMATS);
    }

    public static Date parseDateString(String str, Locale locale, Calendar cal) throws ParseException {
        return NLInformats.parse(str, locale, cal, DATE_FORMATS);
    }

    public static Date parseDateString(String str, ParsePosition pos, Locale locale) throws ParseException {
        return NLInformats.parse(str, pos, locale, DATE_FORMATS);
    }

    public static Date parseDateString(String str, ParsePosition pos, Locale locale, Calendar cal) throws ParseException {
        return NLInformats.parse(str, pos, locale, cal, DATE_FORMATS);
    }

    public static Date parseDateTimeString(String str) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, locale, DATETIME_FORMATS);
    }

    public static Date parseDateTimeString(String str, Calendar cal) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, locale, cal, DATETIME_FORMATS);
    }

    public static Date parseDateTimeString(String str, ParsePosition pos) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, pos, locale, DATETIME_FORMATS);
    }

    public static Date parseDateTimeString(String str, ParsePosition pos, Calendar cal) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, pos, locale, cal, DATETIME_FORMATS);
    }

    public static Date parseDateTimeString(String str, Locale locale) throws ParseException {
        return NLInformats.parse(str, locale, DATETIME_FORMATS);
    }

    public static Date parseDateTimeString(String str, Locale locale, Calendar cal) throws ParseException {
        return NLInformats.parse(str, locale, cal, DATETIME_FORMATS);
    }

    public static Date parseDateTimeString(String str, ParsePosition pos, Locale locale) throws ParseException {
        return NLInformats.parse(str, pos, locale, DATETIME_FORMATS);
    }

    public static Date parseDateTimeString(String str, ParsePosition pos, Locale locale, Calendar cal) throws ParseException {
        return NLInformats.parse(str, pos, locale, cal, DATETIME_FORMATS);
    }

    public static Date parseMonthYearString(String str) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, locale, MONTHYEAR_FORMATS);
    }

    public static Date parseMonthYearString(String str, Calendar cal) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, locale, cal, MONTHYEAR_FORMATS);
    }

    public static Date parseMonthYearString(String str, ParsePosition pos) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, pos, locale, MONTHYEAR_FORMATS);
    }

    public static Date parseMonthYearString(String str, ParsePosition pos, Calendar cal) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, pos, locale, cal, MONTHYEAR_FORMATS);
    }

    public static Date parseMonthYearString(String str, Locale locale) throws ParseException {
        return NLInformats.parse(str, locale, MONTHYEAR_FORMATS);
    }

    public static Date parseMonthYearString(String str, Locale locale, Calendar cal) throws ParseException {
        return NLInformats.parse(str, locale, cal, MONTHYEAR_FORMATS);
    }

    public static Date parseMonthYearString(String str, ParsePosition pos, Locale locale) throws ParseException {
        return NLInformats.parse(str, pos, locale, MONTHYEAR_FORMATS);
    }

    public static Date parseMonthYearString(String str, ParsePosition pos, Locale locale, Calendar cal) throws ParseException {
        return NLInformats.parse(str, pos, locale, cal, MONTHYEAR_FORMATS);
    }

    public static Date parseMonthDayString(String str) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, locale, MONTHDAY_FORMATS);
    }

    public static Date parseMonthDayString(String str, Calendar cal) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, locale, cal, MONTHDAY_FORMATS);
    }

    public static Date parseMonthDayString(String str, ParsePosition pos) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, pos, locale, MONTHDAY_FORMATS);
    }

    public static Date parseMonthDayString(String str, ParsePosition pos, Calendar cal) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, pos, locale, cal, MONTHDAY_FORMATS);
    }

    public static Date parseMonthDayString(String str, Locale locale) throws ParseException {
        return NLInformats.parse(str, locale, MONTHDAY_FORMATS);
    }

    public static Date parseMonthDayString(String str, Locale locale, Calendar cal) throws ParseException {
        return NLInformats.parse(str, locale, cal, MONTHDAY_FORMATS);
    }

    public static Date parseMonthDayString(String str, ParsePosition pos, Locale locale) throws ParseException {
        return NLInformats.parse(str, pos, locale, MONTHDAY_FORMATS);
    }

    public static Date parseMonthDayString(String str, ParsePosition pos, Locale locale, Calendar cal) throws ParseException {
        return NLInformats.parse(str, pos, locale, cal, MONTHDAY_FORMATS);
    }

    public static Date parseQuarterString(String str) throws ParseException {
        Locale locale = Locale.getDefault();
        try {
            return NLInformats.parseQuarter(str, locale);
        }
        catch (ParseException e) {
            if (NLInformats.tryFallback(locale)) {
                return NLInformats.parseQuarter(str, Locale.US);
            }
            throw e;
        }
    }

    public static Date parseQuarterString(String str, Calendar cal) throws ParseException {
        Locale locale = Locale.getDefault();
        try {
            return NLInformats.parseQuarter(str, locale, cal);
        }
        catch (ParseException e) {
            if (NLInformats.tryFallback(locale)) {
                return NLInformats.parseQuarter(str, Locale.US, cal);
            }
            throw e;
        }
    }

    public static Date parseQuarterString(String str, ParsePosition pos) throws ParseException {
        Locale locale = Locale.getDefault();
        int startPos = pos.getIndex();
        try {
            return NLInformats.parseQuarter(str, pos, locale);
        }
        catch (ParseException e) {
            if (NLInformats.tryFallback(locale)) {
                pos.setIndex(startPos);
                pos.setErrorIndex(0);
                return NLInformats.parseQuarter(str, pos, Locale.US);
            }
            throw e;
        }
    }

    public static Date parseQuarterString(String str, ParsePosition pos, Calendar cal) throws ParseException {
        Locale locale = Locale.getDefault();
        int startPos = pos.getIndex();
        try {
            return NLInformats.parseQuarter(str, pos, locale, cal);
        }
        catch (ParseException e) {
            if (NLInformats.tryFallback(locale)) {
                pos.setIndex(startPos);
                pos.setErrorIndex(0);
                return NLInformats.parseQuarter(str, pos, Locale.US, cal);
            }
            throw e;
        }
    }

    public static Date parseQuarterString(String str, Locale locale) throws ParseException {
        try {
            return NLInformats.parseQuarter(str, locale);
        }
        catch (ParseException e) {
            if (NLInformats.tryFallback(locale)) {
                return NLInformats.parseQuarter(str, Locale.US);
            }
            throw e;
        }
    }

    public static Date parseQuarterString(String str, Locale locale, Calendar cal) throws ParseException {
        try {
            return NLInformats.parseQuarter(str, locale, cal);
        }
        catch (ParseException e) {
            if (NLInformats.tryFallback(locale)) {
                return NLInformats.parseQuarter(str, Locale.US, cal);
            }
            throw e;
        }
    }

    public static Date parseQuarterString(String str, ParsePosition ppos, Locale locale) throws ParseException {
        int startPos = ppos.getIndex();
        try {
            return NLInformats.parseQuarter(str, ppos, locale);
        }
        catch (ParseException e) {
            if (NLInformats.tryFallback(locale)) {
                ppos.setIndex(startPos);
                ppos.setErrorIndex(0);
                return NLInformats.parseQuarter(str, ppos, Locale.US);
            }
            throw e;
        }
    }

    public static Date parseQuarterString(String str, ParsePosition ppos, Locale locale, Calendar cal) throws ParseException {
        int startPos = ppos.getIndex();
        try {
            return NLInformats.parseQuarter(str, ppos, locale, cal);
        }
        catch (ParseException e) {
            if (NLInformats.tryFallback(locale)) {
                ppos.setIndex(startPos);
                ppos.setErrorIndex(0);
                return NLInformats.parseQuarter(str, ppos, Locale.US, cal);
            }
            throw e;
        }
    }

    public static Date parseTimeString(String str) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, locale, TIME_FORMATS);
    }

    public static Date parseTimeString(String str, Calendar cal) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, locale, cal, TIME_FORMATS);
    }

    public static Date parseTimeString(String str, ParsePosition pos) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, pos, locale, TIME_FORMATS);
    }

    public static Date parseTimeString(String str, ParsePosition pos, Calendar cal) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, pos, locale, cal, TIME_FORMATS);
    }

    public static Date parseTimeString(String str, Locale locale) throws ParseException {
        return NLInformats.parse(str, locale, TIME_FORMATS);
    }

    public static Date parseTimeString(String str, Locale locale, Calendar cal) throws ParseException {
        return NLInformats.parse(str, locale, cal, TIME_FORMATS);
    }

    public static Date parseTimeString(String str, ParsePosition pos, Locale locale) throws ParseException {
        return NLInformats.parse(str, pos, locale, TIME_FORMATS);
    }

    public static Date parseTimeString(String str, ParsePosition pos, Locale locale, Calendar cal) throws ParseException {
        return NLInformats.parse(str, pos, locale, cal, TIME_FORMATS);
    }

    public static Date parseWeekString(String str) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, locale, WEEK_FORMATS);
    }

    public static Date parseWeekString(String str, Calendar cal) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, locale, cal, WEEK_FORMATS);
    }

    public static Date parseWeekString(String str, ParsePosition pos) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, pos, locale, WEEK_FORMATS);
    }

    public static Date parseWeekString(String str, ParsePosition pos, Calendar cal) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, pos, locale, cal, WEEK_FORMATS);
    }

    public static Date parseWeekString(String str, Locale locale) throws ParseException {
        return NLInformats.parse(str, locale, WEEK_FORMATS);
    }

    public static Date parseWeekString(String str, Locale locale, Calendar cal) throws ParseException {
        return NLInformats.parse(str, locale, cal, WEEK_FORMATS);
    }

    public static Date parseWeekString(String str, ParsePosition pos, Locale locale) throws ParseException {
        return NLInformats.parse(str, pos, locale, WEEK_FORMATS);
    }

    public static Date parseWeekString(String str, ParsePosition pos, Locale locale, Calendar cal) throws ParseException {
        return NLInformats.parse(str, pos, locale, cal, WEEK_FORMATS);
    }

    public static Date parseYearString(String str) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, locale, YEAR_FORMATS);
    }

    public static Date parseYearString(String str, Calendar cal) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, locale, cal, YEAR_FORMATS);
    }

    public static Date parseYearString(String str, ParsePosition pos) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, pos, locale, YEAR_FORMATS);
    }

    public static Date parseYearString(String str, ParsePosition pos, Calendar cal) throws ParseException {
        Locale locale = Locale.getDefault();
        return NLInformats.parse(str, pos, locale, cal, YEAR_FORMATS);
    }

    public static Date parseYearString(String str, Locale locale) throws ParseException {
        return NLInformats.parse(str, locale, YEAR_FORMATS);
    }

    public static Date parseYearString(String str, Locale locale, Calendar cal) throws ParseException {
        return NLInformats.parse(str, locale, cal, YEAR_FORMATS);
    }

    public static Date parseYearString(String str, ParsePosition pos, Locale locale) throws ParseException {
        return NLInformats.parse(str, pos, locale, YEAR_FORMATS);
    }

    public static Date parseYearString(String str, ParsePosition pos, Locale locale, Calendar cal) throws ParseException {
        return NLInformats.parse(str, pos, locale, cal, YEAR_FORMATS);
    }

    public static String getDateStyle(Locale locale) {
        ResourceBundle bundle = NLInformats.getResourceBundle(locale);
        return bundle.getString("datestyle");
    }

    private static Date parse(String str, Locale locale, IGetFormats loadFormats) throws ParseException {
        for (FormatPatternData data : loadFormats.loadFormats(locale)) {
            if (data.formatPattern.name.startsWith("UNIFORM") && str.trim().length() != data.formatPattern.pattern.length()) continue;
            data.fmt.applyPattern(data.formatPattern.pattern);
            data.fmt.setLenient(false);
            try {
                return data.fmt.parse(str);
            }
            catch (ParseException e) {
            }
        }
        StringBuffer buff = new StringBuffer("Unparseable date: \"");
        buff.append(str).append("\"");
        throw new ParseException(buff.toString(), 0);
    }

    private static Date parse(String str, Locale locale, Calendar cal, IGetFormats loadFormats) throws ParseException {
        for (FormatPatternData data : loadFormats.loadFormats(locale)) {
            if (data.formatPattern.name.startsWith("UNIFORM") && str.trim().length() != data.formatPattern.pattern.length()) continue;
            data.fmt.setCalendar(cal);
            data.fmt.applyPattern(data.formatPattern.pattern);
            data.fmt.setLenient(false);
            try {
                Date date = data.fmt.parse(str);
                Calendar cal2 = (Calendar)cal.clone();
                cal2.setTime(date);
                return cal2.getTime();
            }
            catch (ParseException e) {
            }
        }
        StringBuffer buff = new StringBuffer("Unparseable date: \"");
        buff.append(str).append("\"");
        throw new ParseException(buff.toString(), 0);
    }

    private static Date parse(String str, ParsePosition ppos, Locale locale, IGetFormats loadFormats) throws ParseException {
        int pos = -1;
        int startPos = ppos.getIndex();
        for (FormatPatternData data : loadFormats.loadFormats(locale)) {
            int offset;
            if (data.formatPattern.name.startsWith("UNIFORM") && str.trim().length() != data.formatPattern.pattern.length()) continue;
            data.fmt.applyPattern(data.formatPattern.pattern);
            data.fmt.setLenient(false);
            ppos.setIndex(startPos);
            ppos.setErrorIndex(-1);
            Date date = data.fmt.parse(str, ppos);
            if (date != null) {
                return date;
            }
            if (ppos.getIndex() != 0 || (offset = ppos.getErrorIndex()) <= pos) continue;
            pos = offset;
        }
        ppos.setErrorIndex(pos);
        StringBuffer buff = new StringBuffer("Unparseable date: \"");
        buff.append(str).append("\"");
        throw new ParseException(buff.toString(), pos);
    }

    private static Date parse(String str, ParsePosition ppos, Locale locale, Calendar cal, IGetFormats loadFormats) throws ParseException {
        int pos = -1;
        int startPos = ppos.getIndex();
        for (FormatPatternData data : loadFormats.loadFormats(locale)) {
            if (data.formatPattern.name.startsWith("UNIFORM") && str.trim().length() != data.formatPattern.pattern.length()) continue;
            data.fmt.setCalendar(cal);
            data.fmt.applyPattern(data.formatPattern.pattern);
            data.fmt.setLenient(false);
            ppos.setIndex(startPos);
            ppos.setErrorIndex(-1);
            Date date = data.fmt.parse(str, ppos);
            if (date == null || ppos.getIndex() == 0) {
                int offset = ppos.getErrorIndex();
                if (offset <= pos) continue;
                pos = offset;
                continue;
            }
            Calendar cal2 = (Calendar)cal.clone();
            cal2.setTime(date);
            return cal2.getTime();
        }
        ppos.setErrorIndex(pos);
        StringBuffer buff = new StringBuffer("Unparseable date: \"");
        buff.append(str).append("\"");
        throw new ParseException(buff.toString(), pos);
    }

    private static Date parseQuarter(String str, Locale locale) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("", locale);
        for (NLFormats.FormatPattern pattern : NLInformats.getNLQuarterFormats(locale)) {
            for (int i = 0; i < quarterMonths.length; ++i) {
                String fmtStr = NLInformats.fixQuarterPattern(pattern.pattern, quarterMonths[i], locale);
                format.applyPattern(fmtStr);
                format.setLenient(false);
                try {
                    Date date = format.parse(str);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    cal.set(2, i * 3);
                    return cal.getTime();
                }
                catch (ParseException e) {
                    continue;
                }
            }
        }
        StringBuffer buff = new StringBuffer("Unparseable date: \"");
        buff.append(str).append("\"");
        throw new ParseException(buff.toString(), 0);
    }

    private static Date parseQuarter(String str, Locale locale, Calendar cal) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("", locale);
        format.setCalendar(cal);
        for (NLFormats.FormatPattern pattern : NLInformats.getNLQuarterFormats(locale)) {
            for (int i = 0; i < quarterMonths.length; ++i) {
                String fmtStr = NLInformats.fixQuarterPattern(pattern.pattern, quarterMonths[i], locale);
                format.applyPattern(fmtStr);
                format.setLenient(false);
                try {
                    Date date = format.parse(str);
                    Calendar cal2 = (Calendar)cal.clone();
                    cal2.setTime(date);
                    cal2.set(2, i * 3);
                    return cal2.getTime();
                }
                catch (ParseException e) {
                    continue;
                }
            }
        }
        StringBuffer buff = new StringBuffer("Unparseable date: \"");
        buff.append(str).append("\"");
        throw new ParseException(buff.toString(), 0);
    }

    private static Date parseQuarter(String str, ParsePosition ppos, Locale locale) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("", locale);
        int pos = -1;
        int startPos = ppos.getIndex();
        for (NLFormats.FormatPattern pattern : NLInformats.getNLQuarterFormats(locale)) {
            for (int i = 0; i < quarterMonths.length; ++i) {
                String fmtStr = NLInformats.fixQuarterPattern(pattern.pattern, quarterMonths[i], locale);
                format.applyPattern(fmtStr);
                format.setLenient(false);
                ppos.setIndex(startPos);
                ppos.setErrorIndex(-1);
                Date date = format.parse(str, ppos);
                if (date == null || ppos.getIndex() == 0) {
                    int offset = ppos.getErrorIndex();
                    if (offset <= pos) continue;
                    pos = offset;
                    continue;
                }
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                cal.set(2, i * 3);
                return cal.getTime();
            }
        }
        ppos.setErrorIndex(pos);
        StringBuffer buff = new StringBuffer("Unparseable date: \"");
        buff.append(str).append("\"");
        throw new ParseException(buff.toString(), pos);
    }

    private static Date parseQuarter(String str, ParsePosition ppos, Locale locale, Calendar cal) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("", locale);
        format.setCalendar(cal);
        int pos = -1;
        int startPos = ppos.getIndex();
        for (NLFormats.FormatPattern pattern : NLInformats.getNLQuarterFormats(locale)) {
            for (int i = 0; i < quarterMonths.length; ++i) {
                String fmtStr = NLInformats.fixQuarterPattern(pattern.pattern, quarterMonths[i], locale);
                format.applyPattern(fmtStr);
                format.setLenient(false);
                ppos.setIndex(startPos);
                ppos.setErrorIndex(-1);
                Date date = format.parse(str, ppos);
                if (date == null || ppos.getIndex() == 0) {
                    int offset = ppos.getErrorIndex();
                    if (offset <= pos) continue;
                    pos = offset;
                    continue;
                }
                Calendar cal2 = (Calendar)cal.clone();
                cal2.setTime(date);
                cal2.set(2, i * 3);
                return cal2.getTime();
            }
        }
        ppos.setErrorIndex(pos);
        StringBuffer buff = new StringBuffer("Unparseable date: \"");
        buff.append(str).append("\"");
        throw new ParseException(buff.toString(), pos);
    }

    static String fixQuarterPattern(String pattern, int month, Locale locale) {
        String strQuarter;
        int pos = pattern.indexOf("Q");
        if (pos < 0) {
            throw new IllegalArgumentException("The parameter 'pattern' must be a pattern");
        }
        NLFormats.QuarterPatterns qPatterns = NLFormats.loadQuarterPatterns(locale);
        int type = 1;
        type = pattern.length() > pos + 2 && pattern.charAt(pos + 2) == 'Q' ? 0 : (pattern.length() > pos + 1 && pattern.charAt(pos + 1) == 'Q' ? 1 : 2);
        switch (month) {
            default: {
                if (type == 1) {
                    strQuarter = qPatterns.shortFirstQuarter;
                    break;
                }
                if (type == 0) {
                    strQuarter = qPatterns.longFirstQuarter;
                    break;
                }
                strQuarter = qPatterns.abFirstQuarter;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (type == 1) {
                    strQuarter = qPatterns.shortSecondQuarter;
                    break;
                }
                if (type == 0) {
                    strQuarter = qPatterns.longSecondQuarter;
                    break;
                }
                strQuarter = qPatterns.abSecondQuarter;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                if (type == 1) {
                    strQuarter = qPatterns.shortThirdQuarter;
                    break;
                }
                if (type == 0) {
                    strQuarter = qPatterns.longThirdQuarter;
                    break;
                }
                strQuarter = qPatterns.abThirdQuarter;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                strQuarter = type == 1 ? qPatterns.shortFourthQuarter : (type == 0 ? qPatterns.longFourthQuarter : qPatterns.abFourthQuarter);
            }
        }
        StringBuffer buff = new StringBuffer();
        if (pos > 0) {
            buff.append(pattern.substring(0, pos));
        }
        buff.append(strQuarter);
        if (type == 1) {
            buff.append(pattern.substring(pos + 2));
        } else if (type == 0) {
            buff.append(pattern.substring(pos + 3));
        } else {
            buff.append(pattern.substring(pos + 1));
        }
        String str = buff.toString();
        if (strQuarter.charAt(strQuarter.length() - 1) == '\'' && str.length() > pos + strQuarter.length() && str.charAt(pos + strQuarter.length()) == '\'') {
            str = str.substring(0, pos + strQuarter.length() - 1) + str.substring(pos + strQuarter.length() + 1);
        }
        if (strQuarter.charAt(0) == '\'' && pos > 0 && str.charAt(pos - 1) == '\'') {
            str = str.substring(0, pos - 1) + str.substring(pos + 1);
        }
        return str;
    }

    private static List loadAllNLDateFormats(Locale locale) {
        ArrayList coll = new ArrayList();
        coll.addAll(NLInformats.getNLDateFormats(locale));
        coll.addAll(NLInformats.getNLMonthDayFormats(locale));
        coll.addAll(NLInformats.getNLMonthYearFormats(locale));
        coll.addAll(NLInformats.getNLWeekFormats(locale));
        coll.addAll(NLInformats.getNLYearFormats(locale));
        coll.addAll(NLInformats.getNLQuarterFormats(locale));
        NLInformats.sortDates(coll, NLInformats.getDateStyle(locale));
        List unmodifiableList = Collections.unmodifiableList(coll);
        allDateFormats.put(locale, unmodifiableList);
        return unmodifiableList;
    }

    private static List loadNLDateFormats(Locale locale) {
        ResourceBundle bundle = NLInformats.getResourceBundle(locale);
        ArrayList<NLFormats.FormatPattern> coll = new ArrayList<NLFormats.FormatPattern>();
        NLInformats.addPattern(NLDATES, "d_fmt_s", coll, bundle);
        NLInformats.addPattern(NLDATEM, "d_fmt_m", coll, bundle);
        NLInformats.addPattern(NLDATEL, "d_fmt_l", coll, bundle);
        NLInformats.addPattern(NLDATE, "d_fmt", coll, bundle);
        NLInformats.addGeneratedMDYPatterns(locale, coll);
        NLInformats.addPattern(NLDATE_WEEKS, "d_fmt_week_s", coll, bundle);
        NLInformats.addPattern(NLDATE_WEEK, "d_fmt_week", coll, bundle);
        if ("en".equals(locale.getLanguage()) && "US".equals(locale.getCountry())) {
            coll.add(0, new NLFormats.FormatPattern("SASDate", "ddMMMyyyy"));
        }
        int end = coll.size();
        SingleEntry singleEntry = new SingleEntry("UNIFORMw", "");
        singleEntry.setFormatLocale(locale);
        Map shortUniformEntryMap = singleEntry.genNLdatesEntry(0);
        String[] patterns = ((SingleEntry)shortUniformEntryMap.get(new Integer(1))).getPatterns();
        boolean isInclude = false;
        int size = patterns.length;
        for (int index = 0; index < size; ++index) {
            isInclude = false;
            for (int checkInx = 0; checkInx < end; ++checkInx) {
                NLFormats.FormatPattern formatPattern = (NLFormats.FormatPattern)coll.get(checkInx);
                if (!formatPattern.pattern.equals(patterns[index])) continue;
                isInclude = true;
                break;
            }
            if (isInclude) continue;
            coll.add(new NLFormats.FormatPattern("UNIFORM" + index, patterns[index]));
        }
        NLInformats.sortDates(coll, NLInformats.getDateStyle(locale));
        List unmodifiableList = Collections.unmodifiableList(coll);
        dateFormats.put(locale, unmodifiableList);
        return unmodifiableList;
    }

    private static List loadNLDateTimeFormats(Locale locale) {
        ResourceBundle bundle = NLInformats.getResourceBundle(locale);
        ArrayList<NLFormats.FormatPattern> coll = new ArrayList<NLFormats.FormatPattern>();
        NLInformats.addPattern(DATETIME, "d_t_fmt", coll, bundle);
        NLInformats.addPattern(DATETIME_SHORT, "d_t_fmt_s", coll, bundle);
        NLInformats.addPattern(DATETIME_MED, "d_t_fmt_m", coll, bundle);
        NLInformats.addPattern(DATETIME_LONG, "d_t_fmt_l", coll, bundle);
        NLInformats.addPattern(DATETIME_WEEK2, "d_t_fmt_week_s", coll, bundle);
        NLInformats.addPattern(DATETIME_WEEK, "d_t_fmt_week", coll, bundle);
        NLInformats.addPattern(DATETIME_AP, "d_t_ap", coll, bundle);
        coll.add(new NLFormats.FormatPattern(XML_SCHEMA_NAME, XML_SCHEMA_PATTERN));
        if ("en".equals(locale.getLanguage()) && "US".equals(locale.getCountry())) {
            coll.add(0, new NLFormats.FormatPattern("SASDatetime", "ddMMMyyyy:HH:mm:ss"));
            coll.add(0, new NLFormats.FormatPattern("TimeStampTm", "yyyy-MM-dd'T'HH:mm"));
            coll.add(0, new NLFormats.FormatPattern("TimeStampTs", "yyyy-MM-dd'T'HH:mm:ss"));
            coll.add(0, new NLFormats.FormatPattern("TimeStampTms", "yyyy-MM-dd'T'HH:mm:ss.SSS"));
            coll.add(0, new NLFormats.FormatPattern("TimeStamp", "yy-MM-dd HH:mm:ss.SSS"));
        }
        SingleEntry singleEntry = new SingleEntry("UNIFORMw", "");
        singleEntry.setFormatLocale(locale);
        Map shortUniformEntryMap = singleEntry.genNLdatesEntry(1);
        String[] patterns = ((SingleEntry)shortUniformEntryMap.get(new Integer(1))).getPatterns();
        boolean isInclude = false;
        int end = coll.size();
        int size = patterns.length;
        for (int index = 0; index < size; ++index) {
            isInclude = false;
            for (int checkInx = 0; checkInx < end; ++checkInx) {
                NLFormats.FormatPattern formatPattern = (NLFormats.FormatPattern)coll.get(checkInx);
                if (!formatPattern.pattern.equals(patterns[index])) continue;
                isInclude = true;
                break;
            }
            if (isInclude) continue;
            coll.add(new NLFormats.FormatPattern("UNIFORMDT" + index, patterns[index]));
        }
        NLInformats.sortDates(coll, NLInformats.getDateStyle(locale));
        List unmodifiableList = Collections.unmodifiableList(coll);
        dateTimeFormats.put(locale, unmodifiableList);
        return unmodifiableList;
    }

    private static List loadNLMonthYearFormats(Locale locale) {
        ResourceBundle bundle = NLInformats.getResourceBundle(locale);
        ArrayList coll = new ArrayList();
        NLInformats.addPattern(SHORT_MONTH_YEAR_NAME, "d_fmt_yymm_s", coll, bundle);
        NLInformats.addGeneratedMonthYearPatterns(locale, coll);
        NLInformats.addPattern(LONG_MONTH_YEAR_NAME, "d_fmt_yymm", coll, bundle);
        NLInformats.sortDates(coll, NLInformats.getDateStyle(locale));
        List unmodifiableList = Collections.unmodifiableList(coll);
        monthYearFormats.put(locale, unmodifiableList);
        return unmodifiableList;
    }

    private static List loadNLMonthDayFormats(Locale locale) {
        ResourceBundle bundle = NLInformats.getResourceBundle(locale);
        ArrayList coll = new ArrayList();
        NLInformats.addPattern(SHORT_MONTH_DAY_NAME, "d_fmt_mmdd_s", coll, bundle);
        NLInformats.addPattern(LONG_MONTH_DAY_NAME, "d_md", coll, bundle);
        NLInformats.addGeneratedMonthDayPatterns(locale, coll);
        List unmodifiableList = Collections.unmodifiableList(coll);
        monthDayFormats.put(locale, unmodifiableList);
        return unmodifiableList;
    }

    private static List loadNLQuarterFormats(Locale locale) {
        ResourceBundle bundle = NLInformats.getResourceBundle(locale);
        ArrayList coll = new ArrayList();
        NLInformats.addPattern(SHORT_QUARTER_NAME, "d_fmt_yyqq_s", coll, bundle);
        NLInformats.addPattern(LONG_QUARTER_NAME, "d_fmt_yyqq", coll, bundle);
        NLInformats.addGeneratedQuarPatterns(locale, coll);
        NLInformats.sortDates(coll, NLInformats.getDateStyle(locale));
        List unmodifiableList = Collections.unmodifiableList(coll);
        quarterFormats.put(locale, unmodifiableList);
        return unmodifiableList;
    }

    private static List loadNLTimeFormats(Locale locale) {
        ResourceBundle bundle = NLInformats.getResourceBundle(locale);
        ArrayList<NLFormats.FormatPattern> coll = new ArrayList<NLFormats.FormatPattern>();
        NLInformats.addPattern(HMS_12_NAME, "t_ap", coll, bundle);
        NLInformats.addPattern(HMS_24_NAME, "t", coll, bundle);
        Object[] objs = coll.toArray();
        for (int i = 0; i < objs.length; ++i) {
            String prefix;
            Matcher matcher;
            NLFormats.FormatPattern pattern = (NLFormats.FormatPattern)objs[i];
            if (pattern.name.equals(HMS_24_NAME)) {
                matcher = NLTIME_PATTERN.matcher(pattern.pattern);
                if (matcher.find()) {
                    String str = prefix = matcher.group(1);
                    String suffix = matcher.group(3);
                    if (suffix != null) {
                        str = prefix + suffix;
                    }
                    str = str.trim();
                    coll.add(new NLFormats.FormatPattern(HM_24_NAME, str));
                    continue;
                }
                coll.add(new NLFormats.FormatPattern(HM_24_NAME, pattern.pattern));
                continue;
            }
            if (!pattern.name.equals(HMS_12_NAME)) continue;
            matcher = NLTIMAP_PATTERN.matcher(pattern.pattern);
            if (matcher.find()) {
                prefix = matcher.group(1);
                String suffix = matcher.group(3);
                String str = (matcher = SUFFIX_PATTERN.matcher(suffix)).find() ? prefix + suffix : prefix;
                str = str.trim();
                coll.add(new NLFormats.FormatPattern(HM_12_NAME, str));
                continue;
            }
            coll.add(new NLFormats.FormatPattern(HM_12_NAME, pattern.pattern));
        }
        List unmodifiableList = Collections.unmodifiableList(coll);
        timeFormats.put(locale, unmodifiableList);
        return unmodifiableList;
    }

    private static List loadNLWeekFormats(Locale locale) {
        ResourceBundle bundle = NLInformats.getResourceBundle(locale);
        ArrayList coll = new ArrayList();
        NLInformats.addPattern(SHORT_WEEK_NAME, "d_fmt_yyww_s", coll, bundle);
        NLInformats.addPattern(LONG_WEEK_NAME, "d_fmt_yyww", coll, bundle);
        NLInformats.sortDates(coll, NLInformats.getDateStyle(locale));
        List unmodifiableList = Collections.unmodifiableList(coll);
        weekFormats.put(locale, unmodifiableList);
        return unmodifiableList;
    }

    private static List loadNLYearFormats(Locale locale) {
        ResourceBundle bundle = NLInformats.getResourceBundle(locale);
        ArrayList coll = new ArrayList();
        NLInformats.addPattern(SHORT_YEAR_NAME, "d_fmt_year_s", coll, bundle);
        NLInformats.addPattern(LONG_YEAR_NAME, "d_fmt_year", coll, bundle);
        NLInformats.sortDates(coll, NLInformats.getDateStyle(locale));
        List unmodifiableList = Collections.unmodifiableList(coll);
        yearFormats.put(locale, unmodifiableList);
        return unmodifiableList;
    }

    private static Map loadAllDateMap(Locale locale) {
        HashMap<String, String> map = (HashMap<String, String>)allDateMap.get(locale);
        if (map == null) {
            map = new HashMap<String, String>();
            for (NLFormats.FormatPattern pattern : NLInformats.getNLDateTimeFormats(locale)) {
                map.put(pattern.name, pattern.pattern);
            }
            for (NLFormats.FormatPattern pattern : NLInformats.getNLTimeFormats(locale)) {
                map.put(pattern.name, pattern.pattern);
            }
            for (NLFormats.FormatPattern pattern : NLInformats.getAllNLDateFormats(locale)) {
                map.put(pattern.name, pattern.pattern);
            }
            allDateMap.put(locale, map);
        }
        return map;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle rb = (ResourceBundle)bundles.get(locale);
        if (rb == null && (rb = ResourceBundle.getBundle(BUNDLE_NAME, locale)) != null) {
            bundles.put(locale, rb);
        }
        return rb;
    }

    private static void addPattern(String name, String key, List coll, ResourceBundle bundle) {
        try {
            String pattern = bundle.getString(key);
            coll.add(new NLFormats.FormatPattern(name, pattern));
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
    }

    private static boolean tryFallback(Locale locale) {
        return useFallback && (!"en".equals(locale.getLanguage()) || !"US".equals(locale.getCountry()));
    }

    private static void sortDates(List coll, final String dmy) {
        Collections.sort(coll, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                NLFormats.FormatPattern pat0 = (NLFormats.FormatPattern)arg0;
                NLFormats.FormatPattern pat1 = (NLFormats.FormatPattern)arg1;
                boolean patternMatch0 = false;
                boolean patternMatch1 = false;
                Matcher matcher = ((Pattern)patterns.get(dmy)).matcher(pat0.pattern);
                if (matcher.find()) {
                    patternMatch0 = true;
                }
                matcher.reset(pat1.pattern);
                if (matcher.find()) {
                    patternMatch1 = true;
                }
                if (patternMatch0 == patternMatch1) {
                    boolean year1;
                    boolean year0 = pat0.pattern.indexOf("yyyy") >= 0;
                    boolean bl = year1 = pat1.pattern.indexOf("yyyy") >= 0;
                    if (year0 == year1) {
                        boolean month1;
                        boolean month0 = pat0.pattern.indexOf("MMM") >= 0;
                        boolean bl2 = month1 = pat1.pattern.indexOf("MMM") >= 0;
                        if (month0 == month1) {
                            boolean day1;
                            boolean day0 = pat0.pattern.indexOf("dd") >= 0;
                            boolean bl3 = day1 = pat1.pattern.indexOf("dd") >= 0;
                            if (day0 == day1) {
                                return 0;
                            }
                            return day0 ? 1 : -1;
                        }
                        return month0 ? 1 : -1;
                    }
                    return year0 ? 1 : -1;
                }
                return patternMatch0 ? -1 : 1;
            }
        });
    }

    private static void addGeneratedQuarPatterns(Locale locale, List coll) {
        ResourceBundle bundle = NLInformats.getResourceBundle(locale);
        String delim = bundle.getString("date_sep");
        coll.add(new NLFormats.FormatPattern("UNIFORMQS", "yy" + delim + "Q"));
        coll.add(new NLFormats.FormatPattern("UNIFORMQL", "yyyy" + delim + "Q"));
    }

    private static void addGeneratedMDYPatterns(Locale locale, List coll) {
        String datestyle = NLInformats.getDateStyle(locale);
        if (datestyle.equals(YDM)) {
            coll.add(new NLFormats.FormatPattern(MTHDAYYRSLASH, "yy/dd/MM"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRSLASH2, "yy/dd/MMM"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDOT, "yy.dd.MM"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDOT2, "yy.dd.MMM"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDASH, "yy-dd-MM"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDASH2, "yy-dd-MMM"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRSLASHL, "yyyy/dd/MM"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRSLASHL2, "yyyy/dd/MMM"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDOTL, "yyyy.dd.MM"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDOTL2, "yyyy.dd.MMM"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDASHL, "yyyy-dd-MM"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDASHL2, "yyyy-dd-MMM"));
        } else if (datestyle.equals(YMD)) {
            coll.add(new NLFormats.FormatPattern(MTHDAYYRSLASH, "yy/MM/dd"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRSLASH2, "yy/MMM/dd"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDOT, "yy.MM.dd"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDOT2, "yy.MMM.dd"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDASH, "yy-MM-dd"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDASH2, "yy-MMM-dd"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRSLASHL, "yyyy/MM/dd"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRSLASHL2, "yyyy/MMM/dd"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDOTL, "yyyy.MM.dd"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDOTL2, "yyyy.MMM.dd"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDASHL, "yyyy-MM-dd"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDASHL2, "yyyy-MMM-dd"));
        } else if (datestyle.equals(MDY)) {
            coll.add(new NLFormats.FormatPattern(MTHDAYYRSLASH, "MM/dd/yy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRSLASH2, "MMM/dd/yy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDOT, "MM.dd.yy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDOT2, "MMM.dd.yy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDASH, "MM-dd-yy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDASH2, "MMM-dd-yy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRSLASHL, "MM/dd/yyyy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRSLASHL2, "MMM/dd/yyyy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDOTL, "MM.dd.yyyy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDOTL2, "MMM.dd.yyyy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDASHL, "MM-dd-yyyy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDASHL2, "MMM-dd-yyyy"));
        } else if (datestyle.equals(DMY)) {
            coll.add(new NLFormats.FormatPattern(MTHDAYYRSLASH, "dd/MM/yy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRSLASH2, "dd/MMM/yy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDOT, "dd.MM.yy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDOT2, "dd.MMM.yy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDASH, "dd-MM-yy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDASH2, "dd-MMM-yy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRSLASHL, "dd/MM/yyyy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRSLASHL2, "dd/MMM/yyyy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDOTL, "dd.MM.yyyy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDOTL2, "dd.MMM.yyyy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDASHL, "dd-MM-yyyy"));
            coll.add(new NLFormats.FormatPattern(MTHDAYYRDASHL2, "dd-MMM-yyyy"));
        }
    }

    private static void addGeneratedMonthYearPatterns(Locale locale, List coll) {
        String datestyle = NLInformats.getDateStyle(locale);
        if (datestyle.equals(YDM) || datestyle.equals(YMD)) {
            coll.add(new NLFormats.FormatPattern(MTHYEARSLASH, "yy/MM"));
            coll.add(new NLFormats.FormatPattern(MTHYEARSLASH2, "yy/MMM"));
            coll.add(new NLFormats.FormatPattern(MTHYEARDOT, "yy.MM"));
            coll.add(new NLFormats.FormatPattern(MTHYEARDOT2, "yy.MMM"));
            coll.add(new NLFormats.FormatPattern(MTHYEARDASH, "yy-MM"));
            coll.add(new NLFormats.FormatPattern(MTHYEARDASH2, "yy-MMM"));
            coll.add(new NLFormats.FormatPattern(MTHYEARSLASHL, "yyyy/MM"));
            coll.add(new NLFormats.FormatPattern(MTHYEARSLASHL2, "yyyy/MMM"));
            coll.add(new NLFormats.FormatPattern(MTHYEARDOTL, "yyyy.MM"));
            coll.add(new NLFormats.FormatPattern(MTHYEARDOTL2, "yyyy.MMM"));
            coll.add(new NLFormats.FormatPattern(MTHYEARDASHL, "yyyy-MM"));
            coll.add(new NLFormats.FormatPattern(MTHYEARDASHL2, "yyyy-MMM"));
        } else if (datestyle.equals(MDY) || datestyle.equals(DMY)) {
            coll.add(new NLFormats.FormatPattern(MTHYEARSLASH, "MM/yy"));
            coll.add(new NLFormats.FormatPattern(MTHYEARSLASH2, "MMM/yy"));
            coll.add(new NLFormats.FormatPattern(MTHYEARDOT, "MM.yy"));
            coll.add(new NLFormats.FormatPattern(MTHYEARDOT2, "MMM.yy"));
            coll.add(new NLFormats.FormatPattern(MTHYEARDASH, "MM-yy"));
            coll.add(new NLFormats.FormatPattern(MTHYEARDASH2, "MMM-yy"));
            coll.add(new NLFormats.FormatPattern(MTHYEARSLASHL, "MM/yyyy"));
            coll.add(new NLFormats.FormatPattern(MTHYEARSLASHL2, "MMM/yyyy"));
            coll.add(new NLFormats.FormatPattern(MTHYEARDOTL, "MM.yyyy"));
            coll.add(new NLFormats.FormatPattern(MTHYEARDOTL2, "MMM.yyyy"));
            coll.add(new NLFormats.FormatPattern(MTHYEARDASHL, "MM-yyyy"));
            coll.add(new NLFormats.FormatPattern(MTHYEARDASHL2, "MMM-yyyy"));
        }
    }

    private static void addGeneratedMonthDayPatterns(Locale locale, List coll) {
        String datestyle = NLInformats.getDateStyle(locale);
        if (datestyle.equals(YDM) || datestyle.equals(DMY)) {
            coll.add(new NLFormats.FormatPattern(DATEMTHSLASH, "dd/MM"));
            coll.add(new NLFormats.FormatPattern(DATEMTHSLASH2, "dd/MMM"));
            coll.add(new NLFormats.FormatPattern(DATEMTHDOT, "dd.MM"));
            coll.add(new NLFormats.FormatPattern(DATEMTHDOT2, "dd.MMM"));
            coll.add(new NLFormats.FormatPattern(DATEMTHDASH, "dd-MM"));
            coll.add(new NLFormats.FormatPattern(DATEMTHDASH2, "dd-MMM"));
        } else if (datestyle.equals(MDY) || datestyle.equals(YMD)) {
            coll.add(new NLFormats.FormatPattern(DATEMTHSLASH, "MM/dd"));
            coll.add(new NLFormats.FormatPattern(DATEMTHSLASH2, "MMM/dd"));
            coll.add(new NLFormats.FormatPattern(DATEMTHDOT, "MM.dd"));
            coll.add(new NLFormats.FormatPattern(DATEMTHDOT2, "MMM.dd"));
            coll.add(new NLFormats.FormatPattern(DATEMTHDASH, "MM-dd"));
            coll.add(new NLFormats.FormatPattern(DATEMTHDASH2, "MMM-dd"));
        }
    }

    static {
        useFallback = false;
        TIME_FORMATS = new LoadTimeFormats();
        DATE_FORMATS = new LoadDateFormats();
        DATETIME_FORMATS = new LoadDateTimeFormats();
        MONTHYEAR_FORMATS = new LoadMonthYearFormats();
        MONTHDAY_FORMATS = new LoadMonthDayFormats();
        WEEK_FORMATS = new LoadWeekFormats();
        YEAR_FORMATS = new LoadYearFormats();
        YDMPattern = Pattern.compile("y[^']*(\\'[^']*\\')?[^']*d[^']*(\\'[^']*\\')?[^']*M");
        YMDPattern = Pattern.compile("y[^']*(\\'[^']*\\')?[^']*M[^']*(\\'[^']*\\')?[^']*d");
        MDYPattern = Pattern.compile("M[^']*(\\'[^']*\\')?[^']*d[^']*(\\'[^']*\\')?[^']*y");
        DMYPattern = Pattern.compile("d[^']*(\\'[^']*\\')?[^']*M[^']*(\\'[^']*\\')?[^']*y");
        patterns = new HashMap();
        patterns.put(YDM, YDMPattern);
        patterns.put(YMD, YMDPattern);
        patterns.put(MDY, MDYPattern);
        patterns.put(DMY, DMYPattern);
        ArrayList<NLFormats.FormatPattern> temp = new ArrayList<NLFormats.FormatPattern>(5);
        temp.add(new NLFormats.FormatPattern("NLYMDDASH", "yyyy-MM-dd"));
        temp.add(new NLFormats.FormatPattern("NLYMDSLASH", "yyyy/MM/dd"));
        temp.add(new NLFormats.FormatPattern("NLYMDDOT", "yyyy.MM.dd"));
        temp.add(new NLFormats.FormatPattern("NLYMMDDASH", "yyyy-MMM-dd"));
        temp.add(new NLFormats.FormatPattern("NLYMMDDOT", "yyyy.MMM.dd"));
        STANDARD_DATE_FORMATS = Collections.unmodifiableList(temp);
        temp = new ArrayList(5);
        temp.add(new NLFormats.FormatPattern("NLYMMDDASH", "yyyy-MMM-dd"));
        temp.add(new NLFormats.FormatPattern("NLYMMDDOT", "yyyy.MMM.dd"));
        YDM_STANDARD_DATE_FORMATS = Collections.unmodifiableList(temp);
    }
}

