/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.codepolicy.SASScope;
import com.sas.text.FormatPatternData;
import com.sas.text.IGetFormats;
import com.sas.text.NLFormats;
import com.sas.text.NLInformats;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@SASScope
abstract class LoadFormats
implements IGetFormats {
    LoadFormats() {
    }

    @Override
    public List loadFormats(Locale locale) {
        ArrayList coll = new ArrayList();
        if (this.tryFallback(locale)) {
            this.appendAndSort(coll, locale);
        } else {
            this.append(coll, locale);
            this.sort(coll, locale);
        }
        return coll;
    }

    protected abstract List load(Locale var1);

    protected abstract void sort(List var1, Locale var2);

    protected abstract void appendAndSort(List var1, Locale var2);

    private boolean tryFallback(Locale locale) {
        return NLInformats.isFallback() && (!"en".equals(locale.getLanguage()) || !"US".equals(locale.getCountry()));
    }

    protected void append(List coll, Locale locale) {
        boolean isEnUS = "en".equals(locale.getLanguage()) && "US".equals(locale.getCountry());
        List loc = this.load(locale);
        SimpleDateFormat fmt = new SimpleDateFormat("", locale);
        SimpleDateFormat enUSFmt = null;
        for (NLFormats.FormatPattern pattern : loc) {
            FormatPatternData data = new FormatPatternData();
            data.formatPattern = pattern;
            boolean bl = data.isEnUs = isEnUS || pattern.name.equals("NLDATMXML");
            if (!isEnUS && data.isEnUs) {
                if (enUSFmt == null) {
                    enUSFmt = new SimpleDateFormat("", Locale.US);
                }
                data.fmt = enUSFmt;
            } else {
                data.fmt = fmt;
            }
            coll.add(data);
        }
    }
}

