"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesManifest = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const constructs_1 = require("constructs");
const alb_controller_1 = require("./alb-controller");
const kubectl_provider_1 = require("./kubectl-provider");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
const PRUNE_LABEL_PREFIX = 'aws.cdk.eks/prune-';
/**
 * Represents a manifest within the Kubernetes system.
 *
 * Alternatively, you can use `cluster.addManifest(resource[, resource, ...])`
 * to define resources on this cluster.
 *
 * Applies/deletes the manifest using `kubectl`.
 *
 * @stability stable
 */
class KubernetesManifest extends core_2.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_eks_KubernetesManifestProps(props);
        const stack = core_1.Stack.of(this);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(this, props.cluster);
        const prune = (_b = props.prune) !== null && _b !== void 0 ? _b : props.cluster.prune;
        const pruneLabel = prune
            ? this.injectPruneLabel(props.manifest)
            : undefined;
        if ((_c = props.ingressAlb) !== null && _c !== void 0 ? _c : false) {
            this.injectIngressAlbAnnotations(props.manifest, (_d = props.ingressAlbScheme) !== null && _d !== void 0 ? _d : alb_controller_1.AlbScheme.INTERNAL);
        }
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: KubernetesManifest.RESOURCE_TYPE,
            properties: {
                // `toJsonString` enables embedding CDK tokens in the manifest and will
                // render a CloudFormation-compatible JSON string (similar to
                // StepFunctions, CloudWatch Dashboards etc).
                Manifest: stack.toJsonString(props.manifest),
                ClusterName: props.cluster.clusterName,
                RoleArn: provider.roleArn,
                PruneLabel: pruneLabel,
                Overwrite: props.overwrite,
                SkipValidation: props.skipValidation,
            },
        });
    }
    /**
     * Injects a generated prune label to all resources in this manifest. The
     * label name will be `awscdk.eks/manifest-ADDR` where `ADDR` is the address
     * of the construct in the construct tree.
     *
     * @returns the label name
     */
    injectPruneLabel(manifest) {
        // max label name is 64 chars and addrs is always 42.
        const pruneLabel = PRUNE_LABEL_PREFIX + constructs_1.Node.of(this).addr;
        for (const resource of manifest) {
            // skip resource if it's not an object or if it does not have a "kind"
            if (typeof (resource) !== 'object' || !resource.kind) {
                continue;
            }
            if (!resource.metadata) {
                resource.metadata = {};
            }
            if (!resource.metadata.labels) {
                resource.metadata.labels = {};
            }
            resource.metadata.labels = {
                [pruneLabel]: '',
                ...resource.metadata.labels,
            };
        }
        return pruneLabel;
    }
    /**
     * Inject the necessary ingress annontations if possible (and requested).
     *
     * @see https://kubernetes-sigs.github.io/aws-load-balancer-controller/v2.2/guide/ingress/annotations/
     */
    injectIngressAlbAnnotations(manifest, scheme) {
        for (const resource of manifest) {
            // skip resource if it's not an object or if it does not have a "kind"
            if (typeof (resource) !== 'object' || !resource.kind) {
                continue;
            }
            if (resource.kind === 'Ingress') {
                resource.metadata.annotations = {
                    'kubernetes.io/ingress.class': 'alb',
                    'alb.ingress.kubernetes.io/scheme': scheme,
                    ...resource.metadata.annotations,
                };
            }
        }
    }
}
exports.KubernetesManifest = KubernetesManifest;
_a = JSII_RTTI_SYMBOL_1;
KubernetesManifest[_a] = { fqn: "@aws-cdk/aws-eks.KubernetesManifest", version: "1.136.0" };
/**
 * The CloudFormation reosurce type.
 *
 * @stability stable
 */
KubernetesManifest.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-KubernetesResource';
//# sourceMappingURL=data:application/json;base64,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