/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function.hash;

import java.security.NoSuchAlgorithmException;
import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.hash.HashFunction;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class SHA384
extends HashFunction {
    @Override
    public String getURI() {
        return "SHA384";
    }

    @Override
    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("SHA384 requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            if (QueryEvaluationUtil.isSimpleLiteral(literal) || XMLSchema.STRING.equals((Object)literal.getDatatype())) {
                String lexValue = literal.getLabel();
                try {
                    return valueFactory.createLiteral(this.hash(lexValue, "SHA-384"));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new ValueExprEvaluationException("Invalid argument for SHA384: " + literal);
        }
        throw new ValueExprEvaluationException("Invalid argument for SHA384: " + args[0]);
    }
}

