/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.concurrent;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.evaluation.concurrent.NamingThreadFactory;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelExecutor;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelTask;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelTaskBase;
import org.eclipse.rdf4j.federated.evaluation.concurrent.Scheduler;
import org.eclipse.rdf4j.federated.exception.ExceptionUtil;
import org.eclipse.rdf4j.federated.exception.FedXRuntimeException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlledWorkerScheduler<T>
implements Scheduler<T> {
    private static final Logger log = LoggerFactory.getLogger(ControlledWorkerScheduler.class);
    private final ExecutorService executor;
    private final LinkedBlockingQueue<Runnable> _taskQueue = new LinkedBlockingQueue();
    private final int nWorkers;
    private final String name;

    public ControlledWorkerScheduler() {
        this(20, "FedX Worker");
    }

    public ControlledWorkerScheduler(int nWorkers, String name) {
        this.nWorkers = nWorkers;
        this.name = name;
        this.executor = this.createExecutorService();
    }

    @Override
    public void schedule(ParallelTask<T> task) {
        WorkerRunnable runnable = new WorkerRunnable(task);
        Future<?> future = this.executor.submit(runnable);
        if (task instanceof ParallelTaskBase) {
            ((ParallelTaskBase)task).setScheduledFuture(future);
        }
        task.getQueryInfo().registerScheduledTask(task);
    }

    public void scheduleAll(List<ParallelTask<T>> tasks, ParallelExecutor<T> control) {
        for (ParallelTask<T> task : tasks) {
            this.schedule(task);
        }
    }

    public int getTotalNumberOfWorkers() {
        return this.nWorkers;
    }

    public int getNumberOfTasks() {
        return this._taskQueue.size();
    }

    private ExecutorService createExecutorService() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.nWorkers, this.nWorkers, 60L, TimeUnit.SECONDS, this._taskQueue, new NamingThreadFactory(this.name));
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    @Override
    public void abort() {
        log.info("Aborting workers of " + this.name + ".");
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new FedXRuntimeException(e);
        }
    }

    @Override
    public void done() {
    }

    @Override
    public void handleResult(CloseableIteration<T, QueryEvaluationException> res) {
        throw new RuntimeException("Unsupported Operation for this scheduler.");
    }

    @Override
    public void informFinish() {
        throw new RuntimeException("Unsupported Operation for this scheduler!");
    }

    public void informFinish(ParallelExecutor<T> control) {
    }

    @Override
    public boolean isRunning() {
        throw new RuntimeException("Unsupported Operation for this scheduler.");
    }

    public boolean isRunning(ParallelExecutor<T> control) {
        return true;
    }

    @Override
    public void toss(Exception e) {
        throw new RuntimeException("Unsupported Operation for this scheduler.");
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new FedXRuntimeException(e);
        }
    }

    protected class ControlStatus {
        public int waiting;
        public boolean done;

        public ControlStatus(int waiting, boolean done) {
            this.waiting = waiting;
            this.done = done;
        }
    }

    class WorkerRunnable
    implements Runnable {
        private final ParallelTask<T> task;
        private boolean aborted = false;

        public WorkerRunnable(ParallelTask<T> task) {
            this.task = task;
        }

        @Override
        public void run() {
            if (this.aborted) {
                return;
            }
            ParallelExecutor taskControl = this.task.getControl();
            try {
                if (log.isTraceEnabled()) {
                    log.trace("Performing task " + this.task.toString() + " in " + Thread.currentThread().getName());
                }
                CloseableIteration res = this.task.performTask();
                taskControl.addResult(res);
                taskControl.done();
            }
            catch (Throwable t) {
                if (this.aborted) {
                    return;
                }
                log.debug("Exception encountered while evaluating task (" + t.getClass().getSimpleName() + "): " + t.getMessage());
                taskControl.toss(ExceptionUtil.toException(t));
            }
        }

        public void abort() {
            this.aborted = true;
        }
    }
}

