/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class OntologyAxiomPair {
    @Nullable
    private final OWLOntology ontology;
    private final OWLAxiom axiom;

    public OntologyAxiomPair(@Nullable OWLOntology ontology, OWLAxiom axiom) {
        this.ontology = ontology;
        this.axiom = axiom;
    }

    @Nullable
    public OWLOntology getOntology() {
        return this.ontology;
    }

    public OWLAxiom getAxiom() {
        return this.axiom;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OntologyAxiomPair)) {
            return false;
        }
        OntologyAxiomPair other = (OntologyAxiomPair)obj;
        if (this.ontology != null && other.ontology != null) {
            return OWLAPIPreconditions.verifyNotNull(this.ontology).equals(other.ontology) && this.axiom.equals(other.axiom);
        }
        if (this.ontology != other.ontology) {
            return false;
        }
        return this.axiom.equals(other.axiom);
    }

    public int hashCode() {
        if (this.ontology != null) {
            return OWLAPIPreconditions.verifyNotNull(this.ontology).hashCode() + this.axiom.hashCode();
        }
        return 37 + this.axiom.hashCode();
    }

    public String toString() {
        return this.axiom + " in " + (this.ontology != null ? OWLAPIPreconditions.verifyNotNull(this.ontology).toString() : "");
    }
}

