/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipDocumentTarget
implements OWLOntologyDocumentTarget {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipDocumentTarget.class);
    private final File file;

    public ZipDocumentTarget(File file) {
        this.file = OWLAPIPreconditions.checkNotNull(file, "file cannot be null");
    }

    @Override
    public Optional<OutputStream> getOutputStream() {
        File parentFile = this.file.getAbsoluteFile().getParentFile();
        if (parentFile.exists() || parentFile.mkdirs()) {
            try {
                ZipOutputStream os = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.file)));
                os.putNextEntry(new ZipEntry("ontology.txt"));
                return OWLAPIPreconditions.optional(os);
            }
            catch (IOException e) {
                LOGGER.error("Cannot create or find file", (Throwable)e);
                return OWLAPIPreconditions.emptyOptional();
            }
        }
        LOGGER.error("Could not create directories: {}", (Object)parentFile);
        return OWLAPIPreconditions.emptyOptional();
    }
}

