/*
 * Decompiled with CFR 0.152.
 */
package net.jini.lease;

import com.sun.jini.config.Config;
import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.logging.Levels;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import com.sun.jini.thread.TaskManager;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseMap;
import net.jini.core.lease.LeaseMapException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.lease.DesiredExpirationListener;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;

public class LeaseRenewalManager {
    private static final String LRM = "net.jini.lease.LeaseRenewalManager";
    private static final Logger logger = Logger.getLogger("net.jini.lease.LeaseRenewalManager");
    private static final Method cancelMethod;
    private static final Method cancelAllMethod;
    private static final Method renewMethod;
    private static final Method renewAllMethod;
    private static final Method[] leaseToLeaseMethods;
    private static final Method[] leaseToLeaseMapMethods;
    private long renewBatchTimeWindow = 300000L;
    TaskManager taskManager = new TaskManager(11, 15000L, 1.0f);
    private static long renewalRTT;
    private final SortedMap leases = new TreeMap();
    private final List leaseInRenew = new ArrayList(1);
    private QueuerTask queuer = null;
    private List calcList;

    public LeaseRenewalManager() {
    }

    public LeaseRenewalManager(Configuration config) throws ConfigurationException {
        if (config == null) {
            throw new NullPointerException("config is null");
        }
        this.renewBatchTimeWindow = Config.getLongEntry(config, LRM, "renewBatchTimeWindow", this.renewBatchTimeWindow, 0L, Long.MAX_VALUE);
        renewalRTT = Config.getLongEntry(config, LRM, "roundTripTime", renewalRTT, 1L, Long.MAX_VALUE);
        this.taskManager = (TaskManager)Config.getNonNullEntry(config, LRM, "taskManager", TaskManager.class, this.taskManager);
    }

    public LeaseRenewalManager(Lease lease, long desiredExpiration, LeaseListener listener) {
        this.renewUntil(lease, desiredExpiration, listener);
    }

    public void renewUntil(Lease lease, long desiredExpiration, LeaseListener listener) {
        if (desiredExpiration == -1L) {
            this.renewUntil(lease, Long.MAX_VALUE, -1L, listener);
        } else {
            this.renewUntil(lease, desiredExpiration, Long.MAX_VALUE, listener);
        }
    }

    public void renewUntil(Lease lease, long desiredExpiration, long renewDuration, LeaseListener listener) {
        this.validateDuration(renewDuration, desiredExpiration == Long.MAX_VALUE, "desiredExpiration");
        this.addLease(lease, desiredExpiration, renewDuration, listener, System.currentTimeMillis());
    }

    public void renewFor(Lease lease, long desiredDuration, LeaseListener listener) {
        this.renewFor(lease, desiredDuration, Long.MAX_VALUE, listener);
    }

    public void renewFor(Lease lease, long desiredDuration, long renewDuration, LeaseListener listener) {
        this.validateDuration(renewDuration, desiredDuration == Long.MAX_VALUE, "desiredDuration");
        long now = System.currentTimeMillis();
        long desiredExpiration = desiredDuration < Long.MAX_VALUE - now ? now + desiredDuration : Long.MAX_VALUE;
        this.addLease(lease, desiredExpiration, renewDuration, listener, now);
    }

    private void validateDuration(long renewDuration, boolean isForever, String name) {
        if (!(renewDuration > 0L || renewDuration == -1L && isForever)) {
            if (renewDuration == -1L) {
                throw new IllegalArgumentException("A renewDuration of Lease.ANY can only be used with a " + name + " of " + "Lease.FOREVER");
            }
            if (isForever) {
                throw new IllegalArgumentException("When " + name + " is " + "Lease.FOREVER the only valid values for renewDuration " + "are a positive number, Lease.ANY, or Lease.FOREVER");
            }
            throw new IllegalArgumentException("When the " + name + " is not Lease.FOREVER the only valid values for " + "renewDuration are a positive number or Lease.FOREVER");
        }
    }

    private synchronized void addLease(Lease lease, long desiredExpiration, long renewDuration, LeaseListener listener, long now) {
        Entry e = this.findEntryDo(lease);
        if (e != null && !this.removeLeaseInRenew(e)) {
            this.leases.remove(e);
        }
        this.insertEntry(new Entry(lease, desiredExpiration, renewDuration, listener), now);
        this.calcActualRenews(now);
        logger.log(Level.FINE, "Added lease {0}", lease);
    }

    private void insertEntry(Entry e, long now) {
        e.calcRenew(now);
        this.leases.put(e, e);
    }

    public synchronized long getExpiration(Lease lease) throws UnknownLeaseException {
        return this.findEntry((Lease)lease).expiration;
    }

    public synchronized void setExpiration(Lease lease, long expiration) throws UnknownLeaseException {
        Entry e = this.findEntry(lease);
        e.expiration = expiration;
        if (expiration != Long.MAX_VALUE && e.renewDuration == -1L) {
            e.renewDuration = Long.MAX_VALUE;
        }
        if (this.leaseInRenew.indexOf(e) < 0) {
            this.leases.remove(e);
            long now = System.currentTimeMillis();
            this.insertEntry(e, now);
            this.calcActualRenews(now);
        }
    }

    public void cancel(Lease lease) throws UnknownLeaseException, RemoteException {
        this.remove(lease);
        lease.cancel();
    }

    public synchronized void remove(Lease lease) throws UnknownLeaseException {
        Entry e = this.findEntry(lease);
        if (!this.removeLeaseInRenew(e)) {
            this.leases.remove(e);
        }
        this.calcActualRenews();
        logger.log(Level.FINE, "Removed lease {0}", lease);
    }

    public synchronized void clear() {
        this.leases.clear();
        this.leaseInRenew.clear();
        this.calcActualRenews();
        logger.log(Level.FINE, "Removed all leases");
    }

    private void calcActualRenews() {
        this.calcActualRenews(System.currentTimeMillis());
    }

    private void calcActualRenews(long now) {
        int maxThreads = this.taskManager.getMaxThreads() - 1;
        if (this.calcList == null) {
            this.calcList = new ArrayList(maxThreads);
        }
        Iterator iter = this.leases.values().iterator();
        while (iter.hasNext()) {
            Entry e = (Entry)iter.next();
            e.actualRenew = e.renew;
            if (e.renewalsDone()) {
                if (now < e.expiration || e.desiredExpirationListener() != null) continue;
                this.logExpiration(e);
                iter.remove();
                continue;
            }
            if (e.endTime <= now && e.listener == null) {
                this.logExpiration(e);
                iter.remove();
                continue;
            }
            if (this.canBatch(e)) continue;
            Iterator listIter = this.calcList.iterator();
            while (listIter.hasNext() && e.renew < ((Entry)listIter.next()).actualRenew - renewalRTT) {
                listIter.remove();
            }
            if (this.calcList.size() == maxThreads) {
                Entry e1 = (Entry)this.calcList.remove(0);
                e.actualRenew = e1.actualRenew - renewalRTT;
            }
            this.calcList.add(e);
        }
        this.calcList.clear();
        long newWakeup = this.wakeupTime();
        if (this.queuer == null) {
            if (newWakeup < Long.MAX_VALUE) {
                this.queuer = new QueuerTask(newWakeup);
                this.taskManager.add(this.queuer);
            }
        } else if (newWakeup < this.queuer.wakeup || newWakeup == Long.MAX_VALUE && this.leaseInRenew.isEmpty()) {
            this.notifyAll();
        }
    }

    private boolean canBatch(Entry e) {
        Iterator iter = this.leases.tailMap(e).values().iterator();
        iter.next();
        while (iter.hasNext()) {
            Entry be = (Entry)iter.next();
            if (e.renew - be.renew > this.renewBatchTimeWindow) break;
            if (!e.canBatch(be)) continue;
            return true;
        }
        return false;
    }

    private Entry findEntry(Lease lease) throws UnknownLeaseException {
        Entry e = this.findEntryDo(lease);
        if (e != null && (e.renew < e.endTime || System.currentTimeMillis() < e.endTime)) {
            return e;
        }
        throw new UnknownLeaseException();
    }

    private Entry findEntryDo(Lease lease) {
        Entry e = LeaseRenewalManager.findLeaseFromIterator(this.leases.values().iterator(), lease);
        if (e == null) {
            e = LeaseRenewalManager.findLeaseFromIterator(this.leaseInRenew.iterator(), lease);
        }
        return e;
    }

    private static Entry findLeaseFromIterator(Iterator iter, Lease lease) {
        while (iter.hasNext()) {
            Entry e = (Entry)iter.next();
            if (!e.lease.equals(lease)) continue;
            return e;
        }
        return null;
    }

    private void tell(List bad) {
        Iterator iter = bad.iterator();
        while (iter.hasNext()) {
            Entry e = (Entry)iter.next();
            if (e.renewalsDone()) {
                DesiredExpirationListener del = e.desiredExpirationListener();
                if (del == null) continue;
                del.expirationReached(new LeaseRenewalEvent(this, e.lease, e.expiration, null));
                continue;
            }
            e.listener.notify(new LeaseRenewalEvent(this, e.lease, e.expiration, e.ex));
        }
    }

    private void logExpiration(Entry e) {
        if (e.renewalsDone()) {
            logger.log(Level.FINE, "Reached desired expiration for lease {0}", e.lease);
        } else {
            logger.log(Levels.FAILED, "Lease {0} expired before reaching desired expiration of " + e.expiration);
        }
    }

    private static void logThrow(Level level, String sourceMethod, String msg, Object[] params, Throwable e) {
        LogRecord r = new LogRecord(level, msg);
        r.setLoggerName(logger.getName());
        r.setSourceClassName(LeaseRenewalManager.class.getName());
        r.setSourceMethodName(sourceMethod);
        r.setParameters(params);
        r.setThrown(e);
        logger.log(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renewAll(List bList, long now) {
        Map lmeMap = null;
        Throwable t = null;
        ArrayList<Entry> bad = null;
        try {
            if (bList.size() == 1) {
                Entry e = (Entry)bList.get(0);
                logger.log(Level.FINE, "Renewing lease {0}", e.lease);
                e.lease.renew(e.getRenewDuration(now));
            } else {
                LeaseMap batchLeaseMap = LeaseRenewalManager.createBatchLeaseMap(bList, now);
                logger.log(Level.FINE, "Renewing leases {0}", batchLeaseMap);
                batchLeaseMap.renewAll();
            }
        }
        catch (LeaseMapException ex) {
            lmeMap = ex.exceptionMap;
            bad = new ArrayList(lmeMap.size());
        }
        catch (Throwable ex) {
            t = ex;
            bad = new ArrayList<Entry>(bList.size());
        }
        now = System.currentTimeMillis();
        LeaseRenewalManager leaseRenewalManager = this;
        synchronized (leaseRenewalManager) {
            Iterator iter = bList.iterator();
            while (iter.hasNext()) {
                Entry e = (Entry)iter.next();
                if (!this.removeLeaseInRenew(e)) continue;
                if (bad == null) {
                    e.ex = null;
                } else {
                    Throwable throwable = e.ex = t != null ? t : (Throwable)lmeMap.get(e.lease);
                }
                if (e.ex == null) {
                    this.insertEntry(e, now);
                    continue;
                }
                int cat = ThrowableConstants.retryable(e.ex);
                if (cat == 0) {
                    e.delayRenew();
                    this.leases.put(e, e);
                    if (!logger.isLoggable(Levels.HANDLED)) continue;
                    LeaseRenewalManager.logThrow(Levels.HANDLED, "renewAll", "Indefinite exception while renewing lease {0}", new Object[]{e.lease}, e.ex);
                    continue;
                }
                if (logger.isLoggable(Levels.FAILED)) {
                    LeaseRenewalManager.logThrow(Levels.FAILED, "renewAll", "Lease renewal failed for lease {0}", new Object[]{e.lease}, e.ex);
                }
                if (e.listener == null) continue;
                bad.add(e);
            }
            this.calcActualRenews(now);
        }
        if (bad != null) {
            this.tell(bad);
        }
    }

    private static LeaseMap createBatchLeaseMap(List bList, long now) {
        Iterator iter = bList.iterator();
        Entry e = (Entry)iter.next();
        LeaseMap batchLeaseMap = e.lease.createLeaseMap(e.getRenewDuration(now));
        if (e.lease instanceof RemoteMethodControl && batchLeaseMap instanceof RemoteMethodControl) {
            batchLeaseMap = (LeaseMap)((RemoteMethodControl)batchLeaseMap).setConstraints(ConstrainableProxyUtil.translateConstraints(((RemoteMethodControl)e.lease).getConstraints(), leaseToLeaseMapMethods));
        }
        while (iter.hasNext()) {
            e = (Entry)iter.next();
            batchLeaseMap.put((Object)e.lease, (Object)new Long(e.getRenewDuration(now)));
        }
        return batchLeaseMap;
    }

    private boolean removeLeaseInRenew(Entry e) {
        int index = this.leaseInRenew.indexOf(e);
        if (index < 0) {
            return false;
        }
        this.leaseInRenew.remove(index);
        return true;
    }

    private long wakeupTime() {
        if (this.leases.isEmpty()) {
            return Long.MAX_VALUE;
        }
        return ((Entry)this.leases.lastKey()).actualRenew;
    }

    static {
        try {
            cancelMethod = Lease.class.getMethod("cancel", new Class[0]);
            cancelAllMethod = LeaseMap.class.getMethod("cancelAll", new Class[0]);
            renewMethod = Lease.class.getMethod("renew", Long.TYPE);
            renewAllMethod = LeaseMap.class.getMethod("renewAll", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
        leaseToLeaseMethods = new Method[]{cancelMethod, cancelMethod, renewMethod, renewMethod};
        leaseToLeaseMapMethods = new Method[]{cancelMethod, cancelAllMethod, renewMethod, renewAllMethod};
        renewalRTT = 10000L;
    }

    private class QueuerTask
    implements TaskManager.Task {
        long wakeup;

        QueuerTask(long wakeup) {
            this.wakeup = wakeup;
        }

        public boolean runAfter(List tasks, int size) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LeaseRenewalManager leaseRenewalManager = LeaseRenewalManager.this;
            synchronized (leaseRenewalManager) {
                try {
                    while (true) {
                        this.wakeup = LeaseRenewalManager.this.wakeupTime();
                        if (this.wakeup != Long.MAX_VALUE || !LeaseRenewalManager.this.leaseInRenew.isEmpty()) {
                            long now = System.currentTimeMillis();
                            long delta = this.wakeup - now;
                            if (delta <= 0L) {
                                LeaseRenewalManager.this.taskManager.add(new RenewTask(now));
                                continue;
                            }
                            LeaseRenewalManager.this.wait(delta);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LeaseRenewalManager.this.queuer = null;
            }
        }
    }

    private static class Entry
    implements Comparable {
        private static long cnt = 0L;
        public final long id;
        public final Lease lease;
        public long expiration;
        public long renewDuration;
        public final LeaseListener listener;
        public long endTime;
        public long renew;
        public long actualRenew;
        public Throwable ex = null;

        public Entry(Lease lease, long expiration, long renewDuration, LeaseListener listener) {
            this.endTime = lease.getExpiration();
            this.lease = lease;
            this.expiration = expiration;
            this.renewDuration = renewDuration;
            this.listener = listener;
            this.id = cnt++;
        }

        public Entry(long renew) {
            this.renew = renew;
            this.id = Long.MAX_VALUE;
            this.lease = null;
            this.listener = null;
        }

        public long getRenewDuration(long now) {
            if (this.renewDuration == -1L) {
                return this.renewDuration;
            }
            return Math.min(this.expiration - now, this.renewDuration);
        }

        public void calcRenew(long now) {
            this.endTime = this.lease.getExpiration();
            if (this.renewalsDone()) {
                this.renew = null == this.desiredExpirationListener() ? Long.MAX_VALUE : this.expiration;
                return;
            }
            long delta = this.endTime - now;
            delta = delta <= renewalRTT * 2L ? renewalRTT : (delta <= renewalRTT * 8L ? (delta /= 2L) : (delta <= 604800000L ? (delta /= 8L) : (delta <= 1209600000L ? 86400000L : 259200000L)));
            this.renew = this.endTime - delta;
        }

        public void delayRenew() {
            long delta = this.endTime - this.renew;
            if (delta <= renewalRTT) {
                return;
            }
            delta = delta <= renewalRTT * 3L ? renewalRTT : (delta <= 3600000L ? (delta /= 3L) : (delta <= 86400000L ? 1800000L : (delta <= 604800000L ? 10800000L : 28800000L)));
            this.renew += delta;
        }

        public int compareTo(Object obj) {
            if (this == obj) {
                return 0;
            }
            Entry e = (Entry)obj;
            if (this.renew < e.renew || this.renew == e.renew && this.id < e.id) {
                return 1;
            }
            return -1;
        }

        public boolean canBatch(Entry e) {
            return !(this.renewalsDone() || e.renewalsDone() || !Entry.sameConstraints(this.lease, e.lease) || !this.lease.canBatch(e.lease) || this.renewDuration != -1L && this.renew - e.renew > renewalRTT / 2L && this.endTime - e.renew > this.renewDuration / 2L || e.renewDuration != -1L && e.renew <= this.renew - e.renewDuration && e.renew < e.expiration - e.renewDuration);
        }

        private static boolean sameConstraints(Lease l1, Lease l2) {
            if (!(l1 instanceof RemoteMethodControl)) {
                return !(l2 instanceof RemoteMethodControl);
            }
            if (!(l2 instanceof RemoteMethodControl)) {
                return false;
            }
            return ConstrainableProxyUtil.equivalentConstraints(((RemoteMethodControl)l1).getConstraints(), ((RemoteMethodControl)l2).getConstraints(), leaseToLeaseMethods);
        }

        public DesiredExpirationListener desiredExpirationListener() {
            if (this.listener == null) {
                return null;
            }
            if (this.listener instanceof DesiredExpirationListener) {
                return (DesiredExpirationListener)this.listener;
            }
            return null;
        }

        public boolean renewalsDone() {
            return this.expiration <= this.endTime;
        }
    }

    private final class RenewTask
    implements TaskManager.Task {
        private final List bList = new ArrayList(1);
        private final boolean noRenewals;

        RenewTask(long now) {
            Entry e = (Entry)LeaseRenewalManager.this.leases.lastKey();
            if (e.renewalsDone() || e.endTime <= now) {
                this.noRenewals = true;
                SortedMap lMap = LeaseRenewalManager.this.leases.tailMap(new Entry(now));
                Iterator iter = lMap.values().iterator();
                while (iter.hasNext()) {
                    Entry be = (Entry)iter.next();
                    if (!be.renewalsDone() && be.endTime > now) continue;
                    iter.remove();
                    LeaseRenewalManager.this.logExpiration(be);
                    if (be.listener == null) continue;
                    this.bList.add(be);
                }
            } else {
                this.noRenewals = false;
                SortedMap lMap = LeaseRenewalManager.this.leases.tailMap(new Entry(e.renew + LeaseRenewalManager.this.renewBatchTimeWindow));
                Iterator iter = lMap.values().iterator();
                while (iter.hasNext()) {
                    Entry be = (Entry)iter.next();
                    if (be != e && !be.canBatch(e)) continue;
                    iter.remove();
                    LeaseRenewalManager.this.leaseInRenew.add(be);
                    this.bList.add(be);
                }
            }
        }

        public void run() {
            if (this.noRenewals) {
                LeaseRenewalManager.this.tell(this.bList);
            } else {
                long now = System.currentTimeMillis();
                List bad = this.processBadLeases(now);
                if (!this.bList.isEmpty()) {
                    LeaseRenewalManager.this.renewAll(this.bList, now);
                }
                if (bad != null) {
                    LeaseRenewalManager.this.tell(bad);
                }
            }
        }

        public boolean runAfter(List tasks, int size) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List processBadLeases(long now) {
            ArrayList<Entry> bad = null;
            LeaseRenewalManager leaseRenewalManager = LeaseRenewalManager.this;
            synchronized (leaseRenewalManager) {
                Iterator iter = this.bList.iterator();
                while (iter.hasNext()) {
                    Entry e = (Entry)iter.next();
                    if (e.endTime > now) continue;
                    iter.remove();
                    LeaseRenewalManager.this.logExpiration(e);
                    LeaseRenewalManager.this.removeLeaseInRenew(e);
                    if (e.listener == null) continue;
                    if (bad == null) {
                        bad = new ArrayList<Entry>(1);
                    }
                    bad.add(e);
                }
            }
            return bad;
        }
    }
}

