/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shacl.engine.Targets;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.parser.ShapesParser;
import org.apache.jena.sys.JenaSystem;

public class Shapes
implements Iterable<Shape> {
    private final Collection<Shape> rootShapes;
    private final Map<Node, Shape> shapes;
    private final Graph shapesGraph;
    private final Targets targets;

    public static Shapes parse(Model model) {
        return Shapes.parse(model.getGraph());
    }

    public static Shapes parse(Graph graph) {
        Targets targets = ShapesParser.targets(graph);
        HashMap<Node, Shape> shapes = new HashMap<Node, Shape>();
        Collection<Shape> rootShapes = ShapesParser.parseShapes(graph, targets, shapes);
        return new Shapes(graph, shapes, rootShapes, targets);
    }

    public static Shapes parse(String fileOrURL) {
        Graph g = RDFDataMgr.loadGraph((String)fileOrURL);
        return Shapes.parse(g);
    }

    public static Shapes parseAll(Graph graph) {
        Shapes shapes = Shapes.parse(graph);
        Collection<Shape> declShapes = ShapesParser.declaredShapes(graph, shapes.shapes);
        declShapes.forEach(shape -> {
            if (!shapes.getRootShapes().contains(shape)) {
                shapes.rootShapes.add((Shape)shape);
            }
        });
        return shapes;
    }

    public static Shapes parseAll(String fileOrURL) {
        Graph g = RDFDataMgr.loadGraph((String)fileOrURL);
        return Shapes.parseAll(g);
    }

    private Shapes(Graph shapesGraph, Map<Node, Shape> shapes, Collection<Shape> rootShapes, Targets targets) {
        this.rootShapes = rootShapes;
        this.shapes = shapes;
        this.shapesGraph = shapesGraph;
        this.targets = targets;
    }

    public boolean isEmpty() {
        return this.shapes.isEmpty();
    }

    public Collection<Shape> getRootShapes() {
        return this.rootShapes;
    }

    public Shape getShape(Node node) {
        return this.shapes.get(node);
    }

    public Map<Node, Shape> getShapeMap() {
        return this.shapes;
    }

    public Graph getGraph() {
        return this.shapesGraph;
    }

    public Targets getTargets() {
        return this.targets;
    }

    public int numShapes() {
        return this.shapes.values().size();
    }

    public int numRootShapes() {
        return this.rootShapes.size();
    }

    @Override
    public Iterator<Shape> iterator() {
        return this.rootShapes.iterator();
    }

    static {
        JenaSystem.init();
    }
}

