/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx;

import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.btree.proc.ISimpleIndexProcedure;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.service.AbstractClient;
import com.bigdata.service.Split;
import com.bigdata.service.ndx.AbstractDataServiceProcedureTask;
import com.bigdata.service.ndx.IScaleOutClientIndex;
import com.bigdata.service.ndx.IndexSyncRPCCounters;

class SimpleDataServiceProcedureTask
extends AbstractDataServiceProcedureTask {
    protected final byte[] key;
    private int ntries = 1;

    @Override
    protected int getElementCount() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleDataServiceProcedureTask(IScaleOutClientIndex ndx, byte[] key, long ts, Split split, ISimpleIndexProcedure proc, IResultHandler resultHandler) {
        super(ndx, ts, split, proc, resultHandler);
        if (key == null) {
            throw new IllegalArgumentException("name=" + ndx.getName() + ", proc=" + proc);
        }
        this.key = key;
        IndexSyncRPCCounters indexSyncRPCCounters = this.taskCountersByIndex;
        synchronized (indexSyncRPCCounters) {
            ++this.taskCountersByIndex.pointRequestCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void retry() throws Exception {
        IndexSyncRPCCounters indexSyncRPCCounters = this.taskCountersByIndex;
        synchronized (indexSyncRPCCounters) {
            ++this.taskCountersByIndex.redirectCount;
        }
        if (this.ntries++ > ((AbstractClient)this.ndx.getFederation().getClient()).getMaxStaleLocatorRetries()) {
            throw new RuntimeException("Retry count exceeded: ntries=" + this.ntries);
        }
        PartitionLocator locator = this.ndx.getFederation().getMetadataIndex(this.ndx.getName(), this.ts).find(this.key);
        if (log.isInfoEnabled()) {
            log.info((Object)("Retrying: proc=" + this.proc.getClass().getName() + ", locator=" + locator + ", ntries=" + this.ntries));
        }
        this.submit(locator);
    }
}

