/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.geospatial;

import com.bigdata.rdf.internal.gis.ICoordinate;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public interface GeoSpatial {
    public static final String NAMESPACE = "http://www.bigdata.com/rdf/geospatial#";
    public static final URI DATATYPE = new URIImpl("http://www.bigdata.com/rdf/geospatial#geoSpatialLiteral");
    public static final URI SEARCH = new URIImpl("http://www.bigdata.com/rdf/geospatial#search");
    public static final URI PREDICATE = new URIImpl("http://www.bigdata.com/rdf/geospatial#predicate");
    public static final URI CONTEXT = new URIImpl("http://www.bigdata.com/rdf/geospatial#context");
    public static final URI SPATIAL_CIRCLE_CENTER = new URIImpl("http://www.bigdata.com/rdf/geospatial#spatialCircleCenter");
    public static final URI SPATIAL_CIRCLE_RADIUS = new URIImpl("http://www.bigdata.com/rdf/geospatial#spatialCircleRadius");
    public static final URI SPATIAL_RECTANGLE_SOUTH_WEST = new URIImpl("http://www.bigdata.com/rdf/geospatial#spatialRectangleSouthWest");
    public static final URI SPATIAL_RECTANGLE_NORTH_EAST = new URIImpl("http://www.bigdata.com/rdf/geospatial#spatialRectangleNorthEast");
    public static final URI SPATIAL_UNIT = new URIImpl("http://www.bigdata.com/rdf/geospatial#spatialUnit");
    public static final URI TIME_START = new URIImpl("http://www.bigdata.com/rdf/geospatial#timeStart");
    public static final URI TIME_END = new URIImpl("http://www.bigdata.com/rdf/geospatial#timeEnd");
    public static final URI LOCATION_VALUE = new URIImpl("http://www.bigdata.com/rdf/geospatial#locationValue");
    public static final URI TIME_VALUE = new URIImpl("http://www.bigdata.com/rdf/geospatial#timeValue");
    public static final URI LOCATION_AND_TIME_VALUE = new URIImpl("http://www.bigdata.com/rdf/geospatial#locationAndTimeValue");

    public static interface Options {
        public static final String GEO_FUNCTION = GeoSpatial.class.getName() + ".defaultGeoFunction";
        public static final GeoFunction DEFAULT_GEO_FUNCTION = GeoFunction.IN_CIRCLE;
        public static final String GEO_SPATIAL_UNIT = GeoSpatial.class.getName() + ".defaultSpatialUnit";
        public static final ICoordinate.UNITS DEFAULT_GEO_SPATIAL_UNIT = ICoordinate.UNITS.Kilometers;
    }

    public static enum GeoFunction {
        IN_CIRCLE("inCircle"),
        IN_RECTANGLE("inRectangle");

        private String name;

        private GeoFunction(String name) {
            this.name = name;
        }

        public static GeoFunction forName(String name) {
            for (GeoFunction e : GeoFunction.values()) {
                if (!e.toString().equalsIgnoreCase(name)) continue;
                return e;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }
    }
}

