/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.DirectBufferPoolAllocator;
import com.bigdata.service.ResourceService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.UUID;

public abstract class ManagedResourceService
extends ResourceService {
    private final DirectBufferPoolAllocator allocator = new DirectBufferPoolAllocator(DirectBufferPool.INSTANCE);

    public DirectBufferPoolAllocator getAllocator() {
        return this.allocator;
    }

    public ManagedResourceService(InetSocketAddress addr, int requestServicePoolSize) throws IOException {
        super(addr, requestServicePoolSize);
    }

    @Override
    public synchronized void shutdown() {
        super.shutdown();
        this.allocator.close();
    }

    @Override
    public synchronized void shutdownNow() {
        super.shutdownNow();
        this.allocator.close();
    }

    @Override
    protected ByteBuffer getBuffer(UUID uuid) throws Exception {
        DirectBufferPoolAllocator.IAllocation allocation = this.allocator.getAllocation(uuid);
        if (allocation == null) {
            return null;
        }
        return allocation.getSlice();
    }
}

