/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule.eval.pipeline;

import com.bigdata.bop.IBindingSet;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.relation.accesspath.IElementFilter;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.relation.rule.eval.pipeline.JoinTask;
import com.bigdata.relation.rule.eval.pipeline.UnsynchronizedOutputBuffer;

class UnsynchronizedSolutionBuffer<E extends IBindingSet>
extends UnsynchronizedOutputBuffer<E> {
    private final IJoinNexus joinNexus;
    private final IElementFilter<ISolution> solutionFilter;

    public UnsynchronizedSolutionBuffer(JoinTask joinTask, IJoinNexus joinNexus, int capacity) {
        super(joinTask, capacity);
        this.joinNexus = joinNexus;
        this.solutionFilter = joinNexus.getSolutionFilter();
    }

    @Override
    protected void handleChunk(E[] chunk) {
        IBuffer<ISolution[]> solutionBuffer = this.joinTask.getSolutionBuffer();
        IRule<?> rule = this.joinTask.rule;
        ISolution[] a = new ISolution[chunk.length];
        int naccepted = 0;
        for (int i = 0; i < chunk.length; ++i) {
            E bindingSet = chunk[i];
            ISolution solution = this.joinNexus.newSolution(rule, (IBindingSet)bindingSet);
            if (this.solutionFilter != null && !this.solutionFilter.isValid(solution)) continue;
            a[naccepted++] = solution;
        }
        if (naccepted == 0) {
            return;
        }
        if (naccepted < chunk.length) {
            ISolution[] b = new ISolution[naccepted];
            System.arraycopy(a, 0, b, 0, naccepted);
            a = b;
        }
        solutionBuffer.add(a);
        ++this.joinTask.stats.bindingSetChunksOut;
        this.joinTask.stats.bindingSetsOut += (long)naccepted;
    }
}

