/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.accesspath;

import com.bigdata.relation.accesspath.IAsynchronousIterator;
import com.bigdata.striterator.IChunkedIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;

public class WrappedAsynchronousIterator<E, F>
implements IAsynchronousIterator<E> {
    private volatile transient boolean open = true;
    private final IChunkedIterator<F> src;

    public WrappedAsynchronousIterator(IChunkedIterator<F> src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.src = src;
    }

    public boolean hasNext() {
        if (this.open && this.src.hasNext()) {
            return true;
        }
        this.close();
        return false;
    }

    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (E)this.src.nextChunk();
    }

    public void remove() {
        this.src.remove();
    }

    @Override
    public void close() {
        if (this.open) {
            this.open = false;
            this.src.close();
        }
    }

    @Override
    public boolean isExhausted() {
        return !this.hasNext();
    }

    @Override
    public boolean hasNext(long timeout, TimeUnit unit) {
        return this.hasNext();
    }

    @Override
    public E next(long timeout, TimeUnit unit) {
        return this.next();
    }
}

