/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.load;

import com.bigdata.btree.IndexMetadata;
import com.bigdata.journal.IIndexManager;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.util.BytesUtil;
import java.util.UUID;

public class AssignedSplits {
    final byte[][] separatorKeys;
    final UUID[] dataServiceUUIDs;

    public void registerIndex(IIndexManager indexManager, IndexMetadata indexMetadata) {
        if (indexManager == null) {
            throw new IllegalArgumentException();
        }
        if (indexMetadata == null) {
            throw new IllegalArgumentException();
        }
        if (indexManager instanceof IBigdataFederation) {
            ((IBigdataFederation)indexManager).registerIndex(indexMetadata, this.separatorKeys, this.dataServiceUUIDs);
        } else {
            indexManager.registerIndex(indexMetadata);
        }
    }

    public AssignedSplits(byte[][] separatorKeys, UUID[] dataServiceUUIDs) {
        if (separatorKeys == null) {
            throw new IllegalArgumentException();
        }
        if (dataServiceUUIDs != null && separatorKeys.length != dataServiceUUIDs.length) {
            throw new IllegalArgumentException();
        }
        if (separatorKeys.length == 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < separatorKeys.length; ++i) {
            if (separatorKeys[i] == null) {
                throw new IllegalArgumentException();
            }
            if (dataServiceUUIDs != null && dataServiceUUIDs[i] == null) {
                throw new IllegalArgumentException();
            }
            if (i == 0 && separatorKeys[i].length != 0) {
                throw new IllegalArgumentException();
            }
            if (i <= 0 || BytesUtil.compareBytes((byte[])separatorKeys[i - 1], (byte[])separatorKeys[i]) < 0) continue;
            throw new IllegalArgumentException();
        }
        this.separatorKeys = separatorKeys;
        this.dataServiceUUIDs = dataServiceUUIDs;
    }
}

