/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.uri;

import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IInlineUnicode;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUnicode;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.AbstractInlineIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import org.openrdf.model.URI;

public class FullyInlineURIIV<V extends BigdataURI>
extends AbstractInlineIV<V, URI>
implements IInlineUnicode,
URI {
    private static final long serialVersionUID = 1L;
    private final URI uri;
    private transient int byteLength = 0;

    @Override
    public IV<V, URI> clone(boolean clearCache) {
        FullyInlineURIIV tmp = new FullyInlineURIIV(this.uri);
        tmp.byteLength = this.byteLength;
        if (!clearCache) {
            tmp.setValue(this.getValueCache());
        }
        return tmp;
    }

    public FullyInlineURIIV(URI uri) {
        this(uri, 0);
    }

    public FullyInlineURIIV(URI uri, int byteLength) {
        super(VTE.URI, DTE.XSDString);
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        this.uri = uri;
        this.byteLength = byteLength;
    }

    @Override
    public final URI getInlineValue() {
        return this.uri;
    }

    public final String toString() {
        return this.uri.stringValue();
    }

    @Override
    public V asValue(LexiconRelation lex) {
        BigdataURI v = (BigdataURI)this.getValueCache();
        if (v == null) {
            BigdataValueFactory f = lex.getValueFactory();
            v = f.createURI(this.uri.stringValue());
            v.setIV(this);
            this.setValue(v);
        }
        return (V)v;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FullyInlineURIIV) {
            return this.uri.stringValue().equals(((FullyInlineURIIV)o).stringValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.uri.stringValue().hashCode();
    }

    @Override
    public int byteLength() {
        if (this.byteLength == 0) {
            this.byteLength = 1 + IVUnicode.byteLengthUnicode(this.uri.stringValue());
        }
        return this.byteLength;
    }

    @Override
    public final void setByteLength(int byteLength) {
        if (byteLength < 0) {
            throw new IllegalArgumentException();
        }
        if (this.byteLength != 0 && this.byteLength != byteLength) {
            throw new IllegalStateException();
        }
        this.byteLength = byteLength;
    }

    @Override
    public int _compareTo(IV o) {
        FullyInlineURIIV t = (FullyInlineURIIV)o;
        return IVUnicode.IVUnicodeComparator.INSTANCE.compare(this.uri.stringValue(), t.uri.stringValue());
    }

    @Override
    public boolean needsMaterialization() {
        return false;
    }

    public String stringValue() {
        return this.uri.stringValue();
    }

    public String getLocalName() {
        return this.uri.getLocalName();
    }

    public String getNamespace() {
        return this.uri.getNamespace();
    }
}

