/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpBase;
import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.ContextBindingSet;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.ILexiconConfiguration;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.NotMaterializedException;
import com.bigdata.rdf.internal.constraints.ContextNotAvailableException;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.sparql.ast.DummyConstantNode;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.util.Map;
import org.openrdf.model.Literal;
import org.openrdf.model.Value;

public abstract class IVValueExpression<T extends IV>
extends BOpBase
implements IValueExpression<T> {
    private static final long serialVersionUID = -7068219781217676085L;
    private volatile transient BigdataValueFactory vf;
    private volatile transient ILexiconConfiguration<BigdataValue> lc;

    protected static Map<String, Object> anns(GlobalAnnotations globals, NV ... anns) {
        int size = 2 + (anns != null ? anns.length : 0);
        NV[] nv = new NV[size];
        nv[0] = new NV(Annotations.NAMESPACE, globals.lex);
        nv[1] = new NV(Annotations.TIMESTAMP, globals.timestamp);
        if (anns != null) {
            for (int i = 0; i < anns.length; ++i) {
                nv[i + 2] = anns[i];
            }
        }
        return NV.asMap(nv);
    }

    public IVValueExpression(GlobalAnnotations globals, NV ... anns) {
        this(BOpBase.NOARGS, IVValueExpression.anns(globals, anns));
    }

    public IVValueExpression(IValueExpression<? extends IV> x, GlobalAnnotations globals, NV ... anns) {
        this(new BOp[]{x}, IVValueExpression.anns(globals, anns));
    }

    public IVValueExpression(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (this.areGlobalsRequired()) {
            if (this.getProperty(Annotations.NAMESPACE) == null) {
                throw new IllegalArgumentException("must set the lexicon namespace");
            }
            if (this.getProperty(Annotations.TIMESTAMP) == null) {
                throw new IllegalArgumentException("must set the query timestamp");
            }
        }
    }

    public IVValueExpression(IVValueExpression<T> op) {
        super(op);
        if (this.areGlobalsRequired()) {
            if (this.getProperty(Annotations.NAMESPACE) == null) {
                throw new IllegalArgumentException("must set the lexicon namespace");
            }
            if (this.getProperty(Annotations.TIMESTAMP) == null) {
                throw new IllegalArgumentException("must set the query timestamp");
            }
        }
    }

    public IValueExpression<? extends IV> get(int i) {
        try {
            return (IValueExpression)super.get(i);
        }
        catch (ClassCastException ex) {
            throw new SparqlTypeErrorException();
        }
    }

    protected boolean areGlobalsRequired() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BigdataValueFactory getValueFactory() {
        if (this.vf == null) {
            IVValueExpression iVValueExpression = this;
            synchronized (iVValueExpression) {
                if (this.vf == null) {
                    String namespace = this.getNamespace();
                    this.vf = BigdataValueFactoryImpl.getInstance(namespace);
                }
            }
        }
        return this.vf;
    }

    protected String getNamespace() {
        return (String)this.getRequiredProperty(Annotations.NAMESPACE);
    }

    protected long getTimestamp() {
        return (Long)this.getRequiredProperty(Annotations.TIMESTAMP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ILexiconConfiguration<BigdataValue> getLexiconConfiguration(IBindingSet bset) {
        if (this.lc == null) {
            IVValueExpression iVValueExpression = this;
            synchronized (iVValueExpression) {
                if (this.lc == null) {
                    if (!(bset instanceof ContextBindingSet)) {
                        throw new ContextNotAvailableException(this.toString());
                    }
                    BOpContextBase context = ((ContextBindingSet)bset).getBOpContext();
                    String namespace = this.getNamespace();
                    long timestamp = this.getTimestamp();
                    LexiconRelation lex = (LexiconRelation)context.getResource(namespace, timestamp);
                    this.lc = lex.getLexiconConfiguration();
                    if (this.vf != null) {
                        this.vf = this.lc.getValueFactory();
                    }
                }
            }
        }
        return this.lc;
    }

    public static final Literal asLiteral(IV iv) {
        if (iv == null) {
            throw new SparqlTypeErrorException();
        }
        if (!iv.isLiteral()) {
            throw new SparqlTypeErrorException();
        }
        if (iv.isInline() && !iv.needsMaterialization()) {
            return (Literal)iv;
        }
        if (iv.hasValue()) {
            return (BigdataLiteral)iv.getValue();
        }
        throw new NotMaterializedException();
    }

    public static final Value asValue(IV iv) {
        if (iv == null) {
            throw new SparqlTypeErrorException();
        }
        if (iv.isInline() && !iv.needsMaterialization()) {
            return iv;
        }
        if (iv.hasValue()) {
            return iv.getValue();
        }
        throw new NotMaterializedException();
    }

    protected final String literalLabel(IV iv) throws NotMaterializedException {
        return IVValueExpression.asLiteral(iv).getLabel();
    }

    protected IV getAndCheckLiteral(int i, IBindingSet bs) throws SparqlTypeErrorException, NotMaterializedException {
        IV iv = this.getAndCheckBound(i, bs);
        if (!iv.isLiteral()) {
            throw new SparqlTypeErrorException();
        }
        if (iv.needsMaterialization() && !iv.hasValue()) {
            throw new NotMaterializedException();
        }
        return iv;
    }

    protected IV getAndCheckBound(int i, IBindingSet bs) throws SparqlTypeErrorException, NotMaterializedException {
        IV iv = (IV)this.get(i).get(bs);
        if (iv == null) {
            throw new SparqlTypeErrorException.UnboundVarException();
        }
        return iv;
    }

    protected Literal getAndCheckLiteralValue(int i, IBindingSet bs) {
        return IVValueExpression.asLiteral(this.getAndCheckLiteral(i, bs));
    }

    protected final IV asIV(Value value, IBindingSet bs) {
        if (value instanceof IV) {
            return (IV)value;
        }
        BigdataValue v = this.getValueFactory().asValue(value);
        return this.asIV(v, bs);
    }

    protected IV asIV(BigdataValue value, IBindingSet bs) {
        IV iv = value.getIV();
        if (iv != null) {
            iv.setValue(value);
            return iv;
        }
        ILexiconConfiguration<BigdataValue> lc = null;
        try {
            lc = this.getLexiconConfiguration(bs);
        }
        catch (ContextNotAvailableException ex) {
            // empty catch block
        }
        if (lc != null && (iv = lc.createInlineIV(value)) != null) {
            if (iv.needsMaterialization()) {
                iv.setValue(value);
            }
            return iv;
        }
        return DummyConstantNode.toDummyIV(value);
    }

    public static interface Annotations
    extends BOp.Annotations {
        public static final String NAMESPACE = IVValueExpression.class.getName() + ".namespace";
        public static final String TIMESTAMP = IVValueExpression.class.getName() + ".timestamp";
    }
}

