/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.mdi;

import com.bigdata.resources.ResourceManager;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class IndexPartitionCause
implements Externalizable {
    private static final long serialVersionUID = 4643434468430418713L;
    private CauseEnum cause;
    private long synchronousOverflowCounter;
    private long lastCommitTime;
    private static final transient byte VERSION0 = 0;
    private static final transient byte VERSION = 0;

    public CauseEnum getCause() {
        return this.cause;
    }

    public long getSynchronousOverflowCounter() {
        return this.synchronousOverflowCounter;
    }

    public long getLastCommitTime() {
        return this.lastCommitTime;
    }

    public static IndexPartitionCause register(ResourceManager resourceManager) {
        return new IndexPartitionCause(CauseEnum.Register, resourceManager.getSynchronousOverflowCount(), resourceManager.getLiveJournal().getLastCommitTime());
    }

    public static IndexPartitionCause split(ResourceManager resourceManager) {
        return new IndexPartitionCause(CauseEnum.Split, resourceManager.getSynchronousOverflowCount(), resourceManager.getLiveJournal().getLastCommitTime());
    }

    public static IndexPartitionCause join(ResourceManager resourceManager) {
        return new IndexPartitionCause(CauseEnum.Join, resourceManager.getSynchronousOverflowCount(), resourceManager.getLiveJournal().getLastCommitTime());
    }

    public static IndexPartitionCause move(ResourceManager resourceManager) {
        return new IndexPartitionCause(CauseEnum.Move, resourceManager.getSynchronousOverflowCount(), resourceManager.getLiveJournal().getLastCommitTime());
    }

    public IndexPartitionCause() {
    }

    public IndexPartitionCause(CauseEnum cause, long synchronousOverflowCounter, long lastCommitTime) {
        if (cause == null) {
            throw new IllegalArgumentException();
        }
        if (synchronousOverflowCounter < 0L) {
            throw new IllegalArgumentException();
        }
        this.cause = cause;
        this.synchronousOverflowCounter = synchronousOverflowCounter;
        this.lastCommitTime = lastCommitTime;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        if (version != 0) {
            throw new UnsupportedOperationException("version=" + version);
        }
        this.cause = CauseEnum.valueOf(in.readByte());
        this.synchronousOverflowCounter = in.readLong();
        this.lastCommitTime = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeByte(this.cause.code);
        out.writeLong(this.synchronousOverflowCounter);
        out.writeLong(this.lastCommitTime);
    }

    public String toString() {
        return this.getClass().getName() + "{" + (Object)((Object)this.cause) + ",overflowCounter=" + this.synchronousOverflowCounter + ",timestamp=" + this.lastCommitTime + "}";
    }

    public static enum CauseEnum {
        Register(0),
        Split(1),
        Join(2),
        Move(3);

        private final byte code;

        private CauseEnum(byte code) {
            this.code = code;
        }

        static CauseEnum valueOf(byte code) {
            switch (code) {
                case 0: {
                    return Register;
                }
                case 1: {
                    return Split;
                }
                case 2: {
                    return Join;
                }
                case 3: {
                    return Move;
                }
            }
            throw new IllegalArgumentException("code=" + code);
        }
    }
}

