/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.IndexSegment;
import com.bigdata.btree.IndexSegmentStore;
import com.bigdata.mdi.LocalPartitionMetadata;

public class ViewStatistics {
    public final int sourceCount;
    public final int sourceJournalCount;
    public final int sourceSegmentCount;
    public final long sumSegBytes;

    public ViewStatistics(ILocalBTreeView view) {
        LocalPartitionMetadata pmd = view.getIndexMetadata().getPartitionMetadata();
        if (pmd == null) {
            boolean isSeg = view.getMutableBTree().getStore() instanceof IndexSegmentStore;
            this.sourceCount = 1;
            this.sourceJournalCount = isSeg ? 0 : 1;
            this.sourceSegmentCount = isSeg ? 1 : 0;
            this.sumSegBytes = isSeg ? view.getMutableBTree().getStore().size() : 0L;
        } else {
            AbstractBTree[] sources = view.getSources();
            int sourceCount = 0;
            int sourceJournalCount = 0;
            int sourceSegmentCount = 0;
            long sumSegBytes = 0L;
            for (AbstractBTree btree : sources) {
                if (btree instanceof IndexSegment) {
                    ++sourceSegmentCount;
                    sumSegBytes += sources[sourceCount].getStore().size();
                } else {
                    ++sourceJournalCount;
                }
                ++sourceCount;
            }
            this.sourceCount = sourceCount;
            this.sourceJournalCount = sourceJournalCount;
            this.sourceSegmentCount = sourceSegmentCount;
            this.sumSegBytes = sumSegBytes;
        }
    }
}

