/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.engine;

import com.bigdata.bop.engine.IStartOpMessage;
import com.bigdata.io.LongPacker;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;

public class StartOpMessage
implements Externalizable,
IStartOpMessage {
    private static final long serialVersionUID = 1L;
    private UUID queryId;
    private UUID serviceId;
    private int bopId;
    private int partitionId;
    private int messageReadyCount;

    public StartOpMessage() {
    }

    public StartOpMessage(UUID queryId, int opId, int partitionId, UUID serviceId, int nmessages) {
        if (queryId == null) {
            throw new IllegalArgumentException();
        }
        if (nmessages <= 0) {
            throw new IllegalArgumentException();
        }
        this.queryId = queryId;
        this.bopId = opId;
        this.partitionId = partitionId;
        this.serviceId = serviceId;
        this.messageReadyCount = nmessages;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("{queryId=" + this.queryId);
        sb.append(",bopId=" + this.bopId);
        sb.append(",partitionId=" + this.partitionId);
        sb.append(",serviceId=" + this.serviceId);
        sb.append(",nchunks=" + this.messageReadyCount);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public UUID getQueryId() {
        return this.queryId;
    }

    @Override
    public int getBOpId() {
        return this.bopId;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public UUID getServiceId() {
        return this.serviceId;
    }

    @Override
    public int getChunkMessageCount() {
        return this.messageReadyCount;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.queryId.getMostSignificantBits());
        out.writeLong(this.queryId.getLeastSignificantBits());
        out.writeLong(this.serviceId.getMostSignificantBits());
        out.writeLong(this.serviceId.getLeastSignificantBits());
        out.writeInt(this.bopId);
        out.writeInt(this.partitionId);
        LongPacker.packLong(out, (long)this.messageReadyCount);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.queryId = new UUID(in.readLong(), in.readLong());
        this.serviceId = new UUID(in.readLong(), in.readLong());
        this.bopId = in.readInt();
        this.partitionId = in.readInt();
        this.messageReadyCount = LongPacker.unpackInt(in);
    }
}

