/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.results;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.jena.jdbc.results.QueryExecutionResults;
import org.apache.jena.jdbc.statements.JenaStatement;
import org.apache.jena.query.QueryExecution;

public abstract class StreamedResults<T>
extends QueryExecutionResults {
    private T currItem;
    private boolean finished = false;
    private int currRow = 0;

    public StreamedResults(JenaStatement statement, QueryExecution qe, boolean commit) throws SQLException {
        super(statement, qe, commit);
    }

    protected T getCurrentRow() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result set is closed");
        }
        return this.currItem;
    }

    protected abstract boolean hasNext() throws SQLException;

    protected abstract T moveNext() throws SQLException;

    @Override
    public final boolean absolute(int row) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot move to a row after the result set has been closed");
        }
        if (row == 1) {
            return this.first();
        }
        if (row == -1) {
            return this.last();
        }
        if (row <= 0) {
            throw new SQLException("Jena JDBC result sets are forward only, cannot move to a row which is relative to the end of the result set since the number of result rows is not known in advance");
        }
        if (row == this.currRow) {
            return true;
        }
        if (row < this.currRow) {
            throw new SQLException("Jena JDBC result sets are forward only, cannot move backwards");
        }
        while (this.hasNext() && this.currRow < row) {
            this.currItem = this.moveNext();
            ++this.currRow;
        }
        if (this.currRow < row) {
            this.finished = true;
            this.currItem = null;
        }
        return row == this.currRow;
    }

    @Override
    public final void afterLast() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        if (this.finished) {
            return;
        }
        while (this.hasNext()) {
            this.currItem = this.moveNext();
            ++this.currRow;
        }
        this.currItem = null;
        this.finished = true;
    }

    @Override
    public final void beforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        if (this.currRow > 0) {
            throw new SQLException("Jena JDBC result sets are forward only, can't move to before the start of the result set after navigation through the result set has begun");
        }
        this.currItem = null;
    }

    @Override
    protected final void closeInternal() throws SQLException {
        this.currItem = null;
        this.finished = true;
        this.closeStreamInternal();
    }

    protected abstract void closeStreamInternal() throws SQLException;

    @Override
    public final boolean first() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        if (this.currRow == 1) {
            return true;
        }
        throw new SQLException("Jena JDBC result sets are forward only, can't move backwards to the first row after the first row has been passed");
    }

    @Override
    public final int getFetchDirection() {
        return 1000;
    }

    @Override
    public final int getFetchSize() {
        return 0;
    }

    @Override
    public final int getRow() {
        return this.currRow;
    }

    @Override
    public final int getType() {
        return 1003;
    }

    @Override
    public final boolean isAfterLast() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        return this.finished;
    }

    @Override
    public final boolean isBeforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        return this.currRow == 0;
    }

    @Override
    public final boolean isFirst() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        return this.currRow == 1;
    }

    @Override
    public final boolean isLast() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        return !this.hasNext();
    }

    @Override
    public final boolean last() throws SQLException {
        if (this.isClosed() || this.finished) {
            throw new SQLException("Jena JDBC Result Sets are forward-only");
        }
        while (this.hasNext()) {
            this.currItem = this.moveNext();
            ++this.currRow;
        }
        return true;
    }

    @Override
    public final boolean next() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot move to the next row in a closed result set");
        }
        if (this.hasNext()) {
            this.currItem = this.moveNext();
            ++this.currRow;
            return true;
        }
        if (!this.finished) {
            ++this.currRow;
        }
        this.finished = true;
        return false;
    }

    @Override
    public final boolean relative(int rows) throws SQLException {
        int moved;
        if (this.isClosed()) {
            throw new SQLException("Cannot move to a row after the result set has been closed");
        }
        if (rows == 0) {
            return true;
        }
        if (rows < 0) {
            throw new SQLException("Jena JDBC result sets are forward only, cannot move backwards");
        }
        for (moved = 0; this.hasNext() && moved < rows; ++moved) {
            this.currItem = this.moveNext();
            ++this.currRow;
        }
        if (moved < rows) {
            this.finished = true;
            this.currItem = null;
        }
        return rows == moved;
    }

    @Override
    public final void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets only support forward fetch");
        }
    }

    @Override
    public final void setFetchSize(int rows) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

