/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.jena.datatypes.BaseDatatype;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.graph.impl.LiteralLabelFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathParser;
import org.apache.jena.sparql.util.NodeFactoryExtra;

public class Converters {
    private Converters() {
    }

    public static Node checkVar(Node n) {
        if (n.isVariable()) {
            return Var.alloc((Node)n);
        }
        return n;
    }

    public static Node makeLiteral(Object o) {
        RDFDatatype dt = TypeMapper.getInstance().getTypeByValue(o);
        if (dt == null) {
            String msg = "No TypeDef defined for %s. Use TypeMapper.getInstance().register() to register one or use makeLiteral() method in query builder instance.";
            throw new IllegalArgumentException(String.format(msg, o.getClass()));
        }
        return NodeFactory.createLiteral((LiteralLabel)LiteralLabelFactory.createTypedLiteral((Object)o));
    }

    public static Node makeLiteral(String value, String typeUri) {
        Object oValue = value;
        Object dt = TypeMapper.getInstance().getTypeByName(typeUri);
        if (dt == null) {
            dt = new BaseDatatype(typeUri){

                public boolean isValidValue(Object valueForm) {
                    return false;
                }

                public Object parse(String lexicalForm) throws DatatypeFormatException {
                    RDFDatatype dt = TypeMapper.getInstance().getTypeByName(this.uri);
                    if (dt == null) {
                        throw new DatatypeFormatException("no registered Datatype for " + this.uri);
                    }
                    return dt.parse(lexicalForm);
                }
            };
        } else {
            oValue = dt.parse(value);
        }
        LiteralLabel ll = LiteralLabelFactory.createByValue((Object)oValue, null, (RDFDatatype)dt);
        return NodeFactory.createLiteral((LiteralLabel)ll);
    }

    public static Node makeNode(Object o, PrefixMapping pMapping) {
        if (o == null) {
            return Node.ANY;
        }
        if (o instanceof FrontsNode) {
            return Converters.checkVar(((FrontsNode)o).asNode());
        }
        if (o instanceof Node) {
            return Converters.checkVar((Node)o);
        }
        if (o instanceof String) {
            try {
                return Converters.checkVar(NodeFactoryExtra.parseNode((String)((String)o), (PrefixMap)PrefixMapFactory.createForInput((PrefixMapping)pMapping)));
            }
            catch (RiotException riotException) {
                // empty catch block
            }
        }
        return Converters.makeLiteral(o);
    }

    public static Object makeNodeOrPath(Object o, PrefixMapping pMapping) {
        if (o == null) {
            return Node.ANY;
        }
        if (o instanceof Path) {
            return o;
        }
        if (o instanceof FrontsNode) {
            return Converters.checkVar(((FrontsNode)o).asNode());
        }
        if (o instanceof Node) {
            return Converters.checkVar((Node)o);
        }
        if (o instanceof String) {
            try {
                Path p = PathParser.parse((String)((String)o), (PrefixMapping)pMapping);
                if (p instanceof P_Link) {
                    return ((P_Link)p).getNode();
                }
                return p;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Converters.makeNode(o, pMapping);
    }

    public static Var makeVar(Object o) throws ARQInternalErrorException {
        if (o == null) {
            return Var.ANON;
        }
        if (o instanceof Var) {
            return (Var)o;
        }
        Var retval = null;
        retval = o instanceof FrontsNode ? Var.alloc((Node)((FrontsNode)o).asNode()) : (o instanceof Node ? Var.alloc((Node)((Node)o)) : (o instanceof ExprVar ? Var.alloc((ExprVar)((ExprVar)o)) : Var.alloc((String)Var.canonical((String)o.toString()))));
        if ("*".equals(Var.canonical((String)retval.toString()))) {
            return null;
        }
        return retval;
    }

    public static String quoted(String q) {
        int qt = q.indexOf(34);
        int sqt = q.indexOf("'");
        if (qt == -1) {
            qt = Integer.MAX_VALUE;
        }
        if (sqt == -1) {
            sqt = Integer.MAX_VALUE;
        }
        if (qt <= sqt) {
            return String.format("'%s'", q);
        }
        return String.format("\"%s\"", q);
    }

    public static Collection<Node> makeValueNodes(Iterator<?> iter, PrefixMapping prefixMapping) {
        if (iter == null || !iter.hasNext()) {
            return null;
        }
        ArrayList<Node> values = new ArrayList<Node>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o == null) {
                values.add(null);
                continue;
            }
            values.add(Converters.makeNode(o, prefixMapping));
        }
        return values;
    }
}

