/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ganglia;

import com.bigdata.ganglia.IGangliaMetricMessage;
import com.bigdata.ganglia.IHostReport;
import java.io.Serializable;
import java.util.Comparator;

public class HostReportComparator
implements Comparator<IHostReport>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String metricName;
    private final boolean asc;

    public HostReportComparator(String metricName, boolean asc) {
        if (metricName == null) {
            throw new IllegalArgumentException();
        }
        this.metricName = metricName;
        this.asc = asc;
    }

    @Override
    public int compare(IHostReport o1, IHostReport o2) {
        int ret = this.comp(o1, o2);
        if (this.asc) {
            return ret;
        }
        return -ret;
    }

    private int comp(IHostReport o1, IHostReport o2) {
        double d2;
        IGangliaMetricMessage m1 = o1.getMetrics().get(this.metricName);
        IGangliaMetricMessage m2 = o2.getMetrics().get(this.metricName);
        if (m1 == null && m2 == null) {
            return 0;
        }
        if (m1 == null) {
            return -1;
        }
        if (m2 == null) {
            return -1;
        }
        double d1 = Double.parseDouble(m1.getStringValue());
        if (d1 < (d2 = Double.parseDouble(m2.getStringValue()))) {
            return -1;
        }
        if (d2 > d1) {
            return 1;
        }
        return o1.getHostName().compareTo(o2.getHostName());
    }
}

