/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.projection;

import java.util.Map;
import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.datum.Ellipsoid;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.projection.Mercator1SP;
import org.cts.op.projection.Projection;
import org.cts.units.Measure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObliqueMercator
extends Projection {
    public static final Identifier OMERC = new Identifier("EPSG", "9815", "Oblique Mercator", "OMERC");
    protected final double latc;
    protected final double lonc = this.getCentralMeridian();
    protected final double alphac;
    protected final double gammac;
    protected final double kc;
    protected final double FE;
    protected final double FN;
    protected final double B;
    protected final double A;
    protected final double H;
    protected final double gamma0;
    protected final double lambda0;
    protected final double uc;
    protected final double[] invcoeff;

    public ObliqueMercator(Ellipsoid ellipsoid, Map<String, Measure> parameters) {
        super(OMERC, ellipsoid, parameters);
        this.latc = this.getLatitudeOfOrigin();
        this.alphac = this.getAzimuth();
        this.gammac = this.getRectifiedGridAngle();
        this.FE = this.getFalseEasting();
        this.FN = this.getFalseNorthing();
        this.kc = this.getScaleFactor();
        double e = ellipsoid.getEccentricity();
        double e2 = ellipsoid.getSquareEccentricity();
        double esin = e * Math.sin(this.latc);
        this.B = Math.sqrt(1.0 + e2 * Math.pow(Math.cos(this.latc), 4.0) / (1.0 - e2));
        this.A = ellipsoid.getSemiMajorAxis() * this.B * this.kc * Math.sqrt(1.0 - e2) / (1.0 - esin * esin);
        double t0 = Math.tan((1.5707963267948966 - this.latc) / 2.0) / Math.pow((1.0 - esin) / (1.0 + esin), e / 2.0);
        double D = this.B * Math.sqrt((1.0 - e2) / (1.0 - esin * esin)) / Math.cos(this.latc);
        double F = D < 1.0 ? D : D + Math.sqrt(D * D - 1.0) * Math.signum(this.latc);
        this.H = F * Math.pow(t0, this.B);
        double G = (F - 1.0 / F) / 2.0;
        this.gamma0 = Math.asin(Math.sin(this.alphac) / D);
        this.lambda0 = this.lonc - Math.asin(G * Math.tan(this.gamma0)) / this.B;
        this.uc = D > 1.0 ? this.A / this.B * Math.atan(Math.sqrt(D * D - 1.0) / Math.cos(this.alphac)) * Math.signum(this.latc) : 0.0;
        this.invcoeff = Mercator1SP.getInverseMercatorCoeff(ellipsoid);
    }

    @Override
    public Projection.Surface getSurface() {
        return Projection.Surface.CYLINDRICAL;
    }

    @Override
    public Projection.Property getProperty() {
        return Projection.Property.CONFORMAL;
    }

    @Override
    public Projection.Orientation getOrientation() {
        return Projection.Orientation.TANGENT;
    }

    @Override
    public double[] transform(double[] coord) throws CoordinateDimensionException {
        double e = this.ellipsoid.getEccentricity();
        double esin = e * Math.sin(coord[0]);
        double t = Math.tan((1.5707963267948966 - coord[0]) / 2.0) / Math.pow((1.0 - esin) / (1.0 + esin), e / 2.0);
        double Q = this.H / Math.pow(t, this.B);
        double S = (Q - 1.0 / Q) / 2.0;
        double T = (Q + 1.0 / Q) / 2.0;
        double V = Math.sin(this.B * (coord[1] - this.lambda0));
        double U = (S * Math.sin(this.gamma0) - V * Math.cos(this.gamma0)) / T;
        double v = this.A * Math.log((1.0 - U) / (1.0 + U)) / 2.0 / this.B;
        double u = this.A * Math.atan((S * Math.cos(this.gamma0) + V * Math.sin(this.gamma0)) / Math.cos(this.B * (coord[1] - this.lambda0))) / this.B - Math.abs(this.uc) * Math.signum(this.latc);
        coord[0] = this.FE + v * Math.cos(this.gammac) + u * Math.sin(this.gammac);
        coord[1] = this.FN + u * Math.cos(this.gammac) - v * Math.sin(this.gammac);
        return coord;
    }

    @Override
    public Projection inverse() throws NonInvertibleOperationException {
        return new ObliqueMercator(this.ellipsoid, this.parameters){

            public double[] transform(double[] coord) throws CoordinateDimensionException {
                double ki;
                double v = (coord[0] - this.FE) * Math.cos(this.gammac) - (coord[1] - this.FN) * Math.sin(this.gammac);
                double u = (coord[1] - this.FN) * Math.cos(this.gammac) + (coord[0] - this.FE) * Math.sin(this.gammac) + Math.abs(this.uc) * Math.signum(this.latc);
                double Q = Math.exp(-this.B * v / this.A);
                double S = (Q - 1.0 / Q) / 2.0;
                double T = (Q + 1.0 / Q) / 2.0;
                double V = Math.sin(this.B * u / this.A);
                double U = (V * Math.cos(this.gamma0) + S * Math.sin(this.gamma0)) / T;
                double t = Math.pow(this.H / Math.sqrt((1.0 + U) / (1.0 - U)), 1.0 / this.B);
                double lat = ki = 2.0 * (0.7853981633974483 - Math.atan(t));
                for (int i = 1; i < 5; ++i) {
                    lat += this.invcoeff[i] * Math.sin((double)(2 * i) * ki);
                }
                coord[0] = lat;
                coord[1] = this.lambda0 - Math.atan((S * Math.cos(this.gamma0) - V * Math.sin(this.gamma0)) / Math.cos(this.B * u / this.A)) / this.B;
                return coord;
            }

            public Projection inverse() throws NonInvertibleOperationException {
                return ObliqueMercator.this;
            }

            public boolean isDirect() {
                return false;
            }

            public String toString() {
                return ObliqueMercator.this.toString() + " inverse";
            }
        };
    }
}

