/*
 * Decompiled with CFR 0.152.
 */
package org.cts.crs;

import org.cts.IdentifiableComponent;
import org.cts.Identifier;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.cs.Axis;
import org.cts.cs.CoordinateSystem;
import org.cts.datum.VerticalDatum;
import org.cts.op.projection.Projection;
import org.cts.units.Unit;

public class VerticalCRS
extends IdentifiableComponent
implements CoordinateReferenceSystem {
    public static final CoordinateSystem HEIGHT_CS = new CoordinateSystem(new Axis[]{Axis.HEIGHT}, new Unit[]{Unit.METER});
    public static CoordinateSystem ALTITUDE_CS = new CoordinateSystem(new Axis[]{Axis.ALTITUDE}, new Unit[]{Unit.METER});
    private final VerticalDatum verticalDatum;
    private final CoordinateSystem coordinateSystem;

    public VerticalCRS(Identifier identifier, VerticalDatum datum, CoordinateSystem cs) {
        super(identifier);
        this.verticalDatum = datum;
        this.coordinateSystem = cs;
    }

    public VerticalCRS(Identifier identifier, VerticalDatum datum) {
        super(identifier);
        this.verticalDatum = datum;
        this.coordinateSystem = HEIGHT_CS;
    }

    public Projection getProjection() {
        return null;
    }

    public CoordinateReferenceSystem.Type getType() {
        return CoordinateReferenceSystem.Type.VERTICAL;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public VerticalDatum getDatum() {
        return this.verticalDatum;
    }

    public boolean isValid(double[] coord) {
        return this.verticalDatum.getExtent().isInside(coord);
    }

    public String toWKT() {
        StringBuilder w = new StringBuilder();
        w.append("VERT_CS[\"");
        w.append(this.getName());
        w.append("\",");
        w.append(this.getDatum().toWKT());
        w.append(',');
        w.append(this.getCoordinateSystem().getUnit(0).toWKT());
        for (int i = 0; i < this.getCoordinateSystem().getDimension(); ++i) {
            w.append(',');
            w.append(this.getCoordinateSystem().getAxis(i).toWKT());
        }
        if (!this.getAuthorityName().startsWith("LOCAL")) {
            w.append(',');
            w.append(this.getIdentifier().toWKT());
        }
        w.append(']');
        return w.toString();
    }

    public String toString() {
        return "[" + this.getAuthorityName() + ":" + this.getAuthorityKey() + "] " + this.getName() + " (" + this.getShortName() + ")";
    }
}

