"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AzIdToNameMappingFunctionCodeCache = exports.AzIdToNameMapping = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class AzIdToNameMapping extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const handlerPolicy = new aws_cdk_lib_1.aws_iam.ManagedPolicy(this, 'handlerPolicy', {
            statements: [
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    sid: 'AllowSSMParameterEdit',
                    actions: [
                        'ssm:PutParameter',
                        'ssm:DeleteParameter',
                        'ssm:AddTagsToResource',
                    ],
                    resources: [
                        '*',
                    ],
                    conditions: {
                        StringEquals: {
                            'aws:ResourceTag/CdkAzMappingParameter': 'True',
                        },
                    },
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    sid: 'AllowDescribeAZs',
                    actions: [
                        'ec2:DescribeAvailabilityZones',
                    ],
                    resources: [
                        '*',
                    ],
                }),
            ],
        });
        const role = new aws_cdk_lib_1.aws_iam.Role(this, 'handlerRole', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('lambda.amazonaws.com'),
            managedPolicies: [
                handlerPolicy,
            ],
        });
        const onEventHandler = new aws_cdk_lib_1.aws_lambda.Function(this, 'handler', {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_8,
            code: props.lambdaCode ?? aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, '../lambda')),
            handler: 'index.handler',
            description: 'Stores VPC mappings into parameter store',
            timeout: aws_cdk_lib_1.Duration.seconds(5),
            logRetention: props.logRetention ?? aws_cdk_lib_1.aws_logs.RetentionDays.ONE_MONTH,
            role,
        });
        const mapping = new aws_cdk_lib_1.CustomResource(this, 'mapping', {
            serviceToken: onEventHandler.functionArn,
            properties: {
                azIds: props.azIds || ['use1-az2', 'use1-az4', 'use1-az6'],
                prefix: props.ssmParameterPrefix || '/az-mapping/',
            },
        });
        this.mapping = mapping.getAtt('azIds').toString();
    }
}
exports.AzIdToNameMapping = AzIdToNameMapping;
_a = JSII_RTTI_SYMBOL_1;
AzIdToNameMapping[_a] = { fqn: "@renovosolutions/cdk-library-multi-account-az-mapping.AzIdToNameMapping", version: "0.0.43" };
class AzIdToNameMappingFunctionCodeCache extends aws_cdk_lib_1.aws_s3.Bucket {
    constructor(scope, id, props) {
        const removalPolicy = props.removalPolicy ?? aws_cdk_lib_1.RemovalPolicy.DESTROY;
        const autoDeleteObjects = removalPolicy === aws_cdk_lib_1.RemovalPolicy.DESTROY;
        super(scope, id, {
            removalPolicy,
            autoDeleteObjects,
            ...props,
        });
        /** Force the final unzipped asset to be a zip by nesting zips */
        const bundlingCmds = [
            'mkdir -p /asset-output',
            'mkdir -p temp',
            'pip install -r /asset-input/requirements.txt -t /asset-input/temp',
            'cp index.py /asset-input/temp/index.py',
            'cd temp',
            'zip -r lambda.zip .',
            'zip -r /asset-output/temp.zip lambda.zip',
            'cd ..',
            'rm -rf ./temp',
        ];
        new aws_cdk_lib_1.aws_s3_deployment.BucketDeployment(this, 'Deployment', {
            sources: [aws_cdk_lib_1.aws_s3_deployment.Source.asset(path.join(__dirname, '../lambda'), {
                    bundling: {
                        image: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9.bundlingImage,
                        command: [
                            'bash', '-c', bundlingCmds.join(' && '),
                        ],
                    },
                })],
            destinationBucket: this,
            exclude: ['__pycache__/*', '*.pyc'],
            include: ['*.py'],
        });
        this.lambdaCode = aws_cdk_lib_1.aws_lambda.Code.fromBucket(this, 'index.py');
    }
    /**
     * Add access to the whole organization to get
     * the lambda function code from the bucket.
     *
     * @param principalOrgId The organization ID to require for any accounts accessing the bucket.
     */
    addOrgWideAccessPolicy(principalOrgId) {
        return this.addToResourcePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            principals: [new aws_cdk_lib_1.aws_iam.StarPrincipal],
            actions: [
                's3:GetObject',
            ],
            resources: [this.arnForObjects('*')],
            conditions: {
                StringEquals: {
                    'aws:PrincipalOrgID': principalOrgId,
                },
            },
        }));
    }
    ;
    /**
     * Add access to the specified accounts to get
     * the lambda function code from the bucket.
     *
     * @param principalAccountId The account ID to add access for.
     * @param principalOrgId (Optional) The organization ID to require for the account accessing the bucket.
     */
    addAccountAccessPolicy(principalAccountId, principalOrgId) {
        return this.addToResourcePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            principals: [new aws_cdk_lib_1.aws_iam.AccountPrincipal(principalAccountId)],
            actions: ['s3:GetObject'],
            resources: [this.arnForObjects('*')],
            conditions: principalOrgId === undefined ? undefined : {
                StringEquals: {
                    'aws:PrincipalOrgID': principalOrgId,
                },
            },
        }));
    }
    ;
    /**
     * Add access to the specified organizational units to get
     * the lambda function code from the bucket.
     *
     * @param principalOrgPaths The organizational unit paths to add access for.
     */
    addOrgOuAccessPolicy(principalOrgPaths) {
        return this.addToResourcePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            principals: [new aws_cdk_lib_1.aws_iam.StarPrincipal],
            actions: ['s3:GetObject'],
            resources: [this.arnForObjects('*')],
            conditions: {
                StringLike: {
                    'aws:PrincipalOrgPaths': principalOrgPaths,
                },
            },
        }));
    }
}
exports.AzIdToNameMappingFunctionCodeCache = AzIdToNameMappingFunctionCodeCache;
_b = JSII_RTTI_SYMBOL_1;
AzIdToNameMappingFunctionCodeCache[_b] = { fqn: "@renovosolutions/cdk-library-multi-account-az-mapping.AzIdToNameMappingFunctionCodeCache", version: "0.0.43" };
;
//# sourceMappingURL=data:application/json;base64,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