"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoDBSeeder = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const directories_1 = require("./directories");
class DynamoDBSeeder extends core_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        const seeds = props.seeds.bind(this);
        const seedsBucket = ((_b = seeds.s3Location) === null || _b === void 0 ? void 0 : _b.bucketName) ? aws_s3_1.Bucket.fromBucketName(this, 'SeedsBucket', seeds.s3Location.bucketName) : undefined;
        const serviceToken = core_1.CustomResourceProvider.getOrCreate(this, 'Custom::DynamodbSeeder', {
            codeDirectory: directories_1.dynamodbSeederDir,
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_12,
            timeout: (_c = props.timeout) !== null && _c !== void 0 ? _c : core_1.Duration.minutes(15),
            policyStatements: [
                {
                    Effect: aws_iam_1.Effect.ALLOW,
                    Action: ['dynamodb:BatchWriteItem'],
                    Resource: props.table.tableArn,
                },
                seedsBucket
                    ? {
                        Effect: aws_iam_1.Effect.ALLOW,
                        Action: ['s3:GetObject'],
                        Resource: `${seedsBucket.bucketArn}/${(_e = (_d = seeds.s3Location) === null || _d === void 0 ? void 0 : _d.objectKey) !== null && _e !== void 0 ? _e : '*'}`,
                    }
                    : undefined,
            ],
        });
        new core_1.CustomResource(this, 'CustomResource', {
            serviceToken,
            resourceType: 'Custom::DynamodbSeeder',
            properties: {
                TableName: props.table.tableName,
                Seeds: {
                    InlineSeeds: seeds.inlineSeeds,
                    S3Bucket: seeds.s3Location && seeds.s3Location.bucketName,
                    S3Key: seeds.s3Location && seeds.s3Location.objectKey,
                    S3ObjectVersion: seeds.s3Location && seeds.s3Location.objectVersion,
                },
            },
        });
    }
}
exports.DynamoDBSeeder = DynamoDBSeeder;
_a = JSII_RTTI_SYMBOL_1;
DynamoDBSeeder[_a] = { fqn: "@cloudcomponents/cdk-dynamodb-seeder.DynamoDBSeeder", version: "1.24.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZHluYW1vZGItc2VlZGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2R5bmFtb2RiLXNlZWRlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUNBLDhDQUEwQztBQUMxQyw0Q0FBeUM7QUFDekMsd0NBQTJIO0FBRTNILCtDQUFrRDtBQWlCbEQsTUFBYSxjQUFlLFNBQVEsZ0JBQVM7SUFDM0MsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUEwQjs7UUFDbEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLEtBQUssR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUVyQyxNQUFNLFdBQVcsR0FBRyxPQUFBLEtBQUssQ0FBQyxVQUFVLDBDQUFFLFVBQVUsRUFBQyxDQUFDLENBQUMsZUFBTSxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUsYUFBYSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztRQUV2SSxNQUFNLFlBQVksR0FBRyw2QkFBc0IsQ0FBQyxXQUFXLENBQUMsSUFBSSxFQUFFLHdCQUF3QixFQUFFO1lBQ3RGLGFBQWEsRUFBRSwrQkFBaUI7WUFDaEMsT0FBTyxFQUFFLG9DQUE2QixDQUFDLFNBQVM7WUFDaEQsT0FBTyxRQUFFLEtBQUssQ0FBQyxPQUFPLG1DQUFJLGVBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDO1lBQzlDLGdCQUFnQixFQUFFO2dCQUNoQjtvQkFDRSxNQUFNLEVBQUUsZ0JBQU0sQ0FBQyxLQUFLO29CQUNwQixNQUFNLEVBQUUsQ0FBQyx5QkFBeUIsQ0FBQztvQkFDbkMsUUFBUSxFQUFFLEtBQUssQ0FBQyxLQUFLLENBQUMsUUFBUTtpQkFDL0I7Z0JBQ0QsV0FBVztvQkFDVCxDQUFDLENBQUM7d0JBQ0UsTUFBTSxFQUFFLGdCQUFNLENBQUMsS0FBSzt3QkFDcEIsTUFBTSxFQUFFLENBQUMsY0FBYyxDQUFDO3dCQUN4QixRQUFRLEVBQUUsR0FBRyxXQUFXLENBQUMsU0FBUyxJQUFJLFlBQUEsS0FBSyxDQUFDLFVBQVUsMENBQUUsU0FBUyxtQ0FBSSxHQUFHLEVBQUU7cUJBQzNFO29CQUNILENBQUMsQ0FBQyxTQUFTO2FBQ2Q7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLHFCQUFjLENBQUMsSUFBSSxFQUFFLGdCQUFnQixFQUFFO1lBQ3pDLFlBQVk7WUFDWixZQUFZLEVBQUUsd0JBQXdCO1lBQ3RDLFVBQVUsRUFBRTtnQkFDVixTQUFTLEVBQUUsS0FBSyxDQUFDLEtBQUssQ0FBQyxTQUFTO2dCQUNoQyxLQUFLLEVBQUU7b0JBQ0wsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO29CQUM5QixRQUFRLEVBQUUsS0FBSyxDQUFDLFVBQVUsSUFBSSxLQUFLLENBQUMsVUFBVSxDQUFDLFVBQVU7b0JBQ3pELEtBQUssRUFBRSxLQUFLLENBQUMsVUFBVSxJQUFJLEtBQUssQ0FBQyxVQUFVLENBQUMsU0FBUztvQkFDckQsZUFBZSxFQUFFLEtBQUssQ0FBQyxVQUFVLElBQUksS0FBSyxDQUFDLFVBQVUsQ0FBQyxhQUFhO2lCQUNwRTthQUNGO1NBQ0YsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUF6Q0gsd0NBMENDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSVRhYmxlIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWR5bmFtb2RiJztcbmltcG9ydCB7IEVmZmVjdCB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuaW1wb3J0IHsgQnVja2V0IH0gZnJvbSAnQGF3cy1jZGsvYXdzLXMzJztcbmltcG9ydCB7IENvbnN0cnVjdCwgQ3VzdG9tUmVzb3VyY2UsIEN1c3RvbVJlc291cmNlUHJvdmlkZXIsIEN1c3RvbVJlc291cmNlUHJvdmlkZXJSdW50aW1lLCBEdXJhdGlvbiB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG5pbXBvcnQgeyBkeW5hbW9kYlNlZWRlckRpciB9IGZyb20gJy4vZGlyZWN0b3JpZXMnO1xuaW1wb3J0IHsgU2VlZHMgfSBmcm9tICcuL3NlZWRzJztcblxuZXhwb3J0IGludGVyZmFjZSBEeW5hbW9EQlNlZWRlclByb3BzIHtcbiAgcmVhZG9ubHkgdGFibGU6IElUYWJsZTtcbiAgcmVhZG9ubHkgc2VlZHM6IFNlZWRzO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHRpbWVvdXQ/OiBEdXJhdGlvbjtcbn1cblxuZXhwb3J0IGNsYXNzIER5bmFtb0RCU2VlZGVyIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IER5bmFtb0RCU2VlZGVyUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3Qgc2VlZHMgPSBwcm9wcy5zZWVkcy5iaW5kKHRoaXMpO1xuXG4gICAgY29uc3Qgc2VlZHNCdWNrZXQgPSBzZWVkcy5zM0xvY2F0aW9uPy5idWNrZXROYW1lID8gQnVja2V0LmZyb21CdWNrZXROYW1lKHRoaXMsICdTZWVkc0J1Y2tldCcsIHNlZWRzLnMzTG9jYXRpb24uYnVja2V0TmFtZSkgOiB1bmRlZmluZWQ7XG5cbiAgICBjb25zdCBzZXJ2aWNlVG9rZW4gPSBDdXN0b21SZXNvdXJjZVByb3ZpZGVyLmdldE9yQ3JlYXRlKHRoaXMsICdDdXN0b206OkR5bmFtb2RiU2VlZGVyJywge1xuICAgICAgY29kZURpcmVjdG9yeTogZHluYW1vZGJTZWVkZXJEaXIsXG4gICAgICBydW50aW1lOiBDdXN0b21SZXNvdXJjZVByb3ZpZGVyUnVudGltZS5OT0RFSlNfMTIsXG4gICAgICB0aW1lb3V0OiBwcm9wcy50aW1lb3V0ID8/IER1cmF0aW9uLm1pbnV0ZXMoMTUpLFxuICAgICAgcG9saWN5U3RhdGVtZW50czogW1xuICAgICAgICB7XG4gICAgICAgICAgRWZmZWN0OiBFZmZlY3QuQUxMT1csXG4gICAgICAgICAgQWN0aW9uOiBbJ2R5bmFtb2RiOkJhdGNoV3JpdGVJdGVtJ10sXG4gICAgICAgICAgUmVzb3VyY2U6IHByb3BzLnRhYmxlLnRhYmxlQXJuLFxuICAgICAgICB9LFxuICAgICAgICBzZWVkc0J1Y2tldFxuICAgICAgICAgID8ge1xuICAgICAgICAgICAgICBFZmZlY3Q6IEVmZmVjdC5BTExPVyxcbiAgICAgICAgICAgICAgQWN0aW9uOiBbJ3MzOkdldE9iamVjdCddLFxuICAgICAgICAgICAgICBSZXNvdXJjZTogYCR7c2VlZHNCdWNrZXQuYnVja2V0QXJufS8ke3NlZWRzLnMzTG9jYXRpb24/Lm9iamVjdEtleSA/PyAnKid9YCxcbiAgICAgICAgICAgIH1cbiAgICAgICAgICA6IHVuZGVmaW5lZCxcbiAgICAgIF0sXG4gICAgfSk7XG5cbiAgICBuZXcgQ3VzdG9tUmVzb3VyY2UodGhpcywgJ0N1c3RvbVJlc291cmNlJywge1xuICAgICAgc2VydmljZVRva2VuLFxuICAgICAgcmVzb3VyY2VUeXBlOiAnQ3VzdG9tOjpEeW5hbW9kYlNlZWRlcicsXG4gICAgICBwcm9wZXJ0aWVzOiB7XG4gICAgICAgIFRhYmxlTmFtZTogcHJvcHMudGFibGUudGFibGVOYW1lLFxuICAgICAgICBTZWVkczoge1xuICAgICAgICAgIElubGluZVNlZWRzOiBzZWVkcy5pbmxpbmVTZWVkcyxcbiAgICAgICAgICBTM0J1Y2tldDogc2VlZHMuczNMb2NhdGlvbiAmJiBzZWVkcy5zM0xvY2F0aW9uLmJ1Y2tldE5hbWUsXG4gICAgICAgICAgUzNLZXk6IHNlZWRzLnMzTG9jYXRpb24gJiYgc2VlZHMuczNMb2NhdGlvbi5vYmplY3RLZXksXG4gICAgICAgICAgUzNPYmplY3RWZXJzaW9uOiBzZWVkcy5zM0xvY2F0aW9uICYmIHNlZWRzLnMzTG9jYXRpb24ub2JqZWN0VmVyc2lvbixcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==