"""add_idx_to_time_cols.

Revision ID: 010
Revises: 009
Create Date: 2025-03-18 05:49:31.113627

"""

from typing import Sequence, Union

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "010"
down_revision: Union[str, None] = "009"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index(op.f("ix_datasets_uploaded_at"), "datasets", ["uploaded_at"], unique=False)
    op.create_index(
        op.f("ix_document_collections_created_at"),
        "document_collections",
        ["created_at"],
        unique=False,
    )
    op.create_index(
        op.f("ix_document_collections_updated_at"),
        "document_collections",
        ["updated_at"],
        unique=False,
    )
    op.create_index(
        op.f("ix_document_processing_progress_created_at"),
        "document_processing_progress",
        ["created_at"],
        unique=False,
    )
    op.create_index(
        op.f("ix_document_processing_progress_updated_at"),
        "document_processing_progress",
        ["updated_at"],
        unique=False,
    )
    op.create_index(op.f("ix_eval_runs_end_time"), "eval_runs", ["end_time"], unique=False)
    op.create_index(op.f("ix_eval_runs_start_time"), "eval_runs", ["start_time"], unique=False)
    op.create_index(op.f("ix_messages_created_at"), "messages", ["created_at"], unique=False)
    op.create_index(op.f("ix_messages_updated_at"), "messages", ["updated_at"], unique=False)
    op.create_index(
        op.f("ix_output_files_created_at"), "output_files", ["created_at"], unique=False
    )
    op.create_index(
        op.f("ix_output_files_updated_at"), "output_files", ["updated_at"], unique=False
    )
    op.create_index(op.f("ix_runs_start_time"), "runs", ["start_time"], unique=False)
    op.create_index(op.f("ix_sessions_created_at"), "sessions", ["created_at"], unique=False)
    op.create_index(op.f("ix_sessions_updated_at"), "sessions", ["updated_at"], unique=False)
    op.create_index(op.f("ix_users_created_at"), "users", ["created_at"], unique=False)
    op.create_index(op.f("ix_users_updated_at"), "users", ["updated_at"], unique=False)
    op.create_index(
        op.f("ix_vector_indices_created_at"), "vector_indices", ["created_at"], unique=False
    )
    op.create_index(
        op.f("ix_vector_indices_updated_at"), "vector_indices", ["updated_at"], unique=False
    )
    op.create_index(
        op.f("ix_workflow_versions_created_at"), "workflow_versions", ["created_at"], unique=False
    )
    op.create_index(
        op.f("ix_workflow_versions_updated_at"), "workflow_versions", ["updated_at"], unique=False
    )
    op.create_index(op.f("ix_workflows_created_at"), "workflows", ["created_at"], unique=False)
    op.create_index(op.f("ix_workflows_updated_at"), "workflows", ["updated_at"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_workflows_updated_at"), table_name="workflows")
    op.drop_index(op.f("ix_workflows_created_at"), table_name="workflows")
    op.drop_index(op.f("ix_workflow_versions_updated_at"), table_name="workflow_versions")
    op.drop_index(op.f("ix_workflow_versions_created_at"), table_name="workflow_versions")
    op.drop_index(op.f("ix_vector_indices_updated_at"), table_name="vector_indices")
    op.drop_index(op.f("ix_vector_indices_created_at"), table_name="vector_indices")
    op.drop_index(op.f("ix_users_updated_at"), table_name="users")
    op.drop_index(op.f("ix_users_created_at"), table_name="users")
    op.drop_index(op.f("ix_sessions_updated_at"), table_name="sessions")
    op.drop_index(op.f("ix_sessions_created_at"), table_name="sessions")
    op.drop_index(op.f("ix_runs_start_time"), table_name="runs")
    op.drop_index(op.f("ix_output_files_updated_at"), table_name="output_files")
    op.drop_index(op.f("ix_output_files_created_at"), table_name="output_files")
    op.drop_index(op.f("ix_messages_updated_at"), table_name="messages")
    op.drop_index(op.f("ix_messages_created_at"), table_name="messages")
    op.drop_index(op.f("ix_eval_runs_start_time"), table_name="eval_runs")
    op.drop_index(op.f("ix_eval_runs_end_time"), table_name="eval_runs")
    op.drop_index(
        op.f("ix_document_processing_progress_updated_at"),
        table_name="document_processing_progress",
    )
    op.drop_index(
        op.f("ix_document_processing_progress_created_at"),
        table_name="document_processing_progress",
    )
    op.drop_index(op.f("ix_document_collections_updated_at"), table_name="document_collections")
    op.drop_index(op.f("ix_document_collections_created_at"), table_name="document_collections")
    op.drop_index(op.f("ix_datasets_uploaded_at"), table_name="datasets")
    # ### end Alembic commands ###
