"""add_external_id_to_session.

Revision ID: 009
Revises: 008
Create Date: 2025-03-12 04:32:15.946036

"""

from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "009"
down_revision: Union[str, None] = "008"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("sessions", sa.Column("external_id", sa.String(), nullable=True))
    op.create_unique_constraint("sessions_external_id_key", "sessions", ["external_id"])
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint("sessions_external_id_key", "sessions", type_="unique")
    op.drop_column("sessions", "external_id")
    # ### end Alembic commands ###
