"""split_knowledge_base_into_dc_and_vi

Revision ID: 003
Revises: 002
Create Date: 2025-01-13 19:42:54.414404

"""

from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = "003"
down_revision: Union[str, None] = "002"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "document_collections",
        sa.Column("_intid", sa.Integer(), nullable=False),
        sa.Column(
            "id",
            sa.String(),
            sa.Computed(
                "'DC' || _intid",
            ),
            nullable=False,
        ),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("status", sa.String(), nullable=False),
        sa.Column("document_count", sa.Integer(), nullable=False),
        sa.Column("chunk_count", sa.Integer(), nullable=False),
        sa.Column("error_message", sa.String(), nullable=True),
        sa.Column("text_processing_config", sa.JSON(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("updated_at", sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint("_intid"),
        sa.UniqueConstraint("id"),
        sa.UniqueConstraint("name"),
    )
    op.create_table(
        "vector_indices",
        sa.Column("_intid", sa.Integer(), nullable=False),
        sa.Column(
            "id",
            sa.String(),
            sa.Computed(
                "'VI' || _intid",
            ),
            nullable=False,
        ),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("status", sa.String(), nullable=False),
        sa.Column("document_count", sa.Integer(), nullable=False),
        sa.Column("chunk_count", sa.Integer(), nullable=False),
        sa.Column("error_message", sa.String(), nullable=True),
        sa.Column("embedding_config", sa.JSON(), nullable=False),
        sa.Column("collection_id", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("updated_at", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ["collection_id"],
            ["document_collections.id"],
        ),
        sa.PrimaryKeyConstraint("_intid"),
        sa.UniqueConstraint("id"),
        sa.UniqueConstraint("name"),
    )
    op.drop_table("knowledge_bases")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "knowledge_bases",
        sa.Column("_intid", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column(
            "id",
            sa.VARCHAR(),
            sa.Computed("('KB'::text || _intid)", persisted=True),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column("name", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("description", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column("status", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("document_count", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("chunk_count", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("error_message", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column(
            "text_processing_config",
            postgresql.JSON(astext_type=sa.Text()),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "embedding_config",
            postgresql.JSON(astext_type=sa.Text()),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "created_at",
            postgresql.TIMESTAMP(),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            postgresql.TIMESTAMP(),
            autoincrement=False,
            nullable=False,
        ),
        sa.PrimaryKeyConstraint("_intid", name="knowledge_bases_pkey"),
        sa.UniqueConstraint("id", name="knowledge_bases_id_key"),
        sa.UniqueConstraint("name", name="knowledge_bases_name_key"),
    )
    op.drop_table("vector_indices")
    op.drop_table("document_collections")
    # ### end Alembic commands ###
