from .defs import VERSION
from . import Reader

CODES_PRODUCT_ANY = None
CODES_PRODUCT_GRIB = None

KeyValueNotFoundError = KeyError


def codes_get_api_version():
    return VERSION


def codes_new_from_file(file, product_kind=None):
    offset = file.tell()
    handle, size = Reader(None, fileno=file.fileno(), offset=offset).next_handle_size()
    if handle is not None:
        handle.compat = True
        file.seek(offset + size)
    return handle


def codes_release(handle):
    pass


def codes_get_array(handle, item, key_type):

    result = handle.get(item)

    try:
        len(result)
        return result
    except TypeError:
        if result is None:
            raise KeyValueNotFoundError(item)
        return [result]
