/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.cost;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.AggBinaryOp;
import org.apache.sysds.hops.AggUnaryOp;
import org.apache.sysds.hops.BinaryOp;
import org.apache.sysds.hops.DnnOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.IndexingOp;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.NaryOp;
import org.apache.sysds.hops.ParameterizedBuiltinOp;
import org.apache.sysds.hops.ReorgOp;
import org.apache.sysds.hops.TernaryOp;
import org.apache.sysds.hops.UnaryOp;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;

public class ComputeCost {
    private static final Log LOG = LogFactory.getLog((String)ComputeCost.class.getName());

    public static double getHOPComputeCost(Hop currentHop) {
        double costs = 1.0;
        if (currentHop instanceof UnaryOp) {
            switch (((UnaryOp)currentHop).getOp()) {
                case ABS: 
                case ROUND: 
                case CEIL: 
                case FLOOR: 
                case SIGN: {
                    costs = 1.0;
                    break;
                }
                case SPROP: 
                case SQRT: {
                    costs = 2.0;
                    break;
                }
                case EXP: {
                    costs = 18.0;
                    break;
                }
                case SIGMOID: {
                    costs = 21.0;
                    break;
                }
                case LOG: 
                case LOG_NZ: {
                    costs = 32.0;
                    break;
                }
                case NCOL: 
                case NROW: 
                case PRINT: 
                case ASSERT: 
                case CAST_AS_BOOLEAN: 
                case CAST_AS_DOUBLE: 
                case CAST_AS_INT: 
                case CAST_AS_MATRIX: 
                case CAST_AS_SCALAR: {
                    costs = 1.0;
                    break;
                }
                case SIN: {
                    costs = 18.0;
                    break;
                }
                case COS: {
                    costs = 22.0;
                    break;
                }
                case TAN: {
                    costs = 42.0;
                    break;
                }
                case ASIN: {
                    costs = 93.0;
                    break;
                }
                case ACOS: {
                    costs = 103.0;
                    break;
                }
                case ATAN: {
                    costs = 40.0;
                    break;
                }
                case SINH: {
                    costs = 93.0;
                    break;
                }
                case COSH: {
                    costs = 103.0;
                    break;
                }
                case TANH: {
                    costs = 40.0;
                    break;
                }
                case CUMSUM: 
                case CUMMIN: 
                case CUMMAX: 
                case CUMPROD: {
                    costs = 1.0;
                    break;
                }
                case CUMSUMPROD: {
                    costs = 2.0;
                    break;
                }
                default: {
                    LOG.warn((Object)("Cost model not implemented yet for: " + (Object)((Object)((UnaryOp)currentHop).getOp())));
                    break;
                }
            }
        } else if (currentHop instanceof BinaryOp) {
            block19 : switch (((BinaryOp)currentHop).getOp()) {
                case MULT: 
                case PLUS: 
                case MINUS: 
                case MIN: 
                case MAX: 
                case AND: 
                case OR: 
                case EQUAL: 
                case NOTEQUAL: 
                case LESS: 
                case LESSEQUAL: 
                case GREATER: 
                case GREATEREQUAL: 
                case CBIND: 
                case RBIND: {
                    costs = 1.0;
                    break;
                }
                case INTDIV: {
                    costs = 6.0;
                    break;
                }
                case MODULUS: {
                    costs = 8.0;
                    break;
                }
                case DIV: {
                    costs = 22.0;
                    break;
                }
                case LOG: 
                case LOG_NZ: {
                    costs = 32.0;
                    break;
                }
                case POW: {
                    costs = HopRewriteUtils.isLiteralOfValue(currentHop.getInput().get(1), 2.0) ? 1 : 16;
                    break;
                }
                case MINUS_NZ: 
                case MINUS1_MULT: {
                    costs = 2.0;
                    break;
                }
                case MOMENT: {
                    int type = (int)(currentHop.getInput().get(1) instanceof LiteralOp ? HopRewriteUtils.getIntValueSafe((LiteralOp)currentHop.getInput().get(1)) : 2L);
                    switch (type) {
                        case 0: {
                            costs = 1.0;
                            break block19;
                        }
                        case 1: {
                            costs = 8.0;
                            break block19;
                        }
                        case 2: {
                            costs = 16.0;
                            break block19;
                        }
                        case 3: {
                            costs = 31.0;
                            break block19;
                        }
                        case 4: {
                            costs = 51.0;
                            break block19;
                        }
                        case 5: {
                            costs = 16.0;
                        }
                    }
                    break;
                }
                case COV: {
                    costs = 23.0;
                    break;
                }
                default: {
                    LOG.warn((Object)("Cost model not implemented yet for: " + (Object)((Object)((BinaryOp)currentHop).getOp())));
                    break;
                }
            }
        } else if (currentHop instanceof TernaryOp) {
            block38 : switch (((TernaryOp)currentHop).getOp()) {
                case IFELSE: 
                case PLUS_MULT: 
                case MINUS_MULT: {
                    costs = 2.0;
                    break;
                }
                case CTABLE: {
                    costs = 3.0;
                    break;
                }
                case MOMENT: {
                    int type = (int)(currentHop.getInput().get(1) instanceof LiteralOp ? HopRewriteUtils.getIntValueSafe((LiteralOp)currentHop.getInput().get(1)) : 2L);
                    switch (type) {
                        case 0: {
                            costs = 2.0;
                            break block38;
                        }
                        case 1: {
                            costs = 9.0;
                            break block38;
                        }
                        case 2: {
                            costs = 17.0;
                            break block38;
                        }
                        case 3: {
                            costs = 32.0;
                            break block38;
                        }
                        case 4: {
                            costs = 52.0;
                            break block38;
                        }
                        case 5: {
                            costs = 17.0;
                        }
                    }
                    break;
                }
                case COV: {
                    costs = 23.0;
                    break;
                }
                default: {
                    LOG.warn((Object)("Cost model not implemented yet for: " + (Object)((Object)((TernaryOp)currentHop).getOp())));
                    break;
                }
            }
        } else if (currentHop instanceof NaryOp) {
            costs = HopRewriteUtils.isNary(currentHop, Types.OpOpN.MIN, Types.OpOpN.MAX, Types.OpOpN.PLUS) ? (double)currentHop.getInput().size() : 1.0;
        } else if (currentHop instanceof ParameterizedBuiltinOp) {
            costs = 1.0;
        } else if (currentHop instanceof IndexingOp) {
            costs = 1.0;
        } else if (currentHop instanceof ReorgOp) {
            costs = 1.0;
        } else if (currentHop instanceof DnnOp) {
            switch (((DnnOp)currentHop).getOp()) {
                case BIASADD: 
                case BIASMULT: {
                    costs = 2.0;
                }
            }
            LOG.warn((Object)("Cost model not implemented yet for: " + (Object)((Object)((DnnOp)currentHop).getOp())));
        } else if (currentHop instanceof AggBinaryOp) {
            costs = 2L * currentHop.getInput().get(0).getDim2();
            if (currentHop.getInput().get(0).dimsKnown(true)) {
                costs *= currentHop.getInput().get(0).getSparsity();
            }
        } else if (currentHop instanceof AggUnaryOp) {
            switch (((AggUnaryOp)currentHop).getOp()) {
                case SUM: {
                    costs = 4.0;
                    break;
                }
                case SUM_SQ: {
                    costs = 5.0;
                    break;
                }
                case MIN: 
                case MAX: {
                    costs = 1.0;
                    break;
                }
                default: {
                    LOG.warn((Object)("Cost model not implemented yet for: " + (Object)((Object)((AggUnaryOp)currentHop).getOp())));
                }
            }
            switch (((AggUnaryOp)currentHop).getDirection()) {
                case Col: {
                    costs *= (double)Math.max(currentHop.getInput().get(0).getDim1(), 1L);
                    break;
                }
                case Row: {
                    costs *= (double)Math.max(currentHop.getInput().get(0).getDim2(), 1L);
                    break;
                }
                case RowCol: {
                    costs *= (double)ComputeCost.getSize(currentHop.getInput().get(0));
                }
            }
        }
        return costs *= (double)ComputeCost.getSize(currentHop);
    }

    private static long getSize(Hop hop) {
        return Math.max(hop.getDim1(), 1L) * Math.max(hop.getDim2(), 1L);
    }
}

