/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.results.metadata;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.jdbc.results.metadata.columns.ColumnInfo;

public class AbstractResultsMetadata
implements ResultSetMetaData {
    protected ResultSet results;
    protected List<ColumnInfo> columns = new ArrayList<ColumnInfo>();

    public AbstractResultsMetadata(ResultSet results, ColumnInfo[] columns) throws SQLException {
        if (results == null) {
            throw new SQLException("Result Set cannot be null");
        }
        this.results = results;
        for (ColumnInfo column : columns) {
            this.columns.add(column);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        if (this.results != null) {
            return this.results.getStatement().getConnection().getCatalog();
        }
        return "";
    }

    protected final ColumnInfo getColumnInfo(int column) throws SQLException {
        if (column >= 1 && column <= this.columns.size()) {
            return this.columns.get(column - 1);
        }
        throw new SQLException("Column Index is out of bounds");
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.getColumnInfo(column).getClassName();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.getColumnInfo(column).getDisplaySize();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnInfo(column).getLabel();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnInfo(column).getLabel();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getColumnInfo(column).getType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getColumnInfo(column).getTypeName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getColumnInfo(column).getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumnInfo(column).getScale();
    }

    @Override
    public String getSchemaName(int column) {
        return "";
    }

    @Override
    public String getTableName(int column) {
        return "";
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.getColumnInfo(column).isAutoIncrement();
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.getColumnInfo(column).isCaseSensitive();
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.getColumnInfo(column).isCurrency();
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.isWritable(column);
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.getColumnInfo(column).getNullability();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.getColumnInfo(column).isReadOnly();
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.getColumnInfo(column).isSearchable();
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.getColumnInfo(column).isSigned();
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this.getColumnInfo(column).isWritable();
    }

    public List<ColumnInfo> getJenaColumnInfo() {
        return new ArrayList<ColumnInfo>(this.columns);
    }
}

