/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationImplNotAnnotated;
import uk.ac.manchester.cs.owl.owlapi.OWLAxiomImpl;

public class OWLAnnotationAssertionAxiomImpl
extends OWLAxiomImpl
implements OWLAnnotationAssertionAxiom {
    private final OWLAnnotationSubject subject;
    private final OWLAnnotationProperty property;
    private final OWLAnnotationValue value;

    public OWLAnnotationAssertionAxiomImpl(OWLAnnotationSubject subject, OWLAnnotationProperty property, OWLAnnotationValue value, Collection<OWLAnnotation> annotations) {
        super(annotations);
        this.subject = (OWLAnnotationSubject)OWLAPIPreconditions.checkNotNull((Object)subject, (String)"subject cannot be null");
        this.property = (OWLAnnotationProperty)OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        this.value = (OWLAnnotationValue)OWLAPIPreconditions.checkNotNull((Object)value, (String)"value cannot be null");
    }

    public OWLAnnotationAssertionAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLAnnotationAssertionAxiomImpl(this.getSubject(), this.getProperty(), this.getValue(), NO_ANNOTATIONS);
    }

    public boolean isDeprecatedIRIAssertion() {
        return this.property.isDeprecated() && this.getAnnotation().isDeprecatedIRIAnnotation();
    }

    public <T extends OWLAxiom> T getAnnotatedAxiom(Stream<OWLAnnotation> anns) {
        return (T)new OWLAnnotationAssertionAxiomImpl(this.getSubject(), this.getProperty(), this.getValue(), this.mergeAnnos(anns));
    }

    public OWLAnnotationValue getValue() {
        return this.value;
    }

    public OWLAnnotationSubject getSubject() {
        return this.subject;
    }

    public OWLAnnotationProperty getProperty() {
        return this.property;
    }

    public OWLAnnotation getAnnotation() {
        return new OWLAnnotationImplNotAnnotated(this.property, this.value);
    }
}

