/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader.main;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.system.progress.MonitorOutput;
import org.apache.jena.system.progress.ProgressMonitor;
import org.apache.jena.system.progress.ProgressMonitorFactory;
import org.apache.jena.tdb2.loader.BulkLoaderException;
import org.apache.jena.tdb2.loader.main.Destination;
import org.apache.jena.tdb2.loader.main.Indexer;
import org.apache.jena.tdb2.loader.main.LoaderPlan;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.tupletable.TupleIndex;

class PhasedOps {
    PhasedOps() {
    }

    static long acquire(Semaphore termination) {
        return PhasedOps.acquire(termination, 1);
    }

    static long acquire(Semaphore semaphore, int numPermits) {
        return Timer.time(() -> {
            try {
                semaphore.acquire(numPermits);
            }
            catch (InterruptedException e) {
                Log.error(Indexer.class, (String)"Interrupted", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    static Map<String, TupleIndex> indexMap(DatasetGraphTDB dsgtdb) {
        HashMap<String, TupleIndex> indexMap = new HashMap<String, TupleIndex>();
        Arrays.stream(dsgtdb.getTripleTable().getNodeTupleTable().getTupleTable().getIndexes()).forEach(idx -> indexMap.put(idx.getName(), (TupleIndex)idx));
        Arrays.stream(dsgtdb.getQuadTable().getNodeTupleTable().getTupleTable().getIndexes()).forEach(idx -> indexMap.put(idx.getName(), (TupleIndex)idx));
        return indexMap;
    }

    static TupleIndex[][] indexSetsFromNames(String[][] indexNames, Map<String, TupleIndex> indexMap) {
        TupleIndex[][] z = (TupleIndex[][])Arrays.stream(indexNames).map(indexSetNames -> PhasedOps.indexSetFromNames(indexSetNames, indexMap)).toArray(x$0 -> new TupleIndex[x$0][]);
        return z;
    }

    static TupleIndex[] indexSetFromNames(String[] indexNames, Map<String, TupleIndex> indexMap) {
        return (TupleIndex[])Arrays.stream(indexNames).map(name -> PhasedOps.findInIndexMap(name, indexMap)).toArray(TupleIndex[]::new);
    }

    static TupleIndex findInIndexMap(String name, Map<String, TupleIndex> indexMap) {
        TupleIndex tIdx = indexMap.get(name);
        if (tIdx == null) {
            throw new IllegalArgumentException("No such index: " + name);
        }
        return tIdx;
    }

    private static void checkLoaderPlan(LoaderPlan loaderPlan, Map<String, TupleIndex> indexMap) {
        Consumer<String> checker3 = name -> {
            if (name == null) {
                throw new BulkLoaderException("Null index name");
            }
            if (name.length() != 3) {
                throw new BulkLoaderException("Bad length (expected 3): " + name);
            }
            if (!indexMap.containsKey(name)) {
                throw new BulkLoaderException("No such index: " + name);
            }
        };
        Consumer<String> checker4 = name -> {
            if (name == null) {
                throw new BulkLoaderException("Null index name");
            }
            if (name.length() != 4) {
                throw new BulkLoaderException("Bad length (expected 4): " + name);
            }
            if (!indexMap.containsKey(name)) {
                throw new BulkLoaderException("No such index: " + name);
            }
        };
        PhasedOps.arrayApply1(loaderPlan.primaryLoad3(), checker3);
        PhasedOps.arrayApply1(loaderPlan.primaryLoad4(), checker4);
        PhasedOps.arrayApply2(loaderPlan.secondaryIndex3(), checker3);
        PhasedOps.arrayApply2(loaderPlan.secondaryIndex4(), checker4);
        PhasedOps.checkUnique("Primary triples", loaderPlan.primaryLoad3());
        PhasedOps.checkUnique("Primary quads", loaderPlan.primaryLoad4());
        String[] secondary3 = PhasedOps.flatten(loaderPlan.secondaryIndex3(), String[]::new);
        String[] secondary4 = PhasedOps.flatten(loaderPlan.secondaryIndex4(), String[]::new);
        PhasedOps.checkUnique("Secondary triples", secondary3);
        PhasedOps.checkUnique("Secondary quads", secondary4);
    }

    private static <X> void checkUnique(String errorMessage, X[] array) {
        HashSet<X> set = new HashSet<X>();
        for (X x : array) {
            if (set.contains(x)) {
                throw new BulkLoaderException(errorMessage + " : Not unique: " + x);
            }
            set.add(x);
        }
    }

    static String indexMappings(TupleIndex[] indexes) {
        StringJoiner sj = new StringJoiner(", ");
        Arrays.stream(indexes).map(x -> x.getMappingStr()).forEach(str -> sj.add((CharSequence)str));
        return sj.toString();
    }

    private static <X> void arrayApply2(X[][] array, Consumer<X> action) {
        if (array == null) {
            return;
        }
        X[][] XArray = array;
        int n = XArray.length;
        for (int i = 0; i < n; ++i) {
            X[] lines;
            for (X item : lines = XArray[i]) {
                action.accept(item);
            }
        }
    }

    private static <X> void arrayApply1(X[] array, Consumer<X> action) {
        if (array == null) {
            return;
        }
        for (X item : array) {
            action.accept(item);
        }
    }

    private static <X> X[] flatten(X[][] array, IntFunction<X[]> generator) {
        return PhasedOps.flatten(array).toArray(generator);
    }

    private static <X> Stream<X> flatten(X[][] array) {
        if (array == null) {
            return null;
        }
        return Arrays.stream(array).flatMap(Arrays::stream);
    }

    static ReplayResult replay(TupleIndex srcIdx, Destination<Tuple<NodeId>> dest, MonitorOutput output) {
        ProgressMonitor monitor = ProgressMonitorFactory.progressMonitor((String)"Index", (MonitorOutput)output, (int)1000000, (int)10);
        ArrayList<Tuple<NodeId>> block = null;
        int len = srcIdx.getTupleLength();
        monitor.start();
        Iterator<Tuple<NodeId>> iter = srcIdx.all();
        while (iter.hasNext()) {
            if (block == null) {
                block = new ArrayList<Tuple<NodeId>>(100000);
            }
            Tuple<NodeId> row = iter.next();
            block.add(row);
            monitor.tick();
            if (block.size() != 100000) continue;
            dest.deliver(block);
            block = null;
        }
        if (block != null) {
            dest.deliver(block);
        }
        dest.deliver(Collections.emptyList());
        monitor.finish();
        return new ReplayResult(monitor.getTicks(), monitor.getTime());
    }

    static class ReplayResult {
        final long items;
        final long elapsed;

        ReplayResult(long items, long timeInMs) {
            this.items = items;
            this.elapsed = timeInMs;
        }
    }
}

