/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class CSVReader
implements Iterator<Map<String, Object>> {
    private static final Logger log = Logger.getLogger(CSVReader.class);
    protected static final int BUF_SIZE = 20480;
    protected final BufferedReader r;
    private String line = null;
    private int lineNo = 0;
    private boolean exhausted = false;
    private boolean skipCommentLines = true;
    private boolean skipBlankLines = true;
    private boolean trimWhitespace = true;
    private long tailDelayMillis = 0L;
    protected Header[] headers;

    public CSVReader(InputStream is, String charSet) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException();
        }
        if (charSet == null) {
            throw new IllegalArgumentException();
        }
        this.r = new BufferedReader(new InputStreamReader(is, charSet), 20480);
    }

    public CSVReader(Reader r) throws IOException {
        if (r == null) {
            throw new IllegalArgumentException();
        }
        this.r = new BufferedReader(r, 20480);
    }

    public int lineNo() {
        return this.lineNo;
    }

    public boolean setSkipCommentLines(boolean skipCommentLines) {
        boolean tmp = this.skipCommentLines;
        this.skipCommentLines = skipCommentLines;
        return tmp;
    }

    public boolean getSkipCommentLines() {
        return this.skipCommentLines;
    }

    public boolean setSkipBlankLines(boolean skipBlankLines) {
        boolean tmp = this.skipBlankLines;
        this.skipBlankLines = skipBlankLines;
        return tmp;
    }

    public boolean getSkipBlankLines() {
        return this.skipBlankLines;
    }

    public boolean setTrimWhitespace(boolean trimWhitespace) {
        boolean tmp = this.trimWhitespace;
        this.trimWhitespace = trimWhitespace;
        return tmp;
    }

    public boolean getTrimWhitespace() {
        return this.trimWhitespace;
    }

    public long getTailDelayMillis() {
        return this.tailDelayMillis;
    }

    public long setTailDelayMillis(long tailDelayMillis) {
        if (tailDelayMillis < 0L) {
            throw new IllegalArgumentException();
        }
        long tmp = this.tailDelayMillis;
        this.tailDelayMillis = tailDelayMillis;
        return tmp;
    }

    @Override
    public boolean hasNext() {
        if (this.exhausted) {
            return false;
        }
        if (this.line != null) {
            return true;
        }
        try {
            do {
                if (Thread.interrupted()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Interrupted");
                    }
                    this.exhausted = true;
                    return false;
                }
                while (this.tailDelayMillis != 0L && !this.r.ready()) {
                    try {
                        Thread.sleep(this.tailDelayMillis);
                    }
                    catch (InterruptedException e) {
                        log.warn((Object)e.getMessage());
                        return false;
                    }
                }
                this.line = this.r.readLine();
                if (this.line == null) {
                    this.exhausted = true;
                    return false;
                }
                ++this.lineNo;
            } while (this.skipBlankLines && this.line.trim().length() == 0 || this.skipCommentLines && this.line.length() > 0 && this.line.charAt(0) == '#');
            return true;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Map<String, Object> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Map<String, Object> map = this.parse(this.trim(this.split(this.line)));
        this.line = null;
        return map;
    }

    protected String[] split(String line) {
        String[] cols = line.split("[,\t]");
        return cols;
    }

    protected String[] trim(String[] cols) {
        if (!this.trimWhitespace) {
            return cols;
        }
        for (int i = 0; i < cols.length; ++i) {
            String col = cols[i];
            if (col == null) continue;
            if ((col = col.trim()).startsWith("\"") && col.endsWith("\"")) {
                col = col.substring(1, col.length() - 1);
            }
            cols[i] = col;
        }
        return cols;
    }

    protected Map<String, Object> parse(String[] values) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        if (this.headers == null) {
            log.warn((Object)"No headers - using defaults.");
            this.setDefaultHeaders(values.length);
        }
        if (this.headers.length < values.length) {
            throw new RuntimeException("Too many values: line=" + this.lineNo);
        }
        for (int i = 0; i < values.length; ++i) {
            Header h = this.headers[i];
            String text = values[i];
            map.put(h.name, h.parseValue(text));
        }
        return map;
    }

    protected void setDefaultHeaders(int ncols) {
        Header[] headers = new Header[ncols];
        for (int i = 0; i < ncols; ++i) {
            headers[i] = new Header("" + (i + 1));
        }
        this.headers = headers;
    }

    protected Header[] parseHeaders(String line) {
        String[] cols = this.trim(this.split(line));
        Header[] headers = new Header[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            headers[i] = new Header(cols[i]);
        }
        return headers;
    }

    public void readHeaders() throws IOException {
        if (!this.hasNext()) {
            throw new IOException("No more rows");
        }
        this.headers = this.parseHeaders(this.line);
        this.line = null;
    }

    public Header[] getHeaders() {
        return (Header[])this.headers.clone();
    }

    public void setHeaders(Header[] headers) {
        if (headers == null) {
            throw new IllegalArgumentException();
        }
        this.headers = headers;
    }

    public void setHeader(int index, Header header) {
        if (index < 0 || index > this.headers.length) {
            throw new IndexOutOfBoundsException();
        }
        if (header == null) {
            throw new IllegalArgumentException();
        }
        this.headers[index] = header;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class Header {
        private final String name;
        protected static final Format[] formats = new Format[]{new SimpleDateFormat("MM/dd/yy"), new SimpleDateFormat("MM/dd/yyyy"), DateFormat.getDateInstance(3), DateFormat.getDateInstance(2), DateFormat.getDateInstance(1), DateFormat.getDateInstance(0), DateFormat.getTimeInstance(3), DateFormat.getTimeInstance(2), DateFormat.getTimeInstance(1), DateFormat.getTimeInstance(0), DateFormat.getDateTimeInstance(3, 3), DateFormat.getDateTimeInstance(2, 2), DateFormat.getDateTimeInstance(1, 1), DateFormat.getDateTimeInstance(0, 0), NumberFormat.getCurrencyInstance(), NumberFormat.getPercentInstance(), NumberFormat.getNumberInstance(), new DecimalFormat("0.###E0"), new DecimalFormat("##0.#####E0"), NumberFormat.getIntegerInstance()};

        public String getName() {
            return this.name;
        }

        public Header(String name) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            if (name.trim().length() == 0) {
                throw new IllegalArgumentException();
            }
            this.name = name;
        }

        public Object parseValue(String text) {
            for (int i = 0; i < formats.length; ++i) {
                try {
                    Format f = formats[i];
                    if (f instanceof DateFormat) {
                        return ((DateFormat)f).parse(text);
                    }
                    if (f instanceof NumberFormat) {
                        return ((NumberFormat)f).parse(text);
                    }
                    throw new AssertionError();
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return text;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Header)) {
                return false;
            }
            return this.name.equals(((Header)o).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

