/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio.text;

import info.aduna.io.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.BooleanQueryResultParser;
import org.openrdf.query.resultio.QueryResultFormat;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.QueryResultParserBase;

public class BooleanTextParser
extends QueryResultParserBase
implements BooleanQueryResultParser {
    public final BooleanQueryResultFormat getBooleanQueryResultFormat() {
        return BooleanQueryResultFormat.TEXT;
    }

    public synchronized boolean parse(InputStream in) throws IOException, QueryResultParseException {
        InputStreamReader reader = new InputStreamReader(in, Charset.forName("US-ASCII"));
        String value = IOUtil.readString((Reader)reader, (int)16);
        value = value.trim();
        boolean result = false;
        if (value.equalsIgnoreCase("true")) {
            result = true;
        } else if (value.equalsIgnoreCase("false")) {
            result = false;
        } else {
            throw new QueryResultParseException("Invalid value: " + value);
        }
        if (this.handler != null) {
            try {
                this.handler.handleBoolean(result);
            }
            catch (QueryResultHandlerException e) {
                if (e.getCause() != null && e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new QueryResultParseException("Found an issue with the query result handler", (Throwable)e);
            }
        }
        return result;
    }

    public final QueryResultFormat getQueryResultFormat() {
        return this.getBooleanQueryResultFormat();
    }

    public void parseQueryResult(InputStream in) throws IOException, QueryResultParseException, QueryResultHandlerException {
        this.parse(in);
    }
}

