/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapitools.builders.BaseObjectPropertyBuilder;

public class BuilderPropertyChain
extends BaseObjectPropertyBuilder<OWLSubPropertyChainOfAxiom, BuilderPropertyChain> {
    private final List<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>();

    public BuilderPropertyChain(OWLSubPropertyChainOfAxiom expected, OWLDataFactory df) {
        this(df);
        ((BuilderPropertyChain)this.withPropertiesInChain(expected.getPropertyChain()).withProperty(expected.getSuperProperty())).withAnnotations(expected.annotations());
    }

    @Inject
    public BuilderPropertyChain(OWLDataFactory df) {
        super(df);
    }

    public BuilderPropertyChain withPropertyInChain(OWLObjectPropertyExpression arg) {
        this.chain.add(arg);
        return this;
    }

    public BuilderPropertyChain withPropertiesInChain(Collection<OWLObjectPropertyExpression> arg) {
        this.chain.addAll(arg);
        return this;
    }

    public int chainSize() {
        return this.chain.size();
    }

    @Override
    public OWLSubPropertyChainOfAxiom buildObject() {
        return this.df.getOWLSubPropertyChainOfAxiom(this.chain, OWLAPIPreconditions.verifyNotNull(this.getProperty()), this.annotations);
    }
}

