/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

class AxiomConverter
implements OWLAxiomVisitorEx<OWLClassExpression> {
    private final OWLDataFactory factory;

    AxiomConverter(OWLDataFactory df) {
        this.factory = df;
    }

    private static <T> Set<T> set(T desc1, T desc2) {
        HashSet<T> set = new HashSet<T>();
        set.add(desc1);
        set.add(desc2);
        return set;
    }

    private OWLObjectIntersectionOf and(OWLClassExpression desc1, OWLClassExpression desc2) {
        return this.factory.getOWLObjectIntersectionOf(AxiomConverter.set(desc1, desc2));
    }

    private OWLObjectIntersectionOf and(Stream<OWLClassExpression> set) {
        return this.factory.getOWLObjectIntersectionOf(OWLAPIStreamUtils.asList(set));
    }

    private OWLObjectComplementOf not(OWLClassExpression desc) {
        return this.factory.getOWLObjectComplementOf(desc);
    }

    private OWLObjectOneOf oneOf(OWLIndividual ind) {
        return this.factory.getOWLObjectOneOf(CollectionFactory.createSet(ind));
    }

    private OWLObjectUnionOf or(OWLClassExpression desc1, OWLClassExpression desc2) {
        return this.factory.getOWLObjectUnionOf(AxiomConverter.set(desc1, desc2));
    }

    @Override
    public OWLClassExpression doDefault(Object object) {
        throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + object);
    }

    @Override
    public OWLClassExpression visit(OWLClassAssertionAxiom axiom) {
        OWLIndividual ind = axiom.getIndividual();
        OWLClassExpression c = axiom.getClassExpression();
        return this.and(this.oneOf(ind), this.not(c));
    }

    @Override
    public OWLClassExpression visit(OWLDataPropertyAssertionAxiom axiom) {
        OWLObjectOneOf sub = this.oneOf(axiom.getSubject());
        OWLDataHasValue sup = this.factory.getOWLDataHasValue((OWLDataPropertyExpression)axiom.getProperty(), (OWLLiteral)axiom.getObject());
        OWLSubClassOfAxiom ax = this.factory.getOWLSubClassOfAxiom(sub, sup);
        return ax.accept(this);
    }

    @Override
    public OWLClassExpression visit(OWLDataPropertyDomainAxiom axiom) {
        OWLDataSomeValuesFrom sub = this.factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), this.factory.getTopDatatype());
        return this.and(sub, this.not((OWLClassExpression)axiom.getDomain()));
    }

    @Override
    public OWLClassExpression visit(OWLDataPropertyRangeAxiom axiom) {
        return this.factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), this.factory.getOWLDataComplementOf((OWLDataRange)axiom.getRange()));
    }

    @Override
    public OWLClassExpression visit(OWLDifferentIndividualsAxiom axiom) {
        HashSet nominals = new HashSet();
        axiom.individuals().forEach(ind -> nominals.add(this.oneOf((OWLIndividual)ind)));
        return this.factory.getOWLObjectIntersectionOf(nominals);
    }

    @Override
    public OWLClassExpression visit(OWLDisjointClassesAxiom axiom) {
        return this.and(axiom.classExpressions());
    }

    @Override
    public OWLClassExpression visit(OWLEquivalentClassesAxiom axiom) {
        Iterator classes = axiom.classExpressions().iterator();
        OWLClassExpression c1 = (OWLClassExpression)classes.next();
        OWLClassExpression c2 = (OWLClassExpression)classes.next();
        if (c1.isOWLNothing()) {
            return OWLAPIPreconditions.verifyNotNull(c2);
        }
        if (c2.isOWLNothing()) {
            return c1;
        }
        if (c1.isOWLThing()) {
            return this.not(c2);
        }
        if (c2.isOWLThing()) {
            return this.not(c1);
        }
        return this.or(this.and(c1, this.not(c2)), this.and(this.not(c1), c2));
    }

    @Override
    public OWLClassExpression visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        OWLObjectOneOf sub = this.oneOf(axiom.getSubject());
        OWLDataHasValue sup = this.factory.getOWLDataHasValue((OWLDataPropertyExpression)axiom.getProperty(), (OWLLiteral)axiom.getObject());
        return this.factory.getOWLSubClassOfAxiom(sub, this.not(sup)).accept(this);
    }

    @Override
    public OWLClassExpression visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        OWLObjectOneOf sub = this.oneOf(axiom.getSubject());
        OWLObjectHasValue sup = this.factory.getOWLObjectHasValue((OWLObjectPropertyExpression)axiom.getProperty(), (OWLIndividual)axiom.getObject());
        return this.factory.getOWLSubClassOfAxiom(sub, this.not(sup)).accept(this);
    }

    @Override
    public OWLClassExpression visit(OWLObjectPropertyAssertionAxiom axiom) {
        OWLObjectOneOf sub = this.oneOf(axiom.getSubject());
        OWLObjectHasValue sup = this.factory.getOWLObjectHasValue((OWLObjectPropertyExpression)axiom.getProperty(), (OWLIndividual)axiom.getObject());
        OWLSubClassOfAxiom ax = this.factory.getOWLSubClassOfAxiom(sub, sup);
        return ax.accept(this);
    }

    @Override
    public OWLClassExpression visit(OWLObjectPropertyDomainAxiom axiom) {
        return this.and(this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), this.factory.getOWLThing()), this.not((OWLClassExpression)axiom.getDomain()));
    }

    @Override
    public OWLClassExpression visit(OWLObjectPropertyRangeAxiom axiom) {
        return this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), this.not((OWLClassExpression)axiom.getRange()));
    }

    @Override
    public OWLClassExpression visit(OWLSameIndividualAxiom axiom) {
        return this.and(axiom.individuals().map(ind -> this.not(this.oneOf((OWLIndividual)ind))));
    }

    @Override
    public OWLClassExpression visit(OWLSubClassOfAxiom axiom) {
        OWLClassExpression sub = axiom.getSubClass();
        OWLClassExpression sup = axiom.getSuperClass();
        if (sup.isOWLNothing()) {
            return sub;
        }
        if (sub.isOWLThing()) {
            return this.not(sup);
        }
        return this.and(sub, this.not(sup));
    }
}

