/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.algebra.factories;

import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.Bound;
import org.openrdf.query.algebra.Compare;
import org.openrdf.query.algebra.IsBNode;
import org.openrdf.query.algebra.IsLiteral;
import org.openrdf.query.algebra.IsResource;
import org.openrdf.query.algebra.IsURI;
import org.openrdf.query.algebra.LangMatches;
import org.openrdf.query.algebra.Not;
import org.openrdf.query.algebra.Or;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.Regex;
import org.openrdf.query.algebra.SameTerm;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.sail.rdbms.algebra.FalseValue;
import org.openrdf.sail.rdbms.algebra.RefIdColumn;
import org.openrdf.sail.rdbms.algebra.SqlCase;
import org.openrdf.sail.rdbms.algebra.SqlNull;
import org.openrdf.sail.rdbms.algebra.TrueValue;
import org.openrdf.sail.rdbms.algebra.base.SqlExpr;
import org.openrdf.sail.rdbms.algebra.base.SqlExprSupport;
import org.openrdf.sail.rdbms.algebra.factories.SqlExprFactory;
import org.openrdf.sail.rdbms.exceptions.UnsupportedRdbmsOperatorException;

public class BooleanExprFactory
extends QueryModelVisitorBase<UnsupportedRdbmsOperatorException> {
    private static final double HR14 = 5.04E7;
    protected SqlExpr result;
    private SqlExprFactory sql;

    public SqlExpr createBooleanExpr(ValueExpr expr) throws UnsupportedRdbmsOperatorException {
        this.result = null;
        if (expr == null) {
            return new SqlNull();
        }
        expr.visit((QueryModelVisitor)this);
        if (this.result == null) {
            return new SqlNull();
        }
        return this.result;
    }

    public void meet(And node) throws UnsupportedRdbmsOperatorException {
        this.result = SqlExprSupport.and(this.bool(node.getLeftArg()), this.bool(node.getRightArg()));
    }

    public void meet(Bound node) throws UnsupportedRdbmsOperatorException {
        this.result = SqlExprSupport.not(SqlExprSupport.isNull(new RefIdColumn(node.getArg())));
    }

    public void meet(Compare compare) throws UnsupportedRdbmsOperatorException {
        ValueExpr left = compare.getLeftArg();
        ValueExpr right = compare.getRightArg();
        Compare.CompareOp op = compare.getOperator();
        switch (op) {
            case EQ: {
                if (this.isTerm(left) && this.isTerm(right)) {
                    this.result = this.termsEqual(left, right);
                    break;
                }
                this.result = this.equal(left, right);
                break;
            }
            case NE: {
                if (this.isTerm(left) && this.isTerm(right)) {
                    this.result = SqlExprSupport.not(this.termsEqual(left, right));
                    break;
                }
                this.result = SqlExprSupport.not(this.equal(left, right));
                break;
            }
            case GE: 
            case GT: 
            case LE: 
            case LT: {
                SqlExpr simple = SqlExprSupport.and(SqlExprSupport.simple(this.type(left)), SqlExprSupport.simple(this.type(right)));
                SqlExpr labels = SqlExprSupport.and(SqlExprSupport.cmp(this.label(left), op, this.label(right)), simple);
                SqlExpr time = SqlExprSupport.cmp(this.time(left), op, this.time(right));
                SqlExpr within = SqlExprSupport.cmp(this.time(left), op, SqlExprSupport.sub(this.time(right), SqlExprSupport.num(5.04E7)));
                SqlExpr comp = SqlExprSupport.or(SqlExprSupport.eq(this.zoned(left), this.zoned(right)), within);
                SqlExpr dateTime = SqlExprSupport.and(SqlExprSupport.eq(this.type(left), this.type(right)), SqlExprSupport.and(comp, time));
                this.result = SqlExprSupport.or(SqlExprSupport.cmp(this.numeric(left), op, this.numeric(right)), SqlExprSupport.or(dateTime, labels));
            }
        }
    }

    public void meet(IsBNode node) throws UnsupportedRdbmsOperatorException {
        this.result = SqlExprSupport.isNotNull(this.sql.createBNodeExpr(node.getArg()));
    }

    public void meet(IsLiteral node) throws UnsupportedRdbmsOperatorException {
        this.result = SqlExprSupport.isNotNull(this.sql.createLabelExpr(node.getArg()));
    }

    public void meet(IsResource node) throws UnsupportedRdbmsOperatorException {
        SqlExpr isBNode = SqlExprSupport.isNotNull(this.sql.createBNodeExpr(node.getArg()));
        this.result = SqlExprSupport.or(isBNode, SqlExprSupport.isNotNull(this.sql.createUriExpr(node.getArg())));
    }

    public void meet(IsURI node) throws UnsupportedRdbmsOperatorException {
        this.result = SqlExprSupport.isNotNull(this.sql.createUriExpr(node.getArg()));
    }

    public void meet(LangMatches node) throws UnsupportedRdbmsOperatorException {
        ValueExpr left = node.getLeftArg();
        ValueExpr right = node.getRightArg();
        SqlCase sqlCase = new SqlCase();
        sqlCase.when(SqlExprSupport.eq(this.label(right), SqlExprSupport.str("*")), SqlExprSupport.neq(this.label(left), SqlExprSupport.str("")));
        SqlExpr pattern = SqlExprSupport.concat(SqlExprSupport.lowercase(this.label(right)), SqlExprSupport.str("%"));
        sqlCase.when(new TrueValue(), SqlExprSupport.like(this.label(left), pattern));
        this.result = sqlCase;
    }

    public void meet(Not node) throws UnsupportedRdbmsOperatorException {
        this.result = SqlExprSupport.not(this.bool(node.getArg()));
    }

    public void meet(Or node) throws UnsupportedRdbmsOperatorException {
        this.result = SqlExprSupport.or(this.bool(node.getLeftArg()), this.bool(node.getRightArg()));
    }

    public void meet(Regex node) throws UnsupportedRdbmsOperatorException {
        this.result = SqlExprSupport.regex(this.label(node.getArg()), this.label(node.getPatternArg()), this.label(node.getFlagsArg()));
    }

    public void meet(SameTerm node) throws UnsupportedRdbmsOperatorException {
        ValueExpr left = node.getLeftArg();
        ValueExpr right = node.getRightArg();
        boolean leftIsVar = left instanceof Var;
        boolean rightIsVar = right instanceof Var;
        boolean leftIsConst = left instanceof ValueConstant;
        boolean rightIsConst = right instanceof ValueConstant;
        if (leftIsVar && rightIsVar) {
            this.result = SqlExprSupport.eq(new RefIdColumn((Var)left), new RefIdColumn((Var)right));
        } else if ((leftIsVar || leftIsConst) && (rightIsVar || rightIsConst)) {
            this.result = SqlExprSupport.eq(this.hash(left), this.hash(right));
        } else {
            SqlExpr bnodes = SqlExprSupport.eqComparingNull(this.bNode(left), this.bNode(right));
            SqlExpr uris = SqlExprSupport.eqComparingNull(this.uri(left), this.uri(right));
            SqlExpr langs = SqlExprSupport.eqComparingNull(this.lang(left), this.lang(right));
            SqlExpr datatype = SqlExprSupport.eqComparingNull(this.type(left), this.type(right));
            SqlExpr labels = SqlExprSupport.eqComparingNull(this.label(left), this.label(right));
            SqlExpr literals = SqlExprSupport.and(langs, SqlExprSupport.and(datatype, labels));
            this.result = SqlExprSupport.and(bnodes, SqlExprSupport.and(uris, literals));
        }
    }

    public void meet(ValueConstant vc) throws UnsupportedRdbmsOperatorException {
        this.result = this.valueOf(vc.getValue());
    }

    public void meet(Var var) throws UnsupportedRdbmsOperatorException {
        this.result = var.getValue() == null ? this.effectiveBooleanValue((ValueExpr)var) : this.valueOf(var.getValue());
    }

    public void setSqlExprFactory(SqlExprFactory sql) {
        this.sql = sql;
    }

    protected SqlExpr bNode(ValueExpr arg) throws UnsupportedRdbmsOperatorException {
        return this.sql.createBNodeExpr(arg);
    }

    protected SqlExpr bool(ValueExpr arg) throws UnsupportedRdbmsOperatorException {
        return this.sql.createBooleanExpr(arg);
    }

    protected SqlExpr label(ValueExpr arg) throws UnsupportedRdbmsOperatorException {
        return this.sql.createLabelExpr(arg);
    }

    protected SqlExpr lang(ValueExpr arg) throws UnsupportedRdbmsOperatorException {
        return this.sql.createLanguageExpr(arg);
    }

    protected SqlExpr hash(ValueExpr arg) throws UnsupportedRdbmsOperatorException {
        return this.sql.createHashExpr(arg);
    }

    protected void meetNode(QueryModelNode arg) throws UnsupportedRdbmsOperatorException {
        if (!(arg instanceof ValueExpr)) {
            throw SqlExprSupport.unsupported(arg);
        }
        this.result = this.effectiveBooleanValue((ValueExpr)arg);
    }

    protected SqlExpr numeric(ValueExpr arg) throws UnsupportedRdbmsOperatorException {
        return this.sql.createNumericExpr(arg);
    }

    protected SqlExpr time(ValueExpr arg) throws UnsupportedRdbmsOperatorException {
        return this.sql.createTimeExpr(arg);
    }

    protected SqlExpr type(ValueExpr arg) throws UnsupportedRdbmsOperatorException {
        return this.sql.createDatatypeExpr(arg);
    }

    protected SqlExpr uri(ValueExpr arg) throws UnsupportedRdbmsOperatorException {
        return this.sql.createUriExpr(arg);
    }

    protected SqlExpr zoned(ValueExpr arg) throws UnsupportedRdbmsOperatorException {
        return this.sql.createZonedExpr(arg);
    }

    private SqlExpr effectiveBooleanValue(ValueExpr v) throws UnsupportedRdbmsOperatorException {
        String bool = XMLSchema.BOOLEAN.stringValue();
        SqlCase sqlCase = new SqlCase();
        sqlCase.when(SqlExprSupport.eq(this.type(v), SqlExprSupport.str(bool)), SqlExprSupport.eq(this.label(v), SqlExprSupport.str("true")));
        sqlCase.when(SqlExprSupport.simple(this.type(v)), SqlExprSupport.not(SqlExprSupport.eq(this.label(v), SqlExprSupport.str(""))));
        sqlCase.when(SqlExprSupport.isNotNull(this.numeric(v)), SqlExprSupport.not(SqlExprSupport.eq(this.numeric(v), SqlExprSupport.num(0.0))));
        return sqlCase;
    }

    private SqlExpr equal(ValueExpr left, ValueExpr right) throws UnsupportedRdbmsOperatorException {
        SqlExpr bnodes = SqlExprSupport.eq(this.bNode(left), this.bNode(right));
        SqlExpr uris = SqlExprSupport.eq(this.uri(left), this.uri(right));
        SqlCase scase = new SqlCase();
        scase.when(SqlExprSupport.or(SqlExprSupport.isNotNull(this.bNode(left)), SqlExprSupport.isNotNull(this.bNode(right))), bnodes);
        scase.when(SqlExprSupport.or(SqlExprSupport.isNotNull(this.uri(left)), SqlExprSupport.isNotNull(this.uri(right))), uris);
        return this.literalEqual(left, right, scase);
    }

    private boolean isTerm(ValueExpr node) {
        return node instanceof Var || node instanceof ValueConstant;
    }

    private SqlExpr literalEqual(ValueExpr left, ValueExpr right, SqlCase scase) throws UnsupportedRdbmsOperatorException {
        SqlExpr labels = SqlExprSupport.eq(this.label(left), this.label(right));
        SqlExpr langs = SqlExprSupport.and(SqlExprSupport.eqIfNotNull(this.lang(left), this.lang(right)), labels.clone());
        SqlExpr numeric = SqlExprSupport.eq(this.numeric(left), this.numeric(right));
        SqlExpr time = SqlExprSupport.eq(this.time(left), this.time(right));
        SqlExpr bothCalendar = SqlExprSupport.and(SqlExprSupport.isNotNull(this.time(left)), SqlExprSupport.isNotNull(this.time(right)));
        SqlExpr over14 = SqlExprSupport.gt(SqlExprSupport.abs(SqlExprSupport.sub(this.time(left), this.time(right))), SqlExprSupport.num(2.52E7));
        SqlExpr comparable = SqlExprSupport.and(bothCalendar, SqlExprSupport.or(SqlExprSupport.eq(this.zoned(left), this.zoned(right)), over14));
        scase.when(SqlExprSupport.or(SqlExprSupport.isNotNull(this.lang(left)), SqlExprSupport.isNotNull(this.lang(right))), langs);
        scase.when(SqlExprSupport.and(SqlExprSupport.simple(this.type(left)), SqlExprSupport.simple(this.type(right))), labels.clone());
        scase.when(SqlExprSupport.and(SqlExprSupport.isNotNull(this.numeric(left)), SqlExprSupport.isNotNull(this.numeric(right))), numeric);
        scase.when(comparable, time);
        scase.when(SqlExprSupport.and(SqlExprSupport.eq(this.type(left), this.type(right)), labels.clone()), new TrueValue());
        return scase;
    }

    private SqlExpr termsEqual(ValueExpr left, ValueExpr right) throws UnsupportedRdbmsOperatorException {
        SqlExpr bnodes = SqlExprSupport.eqIfNotNull(this.bNode(left), this.bNode(right));
        SqlExpr uris = SqlExprSupport.eqIfNotNull(this.uri(left), this.uri(right));
        SqlCase scase = new SqlCase();
        scase.when(SqlExprSupport.or(SqlExprSupport.isNotNull(this.bNode(left)), SqlExprSupport.isNotNull(this.bNode(right))), bnodes);
        scase.when(SqlExprSupport.or(SqlExprSupport.isNotNull(this.uri(left)), SqlExprSupport.isNotNull(this.uri(right))), uris);
        return this.literalEqual(left, right, scase);
    }

    private SqlExpr valueOf(Value value) {
        if (value instanceof Literal) {
            if (((Literal)value).booleanValue()) {
                return new TrueValue();
            }
            return new FalseValue();
        }
        return SqlExprSupport.sqlNull();
    }
}

