/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.algebra;

import org.openrdf.sail.rdbms.algebra.ColumnVar;
import org.openrdf.sail.rdbms.algebra.base.RdbmsQueryModelNodeBase;
import org.openrdf.sail.rdbms.algebra.base.RdbmsQueryModelVisitorBase;
import org.openrdf.sail.rdbms.algebra.base.SqlExpr;

public class IdColumn
extends RdbmsQueryModelNodeBase
implements SqlExpr {
    private String alias;
    private String column;

    public IdColumn(String alias) {
        this.alias = alias;
        this.column = "id";
    }

    public IdColumn(ColumnVar var) {
        this.alias = var.getAlias();
        this.column = var.getColumn();
    }

    public IdColumn(String alias, String column) {
        this.alias = alias;
        this.column = column;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getColumn() {
        return this.column;
    }

    public String getSignature() {
        return super.getSignature() + " " + this.alias + "." + this.column;
    }

    @Override
    public <X extends Exception> void visit(RdbmsQueryModelVisitorBase<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public IdColumn clone() {
        return (IdColumn)super.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + (this.column == null ? 0 : this.column.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdColumn other = (IdColumn)obj;
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        return !(this.column == null ? other.column != null : !this.column.equals(other.column));
    }
}

